<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Ticket_Layouts_Model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';	
	var $ticket_types = 'ticket_types tt';	
	var $events = 'events e';
	var $ticket_layouts = 'ticket_layouts tl';		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get($event_id)
	{
		//$this->db->join($this->events, 'e.event_id = tl.ticket_layout_event_id', 'left');
		
		$this->db->select('tl.*, lo1.logo_path as logo1
			, lo2.logo_path as logo2, lo3.logo_path as logo3, lo4.logo_path as logo4, lo5.logo_path as logo5
			, tb1.ticket_background_path tb1Path
			, tb2.ticket_background_path tb2Path
			, tb3.ticket_background_path tb3Path
			
		');
		$this->db->join('logos lo1', 'lo1.logo_id = tl.ticket_logo_id_1', 'left');
		$this->db->join('logos lo2', 'lo2.logo_id = tl.ticket_logo_id_2', 'left');
		$this->db->join('logos lo3', 'lo3.logo_id = tl.ticket_logo_id_3', 'left');
		$this->db->join('logos lo4', 'lo4.logo_id = tl.ticket_logo_id_4', 'left');
		$this->db->join('logos lo5', 'lo5.logo_id = tl.ticket_logo_id_5', 'left');
		$this->db->join('ticket_background tb1', 'tl.ticket_background_id = tb1.ticket_background_id', 'left');
		$this->db->join('ticket_background tb2', 'tl.ticket_background_left = tb2.ticket_background_id', 'left');
		$this->db->join('ticket_background tb3', 'tl.ticket_background_right = tb3.ticket_background_id', 'left');
		$this->db->where('ticket_layout_event_id', $event_id);
		$query = $this->db->get($this->ticket_layouts);
	
		return $query->row();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types
	 *
	 * @access	public
	 */
 	function get_ticket_layouts()
	{
		$this->db->join($this->events, 'e.event_id = tl.ticket_layout_event_id', 'left');
		$query = $this->db->get($this->ticket_layouts);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($event_id)
	{
		$fields = array(
			'ticket_layout_event_id'		=> $event_id,
			'ticket_logo_id_1'				=> $this->input->post('ticket_logo_1'),
			'ticket_logo_id_2'				=> $this->input->post('ticket_logo_2'),
			'ticket_logo_id_3'				=> $this->input->post('ticket_logo_3'),
			'ticket_logo_id_4'				=> $this->input->post('ticket_logo_4'),
			'ticket_logo_id_5'				=> $this->input->post('ticket_logo_5'),
			'ticket_text_1'					=> $this->input->post('ticket_text_1'),
			'ticket_font_size_1'			=> $this->input->post('ticket_font_size_1'),
			'ticket_font_face_1'			=> $this->input->post('ticket_font_face_1'),
			'ticket_text_2'					=> $this->input->post('ticket_text_2'),
			'ticket_font_size_2'			=> $this->input->post('ticket_font_size_2'),
			'ticket_font_face_2'			=> $this->input->post('ticket_font_face_2'),
			'ticket_text_3'					=> $this->input->post('ticket_text_3'),
			'ticket_font_size_3'			=> $this->input->post('ticket_font_size_3'),
			'ticket_font_face_3'			=> $this->input->post('ticket_font_face_3'),
			'ticket_text_4'					=> $this->input->post('ticket_text_4'),
			'ticket_font_size_4'			=> $this->input->post('ticket_font_size_4'),
			'ticket_font_face_4'			=> $this->input->post('ticket_font_face_4'),
			'ticket_text_5'					=> $this->input->post('ticket_text_5'),
			'ticket_font_size_5'			=> $this->input->post('ticket_font_size_5'),
			'ticket_font_face_5'			=> $this->input->post('ticket_font_face_5'),
			'ticket_text_6'					=> $this->input->post('ticket_text_6'),
			'ticket_font_size_6'			=> $this->input->post('ticket_font_size_6'),
			'ticket_font_face_6'			=> $this->input->post('ticket_font_face_6'),
			'ticket_text_7'					=> $this->input->post('ticket_text_7'),
			'ticket_font_size_7'			=> $this->input->post('ticket_font_size_7'),
			'ticket_font_face_7'			=> $this->input->post('ticket_font_face_7'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('ticket_layouts');
		
		/*for ( $counter = 1; $counter <= 4; $counter += 1) {

			$fields = array(
				'ticket_logo_event_id'	=> $id,
				'ticket_logo_logo_id'	=> $this->input->post('ticket_logo_'.$counter),
			);
		
			$this->db->set($fields);
			$this->db->insert('ticket_logos');
		};*/
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($event_id)
	{
		$fields = array(
			'ticket_logo_id_1'				=> $this->input->post('ticket_logo_1'),
			'ticket_logo_id_2'				=> $this->input->post('ticket_logo_2'),
			'ticket_logo_id_3'				=> $this->input->post('ticket_logo_3'),
			'ticket_logo_id_4'				=> $this->input->post('ticket_logo_4'),
			'ticket_logo_id_5'				=> $this->input->post('ticket_logo_5'),
			'ticket_text_1'					=> $this->input->post('ticket_text_1'),
			'ticket_font_size_1'			=> $this->input->post('ticket_font_size_1'),
			'ticket_font_face_1'			=> $this->input->post('ticket_font_face_1'),
			'ticket_text_2'					=> $this->input->post('ticket_text_2'),
			'ticket_font_size_2'			=> $this->input->post('ticket_font_size_2'),
			'ticket_font_face_2'			=> $this->input->post('ticket_font_face_2'),
			'ticket_text_3'					=> $this->input->post('ticket_text_3'),
			'ticket_font_size_3'			=> $this->input->post('ticket_font_size_3'),
			'ticket_font_face_3'			=> $this->input->post('ticket_font_face_3'),
			'ticket_text_4'					=> $this->input->post('ticket_text_4'),
			'ticket_font_size_4'			=> $this->input->post('ticket_font_size_4'),
			'ticket_font_face_4'			=> $this->input->post('ticket_font_face_4'),
			'ticket_text_5'					=> $this->input->post('ticket_text_5'),
			'ticket_font_size_5'			=> $this->input->post('ticket_font_size_5'),
			'ticket_font_face_5'			=> $this->input->post('ticket_font_face_5'),
			'ticket_text_6'					=> $this->input->post('ticket_text_6'),
			'ticket_font_size_6'			=> $this->input->post('ticket_font_size_6'),
			'ticket_font_face_6'			=> $this->input->post('ticket_font_face_6'),
			'ticket_text_7'					=> $this->input->post('ticket_text_7'),
			'ticket_font_size_7'			=> $this->input->post('ticket_font_size_7'),
			'ticket_font_face_7'			=> $this->input->post('ticket_font_face_7'),
			'ticket_text_1_left'			=> $this->input->post('ticket_text_1_left'),
			'ticket_font_face_1_left'		=> $this->input->post('ticket_font_face_1_left'),
			'ticket_font_size_1_left'		=> $this->input->post('ticket_font_size_1_left'),
			'ticket_text_2_left' 			=> $this->input->post('ticket_text_2_left'),
			'ticket_font_face_2_left'		=> $this->input->post('ticket_font_face_2_left'),
			'ticket_font_size_2_left'		=> $this->input->post('ticket_font_size_2_left'),
			'ticket_text_3_left'			=> $this->input->post('ticket_text_3_left'),
			'ticket_font_face_3_left'		=> $this->input->post('ticket_font_face_3_left'),
			'ticket_font_size_3_left'		=> $this->input->post('ticket_font_size_3_left'),
			'ticket_text_4_left'			=> $this->input->post('ticket_text_4_left'),
			'ticket_font_face_4_left'		=> $this->input->post('ticket_font_face_4_left'),
			'ticket_font_size_4_left'		=> $this->input->post('ticket_font_size_4_left'),
			'ticket_text_5_left'			=> $this->input->post('ticket_text_5_left'),
			'ticket_font_face_5_left'		=> $this->input->post('ticket_font_face_5_left'),
			'ticket_font_size_5_left'		=> $this->input->post('ticket_font_size_5_left'),
			'ticket_text_1_right'			=> $this->input->post('ticket_text_1_right'),
			'ticket_font_face_1_right'		=> $this->input->post('ticket_font_face_1_right'),
			'ticket_font_size_1_right'		=> $this->input->post('ticket_font_size_1_right'),
			'ticket_text_2_right'			=> $this->input->post('ticket_text_2_right'),
			'ticket_font_face_2_right'		=> $this->input->post('ticket_font_face_2_right'),
			'ticket_font_size_2_right'		=> $this->input->post('ticket_font_size_2_right'),
			'ticket_text_3_right'			=> $this->input->post('ticket_text_3_right'),
			'ticket_font_face_3_right'		=> $this->input->post('ticket_font_face_3_right'),
			'ticket_font_size_3_right'		=> $this->input->post('ticket_font_size_3_right'),
			'ticket_text_4_right'			=> $this->input->post('ticket_text_4_right'),
			'ticket_font_face_4_right'		=> $this->input->post('ticket_font_face_4_right'),
			'ticket_font_size_4_right'		=> $this->input->post('ticket_font_size_4_right'),
			'ticket_text_5_right'			=> $this->input->post('ticket_text_5_right'),
			'ticket_font_face_5_right'		=> $this->input->post('ticket_font_face_5_right'),
			'ticket_font_size_5_right'		=> $this->input->post('ticket_font_size_5_right'),
			'ticket_background_id'			=> $this->input->post('ticket_background'),
			'ticket_background_left'		=> $this->input->post('ticket_background_left'),
			'ticket_background_right'		=> $this->input->post('ticket_background_right'),
		);
		
		// update db
		$this->db->where('ticket_layout_event_id', $event_id);
		$this->db->update($this->ticket_layouts, $fields);
		
		return true;
	}

}
// END ticket_Layouts_model.php
/* Location: ./application/models/ticket_Layouts_model.php */