<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Terminals_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches b';
	var $terminals = 'terminals ter';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_type
	 *
	 * @access	public
	 */
	function get($terminal_id)
	{
		$this->db->where('terminal_id', $terminal_id);
		$this->db->join($this->branches, 'b.branch_id = ter.terminal_branch_id', 'left');
		$query = $this->db->get($this->terminals);
	
		return $query->row();
		
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * get_terminals
	 *
	 * @access	public
	 */
	function get_terminals()
	{
		$this->db->join($this->branches, 'b.branch_id = ter.terminal_branch_id', 'left');
		$query = $this->db->get($this->terminals);
		
		return $query->result();
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_terminals_dropdown
	 *
	 * @access	public
	 */
	function get_terminals_dropdown()
	{
		$this->db->join($this->branches, 'b.branch_id = ter.terminal_branch_id', 'left');
		$query = $this->db->get($this->terminals);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->terminal_id] = $r->branch_name . ' - ' . $r->terminal_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'terminal_branch_id'	=> $this->input->post('branch_id'),
			'terminal_code'			=> $this->input->post('terminal_code'),
			'terminal_name'			=> $this->input->post('terminal_name'),
			'terminal_location'		=> $this->input->post('terminal_location'),	
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('terminals');
		
		return true;
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($terminal_id)
	{
		$fields = array(
			'terminal_branch_id'	=> $this->input->post('branch_id'),
			'terminal_code'			=> $this->input->post('terminal_code'),
			'terminal_name'			=> $this->input->post('terminal_name'),
			'terminal_location'		=> $this->input->post('terminal_location'),		
		);
		
		// update db
		$this->db->where('terminal_id', $terminal_id);
		$this->db->update($this->terminals, $fields);
		
		return true;
	}	
			
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($terminal_id)
	{
		$this->db->delete('terminals', array('terminal_id' => $terminal_id));
		
		return true;
	}
				
}

// END terminals_model.php
/* Location: ./application/models/terminals_model.php */	