<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Sessions_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $sessions = 'sessions s';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_session
	 *
	 * @access	public
	 */
	function get($session_id)
	{
		
		$this->db->where('session_id', $session_id);
		$this->db->join($this->users, 'u.user_id = s.session_user_id', 'left');
		$this->db->join($this->branches, 'o.branch_id = s.session_branch_id', 'left');
		$query = $this->db->get($this->sessions);
	
		return $query->row();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_session_by_user_id
	 *
	 * @access	public
	 */
	function get_by_session_id($session_id)
	{
		$this->db->where('session_id', $session_id);
		$this->db->join($this->users, 'u.user_id = s.session_user_id', 'left');
		$this->db->join($this->branches, 'o.branch_id = s.session_branch_id', 'left');
		$query = $this->db->get($this->sessions);
	
		return $query->row();		
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * get_sessions
	 *
	 * @access	public
	 */
	function get_sessions($offset = false, $limit = false, $ordby=false)
	{
	
		$this->db->join($this->users, 'u.user_id = s.session_user_id', 'left');
		$this->db->join($this->branches, 'o.branch_id = s.session_branch_id', 'left');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		if ($ordby) $this->db->order_by($ordby);
		
		$query = $this->db->get($this->sessions);
		return $query->result();
	}	

	// --------------------------------------------------------------------
	
	/**
	 * get_session_count
	 *
	 * @access	public
	 */
	function get_session_count()
	{
		$this->db->select('count(*) as session_count');		
		$query = $this->db->get($this->sessions);
		$result = $query->row();
		
		return $result->session_count;
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add($session_user_id, $session_branch_id)
	{
		$fields = array(
			'session_user_id'			=> 	$session_user_id,
			'session_branch_id'			=> 	$session_branch_id,
			'session_type'				=>	'',
			'session_date_time'			=> 	date("Y-m-d H:i:s"),
			'session_loose_change'		=>	'',
			'session_beginning_serial'	=> 	$this->input->post('session_beginning_serial'),
			'session_ending_serial'		=> 	$this->input->post('session_ending_serial'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('sessions');
		
		return true;
	}	
	// --------------------------------------------------------------------]
}

// END sessions_model.php
/* Location: ./application/models/sessions_model.php */	