<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Reservations_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $reservations = 'reservation re';
	var $customers = 'customers c';	
	var $transactions = 'transactions t';	
	var $tickets = 'tickets ti';	
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_reservation_list
	 *
	 * @access	public
	 */
	function get_reservations($offset = false, $limit = false)
	{
		$this->db->group_by('t.transaction_id');
		$this->db->where('lower(transaction_status)', strtolower('reserved'));
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
		
		$this->db->order_by('t.transaction_id', 'desc');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);

		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * search_reservation_list
	 *
	 * @access	public
	 */
	function search_reservations($searchkey=array(), $offset = false, $limit = false)
	{
		if (!empty($searchkey) ){
			$this->db->query('set transaction isolation level read uncommitted');
			$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count, ev.event_id');
			$this->db->group_by('t.transaction_id');
			$this->db->where('ti.ticket_status', 'reserved');
			$this->db->where('transaction_status', 'reserved');
			if($this->input->post('mobile')!="")
			$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
			$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
			$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
			$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
			$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
			$this->db->join('events_config ec', 'ev.event_id=ec.events_config_eventid','left');
			
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
						$this->db->where($key, $value);
					}else{
						$this->db->like($key, $value);
					}
					
						break;
				}
			}
			
			$query = $this->db->get($this->transactions);
			// return $query->result();
			$row = $query->row();
			$event_id = "";
			if(isset($row->event_id)){
			$event_id = $row->event_id;
			}else{
				
			}
			$branches = $this->get_branch_filter_reservation($event_id);
			if($branches!=""){
				error_reporting(0);
				$branches = unserialize($branches);
			}else{
				$branches = "";
			}
				
			// print_r($branches);
			// die();
			if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
						// $this->db->where('ev.event_id !=', $event_id);
						
						$val_reservation = $this->validate_reservation($event_id);
						// die();
						if($val_reservation>0){
							// return false;
							return array();
							// echo 'dsasa';
							// die();	
						}
							
			}
		}
		
		
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count, ev.event_id');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('transaction_status', 'reserved');
		if($this->input->post('mobile')!="")
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
		$this->db->join('events_config ec', 'ev.event_id=ec.events_config_eventid','left');
		
		if (!empty($searchkey) )
		{
			
			
			
			if($branches!=""){
				
				// if (!in_array($this->session->userdata('user_branch_id'),$branches)){
					// if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
						// $this->db->where('ev.event_id !=', $event_id);
					// }
				
				// }
					// $this->db->where('ev.event_id !=', $event_id);
					foreach ($searchkey as $key=>$value)
						{
							switch ($key)
							{
								case 'name':
									$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
									break;
								default:
								if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
									if (in_array($this->session->userdata('user_branch_id'),$branches)){
										$this->db->where($key, $value);
									}else{
										$this->db->where($key, '0');
									}
									
								}else{
									$this->db->like($key, $value);
								}
								
									break;
							}
					}
				
				
				if ($limit) $this->db->limit($limit);
				if ($offset) $this->db->offset($offset);
				$query = $this->db->get($this->transactions);
				return $query->result();
				
			} else{
				
				foreach ($searchkey as $key=>$value)
						{
							switch ($key)
							{
								case 'name':
									$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
									break;
								default:
								if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){ 
									$this->db->where($key, $value);
								}else{
									$this->db->like($key, $value);
								}
								
									break;
							}
					}
				
				if ($limit) $this->db->limit($limit);
				if ($offset) $this->db->offset($offset);
				// $this->db->where('transaction_id', 1732147);
				// $query = $this->db->get($this->transactions);
				$query = $this->db->get($this->transactions);
				return $query->result();
			} 

			return $query->result();
			
		
		}else{
			$branches = "";
			if($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation' or $this->session->userdata('user_type') == 'Reservation-Admin'){
				$this->db->where('t.transaction_id', 0);
			}
			/* //coldplay restriction
			if($this->session->userdata('user_type') == 'Admin'){
			
			
			}else{


				$coldplay_users = array('3005','1320');
				if(!in_array($this->session->userdata('user_id'), $coldplay_users)){
						
					$this->db->where('ti.ticket_event_id !=', 5157); 

				}
			
			} */	
			$this->db->order_by('t.transaction_id', 'desc');
			if ($limit) $this->db->limit($limit);
			if ($offset) $this->db->offset($offset);
			$query = $this->db->get($this->transactions);
			return $query->result();
		}

	}
	
	// --------------------------------------------------------------------
	function count_reservations($searchkey=array(), $offset = false, $limit = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.transaction_id');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('lower(transaction_status)', strtolower('reserved'));
		if($this->input->post('mobile')!="")
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		// $this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');

		if (!empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					$this->db->like($key, $value);
						break;
				}
			}
		}
		
		
		$this->db->order_by('t.transaction_id', 'desc');
		
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);

		return $query->result();
	}
	

	/**
	 * get_customer_ID
	 *
	 * @access	public
	 */
	function get_customer_id($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('c.customer_id, ti.ticket_session_id, ti.ticket_event_id, ti.ticket_price_id, ti.ticket_transaction_id');
		$this->db->where('t.transaction_id', $transaction_id);
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$query = $this->db->get($this->transactions);
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * reservation_check
	 *
	 * @access	public
	 */
	function reservation_check()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$fields = array(
			'ticket_status'		=> 'expired',				
		);
		$this->db->where('ticket_reservation_expiry', date());
		$this->db->update($this->tickets, $fields);
		return true;
	}
	// --------------------------------------------------------------------
	
	/**
	 * reservation_expiry
	 *
	 * @access	public
	 */
	function reservation_expiry($transaction_id)
	{
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$query = $this->db->get($this->tickets);		
		return $query->row();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * extend
	 *
	 * @access	public
	 */
	function extend($transaction_id)
	{	
		$no_of_days = ($this->input->post('no_of_days')) ? $this->input->post('no_of_days') : $this->input->post('event_reservation_days');
		$extend_date = date("Y-m-d", strtotime("+$no_of_days days")); 
		
		// update tickets table
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, array('ticket_reservation_expiry' => $extend_date));
			
		return true;
	}	

	// --------------------------------------------------------------------
	
	/**
	 * expire
	 *
	 */
	function expire()
	{
		// update tickets table
		$this->db->where('ticket_status', 'reserved');
		$this->db->where('ticket_reservation_expiry <', date("Y-m-d"));
		$this->db->update($this->tickets, array('ticket_status' => 'expired'));
		//echo $this->db->last_query();
		return true;
	}

	//for edit reservation
	function get_reservations_details($resID = false)
	{
 		$this->db->where('lower(transaction_status)', strtolower('reserved'));
		$this->db->where('transaction_id', $resID); 
 		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left'); 		
   		$query = $this->db->get($this->transactions);

		return $query->row();
	}
		
	function update_reservation()
	{
	
		 
		
		// check first if customer is existing
		$customer = $this->get_by_mobile($this->input->post('customer_mobile'));
		
		if (!empty($customer))
		{	
		
			//update notes
			$fields = array(
				'transaction_comment'			=> $this->input->post('customer_notes'),	
				'transaction_customer_id'		=> $customer->customer_id,					
			);
			
			$this->db->where('transaction_id', $this->input->post('reservation_id'));
			$this->db->update($this->transactions, $fields);
			
		
			//update customer details
			$fields2 = array(
				'customer_firstname'		=> $this->input->post('customer_firstname'),				
				'customer_lastname'			=> $this->input->post('customer_lastname'),				
 			);
			$this->db->where('customer_mobile', $this->input->post('customer_mobile'));
			$this->db->update($this->customers, $fields2);
			
			 
		
		}else{
		 
		
			$fields = array(
				'customer_firstname'		=> $this->input->post('customer_firstname'),				
				'customer_lastname'			=> $this->input->post('customer_lastname'),				
				'customer_gender'			=> 0,		
				'customer_nationality'		=> 0,		
				'customer_marital_status'	=> 0,		
				'customer_address1'			=> 0,		
				'customer_address2'			=> 0,		
				'customer_city'				=> 0,		
				'customer_zip'				=> 0,		
				'customer_phone'			=> 0,		
				'customer_fax'				=> 0,		
				'customer_fax'				=> 0,		
				'customer_email'			=> 0,		
				'customer_website'			=> 0,		
				'customer_notes'			=> 0,		

				
				'customer_mobile'			=> $this->input->post('customer_mobile'),				
 			);
				
			$this->db->set($fields);
			$this->db->insert('customers');
		
			
			//update notes
			$fields = array(
				'transaction_comment'			=> $this->input->post('customer_notes'),				
				'transaction_customer_id'		=> $this->db->insert_id(),				
			);
			
			$this->db->where('transaction_id', $this->input->post('reservation_id'));
			$this->db->update($this->transactions, $fields);
			
			 
		}
		
		 
		
		
		return true;
		
	}
	
	function get_by_mobile($mobile)
	{
		$this->db->where('customer_mobile', $mobile);
		$query = $this->db->get($this->customers);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	
	function search_reservations_v2($event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('transaction_status', 'reserved');
		$this->db->where('ti.ticket_event_id', $event_id);
		// if($this->input->post('mobile')!="")
		// $this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');

		 
		
		$this->db->order_by('t.transaction_id', 'desc'); 
		$query = $this->db->get($this->transactions);

		return $query->result();
	}
	
	function validate_reservation($event_id){
		$this->db->where('event_reservation_claiming', "1");
		$this->db->where('events_config_eventid', $event_id);
		$query = $this->db->get('events_config');
		return $query->num_rows();
	}
	
	function get_branch_filter_reservation($event_id = false){
		$this->db->select('event_branch_filter_reservation');
		$this->db->where('events_config_eventid', $event_id);
		
		$query = $this->db->get('events_config');
		$row = $query->row();
		
		if(isset($row->event_branch_filter_reservation)){
			$event_branch_filter_reservation = $row->event_branch_filter_reservation;
			return $event_branch_filter_reservation;
		}else{
			return "";
		}
	
		
		// return $query->row()->event_branch_filter_reservation;
	}
	
}



// END reservations_model.php
/* Location: ./application/models/reservations_model.php */	
