<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Promoters_model extends CI_Model
{
	var $promoters = 'promoters p';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_promoter
	 *
	 * @access	public
	 */
	function get($promoter_id)
	{
		$this->db->where('promoter_id', $promoter_id);
		$query = $this->db->get($this->promoters);
		//echo $this->db->last_query();
		
		return $query->row();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_promoters
	 *
	 * @access	public
	 */
	function get_promoters($searchkey=array())
	{
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}
		$query = $this->db->get($this->promoters);
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_promoters_dropdown
	 *
	 * @access	public
	 */
	function get_promoters_dropdown()
	{
		$this->db->where('promoter_active', 1);
		$query = $this->db->get($this->promoters);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->promoter_id] = $r->promoter_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * prep_password
	 *
	 * @access	public
	 */
	function prep_password($password)
	{
		return sha1($this->config->item('encryption_key').$password);
	}

	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'promoter_username'	=> $this->input->post('promoters_username'),
			'promoter_password'	=> $this->prep_password($this->input->post('promoters_password')),
			'promoter_name'		=> $this->input->post('promoters_name'),
			'promoter_signatory'	=> $this->input->post('promoters_signatory'),
			'promoter_position'	=> $this->input->post('promoters_position'),
			/* 'promoter_ctc_number'	=> $this->input->post('promoters_ctc_number'),		
			'promoter_ctc_date'	=> $this->input->post('promoters_ctc_date'),					
			'promoter_ctc_place'	=> $this->input->post('promoters_ctc_place'),	 */				
			'promoter_address1'	=> $this->input->post('promoters_address1'),					
			'promoter_address2'	=> $this->input->post('promoters_address2'),					
			'promoter_city'		=> $this->input->post('promoters_city'),					
			'promoter_zip'			=> $this->input->post('promoters_zip'),					
			'promoter_country'		=> $this->input->post('promoters_country'),					
			'promoter_phone1'		=> $this->input->post('promoters_phone1'),					
			'promoter_phone2'		=> $this->input->post('promoters_phone2'),					
			'promoter_fax'			=> $this->input->post('promoters_fax'),					
			'promoter_mobile'		=> $this->input->post('promoters_mobile'),					
			'promoter_email'		=> $this->input->post('promoters_email'),					
			'promoter_website'		=> $this->input->post('promoters_website'),					
			'promoter_active'		=> '1',					
			'promoter_tin'			=> $this->input->post('promoters_tin'),
			'promoter_vendor_key'	=> $this->input->post('promoters_vendor_key'),					
			
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('promoters');
		
		return $this->db->insert_id();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($promoter_id)
	{
		$fields = array(
			'promoter_username'		=> $this->input->post('promoter_username'),
			'promoter_name'			=> $this->input->post('promoter_name'),
			'promoter_signatory'	=> $this->input->post('promoter_signatory'),
			'promoter_position'		=> $this->input->post('promoter_position'),
			/* 'promoter_ctc_number'	=> $this->input->post('promoter_ctc_number'),
			'promoter_ctc_date'		=> $this->input->post('promoter_ctc_date'),
			'promoter_ctc_place'	=> $this->input->post('promoter_ctc_place'), */
			'promoter_address1'		=> $this->input->post('promoter_address1'),
			'promoter_address2'		=> $this->input->post('promoter_address2'),
			'promoter_city'			=> $this->input->post('promoter_city'),
			'promoter_zip'			=> $this->input->post('promoter_zip'),
			'promoter_country'		=> $this->input->post('promoter_country'),
			'promoter_phone1'		=> $this->input->post('promoter_phone1'),
			'promoter_phone2'		=> $this->input->post('promoter_phone2'),
			'promoter_fax'			=> $this->input->post('promoter_fax'),
			'promoter_mobile'		=> $this->input->post('promoter_mobile'),
			'promoter_email'		=> $this->input->post('promoter_email'),
			'promoter_website'		=> $this->input->post('promoter_website'),	
			'promoter_tin'			=> $this->input->post('promoter_tin'),	
			'promoter_active'		=> $this->input->post('promoter_active'),	
			'promoter_vendor_key'	=> $this->input->post('promoter_vendor_key'),	
		);
		
		// optional fields
		if ($this->input->post('promoter_password'))
		{
			$fields['promoter_password'] = $this->prep_password($this->input->post('promoter_password'));
		}
		
		// update db
		$this->db->where('promoter_id', $promoter_id);
		$this->db->update($this->promoters, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($promoter_id)
	{
		$this->db->delete('promoters', array('promoter_id' => $promoter_id));
		
		return true;
	}
	
	function is_username_exist($username = FALSE)
	{
		// check if username exists
		$this->db->where('lower(promoter_username)', strtolower($username));
		$query = $this->db->get($this->promoters);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	function is_promoters_tin_exist($promoter_tin = FALSE, $id = FALSE)
	{
		// check if promoter_tin exists
		$this->db->where('promoter_tin', $promoter_tin);
		if($id){
		$this->db->where('promoter_id !=', strtolower($id));
		}
		$query = $this->db->get($this->promoters);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	function is_promoters_vendor_exist($promoter_vendor_key = FALSE, $id = FALSE)
	{
		// check if promoter_vendor_key exists
		if($promoter_vendor_key!=""){
		$this->db->where('promoter_vendor_key', strtolower($promoter_vendor_key));
		}
		if($id){
		$this->db->where('promoter_id !=', strtolower($id));
		}
		$query = $this->db->get($this->promoters);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	function no_vendor($vendor=false)
	{
		if($vendor=="inactive"){
			$this->db->where('promoter_active', 0);
		}else{
			$this->db->where('promoter_vendor_key', "");
		}
		$query = $this->db->get($this->promoters);
		
		return $query->result();
	}


}
// END promoters_model.php
/* Location: ./application/models/promoters_model.php */