<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Printer_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';

	var $paid_status = array('paid','paid_online');

	public function __construct()
	{
		parent::__construct();
	}

	function get_ticket_details($transaction_id = false){
	 
		 
		// $query = $this->db->select();
		$this->db->select( "ev.event_title as event_title
					 , ev.event_code as event_code
					 , ev.event_date_time as event_date_time
					 , ev.event_venue_amusement_tax as amtax
					 , tr.transaction_id
					 , ti.ticket_id as ticket_id
					 , tr.transaction_comment
					 , tr.transaction_date as transaction_date
					 , se.section_code as section
					 , ti.ticket_row as row
					 , ti.ticket_seat as seat
					 , tt.ticket_type_name as ticket_type
					 , tt.ticket_type_discount_type as discount_type
					 , tt.ticket_type_discount as discount
					 ,CASE WHEN ((tt.ticket_type_discount_type = 'Percentage') AND (ti.ticket_type_id != 2)) THEN (pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE pr.price_price END 'price',
					 , br.branch_name as branch  
 					 , ti.ticket_status as status",false);
		

		$this->db->join('tickets ti', 'ti.ticket_transaction_id = tr.transaction_id','left');
		$this->db->join('events ev', 'ev.event_id = ti.ticket_event_id','left');
		$this->db->join('sections se', 'se.section_id = ti.ticket_section_id','left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id','left');
		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id','left');
		$this->db->join('branches br', 'br.branch_id = tr.transaction_branch_id','left');
		$this->db->join('tickets_used tu', 'tu.ticket_used_ticket_id = ti.ticket_id  ','left');

	
		$this->db->where('tr.transaction_id', $transaction_id);
		$this->db->where('tr.transaction_status', 'done');
		$this->db->where('ti.ticket_status', 'done');
		$this->db->where('tu.ticket_used_ticket_id IS NULL');
		$this->db->group_by('ti.ticket_id'); 
		$query = $this->db->get('transactions tr');
		 
		 

		return $query;
	
	}

	function insert_details($xml_data = false)
	{
		
		if(!empty($xml_data)){
			if(isset($xml_data['row'][0]['Ticket_Id'])){
				foreach($xml_data as $x){ 
					foreach($x as $y){
						
						//insert card details
						$details = array(
							'ticket_used_ticket_id'	=> $y['Ticket_Id'], 	
							'ticket_used_transaction_id' => $y['Transaction_Id'],	
							'ticket_used_card_type'	=> $y['CardType'],	
							'ticket_used_card_number'	=> $y['PrintedCardNumber'],	
							'ticket_used_status'	=> $y['Status'],	
							'ticket_used_user_id'	=> $this->session->userdata('user_id'),	
 						);

						// insert to db
						$this->db->set($details);
						$this->db->insert('tickets_used');

						
					} 
				}
			}else{ 
				foreach($xml_data as $x){ 
					 
						
					//insert card details
					$details = array(
						'ticket_used_ticket_id'	=> $x['Ticket_Id'], 	
						'ticket_used_transaction_id' => $x['Transaction_Id'],	
						'ticket_used_card_type'	=> $x['CardType'],	
						'ticket_used_card_number'	=> $x['PrintedCardNumber'],	
						'ticket_used_status'	=> $x['Status'],
						'ticket_used_user_id'	=> $this->session->userdata('user_id'),	
					);

					// insert to db
					$this->db->set($details);
					$this->db->insert('tickets_used');

						
					 
				}
			
			
			
			}
		 
		}
 
		return  true;
	}
	 
	function check_status($xml_data = false){
	 
		if(!empty($xml_data)){
			if(isset($xml_data['row']['Ticket_Id'])){  
				$ticketID = $xml_data['row']['Ticket_Id']; 
			}else{
				$ticketID = false; 
			}
		}else{
			$ticketID = false;
		}
		
		// $query = $this->db->select();
		$this->db->select('tix.ticket_status as status',false); 
		$this->db->where('tix.ticket_id', $ticketID); 
		$query = $this->db->get('tickets tix');
	
		if($query){ 
			echo $query->row()->status; 
		}else{
			echo false;
		}
 
		// return $query;
	}
  	
	function get_voided_ticket_count($transaction_id) {
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ti.ticket_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'voided');
		$query = $this->db->get($this->tickets);
		return $query->num_rows();
	}
	
	//for etickets
	function get_ticket_layout($event_id){
		
		$sql = "SELECT * FROM ticket_layouts t left join ticket_background tt ON tt.ticket_background_id = t.ticket_background_id  WHERE t.ticket_layout_event_id = ?";
		$query = $this->db->query($sql, [$event_id]);
		if($query->num_rows()> 0){
			return $query->row();
		}else{
			return 0;
		}
	}
	
	
	function get_trans_details($transaction_id = false){
	 
		 
		// $query = $this->db->select();
		$this->db->select( "ev.event_title as event_title
					 , ev.event_code as event_code
					 , ev.event_date_time as event_date_time 
					 , tr.transaction_id
					 , ti.ticket_id 
					 , ti.ticket_price_id 
					 , ti.ticket_event_id 
					 , tr.transaction_date 
					 , se.section_name 
					 , ti.ticket_row as row
					 , ti.ticket_seat as seat
					 , ti.ticket_acknowledgment_receipt as ar
					 , tt.ticket_type_name as ticket_type
					 , tt.ticket_type_discount_type as discount_type
					 , tt.ticket_type_discount as discount
					 ,CASE WHEN ((tt.ticket_type_discount_type = 'Percentage') AND (ti.ticket_type_id != 2)) THEN (pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE pr.price_price - tt.ticket_type_discount  END 'price',
					 , br.branch_name as branch 
					 , ec.event_eticket_p_image
					 , ec.event_eticket_l_image					 
 					 , ti.ticket_status",false);
		

		$this->db->join('tickets ti', 'ti.ticket_transaction_id = tr.transaction_id','left');
		$this->db->join('events ev', 'ev.event_id = ti.ticket_event_id','left');
		$this->db->join('events_config ec', 'ev.event_id = ec.events_config_eventid','left');
		$this->db->join('sections se', 'se.section_id = ti.ticket_section_id','left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id','left');
		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id','left');
		$this->db->join('branches br', 'br.branch_id = tr.transaction_branch_id','left');
  
	
		$this->db->where('tr.transaction_id', $transaction_id);
		$this->db->where_in('tr.transaction_status',['done','paid','paid_online']);
		$this->db->where_in('ti.ticket_status', ['done','paid','paid_online']);
 		$this->db->group_by('ti.ticket_id'); 
		$query = $this->db->get('transactions tr');
		 
		 

		return $query->result();
	
	}

}
