<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Online_transactions_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $branches = 'branches b';
	var $users = 'users u';
	var $prices = 'prices p';
	var $sections = 'sections s';
	var $events = 'events e';

	var $arrTListStat = array(); // status filter for TRANSACTION LISTING
	var $arrEventTListStat = array('reserved','unselected'); // status filter for EVENT TRANSACTION LISTING
	// using constructor function, get value of $arrEventTlistStat to make filter for transaction listing the same

	public function __construct()
	{
		parent::__construct();
		$this->load->model('payment_types_model', 'payment_types_model');
		$this->load->model('branches_model', 'branches_model');
		
		// same filter array. no reserve for display of TRANSACTION LISTING
		$this->arrTListStat = $this->arrEventTListStat;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->terminals, 't.transaction_terminal_id = te.terminal_id');
		$this->db->join($this->branches, 't.transaction_branch_id = b.branch_id');
		$this->db->join($this->users, 't.transaction_user_id = u.user_id');
		$this->db->join($this->customers, 't.transaction_customer_id = c.customer_id', 'left');
		$this->db->join('module_types mt', 'mt.module_type_transaction_id = t.transaction_id', 'left');
		
		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get($this->transactions);
	
		return $query->row();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_last_record
	 *
	 * @access	public
	 */
	function get_last_record()
	{
		$this->db->select_max('transaction_id');
		$this->db->where('transaction_status', 'done');
		$query = $this->db->get($this->transactions);
		$row = $query->row();
		return $row->transaction_id;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_transactions
	 *
	 * @access	public
	 */
	function get_transactions()
	{
		$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->order_by('t.transaction_id', 'desc');
		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$query = $this->db->get($this->transactions);
		
		return $query->result();
	}
		
		
	// --------------------------------------------------------------------
	
	/**
	 * get_terminal_transactions
	 *
	 * @access	public
	 */
	function get_terminal_transactions($transid, $name, $mobno, $offset = false, $limit = false)
	{
		if(!empty($transid) || !empty($name) || !empty($mobno))
		{
			if(!empty($transid))
			{
				$this->db->where('t.transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(c.customer_lastname, c.customer_firstname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('c.customer_mobile', $mobno);
			}
		}
		else
		{	
			// if ($this->session->userdata('user_branch_id') != 1)
			// {	
				// $this->db->where('t.transaction_branch_id', $this->session->userdata('user_branch_id'));
			// }
		}
		
		//$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, ti.ticket_branch_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
				, GROUP_CONCAT(DISTINCT ti.ticket_status) concat_tixstatus
 			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		// $this->db->join('module_types mt', 'mt.module_type_transaction_id = t.transaction_id', 'left');
		$this->db->group_by('t.transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);
		$this->db->where('customer_username !=', '');
		
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);
		return $query->result();
	}
	
	function get_terminal_transactions_by_customer($customer, $transid, $name, $mobno, $offset = false, $limit = false)
	{
	
		if(!empty($transid) || !empty($name) || !empty($mobno))
		{
			if(!empty($transid))
			{
				$this->db->where('t.transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(c.customer_lastname, c.customer_firstname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('c.customer_mobile', $mobno);
			}
		}
		else
		{	
			// if ($this->session->userdata('user_branch_id') != 1)
			// {	
				// $this->db->where('t.transaction_branch_id', $this->session->userdata('user_branch_id'));
			// }
		}
		
		//$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, ti.ticket_branch_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
				, GROUP_CONCAT(DISTINCT ti.ticket_status) concat_tixstatus
 			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		// $this->db->join('module_types mt', 'mt.module_type_transaction_id = t.transaction_id', 'left');
		$this->db->group_by('t.transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		
		$this->db->where('t.transaction_customer_id', $customer);
		
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);

		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	function get_terminal_transactions_allcount($transid, $name, $mobno)
	{
		$this->db->select('t.transaction_id');
		if(!empty($transid) || !empty($name) || !empty($mobno))
		{
			if(!empty($transid))
			{
				$this->db->where('transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(customer_lastname,customer_firstname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('customer_mobile', $mobno);
			}
		}
		else
		{	
			if ($this->session->userdata('user_branch_id') != 1)
			{	
				$this->db->where('transaction_branch_id', $this->session->userdata('user_branch_id'));
			}
		}

		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, ti.ticket_branch_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->group_by('ti.ticket_transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);

		$query = $this->db->get($this->transactions);
		return $result = $query->num_rows();

	}
	
	function get_terminal_transactions_allcount_alt($customer, $transid, $name, $mobno, $event_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if(!empty($transid) || !empty($name) || !empty($mobno)|| !empty($event_id))
		{
			if(!empty($transid))
			{
				$this->db->where('transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(customer_lastname,customer_firstname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('customer_mobile', $mobno);
			}
			if (!empty($event_id))
			{
				$this->db->where('ti.ticket_event_id', $event_id);
			}
		}
		else
		{	
			// if ($this->session->userdata('user_branch_id') != 1)
			// {	
				// $this->db->where('transaction_branch_id', $this->session->userdata('user_branch_id'));
			// }
		}

		$this->db->select('count(DISTINCT t.transaction_id) AS count_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		// $this->db->group_by('ti.ticket_transaction_id');
		// $this->db->order_by('t.transaction_id', 'desc');
		// $this->db->where('', $this->arrTListStat);
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);
		
		if($customer!='')$this->db->where('t.transaction_customer_id', $customer);
		$this->db->where('customer_username !=', '');
		
		$query = $this->db->get($this->transactions);
		$counter = 0;
		foreach($query->result() as $row) {
			$counter = $row->count_id;
		}
		return $counter;

	}
	
	function edit_details($transaction_id)
	{
		$fields = array(
			'dashboard_transaction_card_no'			=> $this->input->post('card_number'),
			'dashboard_transaction_extra'			=> $this->input->post('extra_field'),
			'dashboard_transaction_block_status'	=> $this->input->post('block_status'),
		);
		
		// insert to db
		
		$result = $this->get_payment_details($transaction_id);
		if($result){
			$this->db->where('dashboard_transaction_id', $transaction_id);
			$this->db->update('dashboard_transactions', $fields);
		
		}else{
			$fields['dashboard_transaction_id'] = $transaction_id;
			$this->db->insert('dashboard_transactions',$fields);
		
		}
		
		// return $this->db->insert_id();;
	}
	
	
	function get_payment_details($transaction_id){
	
	$this->db->where('dashboard_transaction_id',$transaction_id);
	$query = $this->db->get('dashboard_transactions');
	return $query->row();
	
	}
	
	function get_transaction_status() {
		$this->db->query('set transaction isolation level read uncommitted');
		// show columns from transactions like 'transaction_status';
		$fields = $this->db->query("show columns from transactions like 'transaction_status'")->result();
		// $fields = $this->db->field_data("transactions");
		$arrayinfo = array();

		foreach ($fields as $field) {
			$str = $field->Type;
		}
		$enum_pre = "enum('";
		$enum_post = "')";
		$str = substr($str,6,strlen($str)-strlen($enum_pre)-strlen($enum_post));
		$arrayinfo[] = "--ALL STATUS--";
		foreach(explode("','",$str) as $k=>$v) {
			$arrayinfo[$v] = "$v";
		}
		// print_r($arrayinfo);
		return $arrayinfo;
	}
	
	function get_online_transaction_dates()
	{
		
		$this->db->select("CONVERT(t.transaction_date,CHAR(10)) As transdate");
		$this->db->distinct();
		$this->db->order_by("t.transaction_date DESC");
		$this->db->where('t.transaction_user_id', 1);
		$query = $this->db->get($this->transactions);

		$arraydates["0000-00-00"] = "all";

		foreach ($query->result() as $row) {
			$arraydates[$row->transdate] = $row->transdate;
		}
		
		return $arraydates;
	}
	function get_all_online_transactions($transdate = false, $transtat = 0, $transid, $name, $mobno,$event_id, $offset = 0, $limit = 0)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $defdate = "1970-01-01";
		// $transdate = date("Y-m-d", strtotime($transdate));
		if(!empty($transid) || !empty($name) || !empty($mobno) || !empty($transdate)|| !empty($event_id))
		{
			if(!empty($transid))
			{
				$this->db->where('t.transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->where("(concat(c.customer_firstname,' ', c.customer_lastname) LIKE '%$name%')");

			}
			if (!empty($mobno))
			{
				$this->db->where('c.customer_mobile', $mobno);
			}
			if (!empty($event_id))
			{
				$this->db->where('ti.ticket_event_id', $event_id);
				
			}
		}
		// if (empty($transdate))
		// {
			// $transdate = $defdate;
		// }
		
		//$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, t.transaction_comment
				, t.transaction_ipay_status
				, ti.ticket_branch_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
				, GROUP_CONCAT(DISTINCT ti.ticket_status) concat_tixstatus
				, COUNT(ti.ticket_id) count_ticket_id
 				, s.section_name
				, p.price_name
				, p.price_id
				, ti.ticket_event_id
			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		// $this->db->join('module_types mt', 'mt.module_type_transaction_id = t.transaction_id', 'left');
		$this->db->where("t.transaction_date >= '$transdate 00:00:00'");
		if (strlen($transtat) > 1) {
			$this->db->where("t.transaction_status", $transtat); 
		}
		if ($transdate) {
			$this->db->where("t.transaction_date <= '$transdate 23:59:59'");
		}
		$this->db->where("t.transaction_user_id",1);
		$this->db->group_by('t.transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		// $this->db->where_not_in('t.transaction_status', $this->arrTListStat);
		// $this->db->where_in('ti.ticket_status', $this->arrTicketStat);
/* 
		if ($transdate == $defdate) {
			$limit = 50;
			$offset = 0;
		}
		 */
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);
			// echo $this->db->last_query();
		return $query->result();
	}

}
// END transactions_model.php
/* Location: ./application/models/transactions_model.php */		