<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Online_codes_model extends CI_Model
{

	var $events = 'events e';
	var $events_config = "events_config ec"; 
	var $venues = "venues v"; 
	public function __construct()
	{
		parent::__construct();
 	}
	
	function listing($active = false) {
		
		if ($active) {
			$this->db->where("event_online_concert", 1);
		}
		$this->db->join($this->events_config, 'ec.events_config_eventid = e.event_id', 'left');
		$this->db->join($this->venues, 'v.venue_id = e.event_venue_id', 'left');
		$this->db->where("event_online_concert", 1);
		return $this->db->get($this->events)->result();
	}
	
	
	function set_status($event_id = 0,$status = 0)
	{
		$retval = false;
		if ($event_id > 0) {
			$tablename = 'events_config';
			$where = "events_config_eventid = $event_id";

			$fields = array(
				'event_online_concert' => $status, 
			);
			// build insert SQL
			$__usql = $this->db->update_string($tablename, $fields, $where);
			$retval = $this->db->simple_query($__usql);
		}
		
		return $retval;
	}
	
	
	function getAll($event_id, $transtat = 0,$searchkey, $offset = 0, $limit = 0){
	

		if(!empty($searchkey))
		{
			foreach($searchkey as $x=>$y){
				
				if($y)
				$this->db->where($x, $y);
				
			}
			 
			
		}
		
		 
		if($transtat == '1')
		$this->db->where("online_code_transaction_id = 0");
		elseif($transtat == '2')
		$this->db->where("online_code_transaction_id != 0");

		 
		
		$this->db->where("online_code_event_id", $event_id);
		$this->db->order_by("online_code_id", "DESC");

		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get('online_codes');
		return $query->result();
	  
	}
	
	
	function countAll($event_id, $transid, $ticketid, $code)
	{
		if(!empty($transid) || !empty($code))
		{
			if(!empty($transid))
			{
				$this->db->where('online_code_transaction_id', $transid);
			}
			if (!empty($ticketid))
			{
				$this->db->where('online_code_ticket_id', $ticketid);
			}
			if (!empty($qrcode))
			{
				$this->db->where('online_code', $code);
			}
			
		}

		$this->db->select('count(DISTINCT online_code_id) AS count_id');
		$this->db->where('online_code_event_id', $event_id);
		$query = $this->db->get('online_codes');
		$counter = 0;
		foreach($query->result() as $row) {
			$counter = $row->count_id;
		}
		return $counter;

	}
	
	
	function add_entry($event_id=false, $csvdata=false)
	{
		/*
			Access Code = first 6-digits of barcode
			Range = 311100 to 322222

			Barcode length = 16
			
			Example: 
					311100 1234567890 Regular Day Pass
					311101 1234567890 Promo 1
		*/
		// print_r($csvdata);
		$valid = false;
		if (count($csvdata) > 0) {
			$code = $csvdata[0];
			$fields = array(
				'online_code_event_id'		=> $event_id,
				'online_code_price_id'		=> implode(",",$this->input->post('price_id')),
				'online_code'				=> $code,
 			);
			
			// build insert SQL
			$__isql = $this->db->insert_string('online_codes', $fields);
			$valid = $this->db->simple_query($__isql);
		} 
		return $valid;

	}

	
	function generate($event_id =false){
		 
		$prefix = $this->input->post('prefix');
		$chars = $this->input->post('chars');
		$numeric = $this->input->post('numeric');
		$upper = $this->input->post('upper');
		$lower = $this->input->post('lower');
		$no_codes = $this->input->post('no_codes');
		 
		$num ='0123456789';
		$upperc ='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$lowerc = 'abcdefghijklmnopqrstuvwxyz';
		
		$input = '';
		if($numeric){$input .= $num;}
		if($upper){$input .= $upperc;}
		if($lower){$input .= $lowerc;}
		if($prefix){$prefix = $prefix;}
		 
		$generated = array();
		
		for($x=0; $x < $no_codes; $x++ ){ 
			   
			$rand = $this->generate_string($input,$chars);
			
			if(in_array($rand,$generated)){ //check if string already exist
				$x--;
			}else{ 
				$generated[] = $rand;	
			}
		}
		 
		
		//prepare data
		$data = array();
		foreach($generated as $i){
			
			$data[] = array(
				'online_code_event_id'		=> $event_id,
				'online_code_price_id'		=> implode(",",$this->input->post('price_id')),
				'online_code'				=> $prefix . $i,
			);
		}
		
		$this->db->insert_batch('online_codes', $data);
		
		
		
	}
	
	function generate_string($input, $strength = 10) {
		$input_length = strlen($input);
		$random_string = '';
		for($i = 0; $i < $strength; $i++) {
			$random_character = $input[mt_rand(0, $input_length - 1)];
			$random_string .= $random_character;
		}
	 
		return $random_string;
	}
 
  
	
	
	function get_price_array($event_id = 0)
	{
		$result = array();

		if ($event_id > 0)
		{
			$this->db->where('pc.price_event_id', $event_id);
			// $this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
			$this->db->order_by('pc.price_price', 'desc'); 
			$query = $this->db->get('prices pc');
			
			// transform result into an associative array
			$result[0] = '';
			foreach($query->result() as $r)
			{
				$result[$r->price_id] = $r->price_name . ' (' . $r->price_price . ' pesos)';
			}
		}
		return $result;
	}
	
 
	
	
}

