	<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class New_reports_model extends CI_Model
{
	
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $prices = 'prices pr';

	var $ticket_types = 'ticket_types tt';
	var $events = 'events ev';
	var $venues = 'venues ve';
	var $promoters = 'promoters pro';
	var $users	=	'users u';
	var $branches = 'branches br';
	var $payments = 'payments pay';
	var $payment_types = 'payment_types pt';

	// added for consolidated reports  BY JAIZON
	var $sections = 'sections sec';
	var $seatplans = 'seatplans sea';
	
	//added for convenience charge report BY KOREWA
	var $charges = 'charges ch';
	
	
	public function __construct()
	{
		parent::__construct();
	}	
	
	
	function get_report_details(){
		$this->db->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');
		$this->db->select('event_id,event_title as event_name');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get('events');
		
		return $query->row();
	
	}
	
	
	function get_unredeemed_list(){
		$this->db->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');	
		$referrer = $this->input->get_post("referrer");
		
		$querystring = "SELECT 
		tr.transaction_id
		,CONCAT(cu.customer_firstname, ' ', cu.customer_lastname) AS customer
		,cu.customer_email
		,cu.customer_mobile
		,CONCAT(se.section_name,' ',GROUP_CONCAT( DISTINCT(ti.ticket_row), '', ti.ticket_seat,' ' SEPARATOR ' / ' )) as sec_row_seat
		,COUNT(ti.ticket_id) AS ticket_quantity
		,SUM(pr.price_price) as total_amount
		,SUM(CASE WHEN (tt.ticket_type_discount_type = 'Percentage') THEN ROUND(pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE ROUND(pr.price_price - tt.ticket_type_discount) END) as 'amount'
		,tr.transaction_date
	
	
		FROM transactions tr
		INNER JOIN tickets ti ON ti.ticket_transaction_id = tr.transaction_id
		INNER JOIN customers cu ON cu.customer_id = tr.transaction_customer_id
		INNER JOIN sections se ON se.section_id = ti.ticket_section_id 
		INNER JOIN prices pr ON pr.price_id = ti.ticket_price_id
		INNER JOIN ticket_types tt ON tt.ticket_type_id = ti.ticket_type_id 
				 
			
		WHERE ti.ticket_event_id = ". $event_id ."
		AND ti.ticket_transaction_id != 0 
		AND tr.transaction_status in('paid_online')";
		
		if($referrer){
				$querystring = $querystring . "	AND tr.transaction_referrer = '". $referrer . "'";
		}
		
		$querystring = $querystring . "GROUP BY tr.transaction_id";
		$query = $this->db->query($querystring);
		
		return $query->result();
	
	
	}
	 
	
	function top_spenders_list_by_qty(){
	$this->db->query('set transaction isolation level read uncommitted');
	$event_id = $this->input->post('event_id');	
	
	if($event_id != "0"){
		
	$querystring = "select
					 cu.customer_id as CustomerID
					 ,GROUP_CONCAT( distinct(tr.transaction_id) SEPARATOR ' | ') as TransID
					,CONCAT(cu.customer_firstname, ' ', cu.customer_lastname) AS Name
					,count(tix.ticket_id) as Qty
					,SUM(pr.price_price) as Amount
					from customers cu
					left join transactions tr on tr.transaction_customer_id = cu.customer_id 
					left join tickets tix on tix.ticket_transaction_id = tr.transaction_id
					left join events ev on ev.event_id = tix.ticket_event_id
					left join ticket_types tt on tt.ticket_type_id = tix.ticket_type_id 
					left join prices pr ON pr.price_id = tix.ticket_price_id 
					where tr.transaction_branch_id = '90' and
					ev.event_id = " . $event_id . " and 
					tr.transaction_status != 'unselected' and 
					tix.ticket_status != 'unselected'
					GROUP BY
					cu.customer_id 
					ORDER BY
					Qty DESC    
					LIMIT 20
					";
	}else{
		$querystring = "select
					 cu.customer_id as CustomerID
					 ,GROUP_CONCAT( distinct(tr.transaction_id) SEPARATOR ' | ') as TransID
					,CONCAT(cu.customer_firstname, ' ', cu.customer_lastname) AS Name
					,count(tix.ticket_id) as Qty
					,SUM(pr.price_price) as Amount
					from customers cu
					left join transactions tr on tr.transaction_customer_id = cu.customer_id 
					left join tickets tix on tix.ticket_transaction_id = tr.transaction_id
					left join ticket_types tt on tt.ticket_type_id = tix.ticket_type_id 
					left join prices pr ON pr.price_id = tix.ticket_price_id 
					where tr.transaction_branch_id = '90' and
					tr.transaction_status != 'unselected' and 
					tix.ticket_status != 'unselected'
					GROUP BY
					cu.customer_id 
					ORDER BY
					Qty DESC    
					LIMIT 20
					";
	}
	
	$query = $this->db->query($querystring);
	
	return $query->result();
}



	function top_spenders_list_by_amount(){
		$this->db->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');	
		$query = $this->db->query("
		
		select
		 cu.customer_id as CustomerID
		 ,GROUP_CONCAT( distinct(tr.transaction_id) SEPARATOR ' | ') as TransID
		,CONCAT(cu.customer_firstname, ' ', cu.customer_lastname) AS Name
		,count(tix.ticket_id) as Qty
		,SUM(pr.price_price) as Amount
		
		from customers cu
		
		left join transactions tr on tr.transaction_customer_id = cu.customer_id 
		left join tickets tix on tix.ticket_transaction_id = tr.transaction_id
		left join events ev on ev.event_id = tix.ticket_event_id
		left join ticket_types tt on tt.ticket_type_id = tix.ticket_type_id 
		left join prices pr ON pr.price_id = tix.ticket_price_id 
		where tr.transaction_branch_id = '90' and
		ev.event_id = " . $event_id . " and 
		tr.transaction_status != 'unselected' and 
		tix.ticket_status != 'unselected'
		GROUP BY
		cu.customer_id 
		
		ORDER BY
		Amount DESC    
		
		LIMIT 20
		
		");
		
		return $query->result();
	}
	
	
	function get_sold_seats($status,$event_id){
		$this->db->query('set transaction isolation level read uncommitted');
	// echo $status . ' ' . $event_id;
	// Die();
	
	
        $query = $this->db->query("

        select
        ti.ticket_transaction_id as trans_id
        ,ti.ticket_id
        ,se.section_name
        ,ti.ticket_row
        ,ti.ticket_seat
         from
		 
        tickets ti

        left join sections se on se.section_id = ti.ticket_section_id

        where ti.ticket_event_id = '$event_id'
        and ti.ticket_status = '$status'

        ");
        return $query->result();

     }

	function get_eplus_report_list(){
	
		$this->db->query('set transaction isolation level read uncommitted');
		$date = $this->input->post('reports_date');	
		$query = $this->db->query("
		
		SELECT 
		ev.event_long_title
		,ev.event_code
		,ti.ticket_transaction_id 
		,ti.ticket_id
		,tu.ticket_used_card_number
		,CONCAT(cu.customer_firstname, ' ', cu.customer_lastname) AS customer
		,tt.ticket_type_name
		,tu.ticket_used_card_type

		,CONCAT(u.user_firstname, ' ', u.user_lastname) AS user 		



		,branch_name as branch		 
	
		FROM tickets_used tu
		left JOIN tickets ti ON ti.ticket_id = tu.ticket_used_ticket_id
		left JOIN transactions tr ON tr.transaction_id = ti.ticket_transaction_id
		left JOIN events ev ON ev.event_id = ti.ticket_event_id
		left JOIN customers cu ON cu.customer_id = tr.transaction_customer_id
		left JOIN ticket_types tt ON tt.ticket_type_id = ti.ticket_type_id
		left JOIN users u ON u.user_id = tu.ticket_used_user_id



		left JOIN branches b ON b.branch_id = u.user_branch_id 			

		WHERE ticket_used_date_created LIKE '%$date%'
		AND ti.ticket_transaction_id != 0 
		AND ti.ticket_status = 'done'
		GROUP BY tu.ticket_used_ticket_id
		
		");
		
		return $query->result();
	
	
	}
		
	function get_event_title()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		
		if($this->session->userdata('user_branch_id') == 144){
		$this->db->where('event_id',5645);
		}
		
		
		$this->db->order_by('event_date_time', 'desc');
		$query = $this->db->get('events');
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			$array[''] = '';
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			
			return $array;
		}
		else
		{
			return $result;
		}
	}	
	
	function get_ticket_list(){
	$this->db->query('set transaction isolation level read uncommitted');
	$event_id = $this->input->post('event_id');
	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$status = $this->input->post('status');
	$ticket_types = $this->input->post('ticket_types');

	
	$this->db->select('
		p.price_name,
		p.price_price,
		tr.transaction_id,
		t.ticket_id,
		t.ticket_status,
		t.ticket_row,
		t.ticket_seat,
		b.branch_name,
		tr.transaction_date,
		tr.transaction_comment,
		tt.ticket_type_name, 
		ut.used_entry_datetime as date_used,
		ut.used_last_date as last_accessed,
		c.customer_firstname,
		c.customer_lastname,
		c.customer_mobile, 
		c.customer_registration_code, 
		pt.payment_type_name, 
		s.section_name,
		st.*  
		
	');
	
	
	
	$this->db->join('ticket_types tt', 'tt.ticket_type_id = t.ticket_type_id');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id');
	$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id');
	$this->db->join('branches b', 'b.branch_id = t.ticket_branch_id');
	$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id');
	$this->db->join('used_tickets ut', 'ut.used_ticket_id = t.ticket_id','left');
	$this->db->join('sections s', 's.section_id = t.ticket_section_id','left');
	$this->db->join('payments pay', 'pay.payment_transaction_id = tr.transaction_id','left');
	$this->db->join('payment_types pt', 'pt.payment_type_id = pay.payment_payment_type_id','left');
	$this->db->join('senior_transactions st', 'st.senior_ticket_id = t.ticket_id','left');
	
	
	if($status == 'voided'){
	$this->db->select('v.*,
		u.username, br.branch_name as branch_voided');

	
	$this->db->join('voided_transactions v', 'v.voided_transaction_id = tr.transaction_id','left');
	$this->db->join('users u', 'u.user_id = v.voided_user_id','left');
	$this->db->join('branches br', 'br.branch_id = u.user_branch_id','left');
	
 
	}
	
	$this->db->where("date(tr.transaction_date) <=", $date_to);
	$this->db->where("t.ticket_event_id", $event_id);
	 
		
	if($status == 'unredeemed'){
  
		$this->db->where("t.ticket_status", 'paid_online');
		
	}else{
		
		$this->db->where("t.ticket_status", $status);
		
	}
	
	
	if($ticket_types)
	$this->db->where('t.ticket_type_id', $ticket_types);
	
	 
	if($status == 'paid_online'){
		$this->db->where('t.ticket_branch_id <>', 90);
	}
	
	
	
	if($date_from)
	$this->db->where("date(tr.transaction_date) >=", $date_from);
	$this->db->group_by('t.ticket_id');
	$this->db->order_by('tr.transaction_date','desc');
 
	$query = $this->db->get('tickets t');
	return $query->result();
	
	
	}
	
	function get_ticket_list_duplicate(){
	$this->db->query('set transaction isolation level read uncommitted');
	$event_id = $this->input->post('event_id');
	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$status = $this->input->post('status');
	$ticket_types = $this->input->post('ticket_types');

	
	$this->db->select('
		p.price_name,
		p.price_price,
		tr.transaction_id,
		t.ticket_id,
		t.ticket_status,
		t.ticket_row,
		t.ticket_seat,
		b.branch_name,
		tr.transaction_date,
		tr.transaction_comment,
		tt.ticket_type_name, 
		ut.used_entry_datetime as date_used,
		ut.used_last_date as last_accessed,
		c.customer_firstname,
		c.customer_lastname,
		c.customer_mobile, 
		pt.payment_type_name, 
		s.section_name,
		st.*  
		
	');
	
	
	
	$this->db->join('ticket_types tt', 'tt.ticket_type_id = t.ticket_type_id');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id');
	$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id');
	$this->db->join('branches b', 'b.branch_id = t.ticket_branch_id');
	$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id');
	$this->db->join('used_tickets ut', 'ut.used_ticket_id = t.ticket_id','left');
	$this->db->join('sections s', 's.section_id = t.ticket_section_id','left');
	$this->db->join('payments pay', 'pay.payment_transaction_id = tr.transaction_id','left');
	$this->db->join('payment_types pt', 'pt.payment_type_id = pay.payment_payment_type_id','left');
	$this->db->join('senior_transactions st', 'st.senior_ticket_id = t.ticket_id','left');
	
	
	if($status == 'voided'){
	$this->db->select('v.*,
		u.username, br.branch_name as branch_voided');

	
	$this->db->join('voided_transactions v', 'v.voided_transaction_id = tr.transaction_id','left');
	$this->db->join('users u', 'u.user_id = v.voided_user_id','left');
	$this->db->join('branches br', 'br.branch_id = u.user_branch_id','left');
	
 
	}
	
	$this->db->where("date(tr.transaction_date) <=", $date_to);
	$this->db->where("t.ticket_event_id", $event_id);
	 
		
	if($status == 'unredeemed'){
  
		$this->db->where("t.ticket_status", 'paid_online');
		
	}else{
		
		$this->db->where("t.ticket_status", $status);
		
	}
	
	
	if($ticket_types)
	$this->db->where('t.ticket_type_id', $ticket_types);
	
	 
	if($status == 'paid_online'){
		$this->db->where('t.ticket_branch_id <>', 90);
	}
	
	
	
	if($date_from)
	$this->db->where("date(tr.transaction_date) >=", $date_from);
	$this->db->group_by('t.ticket_id');
	$this->db->order_by('tr.transaction_date','desc');
 
	$query = $this->db->get('tickets_backup t');
	return $query->result();
	
	
	}
	
	
	function get_branches_dropdown_for_cc()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$this->db->where('branch_id !=', 40);
		if ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db->where('branch_id', $this->session->userdata('user_branch_id'));
		}
		$this->db->like('branch_name','DS-SM');
		$this->db->order_by('branch_name');
		$query = $this->db->get('branches');
			
		$result = $query->result();
		
		if ($result)
		{
			// add an empty array 
			if ($this->session->userdata('user_branch_id') == 1)
			{
				$array[''] = '';
			}
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}

	}
	
	function get_ticket_types_dropdown()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_name');
		$this->db->where('ticket_type_active', 1); 
		$query = $this->db->get('ticket_types');
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			$array[''] = '';
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	 
	function get_event_title_conso()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		$this->db->order_by('event_long_title', 'asc');
		$this->db->group_by('event_long_title');
		$query = $this->db->get('events');
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			$array[''] = '';
			foreach($result as $r)
			{
				$array[$r->event_long_title] = $r->event_long_title;
			}
			
			return $array;
		}
		else
		{
			return $result;
		}
	}

	function get_customer_list(){
	$this->db->query('set transaction isolation level read uncommitted');
	$event = $this->input->post('event_id');
	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$status = $this->input->post('status');
	$ticket_types = $this->input->post('ticket_types');
	
	
	$this->db->select('  
		c.customer_firstname,
		c.customer_lastname,
		c.customer_mobile,
		c.customer_email, 
		GROUP_CONCAT(s.section_name ) as section_name
	');
	
  	$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id');
 	$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id');
	$this->db->join('events e', 'e.event_id = t.ticket_event_id'); 
	$this->db->join('sections s', 's.section_id = t.ticket_section_id');
  
	$this->db->where("date(tr.transaction_date) <=", $date_to);
	$this->db->where("e.event_long_title", $event);
	$this->db->where("t.ticket_status", $status);
	
	if($ticket_types)
	$this->db->where('t.ticket_type_id', $ticket_types);
	
	 
	
	if($date_from)
	$this->db->where("date(tr.transaction_date) >=", $date_from);
	$this->db->order_by('c.customer_email','desc');
	$this->db->group_by('c.customer_id','desc');
 
	$query = $this->db->get('tickets t');
	return $query->result();
	
	
	}
		
	function onlineclaimed_transactions($date_from, $date_to, $eventid, $branchid, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$online_branch_id = $this->reports->gbiddos();
		$this->db->select('ev.event_title, ev.event_code, ev.event_internet_sales_charge, t.transaction_id, ti.ticket_transaction_id, c.customer_firstname, c.customer_lastname, tt.ticket_type_name');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('ti.ticket_date_printed >=', $date_from);
		$this->db->where('ti.ticket_date_printed <=', $date_to);
		$this->db->where('t.transaction_user_id', '1');
		$this->db->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db->where('ti.ticket_branch_id', $branchid);
			}
			else{
				$this->db->join('branches br', 'br.branch_id = ti.ticket_branch_id', 'left outer');
				$this->db->like('br.branch_name', 'DS-SM'); 
			}
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db->where('ti.ticket_user_id', $seller);
		}
		
		$this->db->group_by('t.transaction_id'); 
		$this->db->order_by('ev.event_id', 'asc'); 
		
		$query = $this->db->get('transactions t');
		return $query->result();
	}
	
	function total_transaction($date_from, $date_to, $eventid, $branchid, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('COUNT(t.transaction_id) as total_trasaction');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left');
		$this->db->where('ti.ticket_date_printed >=', $date_from);
		$this->db->where('ti.ticket_date_printed <=', $date_to);
		
		$this->db->where('t.transaction_user_id', '1');
		$this->db->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db->where('ti.ticket_branch_id', $branchid);
			}
			else{
			
				$this->db->join('branches br', 'br.branch_id = ti.ticket_branch_id', 'left outer');
				$this->db->like('br.branch_name', 'DS-SM'); 
			}
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db->where('ti.ticket_user_id', $seller);
		}	
		$this->db->group_by('t.transaction_id'); 
		
		$query = $this->db->get('transactions t');
		return $query->num_rows();
	}
	
 	 
	function get_issued_eplus_cards($date_from = false, $date_to = false , $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date <=', $date_to.' 23:59:59');
		
		// $this->db->where('t.ticket_event_id' ,2488);
		
		$this->db->group_by('eplus_card_ticket_id');
		
		$query = $this->db->get('eplus_cards e');
		return $query->result();
	}
	
	function get_issued_eplus_cards_one($date_from = false, $date_to = false , $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_claim_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date_claimed >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date_claimed <=', $date_to.' 23:59:59');
		
		$this->db->where_in('t.ticket_event_id' ,array(2472,2488));
		
		$this->db->group_by('eplus_card_ticket_id');
		
		$query = $this->db->get('eplus_cards e');
		return $query->result();
	}

	function get_issued_eplus_cards_one_group($date_from = false, $date_to = false , $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('count(distinct(t.ticket_id)) as count,b.branch_name');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_claim_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date_claimed >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date_claimed <=', $date_to.' 23:59:59');
		
		$this->db->where_in('t.ticket_event_id' ,array(2472,2488));
		
		$this->db->group_by('b.branch_id');
		
		$query = $this->db->get('eplus_cards e');
		return $query->result();
	}

	
	function get_branches_dropdown()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->order_by('branch_name');
		$query = $this->db->get($this->branches);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[''] = '';
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	
	function onlineclaimed_transactions_mw($date_from, $date_to, $eventid, $branchid, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//$online_branch_id = $this->reports->gbiddos();
		$this->db->select('ev.event_title, ev.event_code, ev.event_internet_sales_charge, t.transaction_id, ti.ticket_transaction_id, c.customer_firstname, c.customer_lastname, tt.ticket_type_name');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db->where('ti.ticket_date_printed >=', $date_from);
		$this->db->where('ti.ticket_date_printed <=', $date_to);
		$this->db->where('t.transaction_user_id', '1');
		$this->db->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db->where('ti.ticket_branch_id', $branchid);
			}
			else{
				$this->db->join('branches br', 'br.branch_id = ti.ticket_branch_id', 'left outer');
				$this->db->like('br.branch_name', 'MW-'); 
			}
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db->where('ti.ticket_user_id', $seller);
		}
		
		$this->db->group_by('t.transaction_id'); 
		$this->db->order_by('ev.event_id', 'asc'); 
		
		$query = $this->db->get('transactions t');
		return $query->result();
	}

	function total_transaction_mw($date_from, $date_to, $eventid, $branchid, $seller)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('COUNT(t.transaction_id) as total_trasaction');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left');
		$this->db->where('ti.ticket_date_printed >=', $date_from);
		$this->db->where('ti.ticket_date_printed <=', $date_to);
		
		$this->db->where('t.transaction_user_id', '1');
		$this->db->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db->where('ti.ticket_branch_id', $branchid);
			}
			else{
			
				$this->db->join('branches br', 'br.branch_id = ti.ticket_branch_id', 'left outer');
				$this->db->like('br.branch_name', 'MW-'); 
			}
		}
		else
		{
			$this->db->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db->where('ti.ticket_user_id', $seller);
		}	
		$this->db->group_by('t.transaction_id'); 
		
		$query = $this->db->get('transactions t');
		return $query->num_rows();
	}
	
		
	//iptl
	function get_all_issued_eplus_cards($date_from = false, $date_to = false , $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,e.eplus_card_event_date,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,3370);
		
		$this->db->group_by('eplus_card_id');
		
		$query = $this->db->get('eplus_cards e');
		return $query->result();
	}

	function get_all_issued_eplus_cards_generic($date_from = false, $date_to = false , $event_id = false, $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,e.eplus_card_event_date,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,$event_id);
		
		$this->db->group_by('eplus_card_id');
		
		$query = $this->db->get('eplus_cards e');
		return $query->result();
	}
	
	
	function get_all_voided_eplus_cards($date_from = false, $date_to = false , $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,3370);
		$this->db->where('e.eplus_card_event_date !=' ,'NULL');
		
		$this->db->group_by('eplus_card_id');
		
		$query = $this->db->get('eplus_card_logs e');
		return $query->result();
	}
	
	function get_all_voided_eplus_cards_generic($date_from = false, $date_to = false , $event_id = false , $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,$event_id);
		$this->db->where('e.eplus_card_event_date !=' ,'NULL');
		
		$this->db->group_by('eplus_card_id');
		
		$query = $this->db->get('eplus_card_logs e');
		return $query->result();
	}
	
	function get_customer_list_online(){
	$this->db->query('set transaction isolation level read uncommitted');
	$event = $this->input->post('event_id');
	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$status = $this->input->post('status');
	$ticket_types = $this->input->post('ticket_types');
	
	
	$this->db->select('  
		c.customer_firstname,
		c.customer_lastname,
		c.customer_mobile,
		c.customer_birthdate, 
		c.customer_gender, 
		c.customer_address1, 
		c.customer_mobile, 
		c.customer_email, 
		c.customer_tsize, 
		c.customer_ticketID, 
		p.price_name, 
		p.price_price, 
		c.customer_registration_date
	');
	
  	$this->db->join('prices p', 'p.price_id = c.customer_run_category');
	$this->db->join('events e', 'e.event_id = c.customer_event_id');

	$this->db->where("date(c.customer_registration_date) <=", $date_to);
	$this->db->where("e.event_long_title", $event);
	// $this->db->where("t.ticket_status", $status);
	
	// if($ticket_types)
	// $this->db->where('t.ticket_type_id', $ticket_types);
	
	 
	
	if($date_from)
	$this->db->where("date(c.customer_registration_date) >=", $date_from);
	$this->db->group_by('c.customer_ticketID');
 
	$query = $this->db->get('online_customers c');
	return $query->result();
	
	
	}
		
		
	function get_ticket_list_conso(){
	$this->db->query('set transaction isolation level read uncommitted');
	$event_id = $this->input->post('event_id');
	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$status = $this->input->post('status');
	$ticket_types = $this->input->post('ticket_types');
	
	
	$this->db->select('
		p.price_name,
		p.price_price,
		tr.transaction_id,
		t.ticket_id,
		t.ticket_status,
		t.ticket_row,
		t.ticket_seat,
		b.branch_name,
		tr.transaction_date,
		tr.transaction_comment,
		tt.ticket_type_name, 
		ut.used_entry_datetime as date_used,
		ut.used_last_date as last_accessed,
		c.customer_firstname,
		c.customer_lastname,
		c.customer_mobile, 
		pt.payment_type_name, 
		s.section_name ,
		e.event_date_time, 
		e.event_title
		
	
	');
	//	e.event_title
	$this->db->join('ticket_types tt', 'tt.ticket_type_id = t.ticket_type_id');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id');
	$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id');
	$this->db->join('branches b', 'b.branch_id = t.ticket_branch_id');
	$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id');
	$this->db->join('used_tickets ut', 'ut.used_ticket_id = t.ticket_id','left');
	$this->db->join('sections s', 's.section_id = t.ticket_section_id','left');
	$this->db->join('payments pay', 'pay.payment_transaction_id = tr.transaction_id','left');
	$this->db->join('payment_types pt', 'pt.payment_type_id = pay.payment_payment_type_id','left');
	$this->db->join('events e', 'e.event_id = t.ticket_event_id','left');
 
 
	if($status == 'voided'){
	$this->db->select('v.*,
		u.username ');
	
	$this->db->join('voided_transactions v', 'v.voided_transaction_id = tr.transaction_id','left');
	$this->db->join('users u', 'u.user_id = v.voided_user_id','left');
 
	}
	
 
 
	$this->db->where("date(tr.transaction_date) <=", $date_to);
	// $this->db->where("t.ticket_event_id", $event_id);
	 
	if($status == 'unredeemed'){
 
		
		$this->db->where("t.ticket_status", 'paid_online');
		
	}else{
		
		$this->db->where("t.ticket_status", $status);
		
	}
	
	
	$this->db->where('e.event_long_title', $event_id); 
	if($ticket_types)
	$this->db->where('t.ticket_type_id', $ticket_types);
	
	 
	if($status == 'paid_online'){
		$this->db->where('t.ticket_branch_id <>', 90);
	}
	
	if($date_from)
	$this->db->where("date(tr.transaction_date) >=", $date_from); 
	$this->db->group_by('t.ticket_id');
	$this->db->order_by('e.event_id','desc');
	// $this->db->limit(2);
 
	$query = $this->db->get('tickets t');
	return $query->result();
	
	
	}
	
	function get_ticket_list_v2(){
	$this->db->query('set transaction isolation level read uncommitted');
	$event_id = $this->input->post('event_id');
	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$status = $this->input->post('status');
	$ticket_types = $this->input->post('ticket_types');
	
	
	$this->db->select("
		CONCAT(s.section_name, ' ', GROUP_CONCAT(DISTINCT(t.ticket_row), '', t.ticket_seat, ' '  order by t.ticket_row,t.ticket_seat * 1 asc SEPARATOR ' / ' )) AS price_name, 
		sum(p.price_price) as price_price,
		tr.transaction_id,
 		t.ticket_status, 
		b.branch_name,
		tr.transaction_date,
		tr.transaction_comment,
		tt.ticket_type_name, 
		ut.used_entry_datetime as date_used,
		ut.used_last_date as last_accessed,
		c.customer_firstname,
		c.customer_lastname,
		c.customer_mobile, 
		pt.payment_type_name, 
 		st.* 
		 
	", false);
	
	$this->db->join('ticket_types tt', 'tt.ticket_type_id = t.ticket_type_id');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id');
	$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id');
	$this->db->join('branches b', 'b.branch_id = t.ticket_branch_id');
	$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id');
	$this->db->join('used_tickets ut', 'ut.used_ticket_id = t.ticket_id','left');
	$this->db->join('sections s', 's.section_id = t.ticket_section_id','left');
	$this->db->join('payments pay', 'pay.payment_transaction_id = tr.transaction_id','left');
	$this->db->join('payment_types pt', 'pt.payment_type_id = pay.payment_payment_type_id','left');
	$this->db->join('senior_transactions st', 'st.senior_ticket_id = t.ticket_id','left');
 
 	
	if($status == 'voided'){
	$this->db->select('v.*,
		u.username ');
	
	$this->db->join('voided_transactions v', 'v.voided_transaction_id = tr.transaction_id','left');
	$this->db->join('users u', 'u.user_id = v.voided_user_id','left');
 
	}
	
  
	$this->db->where("date(tr.transaction_date) <=", $date_to);
	$this->db->where("t.ticket_event_id", $event_id);
	
	if($status == 'unredeemed'){
 
		
		$this->db->where("t.ticket_status", 'paid_online');
		
	}else{
		
		$this->db->where("t.ticket_status", $status);
		
	}
	
 
	if($ticket_types)
	$this->db->where('t.ticket_type_id', $ticket_types);
	
	 
	if($status == 'paid_online'){
		$this->db->where('t.ticket_branch_id <>', 90);
	}
	
	if($date_from)
	$this->db->where("date(tr.transaction_date) >=", $date_from);
	$this->db->group_by('tr.transaction_id');
	$this->db->order_by('tr.transaction_date','desc');
 
	$query = $this->db->get('tickets t');
	return $query->result();
	
	
	}
	
	
	//dreamplay
	function get_all_issued_deplus_cards_generic($date_from = false, $date_to = false , $event_id = false, $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,c.customer_firstname, c.customer_lastname,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id', 'left');
		$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_card_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_card_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,$event_id);
		
		$this->db->group_by('eplus_card_id');
		
		$query = $this->db->get('eplus_cards_dreamplay e');
		return $query->result();
	}
	
	function get_all_issued_deplus_cards_generic_voided($date_from = false, $date_to = false , $event_id = false, $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,c.customer_firstname, c.customer_lastname,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id', 'left');
		$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id', 'left');
		
	  
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_cart_void_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_cart_void_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,$event_id);
		$this->db->where('e.eplus_card_type' ,'Edited');
		
		$this->db->group_by('eplus_card_id');
		
		$query = $this->db->get('eplus_cards_dreamplay_voided_logs e');
		return $query->result();
	}
	function get_all_issued_deplus_cards_generic_voided2($date_from = false, $date_to = false , $event_id = false, $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('e.*,c.customer_firstname, c.customer_lastname,s.section_name,u.user_firstname,u.user_lastname,b.branch_name,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id', 'left');
		$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id', 'left');
		
	  
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('e.eplus_cart_void_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('e.eplus_cart_void_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,$event_id);
		$this->db->where('e.eplus_card_type' ,'Lost');
		
		$this->db->group_by('eplus_card_id');
		
		$query = $this->db->get('eplus_cards_dreamplay_voided_logs e');
		return $query->result();
	}
	
	 function get_all_entry_logs($date_from = false, $date_to = false , $event_id = false, $branch = false)
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('el.*,e.*,c.customer_firstname, c.customer_lastname,s.section_name,u.user_firstname,u.user_lastname,t.ticket_id,t.ticket_transaction_id');
		$this->db->join('eplus_cards_dreamplay e', 'e.eplus_card_id = el.eplus_card_id', 'left');
		$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id', 'left');
		$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
		$this->db->join('users u', 'u.user_id = e.eplus_card_user_id', 'left');
		$this->db->join('branches b', 'b.branch_id = u.user_branch_id', 'left');
		$this->db->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id', 'left');
		$this->db->join('customers c', 'c.customer_id = tr.transaction_customer_id', 'left');
		
	  
		
		if($branch)
		$this->db->where('b.branch_id', $branch);
		
		if($date_from)
		$this->db->where('el.eplus_card_log_date >=', $date_from.' 00:00:01');
		
		if($date_to)
		$this->db->where('el.eplus_card_log_date <=', $date_to.' 23:59:59');
		
		$this->db->where('t.ticket_event_id' ,$event_id);
		$this->db->where('eplus_card_log_type' , 'Access');
		$this->db->order_by('eplus_card_log_id', 'desc');
		$this->db->group_by('eplus_card_log_id');
		
		$query = $this->db->get('eplus_cards_dreamplay_entry_logs el');
		return $query->result();
	}
	
	function get_event_title_for_lgu()
	{
		 $this->db->query('set transaction isolation level read uncommitted');
		$this->db->join('events_config ec','ec.events_config_eventid = ev.event_id','left');
		$this->db->order_by('event_date_time', 'desc');
		//$this->db->where('ec.events_config_turnstile_active',1); 
		
		if($this->session->userdata('user_branch_id') == 144){
		$this->db->where('event_id',5645);
		}
		
		$query = $this->db->get($this->events);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title; 
			}
			
			// $array["0"] = "ALL EVENTS";
			
			return $array;
		}
		else
		{
			return $result;
		}
	}

	
	
	function get_lgu_report(){
		$this->db->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');	
		$date_filter = $this->input->post('date_filter');
		$date_to = $this->input->post('date_filter');
		$date_from = $this->input->post('date_filter_from');
		$date_entry = "used_entry_datetime";
		
		if($event_id=="5304"){
			$date_entry = "used_last_date";
		}
		
		if($date_from==$date_to) :
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and date($date_entry) <= '$date_from' and date($date_entry) >=  '$date_to'
						and used_remark is NULL 
						
						order by p.price_price  desc 
						";
		
		elseif($date_from!=$date_to) :
		// $date_to = date('Y-m-d',date(strtotime("+1 day", strtotime($date_filter))));
		
		// echo $date_to;
		// die();
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and date($date_entry) >= '$date_from' and date($date_entry) <=  '$date_to'
						and used_remark is NULL 
						
						order by p.price_price  desc 
						";
	 
		else:
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_remark is NULL 
						order by p.price_price  desc 
						";
	 
		endif;
	 
		$query = $this->db->query($querystring);
		return $query->result();
	}
	
	
	
	function get_lgu_report_list(){
		$this->db->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');	
		$date_filter = $this->input->post('date_filter');
	
		if($date_filter) :	
		$date_to = date('Y-m-d',date(strtotime("+1 day", strtotime($date_filter))));
	 
			
			
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_remark is NULL 
						and used_entry_datetime is not NULL 
						and used_entry_datetime between '$date_filter' and '$date_to'
						order by ut.used_id  desc 
						";
						
		else:				
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_remark is NULL 
						and used_entry_datetime is not NULL 
						order by ut.used_id  desc 
						";
						
						
		endif;				
						
	 
		$query = $this->db->query($querystring);
		
		return $query->result();
	}

	function get_payment_tender_report(){
		
		ini_set("memory_limit","3072M");

		$event_id = $this->input->post('event_id');
		$reports_date = $this->input->post('reports_date');
		$reports_date_from = $this->input->post('reports_date_from');
		
		$this->db->query('set transaction isolation level read uncommitted');
		
		// SUMMARY TABLE: identify all tickets and transactions with DONE status and do data prep for display
		$this->db->select('
				t.transaction_branch_id
				, date(t.transaction_date) transdate
				, t.transaction_id
				, t.transaction_cash_change
				, p.payment_id
				, tix.ticket_id
				, tix.ticket_price_id
				, p.payment_payment_type_id
				, pt.payment_type_type
				, pt.payment_type_name
				, tix.ticket_type_id
				, pr.price_name
				, pr.price_price
				, p.payment_amount
				, p.payment_amount_voided
				, p.payment_amount_type
				, t.transaction_status
				, tix.ticket_status
				, tix.ticket_section_id
				, ttp.ticket_type_group
				, chr.charge_amount
				, chr.charge_amount_voided
				, chr.charge_type
				, ta.total_payment_type_id

 			');
		$this->db->from('tickets tix');
		$this->db->join('transactions t', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
		$this->db->join('payments p', 't.transaction_id = p.payment_transaction_id', 'LEFT');
		$this->db->join('payment_types pt', 'pt.payment_type_id = p.payment_payment_type_id', 'LEFT');
		$this->db->join('prices pr', 'tix.ticket_price_id = pr.price_id', 'LEFT');
		$this->db->join('ticket_types ttp', 'tix.ticket_type_id = ttp.ticket_type_id', 'LEFT');
		$this->db->join('charges chr', 't.transaction_id = chr.charge_transaction_id', 'LEFT');
		$this->db->join('total_amount ta', 't.transaction_id = ta.total_transaction_id', 'LEFT');
  		$this->db->where_in('tix.ticket_event_id', $event_id);
		$this->db->where('t.transaction_status', 'done');
		$this->db->where('tix.ticket_status', 'done');
		$this->db->where('date(t.transaction_date) <= ', $reports_date);
		$this->db->where('ttp.ticket_type_group', 0);
		//check if DS head office 
		if($this->session->userdata('user_branch_id') == 142){ 
			$this->db->where('branch_category','SM Dept. Store');
		}
		
		if ($reports_date_from) {
			$this->db->where('date(t.transaction_date) >= ', $reports_date_from);
		}
	
		$this->db->group_by('payment_id');	
		
		$query = $this->db->get();
		return $query->result();
		
	}
	 
	function get_payment_tender_qty_report(){
		
		ini_set("memory_limit","3072M");
		$event_id = $this->input->post('event_id');
		$reports_date = $this->input->post('reports_date');
		$reports_date_from = $this->input->post('reports_date_from');
		
		$this->db->query('set transaction isolation level read uncommitted');
		
		// SUMMARY TABLE: identify all tickets and transactions with DONE status and do data prep for display
		$this->db->select('
				t.transaction_branch_id
				, date(t.transaction_date) transdate
				, t.transaction_id
 				, tix.ticket_id
				, tix.ticket_price_id
  				, tix.ticket_type_id
 				, pr.price_name
				, pr.price_price
				, p.payment_payment_type_id
 				, t.transaction_status
				, tix.ticket_status
				, tix.ticket_section_id
				, ttp.ticket_type_group
				 , ttp.ticket_type_name

 			');
		$this->db->from('tickets tix');
		$this->db->join('transactions t', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
  		$this->db->join('prices pr', 'tix.ticket_price_id = pr.price_id', 'LEFT');
		$this->db->join('payments p', 't.transaction_id = p.payment_transaction_id', 'LEFT');
		$this->db->join('ticket_types ttp', 'tix.ticket_type_id = ttp.ticket_type_id', 'LEFT');
 		$this->db->where_in('tix.ticket_event_id', $event_id);
		$this->db->where('t.transaction_status', 'done');
		$this->db->where('tix.ticket_status', 'done');
		$this->db->where('ttp.ticket_type_group', 0);
		$this->db->where('date(t.transaction_date) <= ', $reports_date);
		
		//check if DS head office 
		if($this->session->userdata('user_branch_id') == 142){ 
			$this->db->where('branch_category','SM Dept. Store');
		}
		
		if ($reports_date_from) {
			$this->db->where('date(t.transaction_date) >= ', $reports_date_from);
		}
	
		$this->db->group_by('ticket_id');	
		
		$query = $this->db->get();
		return $query->result();
		
	}
	
		 
	function get_payment_tender_report2(){
		
		ini_set("memory_limit","3072M");

		$event_id = $this->input->post('event_id');
		$reports_date = $this->input->post('reports_date');
		$reports_date_from = $this->input->post('reports_date_from');
		
		$this->db->query('set transaction isolation level read uncommitted');
		
		// SUMMARY TABLE: identify all tickets and transactions with DONE status and do data prep for display
		$this->db->select('
				t.transaction_branch_id
				, date(t.transaction_date) transdate
				, t.transaction_id
				, t.transaction_cash_change
				, p.payment_id
				, tix.ticket_id
				, tix.ticket_price_id
				, p.payment_payment_type_id
				, pt.payment_type_type
				, pt.payment_type_name
				, tix.ticket_type_id
				, pr.price_name
				, pr.price_price
				, p.payment_amount
				, p.payment_amount_voided
				, p.payment_amount_type
				, t.transaction_status
				, tix.ticket_status
				, tix.ticket_section_id
				, ttp.ticket_type_group
				, chr.charge_amount
				, chr.charge_amount_voided
				, chr.charge_type
				, ta.total_payment_type_id
				, ttp.ticket_type_name

 			');
		$this->db->from('tickets tix');
		$this->db->join('transactions t', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
		$this->db->join('payments p', 't.transaction_id = p.payment_transaction_id', 'LEFT');
		$this->db->join('payment_types pt', 'pt.payment_type_id = p.payment_payment_type_id', 'LEFT');
		$this->db->join('prices pr', 'tix.ticket_price_id = pr.price_id', 'LEFT');
		$this->db->join('ticket_types ttp', 'tix.ticket_type_id = ttp.ticket_type_id', 'LEFT');
		$this->db->join('charges chr', 't.transaction_id = chr.charge_transaction_id', 'LEFT');
		$this->db->join('total_amount ta', 't.transaction_id = ta.total_transaction_id', 'LEFT');
  		$this->db->where_in('tix.ticket_event_id', $event_id);
		$this->db->where('t.transaction_status', 'done');
		$this->db->where('tix.ticket_status', 'done');
		$this->db->where('date(t.transaction_date) <= ', $reports_date);
		$this->db->where('ttp.ticket_type_group', 0);
		// $this->db->where('ttp.ticket_type_id', 1);
		// $this->db->where_in('tix.ticket_price_id', array(31580,31579));
		//check if DS head office 
		if($this->session->userdata('user_branch_id') == 142){ 
			$this->db->where('branch_category','SM Dept. Store');
		}
		
		if ($reports_date_from) {
			$this->db->where('date(t.transaction_date) >= ', $reports_date_from);
		}
	
		$this->db->group_by('ticket_id');	
		
		$query = $this->db->get();
		return $query->result();
		
	}
	
	
	//for archived tickets
		
	function get_lgu_report_duplicate(){
		$this->db->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');	
		$date_filter = $this->input->post('date_filter');
		$date_from = $this->input->post('date_from');
	
		if($date_from) :	
		$date_to = date('Y-m-d',date(strtotime("+1 day", strtotime($date_filter))));
		
		// echo $date_to;
		// die();
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets_backup t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_entry_datetime between '$date_from' and '$date_to'
						and used_remark is NULL 
						
						order by p.price_price  desc 
						";
	 
		else:
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets_backup t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_remark is NULL 
						order by p.price_price  desc 
						";
	 
		endif;
	 
	 
	 
		$query = $this->db->query($querystring);
		
		return $query->result();
	}
	
	
	
	function get_lgu_report_list_duplicate(){
		$this->db->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');	
		$date_filter = $this->input->post('date_filter');
	
		if($date_filter) :	
		$date_to = date('Y-m-d',date(strtotime("+1 day", strtotime($date_filter))));
	 
			
			
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets_backup t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_remark is NULL 
						and used_entry_datetime is not NULL 
						and used_entry_datetime between '$date_filter' and '$date_to'
						order by ut.used_id  desc 
						";
						
		else:				
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets_backup t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_remark is NULL 
						and used_entry_datetime is not NULL 
						order by ut.used_id  desc 
						";
						
						
		endif;				
						
	 
		$query = $this->db->query($querystring);
		
		return $query->result();
	}

	function get_refund_summary(){
	$this->db->query('set transaction isolation level read uncommitted');
 	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');

	if(!$date_from){
		$date_from = "1970-01-01";
	}
	
	$sql = "SELECT 
	a.event_title , sum(a.total_amount) AS total_amount
	FROM(
	SELECT 
	e.event_id,e.event_title, CASE When p.payment_payment_type_id = 1 Then p.payment_amount - transaction_cash_change -  p.payment_amount_voided ELSE 0 END AS total_amount 
	FROM `queue_refund` `q`
	JOIN `tickets` `t` ON `q`.`queue_refund_transaction_id` = `t`.`ticket_transaction_id`  
	JOIN `events` `e` ON `e`.`event_id` = `t`.`ticket_event_id`
	JOIN `transactions` `tr` ON `tr`.`transaction_id` = `t`.`ticket_transaction_id`

	JOIN `payments` `p` ON `p`.`payment_transaction_id` = `t`.`ticket_transaction_id` -- AND `p`.`payment_payment_type_id` = 1
	WHERE DATE(q.queue_refund_date) <= ? AND DATE(q.queue_refund_date) >= ?
	GROUP BY `t`.ticket_transaction_id
	 )AS a 
	 GROUP BY a.event_id";
 	$query = $this->db->query($sql, [$date_to, $date_from]);
	return $query->result();

	}
	
	function get_refund_daily(){
	$this->db->query('set transaction isolation level read uncommitted');
 	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');

	if(!$date_from){
		$date_from = "1970-01-01";
	}
	
	$sql = "SELECT q.queue_refund_date,q.date_modified, q.queue_refund_number,t.ticket_transaction_id as transaction_id, c.customer_firstname, c.customer_lastname, e.event_title, branch_name,
 CASE When p.payment_payment_type_id = 1 Then p.payment_amount - transaction_cash_change -  p.payment_amount_voided ELSE 0 END AS total_amount 
	FROM `queue_refund` `q`
	JOIN `tickets` `t` ON `q`.`queue_refund_transaction_id` = `t`.`ticket_transaction_id`
	JOIN `events` `e` ON `e`.`event_id` = `t`.`ticket_event_id`
	JOIN `transactions` `tr` ON `tr`.`transaction_id` = `t`.`ticket_transaction_id`
	JOIN customers c ON c.customer_id = tr.transaction_customer_id
	LEFT JOIN branches b ON b.branch_id = queue_refund_branch_id
	JOIN `payments` `p` ON `p`.`payment_transaction_id` = `t`.`ticket_transaction_id`  -- AND `p`.`payment_payment_type_id` = 1
	WHERE DATE(q.queue_refund_date) <= ? AND DATE(q.queue_refund_date) >= ?
	GROUP BY `t`.ticket_transaction_id ORDER BY q.queue_refund_date,q.queue_refund_number asc";
 	$query = $this->db->query($sql, [$date_to, $date_from]);
	return $query->result();

	}
	
	function get_ticket_print_summary(){
	$this->db->query('set transaction isolation level read uncommitted');
 	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$date_to = date('Y-m-d', strtotime("+1 day", strtotime($date_to)));


	if(!$date_from){
		$date_from = "1970-01-01";
	}
	
	$sql = "SELECT 
	b.event_id,b.event_title, b.total_qty, b.sold_online, b.sold_otc, b.redeemed, b.online_voided, b.otc_voided
	FROM(
	SELECT 
		a.event_seatplan_id,a.event_id,a.event_title, sum(a.total_qty) AS total_qty, sum(a.sold_online) AS sold_online, sum(a.sold_otc) AS sold_otc, sum(a.redeemed) AS redeemed, SUM(a.online_voided) AS online_voided, SUM(a.otc_voided) AS otc_voided
	FROM(
	SELECT
		e.event_title
		,e.event_id
		,e.event_seatplan_id
		,1 AS total_qty
		, IF(tr.transaction_branch_id = 90 AND t.ticket_status = 'paid_online', '1','0') AS sold_online
		, IF(tr.transaction_branch_id <> 90 AND t.ticket_status = 'done', '1','0') AS sold_otc
		, IF(tr.transaction_branch_id = 90 AND t.ticket_status = 'done', '1','0') AS redeemed
		, IF(tr.transaction_branch_id = 90 AND t.ticket_status = 'voided', '-1','0') AS online_voided
		, IF(tr.transaction_branch_id <> 90 AND t.ticket_status = 'voided', '-1','0') AS otc_voided
		FROM historical_tickets t 
		LEFT JOIN historical_transactions tr ON tr.transaction_id = t.ticket_transaction_id
		LEFT JOIN events e ON e.event_id = t.ticket_event_id
		WHERE t.ticket_status IN ('done','paid_online','voided') 
		AND t.ticket_date_entered BETWEEN ? AND ?
		-- AND t.ticket_transaction_id = 2607
		 GROUP BY t.ticket_id, t.ticket_status
	)AS a

	GROUP BY a.event_id
	) AS b

 	 GROUP BY b.event_id";
 	$query = $this->db->query($sql, [$date_from, $date_to]);
	return $query->result();

	}
	
	function get_event_cap($event_ids)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where_in('price_event_id', $event_ids);
		$query = $this->db->get($this->prices);
		$prices = $query->result();
		
		
			
		$sections = array();
		$event_cap = array();
		foreach ($prices as $price)
		{
			 
			$sections = unserialize($price->price_sections);

			$this->db->select('sum(section_capacity) as cap');
			$this->db->where_in('section_id', $sections);
 			$query = $this->db->get($this->sections);
			if(!isset($event_cap[$price->price_event_id])) $event_cap[$price->price_event_id] = 0;
 			$event_cap[$price->price_event_id] += $query->row()->cap;
			
			 
		}
		
		 
		
		// echo '<pre>';
		// print_r($event_cap);
		// die();
		
		return $event_cap;
	}
	
	  
    function get_eft_transactions(){
	$this->db->query('set transaction isolation level read uncommitted');
 	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
	$branch_id = $this->input->post('branch_id');
 

	if(!$date_from){
		$date_from = "1970-01-01";
	}
	
 
		
	$this->db->select("branch_name, user_firstname, user_lastname, ticket_transaction_id,
	e.eft_payment_date, payment_type_name,payment_type_type, eft_payment_amount as payment_amount,
	eft_merchant_num, eft_card_num, eft_approval_code,eft_terminal_num,
	eft_invoice_num,eft_cardholder_name");
	
	$this->db->where_not_in('payment_type_type',[1,59]);
	$this->db->where('e.eft_payment_date >=', $date_from.' 00:00:01'); 
	$this->db->where('e.eft_payment_date <=', $date_to.' 23:59:59');
	
	if($branch_id){
		$this->db->where('ticket_branch_id',$branch_id);
	}
	$this->db->join('eft_payments_info ep', 'e.eft_payment_id = ep.eft_payment_id');
	$this->db->join('tickets t', 't.ticket_session_id = e.eft_payment_order_id');
	$this->db->join('branches b', 'b.branch_id = t.ticket_branch_id');
	$this->db->join('users u', 'u.user_id = e.eft_payment_user_id');
	//$this->db->join('payments p', 'p.payment_id = e.eft_payment_id');
	$this->db->join('payment_types pt', 'pt.payment_type_id = ep.eft_payment_type_id');
	 
	$this->db->group_by('eft_id');
	$this->db->order_by('eft_id','desc');
	
	$query = $this->db->get('eft_payments e');
	//die($this->db->last_query());
	return $query->result();

	}
	
}		
// END reports_model.php
/* Location: ./application/models/reports_model.php */		



