<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Logs_Online_model extends CI_Model
{
	var $ologs = 'logs_online';

	public function __construct()
	{
		parent::__construct();
	}

	function add_info_to_review($data) {
		$action = array(
				"tid" => 0,
				"action" => "REVIEW", 
				"details" => $data,
			);
		$this->__add($action);
	}
	
	function add_arrayinfo_to_review($data) {
		$action = array(
				"tid" => 0,
				"action" => "REVIEW", 
				"details" => serialize($data),
			);
		$this->__add($action);
	}

	function add_return_receipt($transaction_id, $paycode="") {
		$action = array(
				"tid" => $transaction_id,
				"action" => "COMPLETED", 
			);
		
		$this->__add($action);
	}
	
	function add_return_from_payment_gateway($transaction_id, $paycode="") {
		$action = array(
				"tid" => $transaction_id,
				"action" => "RETURN_$paycode", 
			);
		
		$this->__add($action);
	}
	
	function add_payment_attempt($transaction_id) {
		$action = array(
				"tid" => $transaction_id,
				"action" => "PREPAY_START", 
			);
		
		$this->__add($action);
	}

	function add_payment_attempt_validated($transaction_id, $paycode="") {
		$action = array(
				"tid" => $transaction_id,
				"action" => "PAYCODE_$paycode",
			);
		
		$this->__add($action);
	}
	
	function __add($action)
	{
		if (!isset($action["action"])) {
			$action["action"] = "OLOG";
		}
		
		if (!isset($action["cid"])) {
			$action["cid"] = ($this->session->userdata('cid')) ? $this->session->userdata('cid') : 0;
		}

		$referrer = (isset($_SERVER["HTTP_REFERER"])) ? $_SERVER["HTTP_REFERER"] : '';
		if (!isset($action["details"])) {
			if (isset($_POST)) {
				$formdata = $_POST;
				if (isset($formdata["password"])) {
					unset($formdata["password"]);
				}
				$action["details"] = serialize($formdata);
			} else {
				$action["details"] = "";
			}
		}
		

		$fields = array(
			'olog_action'			=>	'0:'.$action["action"],
			'olog_customer_id'		=> 	($action["cid"]*1),
			'olog_transaction_id'	=> 	($action["tid"]*1),
			'olog_uri'				=> 	$_SERVER["REQUEST_URI"],
			'olog_ip_address'		=>	get_ip_address(),
			'olog_referrer'			=> 	$referrer,
			'olog_details'			=>	$action["details"],
		);

		// insert to db
		$this->db->set($fields);
		$this->db->insert($this->ologs);
		return true;
	}	

}

