<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Liquidation_report_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $prices = 'prices pr';

	var $ticket_types = 'ticket_types tt';
	var $events = 'events ev';
	var $venues = 'venues ve';
	var $promoters = 'promoters pro';
	var $users	=	'users u';
	var $branches = 'branches br';
	var $payments = 'payments pay';
	var $payment_types = 'payment_types pt';

	// added for consolidated reports  BY JAIZON
	var $sections = 'sections sec';
	var $seatplans = 'seatplans sea';
	
	//added for convenience charge report BY KOREWA
	var $charges = 'charges ch';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * for review
	 *
	 * @access	public
	 */
	 
	 function for_review(){
		$details = serialize($_POST);
		 
		$fields = array(
		'event_id'				=> $this->input->post('event_id'),
		'commission_type'		=> $this->input->post('commission_type'),
		'processor_id'			=> $this->session->userdata('user_id'),
		'status'				=> 1,
		'process_date'			=> date("Y-m-d H:i:s"),		
		'commission_details'	=> $details		
		);
		
		$this->db->set($fields);
		$this->db->insert('liquidation_report');
		 
	 }
	 
	 /**
	 * checking
	 *
	 * @access	public
	 */
	 
	 /**
	 * validate process LR
	 *
	 * @access	public
	 */
	 
	function for_review_validation($event_id){
		$this->db->select('lr_no, event_id, commission_details');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get('liquidation_report lr');
		// echo $this->db->last_query();
		// die();
		$row =  $query->row();
		
		return $row->event_id;
		 
	 }
	 
	 function check_reviewed($lr_no){
		$this->db->select('reviewer_id');
		$this->db->where('lr_no', $lr_no);
		$query = $this->db->get('liquidation_report lr');
		// echo $this->db->last_query();
		// die();
		$row =  $query->row();
		
		return $row->reviewer_id;
		 
	 }
	 
	 function check($lr_no)
	{
		$fields = array(
			'reviewer_id'		=> $this->session->userdata('user_id'),				
			'check_date'		=> date("Y-m-d H:i:s"),			
			'status'			=> 2				
		);
		$this->db->where('lr_no', $lr_no);
		$this->db->update('liquidation_report', $fields);
		return true;
	}
	
	 function checkedd($lr_no,$user_id)
	{
		$fields = array(
			'reviewer_id'		=> $user_id,				
			'check_date'		=> date("Y-m-d H:i:s"),			
			'status'			=> 2				
		);
		$this->db->where('lr_no', $lr_no);
		$this->db->update('liquidation_report', $fields);
		return true;
	}
	/**
	 * get liquidation list
	 *
	 * @access	public
	 */
	 
	 /**
	 * for edit
	 *
	 * @access	public
	 */
	 
	 function update($lr_no){
		$details = serialize($_POST);
		 
		$fields = array(
		'event_id'				=> $this->input->post('event_id'),
		'commission_type'		=> $this->input->post('commission_type'),
		// 'processor_id'			=> $this->session->userdata('user_id'),
		// 'status'				=> 0,
		'remarks'				=> $this->input->post('remarks'),
		'process_date'			=> date("Y-m-d H:i:s"),		
		'commission_details'	=> $details		
		);
		
		// $this->db->set($fields);
		$this->db->where('lr_no', $lr_no);
		$this->db->update('liquidation_report', $fields);
		return true;
		 
	 }
	 
	function get_lr_list($searchkey=false, $offset = false, $limit = false)
	{
		$this->db->select('e.event_id,lr.status, e.event_title, e.event_date_time, u.user_firstname as "processor_firstname", u.user_lastname as  "processor_lastname", us.user_firstname as "reviewer_firstname", us.user_lastname as "reviewer_lastname",process_date,check_date, lr_no, pr.promoter_name, v.venue_name');
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}
		
		$this->db->join('users u', 'u.user_id = lr.processor_id', 'left');
		$this->db->join('users us', 'us.user_id = lr.reviewer_id', 'left');
		$this->db->join('events e', 'e.event_id = lr.event_id', 'left');
		$this->db->join('promoters pr', 'e.event_promoter_id = pr.promoter_id', 'left');
		$this->db->join('seatplans s', 'e.event_seatplan_id = s.seatplan_id', 'left');
		$this->db->join('venues v', 'v.venue_id = s.seatplan_venue_id', 'left');
		
		$this->db->order_by('lr.lr_no', 'desc');
		$this->db->limit(30);
		$query = $this->db->get('liquidation_report lr');
		
		// echo $this->db->last_query();
		// die();
		return $query->result();
	}
	
	/**
	 * get lr info
	 *
	 * @access	public
	 */
	function get_lr($lr_id = false)
	{
		$this->db->select('lr_no, event_id, commission_details');
		$this->db->where('lr_no', $lr_id);
		$query = $this->db->get('liquidation_report lr');
		// echo $this->db->last_query();
		// die();
		$row =  $query->row();
		
		return $row->commission_details;
	}
	// --------------------------------------------------------------------
	
}		
// END reports_model.php
/* Location: ./application/models/reports_model.php */		
