<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class gtqr_model extends CI_Model
{

	var $events = 'events e';
	var $events_config = "events_config ec";
	var $guestlist = "guestlist gl";
	var $guestlist_config = "guestlist_config gc";
	var $guestlist_config_ext = "guestlist_config_ext gce";
	var $guestlist_transactions = "guestlist_transactions glt";
	var $venues = "venues v";
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('sections_model', 'sections');
		// $this->load->model('events_model', 'events');
	}
	
	function add_entry($event_id=false, $csvdata=false)
	{
		/*
			Access Code = first 6-digits of barcode
			Range = 311100 to 322222

			Barcode length = 16
			
			Example: 
					311100 1234567890 Regular Day Pass
					311101 1234567890 Promo 1
		*/
		// print_r($csvdata);
		$valid = false;
		if (count($csvdata) > 0) { 
			$fields = array(
				'qr_event_id'		=> $event_id,
				'qr_qrcode'			=> $csvdata[0],
				'qr_price_id'		=> $csvdata[1],
				'qr_ticket_type_id'	=> $csvdata[2],
				'qr_type'			=> $csvdata[3],
				'qr_start_date'		=> $csvdata[4],
				'qr_end_date'		=> $csvdata[5]
			);
			
			// build insert SQL
			$__isql = $this->db->insert_string('qrcode', $fields);
			$valid = $this->db->simple_query($__isql);
		}
		return $valid;

	}

	function listing($active = false) {
		
		if ($active) {
			$this->db->where("events_config_qrcode_active", 1);
		}
		$this->db->join($this->events_config, 'ec.events_config_eventid = e.event_id', 'left');
		$this->db->join($this->venues, 'v.venue_id = e.event_venue_id', 'left');
		$this->db->where("events_config_qrcode_active", 1);
		return $this->db->get($this->events)->result();
	}
	
	function set_qrsale_listing_config($event_id = 0,$status = 0)
	{
		$retval = false;
		if ($event_id > 0) {
			$tablename = 'events_config';
			$where = "events_config_eventid = $event_id";

			$fields = array(
				'events_config_qrcode_active' => $status, 
			);
			// build insert SQL
			$__usql = $this->db->update_string($tablename, $fields, $where);
			$retval = $this->db->simple_query($__usql);
		}
		
		return $retval;
	}
	
	function qrcodelist($event_id = 0, $show_all = false, $view_usedqrcode = false) {

		$retval = false;
		
		if ($event_id > 0) {
			$this->db->join('prices pr', 'pr.price_id = qr.qr_price_id', 'left');
			// $this->db->join('tickets tix', 'tix.ticket_id = ekb.ek_ticket_id', 'left');
			$this->db->where("qr_event_id", $event_id);
			if ($show_all) {} 
			else {
				// if ($view_usedqrcode) {
				// 	$this->db->where("qr_transaction_id IS NULL");
				// } else {
				// 	$this->db->where("qr_transaction_id IS NOT NULL");
				// }
			}
			$this->db->order_by("qr_id", "DESC");
			$retval = $this->db->get('qrcode qr')->result();
		}
		
		return $retval;
	}
	
	function mark_qrcode_for_transaction_id($event_id, $transaction_id, $qrcode) {
			
			if($event_id == 2888  || $event_id == 4472|| $event_id == 6404){
			
			}else{ 
				$fields['qr_transaction_id'] = $transaction_id;
				$this->db->where('qr_event_id', $event_id);
				$this->db->where('qr_qrcode', $qrcode);
				$this->db->limit(1);
				$this->db->update('qrcode', $fields);
			}
			
	}
	
	
	function check_qrcode(){
	
		$user_id = $this->session->userdata('user_id');
		$event_id = $this->session->userdata('cei');
		$qrCode = $this->input->post('qrCode');
		$this->db->where('qr_qrcode', $qrCode);
		$this->db->where('qr_event_id', $event_id);
		$query = $this->db->get('qrcode');
		$count =  $query->num_rows();
		if($count > 0){
		
			$result = $query->row();
			
			if($result->qr_transaction_id == null && ($result->qr_user_id == null or $result->qr_user_id == $user_id)){
				$this->session->set_userdata('cqr', $qrCode);
				$this->setuser($qrCode);
				return 'ok';
			}
			elseif($result->qr_transaction_id != null)
				return 'not';
			elseif($result->qr_transaction_id == null && $result->qr_user_id != null)
				return 'selected';
			
			 

		}elseif($qrCode == 'F2686CE0'){
			return 'ok';
		}else{
			return false;
		}
	
	}
	
	function setuser($qrCode){
		
		
		if($this->session->userdata('cei') == 4472 || $this->session->userdata('cei') == 6404){
		
		
		}else{
		
			$user_id = $this->session->userdata('user_id');
			$fields['qr_user_id'] = $user_id;
			$this->db->where('qr_qrcode', $qrCode);
			$this->db->update('qrcode', $fields);
		}
	}
	
	function getAll($event_id, $transtat = 0, $transid, $qrcode, $offset = 0, $limit = 0){
	

		if(!empty($transid) || !empty($qrcode))
		{
			if(!empty($transid))
			{
				$this->db->where('qr_transaction_id', $transid);
			}
			if (!empty($qrcode))
			{
				$this->db->where('qr_qrcode', $qrcode);
			}
			
		}
		
		if ($transtat <> "0") {
			if($transtat == '1')
			$this->db->where("qr_transaction_id",0);
			else
			$this->db->where("qr_transaction_id > 0");

		}
		
		$this->db->where("qr_event_id", $event_id);
		$this->db->order_by("qr_id", "DESC");

		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get('qrcode');
		return $query->result();
	

	
	}
	
	function countAll($event_id, $transid, $qr_code)
	{
		if(!empty($transid) || !empty($qr_code))
		{
			if(!empty($transid))
			{
				$this->db->where('qr_transaction_id', $transid);
			}
			if (!empty($qrcode))
			{
				$this->db->where('qr_qrcode', $qrcode);
			}
			
		}

		$this->db->select('count(DISTINCT qr_id) AS count_id');
		$this->db->where('qr_event_id', $event_id);
		$query = $this->db->get('qrcode');
		$counter = 0;
		foreach($query->result() as $row) {
			$counter = $row->count_id;
		}
		return $counter;

	}
	
	
	
	
	
}

