<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Files_model extends CI_Model
{
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
		
		$this->load->library('upload');
		$this->load->library('image_lib');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * upload_logo
	 *
	 */
	function upload_logo()
	{
		$upload_path = './uploads/logos/';
	
		// config settings for file upload
		$config['overwrite'] = TRUE;
		$config['upload_path'] = $upload_path;
		$config['allowed_types'] = 'gif|jpg|png';
	
		$this->upload->initialize($config);
		
		// upload the file
		if ($this->upload->do_upload('logo'))
		{
			// uploaded data
			$data = $this->upload->data();
			$filename = $data['file_name'];
			
			// resize the file
			$config['image_library'] = 'gd2';
			$config['source_image'] = $data['full_path'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 100;
			$config['height'] = 80;
	
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			
			// delete the original file
			//unlink($data['full_path']);
			
			// image path
			$image_path = 'logos/' . $filename;
			 
			return array($filename, $image_path);
		}
		else
		{
			// show error message
			echo $this->upload->display_errors();
		}	
	}
	
	//for uploading poster
	function upload_poster()
	{
		$upload_path = $this->prepare_directory_by_name('posters');

		if ($upload_path) {
			// config settings for file upload
			$config['overwrite'] = TRUE;
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = 'gif|jpg|png';
		
			$this->upload->initialize($config);
			
			// upload the file
			if ($this->upload->do_upload('poster'))
			{
				// uploaded data
				$data = $this->upload->data();
				//title		
				$title = $this->input->post('event_title');
				$newtitle = str_replace (" ", "", $title);
				$newname = preg_replace("/[^a-zA-Z0-9\s]/", "", $newtitle);
				$filename = date("YmdHis").$newname.$data['file_name'];
				//end of title
				
				$filewh = $data['image_width'].' x '.$data['image_height'];
				$filesize = $data['file_size'];
				
				// image path
				$image_path = $upload_path . $filename;
				$path = rename($data['full_path'], $data['file_path'].$filename);
				
				// resize the file
				$config['image_library'] = 'gd2';
				$config['source_image'] = $data['file_path'].$filename;
				$config['maintain_ratio'] = TRUE;
				$config['width'] = 100;
				$config['height'] = 80;
		
				//$this->image_lib->initialize($config);
				//$this->image_lib->resize();
				
				// delete the original file
				//unlink($data['full_path']);
				
				
				 
				return array($filename, $image_path, $filewh, $filesize);
			}
		}
		
		
		// show error message
		echo $this->upload->display_errors();
	}
	
	//for uploading ads
	function upload_ad($imageName=false)
	{
		$upload_path = $this->prepare_directory_by_name();		
		list($month, $year) = $this->prepare_directory();

		$ads_type = $this->input->post('ad_type');
				
		if ($upload_path) {
			// config settings for file upload
			$config['overwrite'] = TRUE;
			$config['upload_path'] = $upload_path;
			// $config['allowed_types'] = 'gif|jpg|png';
			$config['allowed_types'] = 'jpg|png';
			$config['max_size'] = 200;
		
			$this->upload->initialize($config);

			// upload the file
			if ($this->upload->do_upload('ad'))
			{
				// uploaded data
				$data = $this->upload->data();

				//title		
				$title = $this->input->post('ad_title');
				
				$newtitle = str_replace (" ", "", $title);
				$newname = preg_replace("/[^a-zA-Z0-9\s]/", "", $newtitle);
				
				$filename = $imageName;
				// $filename = rename(sha1(rand()) . $data['file_ext'], "as");
				
				//end of title
				
				$filewh = $data['image_width'].' x '.$data['image_height'];
				$filesize = $data['file_size'];
				
				// image path
				// $image_path = $upload_path . $filename;
				$image_path = $upload_path . $filename;

				$path = rename($data['full_path'], $data['file_path'].$filename);
				
				// resize the file
				$config['image_library'] = 'gd2';
				$config['source_image'] = $data['file_path'].$filename;
				$config['maintain_ratio'] = TRUE;
				$config['width'] = 100;
				$config['height'] = 80;
		
				// $this->image_lib->initialize($config);
				// $this->image_lib->resize();
				
				// delete the original file
				//unlink($data['full_path']);
				
				$optimize = $this->optimize_image($data['file_path'].$filename,$data['file_path'].$filename,$ads_type);		

				return array($filename, $image_path, $filewh, $filesize);
			}

			else {
				return array($this->upload->display_errors(), "", "", "");
			}
		}
	}
	
	
	//for uploading gallery images
	function upload_gallery_images()
	{
		$upload_path = $this->prepare_directory_by_name('gallery');
			
				
		
				
		if ($upload_path) {
			// config settings for file upload
			$config['overwrite'] = TRUE;
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = 'gif|jpg|png';
		
			$this->upload->initialize($config);
			
		
			
			// upload the file
			if ($this->upload->do_upload('image'))
			{
				// uploaded data
				$data = $this->upload->data();

				//title		
				$title = $this->input->post('image_title');
				
				$newtitle = str_replace (" ", "", $title);
				$newname = preg_replace("/[^a-zA-Z0-9\s]/", "", $newtitle);
				
				// $filename = date("YmdHis").$newname.$data['file_name'];
		
				$filename = $data['file_name'];
				
				//end of title
				
				$filewh = $data['image_width'].' x '.$data['image_height'];
				$filesize = $data['file_size'];
				
				// image path
				// $image_path = $upload_path . $filename;
				$image_path = $upload_path;

				$path = rename($data['full_path'], $data['file_path'].$filename);
				
				// resize the file
				$config['image_library'] = 'gd2';
				$config['source_image'] = $data['file_path'].$filename;
				$config['maintain_ratio'] = TRUE;
				$config['width'] = 100;
				$config['height'] = 80;
		
				//$this->image_lib->initialize($config);s
				//$this->image_lib->resize();
				
				// delete the original file
				//unlink($data['full_path']);

				return array($filename, $image_path, $filewh, $filesize);
			}
			else{
			
			Die('ayaw');
			}
			
			
		}
		// Die('kamote');
		
		// show error message
		echo $this->upload->display_errors();
	
	
	}
	
	
	
	//for embeding videos
/* 	function embed_video()
	{
		$video_name = $this->input->post('video_name');
		$event_id = $this->input->post('event_id');
		$video_url = $this->input->post('video_url');
				
		// add video to db
		$fields = array(
			'video_name'		=> $video_name
			'video_event_id'	=> $event_id,
			'video_url'			=> $video_url,

		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('videos');
		
		return $this->db->insert_id();

	} */
	
	//for uploading banner
	function upload_banner($newName)
	{
		$upload_path = $this->prepare_directory_by_name('banners');
		list($month, $year) = $this->prepare_directory();

		if ($upload_path) {
			// config settings for file upload
			$config['overwrite'] = TRUE;
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = 'gif|jpg|png';
			$config['max_size'] = 200;

			$this->upload->initialize($config);
			
			// upload the file
			if ($this->upload->do_upload('banner'))
			{
				// uploaded data
				$data = $this->upload->data();
				$title = $this->input->post('event_title');
				$newtitle = str_replace (" ", "", $title);
				$newname = preg_replace("/[^a-zA-Z0-9\s]/", "", $newtitle);
				$filename = $newName;
				//$fullpath = $data['file_path'].$filename;
				$path = rename($data['full_path'], $data['file_path'].$filename);
				$filewh = $data['image_width'].' x '.$data['image_height'];
				$filesize = $data['file_size'];
				
				// resize the file
				$config['image_library'] = 'gd2';
				$config['source_image'] = $data['file_path'].$filename;
				$config['maintain_ratio'] = TRUE;
				$config['width'] = 100;
				$config['height'] = 80;
		
				//$this->image_lib->initialize($config);
				//$this->image_lib->resize();
				
				// delete the original file
				//unlink($data['full_path']);
				
				// image path
				$image_path = $upload_path . $filename;
				 
				return array($filename, $image_path, $filewh, $filesize);
			} 
			else {
				return array($this->upload->display_errors(), "", "", "");
			}
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * upload_image
	 *
	 */
	function upload_image($field_name, $max_width, $max_height, $newName=false)
	{
	
	
		$upload_path = './uploads/images';
		
		// prepare the directory
		list($month, $year) = $this->prepare_directory();
		
		// config settings for file upload
		$config['overwrite'] = TRUE;
		// $config['file_name'] = 'kamote';
		$config['upload_path'] = $upload_path;
		$config['allowed_types'] = 'gif|jpg|png';
		$config['max_size'] = 200;

		$this->upload->initialize($config);

		// upload the file
		if ($this->upload->do_upload($field_name))
		{
			// uploaded data
			$data = $this->upload->data();

			
			// resize the file
			$config['image_library'] = 'gd2';
			$config['source_image'] = $data['full_path'];
			$image = $newName;


			// $image = $data['raw_name'];
			$config['new_image'] = $image;
			$config['maintain_ratio'] = TRUE;
			$config['width'] = $max_width;
			$config['height'] = $max_height;

			$this->image_lib->initialize($config);
			$this->image_lib->resize();

			$this->upload->initialize($config);

			
			// delete the original file
			unlink($data['full_path']);
			
			// image path
			// $image_path = $year . '/' . $month . '/' . $image;
			
			$path = "./uploads/images/".$newName;
			// $optimize = $this->optimize_image($path,$path);
			
			return $newName;
		}
		else
		{
			// show error message
			return $this->upload->display_errors();
		}	
	}
	


	function upload_image_1($field_name, $max_width, $max_height,$newName=false,$version=false)
	{

	
		if(!$field_name){
		return false;
		}
		else{
		$upload_path = './uploads/images';
	
		// prepare the directory
		list($month, $year) = $this->prepare_directory();
		
		// config settings for file upload
		$config['overwrite'] = TRUE;
		$config['upload_path'] = $upload_path;
		$config['allowed_types'] = 'gif|jpg|png';
		$config['max_size'] = 200;

		$this->upload->initialize($config);

			// upload the file
			if ($this->upload->do_upload($field_name))
			{
				// uploaded data
				$data = $this->upload->data();
				
				// resize the file
				$config['image_library'] = 'gd2';
				$config['source_image'] = $data['full_path'];
				// $image = sha1(rand()) . $data['file_ext'];
				$image = $newName;
				$config['new_image'] = $image;
				$config['maintain_ratio'] = TRUE;
				$config['width'] = $max_width;
				$config['height'] = $max_height;

				$this->image_lib->initialize($config);
				$this->image_lib->resize();
				
				// delete the original file
				unlink($data['full_path']);
				
				// image path
				// $image_path = $year . '/' . $month . '/' . $image;
				
				$path = "./uploads/images/".$newName;
				$optimize = $this->optimize_image($path,$path);
				
				return $newName;
			}
			else
			{
				// show error message
				return $this->upload->display_errors();
			}	
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * upload_background
	 *
	 */
	function upload_background($newName=false)
	{
		$upload_path = $this->prepare_directory_by_name('ticket_background');
		list($month, $year) = $this->prepare_directory();
		
		if ($upload_path) {
			// config settings for file upload
			$config['overwrite'] = TRUE;
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = 'gif|jpg|png';
			$config['max_size'] = 200;

			$this->upload->initialize($config);
			
			// upload the file
			if ($this->upload->do_upload('background'))
			{
				// uploaded data
				$data = $this->upload->data();
				$title = $this->input->post('event_title');
				$newtitle = str_replace (" ", "", $title);
				$newname = preg_replace("/[^a-zA-Z0-9\s]/", "", $newtitle);
				$filename = $newName;
				//$fullpath = $data['file_path'].$filename;
				$path = rename($data['full_path'], $data['file_path'].$filename);
				$filewh = $data['image_width'].' x '.$data['image_height'];
				$filesize = $data['file_size'];
				
				// resize the file
				$config['image_library'] = 'gd2';
				$config['source_image'] = $data['file_path'].$filename;
				$config['maintain_ratio'] = TRUE;
				$config['width'] = 100;
				$config['height'] = 80;
		
				//$this->image_lib->initialize($config);
				//$this->image_lib->resize();
				
				// delete the original file
				//unlink($data['full_path']);
				
				// image path
				$image_path = $upload_path . $filename;
				$path = $data['file_path'].$filename;
				 
				return array($filename, $image_path, $filewh, $filesize, $path);
			} else {
				return array($this->upload->display_errors(), "", "", "", "");
			}
		}
		// show error message
	}
	
	/**
	 * prepare_directory
	 *
	 */
	function prepare_directory()
	{
		// prepare the directory (refer to current date)
		$upload_path = './uploads/';
		$image = "images";
		$month = date("m");
		$year = date("Y");
		
		// create the current year directory if not existing
		if (! file_exists($upload_path . $image)) 
		{
			mkdir($upload_path . $image, 0777);
		}
		
		// create the current month directory if not existing
		// if (! file_exists($upload_path . $year . '/' . $month)) 
		// {
			// mkdir($upload_path . $year . '/' . $month, 0777);
		// }
		
		return array($month, $year);
	}
			
	function prepare_directory_by_name()
	{
		// prepare the directory (refer to current date)

		$upload_path = "./uploads/images/";
		
		return $upload_path;
	}
	
	function optimize_image($source_url, $destination_url, $ads_type=false){
		/* 
		require_once(BASEPATH."application/libraries/Tinify/Exception.php");
		require_once(BASEPATH."application/libraries/Tinify/ResultMeta.php");
		require_once(BASEPATH."application/libraries/Tinify/Result.php");
		require_once(BASEPATH."application/libraries/Tinify/Source.php");
		require_once(BASEPATH."application/libraries/Tinify/Client.php");
		require_once(BASEPATH."application/libraries/Tinify.php");
	
		// \Tinify\setKey("B6PqxSdMAqjSQU1L4udUz2Nk0BZskYbc"); // Switch to this key if image compression exceeded to 500
		\Tinify\setKey("ZCtuIAlNoDR5qg28NA3dwkvsNzABAWX5");
		
		if($ads_type){
			if($ads_type == "Lead"){
				$width = 740;
			}else{
				$width = 340;
			}
			$source = \Tinify\fromFile($source_url);
			$resized = $source->resize(array(
				"method" => "scale",
				"width" => $width
			));
			$resized->toFile($destination_url);
		}else{
			$source = \Tinify\fromFile($source_url);
			$source->toFile($destination_url);
		}
		 */
		return TRUE;
	}
			
}
// END files_model.php
/* Location: ./application/models/files_model.php */	
