<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Events_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $events = 'events e';
	var $events_config = 'events_config ec';
	var $event_types = 'event_types et';
	var $seatplans = 'seatplans sp';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}


	// --------------------------------------------------------------------
	
	/**
	 * 
	 *
	 * @access	public
	 */
	function get($event_id=false)
	{
		$this->db->query('set transaction isolation level read uncommitted');

		if($event_id){
		$this->db->where('event_id', $event_id);
		}
		
		$this->db->join($this->events_config, 'ec.events_config_eventid = e.event_id', 'left');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->join($this->seatplans, 'e.event_seatplan_id = sp.seatplan_id', 'left');
		$query = $this->db->get($this->events);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	/**
	 * get_event
	 *
	 * @access	public
	 */
	function get_by_transaction_id($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('transaction_id', $transaction_id);
		$this->db->join('tickets', 'ticket_event_id=event_id','left');
		$this->db->join('transactions','ticket_transaction_id=transaction_id','left');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->join($this->seatplans, 'e.event_seatplan_id = sp.seatplan_id', 'left');
		$this->db->limit(1);
		$query = $this->db->get($this->events);
		
		return $query->row();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_events
	 *
	 * @access	public
	 */
	function get_events()
	{
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_events
	 *
	 * @access	public
	 */
	function get_current_events($searchkey=array())
	{
		$this->db->query('set transaction isolation level read uncommitted');
		//hide event 
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Finance'))){
			
			$this->db->where('event_id !=', '10');
			// $this->db->where('event_id !=', '5157'); coldplay
			// $this->db->where('event_id !=', '5661'); //in the mix
			// $this->db->where('event_id !=', '5731'); //ariana
			
			$this->db->where('event_id !=', '5359'); //65TH MISS UNIVERSE COMPETITION - PRELIMINARY
			$this->db->where('event_id !=', '5360'); //65TH MISS UNIVERSE COMPETITION - DRESS REHEARSAL	
			
			// $this->db->where('event_id !=', '5279');
			// $this->db->where('event_id !=', '5280');
			// $this->db->where('event_id !=', '5788'); //ed sheeran
			// $this->db->where('event_id !=', '5645'); //kidzania
			// $this->db->where('event_id !=', '5803'); //Harry Styles

			// $ignore = array(3808,3822 );
			// $this->db->where_not_in('event_id', $ignore);
		}
		
		
		//toruk special access
		$turok = array(5577,5628,5627,5630,5629,5631,5632,5634,5633,5636,5635,5638,5637,5640,5639);
		$turok_seller = array(4243,4242,4185,4226,4227,4228,4229,4230,4231,4232,4234,4235);
		
		if (in_array($this->session->userdata('user_id'), $turok_seller)){
			 
			$this->db->where_in('event_id', $turok);
			 
		}
		
		
		
		
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Event','Finance')))
		{
			$this->db->where('event_active', '1');
		}
		
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Finance')))
		{
			$this->db->where('event_date_time >=', date("Y-m-d"));
		}
		
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}
		
		if (! $is_key_exists)
		{
			$this->db->where('event_date_time >=', date("Y-m-d"));
		}
		
		/*if ($this->session->userdata('user_type') != 'Admin' and !$is_key_exists)
		{
			$this->db->where('event_date_time >=', date("Y-m-d"));
		}*/


		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		
		
		
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	function get_active_events($searchkey=array())
	{
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}

		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		
		
		$this->db->where('event_active', '1');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	function get_inactive_events($searchkey=array())
	{
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		

		$this->db->where('event_active <> ', '1');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc');
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	function get_all_events($searchkey=array())
	{		
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}

		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){ 
			$this->db->where('event_cod', 1);
		}
			
		
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_receipt_number
	 *
	 * @access	public
	 */
	function get_receipt_number($event_id)
	{
		// get last receipt number
		$this->db->select('event_last_receipt_number');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get($this->events);
		$row = $query->row();
		
		$next_receipt_number = $row->event_last_receipt_number += 1;
		
		// update last receipt number
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, array('event_last_receipt_number' => $next_receipt_number));
		
		return $next_receipt_number;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_events_dropdown
	 *
	 * @access	public
	 */
	function get_events_dropdown()
	{
		$query = $this->db->get($this->events);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
		
	/**
	 * get_events_dropdown
	 *
	 * @access	public
	 */
	function get_active_events_dropdown()
	{
		$this->db->where('event_active',1);
		$query = $this->db->get($this->events);
		
		
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_find_sets_events_dropdown()
	{
		$this->db->order_by('event_title', 'asc'); 
		$this->db->where('event_active',1);
		$query = $this->db->get($this->events);
		
		
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_reservation_expiry
	 *
	 */
	function reservation_expiry($event_id)
	{
		$this->db->where('event_id', $event_id);
		$query = $this->db->get($this->events);
		
		return $query->row();
		
	}	

	// --------------------------------------------------------------------
	
	/**
	 * _copy_seatplan
	 *
	 */
	function _copy_seatplan($seatplan_id)
	{
		// copy the seat plan from the template
		$sql = "insert into seatplans(seatplan_name, seatplan_venue_id, seatplan_image, seatplan_template, seatplan_active) select seatplan_name, seatplan_venue_id, seatplan_image, '0', '1' from seatplans where seatplan_id = ?"; 
		$this->db->query($sql, $seatplan_id);
		$new_seatplan_id = $this->db->insert_id();
	
		// copy the sections as well
		$sql = "insert into sections(section_code, section_name, section_type, section_stage_location, section_seat_config, section_seat_heads, section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to, section_col_increment, section_row_aisles, section_col_aisles, section_capacity, section_available, section_seatplan_id) select section_code, section_name, section_type, section_stage_location, section_seat_config,section_seat_heads, section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to, section_col_increment, section_row_aisles, section_col_aisles, section_capacity, section_capacity, ? from sections where section_seatplan_id = ?"; 
		$this->db->query($sql, array($new_seatplan_id,  $seatplan_id)); 
		
		return $new_seatplan_id;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _copy_event
	 *
	 */
	function _copy_event($event_id)
	{
		// get event info
		$event = $this->get($event_id);
		
		// copy the seatplan first
		$new_seatplan_id = $this->_copy_seatplan($event->event_seatplan_id);

 
	
		

		// copy the event
		$sql = "insert into events(
 				event_title,
				event_long_title,
				event_type,
				event_performers,
				event_performers_website,
				event_description,
				event_venue_id,
				event_date_time,
				event_image,
				event_image_1,
				event_ticket_logo_1,
				event_ticket_logo_2,
				event_promoter_id,
				event_seatplan_id,
				event_ticket_types,
				event_venue_amusement_tax,
				event_venue_withholding_tax,
				event_venue_tax,
				event_venue_charge_1,
				event_venue_charge_2,
				event_venue_charge_3,
				event_venue_charge_4,
				event_venue_charge_5,
				event_venue_commission,
				event_service_charge,
				event_ticket_charge,
				event_vat,
				event_withholding_tax,
				event_bank_charge_internet,
				event_bank_charge_outlet,
				event_administrative_fee,
				event_minimum_guarantee,
				event_internet_sales_charge,
				event_delivery_charge,
				event_revenue_pullout,
				event_complimentary_pullout,
				event_interest_fee,
				event_reservation_fee,
				event_charge_01,
				event_charge_02,
				event_charge_03,
				event_charge_04,
				event_charge_05,
				event_charge_06,
				event_charge_07,
				event_charge_08,
				event_charge_09,
				event_charge_10,
				event_last_receipt_number,
				event_reservation_expire,
				event_active,
				event_disable_reservation,
				event_recommended
			) 




			select
 				event_title,
				event_long_title,
				event_type,
				event_performers,
				event_performers_website,
				event_description,
				event_venue_id,
				?,
				event_image,
				event_image_1,
				event_ticket_logo_1,
				event_ticket_logo_2,
				event_promoter_id,
				?,
				event_ticket_types,
				event_venue_amusement_tax,
				event_venue_withholding_tax,
				event_venue_tax,
				event_venue_charge_1,
				event_venue_charge_2,
				event_venue_charge_3,
				event_venue_charge_4,
				event_venue_charge_5,
				event_venue_commission,
				event_service_charge,
				event_ticket_charge,
				event_vat,
				event_withholding_tax,
				event_bank_charge_internet,
				event_bank_charge_outlet,
				event_administrative_fee,
				event_minimum_guarantee,
				event_internet_sales_charge,
				event_delivery_charge,
				event_revenue_pullout,
				event_complimentary_pullout,
				event_interest_fee,
				event_reservation_fee,
				event_charge_01,
				event_charge_02,
				event_charge_03,
				event_charge_04,
				event_charge_05,
				event_charge_06,
				event_charge_07,
				event_charge_08,
				event_charge_09,
				event_charge_10,
				event_last_receipt_number,
				event_reservation_expire,
				event_active,
				event_disable_reservation,
				event_recommended

			from events where event_id = ?"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),$new_seatplan_id, $event_id));
		
		$new_event_id = $this->db->insert_id();
		
		return $new_event_id;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * _copy_prices
	 *
	 */
	function _copy_prices($new_event_id, $event_id)
	{
		$sql = "insert into prices(
				price_event_id,
				price_name,
				price_price,
				price_sections
			) 
			
			select
			 	?,
				price_name,
				price_price,
				price_sections
				
			from prices where price_event_id = ?"; 
			
		$this->db->query($sql, array($new_event_id, $event_id));
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _copy_ticket_layout
	 *
	 */
	function _copy_ticket_layout($new_event_id, $event_id)
	{
		$sql = "insert into ticket_layouts(
				ticket_layout_event_id,
				ticket_logo_id_1,
				ticket_logo_id_2,
				ticket_logo_id_3,
				ticket_logo_id_4,
				ticket_logo_id_5,
				ticket_text_1,
				ticket_font_size_1,
				ticket_font_face_1,
				ticket_text_2,
				ticket_font_size_2,
				ticket_font_face_2,
				ticket_text_3,
				ticket_font_size_3,
				ticket_font_face_3,
				ticket_text_4,
				ticket_font_size_4,
				ticket_font_face_4,
				ticket_text_5,
				ticket_font_size_5,
				ticket_font_face_5,
				ticket_text_6,
				ticket_font_size_6,
				ticket_font_face_6,
				ticket_text_7,
				ticket_font_size_7,
				ticket_font_face_7
			) 
			
			select
			 	?,
				ticket_logo_id_1,
				ticket_logo_id_2,
				ticket_logo_id_3,
				ticket_logo_id_4,
				ticket_logo_id_5,
				ticket_text_1,
				ticket_font_size_1,
				ticket_font_face_1,
				ticket_text_2,
				ticket_font_size_2,
				ticket_font_face_2,
				ticket_text_3,
				ticket_font_size_3,
				ticket_font_face_3,
				ticket_text_4,
				ticket_font_size_4,
				ticket_font_face_4,
				ticket_text_5,
				ticket_font_size_5,
				ticket_font_face_5,
				ticket_text_6,
				ticket_font_size_6,
				ticket_font_face_6,
				ticket_text_7,
				ticket_font_size_7,
				ticket_font_face_7
				
			from ticket_layouts where ticket_layout_event_id = ?"; 
			
		$this->db->query($sql, array($new_event_id, $event_id));
		
		return true;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * copy
	 *
	 */
	function copy($event_id)
	{
		// copy the event, seatplan and sections
		$new_event_id = $this->_copy_event($event_id);
		
		// copy the prices
		$this->_copy_prices($new_event_id, $event_id);
		
		// copy the ticket layout
		$this->_copy_ticket_layout($new_event_id, $event_id);

		return $new_event_id;
	}

	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($event_image)
	{
		// copy the seat plan first
		$seatplan_id = $this->_copy_seatplan($this->input->post('seatplan_id'));
		
		// add the event
		$fields = array(
			'event_code'				=> $this->input->post('event_code'),
			'event_title'				=> $this->input->post('event_title'),
			'event_long_title'			=> $this->input->post('event_long_title'),
			// 'event_url'					=> $this->input->post('event_url'),
			//'event_type'				=> $this->input->post('event_type'),
			'event_performers'			=> $this->input->post('event_performers'),
			'event_performers_website'	=> $this->input->post('event_performers_website'),
			'event_description'			=> $this->input->post('event_description'),
			'event_venue_id'			=> $this->input->post('venue_id'),
			'event_date_time'			=> $this->input->post('date_time'),		
			'event_promoter_id'			=> $this->input->post('promoter_id'),
			'event_seatplan_id'			=> $seatplan_id,	
			'event_image'				=> $event_image,	
			'event_expiration'			=> $this->input->post('event_expiration'),	 
			'event_active'				=> '0', 
			'event_hotel'				=> 0,	
			'event_always_show'			=> 0,	
			'event_reservation_expire'	=> $this->input->post('event_reservation_expire'),
			'event_internet_sales_charge'	=> $this->input->post('event_internet_sales_charge'),
			'event_tags'				=> $this->input->post('event_tags'),
			'event_announcement_date'	=> $this->input->post('event_announcement_date'),	
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('events');
		
		return $this->db->insert_id();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($event_id, $event_image = false, $event_image_1 = false, $event_image_2 = false, $event_image_3 = false)
	{
		$seatplan_id = $this->input->post('seatplan_id');
		if ($seatplan_id != $this->input->post('current_seatplan_id'))
		{
			// copy the seat plan first
			$seatplan_id = $this->_copy_seatplan($this->input->post('seatplan_id'));
		}
		

		// save to database
		$fields = array(
			'event_code'				=> $this->input->post('event_code'),
			'event_title'				=> $this->input->post('event_title'),
			'event_long_title'			=> $this->input->post('event_long_title'),
			// 'event_url'					=> $this->input->post('event_url'),
			'event_category'			=> $this->input->post('event_category'),
			'event_performers'			=> $this->input->post('event_performers'),
			'event_performers_website'	=> $this->input->post('event_performers_website'),
			'event_description'			=> $this->input->post('event_description'),
			'event_venue_id'			=> $this->input->post('venue_id'),
			'event_date_time'			=> $this->input->post('date_time'),
			'event_expiration'			=> $this->input->post('event_expiration'),
			'event_promoter_id'			=> $this->input->post('promoter_id'),
			'event_seatplan_id'			=> $seatplan_id,
			'event_enable_online_selling'	=> $this->input->post('event_enable_online_selling'),		
			'event_postponed_date'		=> $this->input->post('date_postponed'),		
			'event_active'				=> $this->input->post('event_active'),		
			'event_hotel'				=> $this->input->post('event_hotel'),	
			'event_always_show'			=> $this->input->post('event_always_show'),	
			'event_disable_reservation'	=> $this->input->post('event_disable_reservation'),	
			'event_reservation_expire'	=> $this->input->post('event_reservation_expire'),		
			'event_online_registration'	=> $this->input->post('event_online_registration'),		
			'event_promo'			 	=> $this->input->post('event_promo'),
			'event_max_ticket'			=> $this->input->post('event_max_ticket'),				
			'event_cod'					=> $this->input->post('event_cod'),	
			'event_tags'				=> $this->input->post('event_tags'),	
			'event_season_pass'				=> $this->input->post('event_season'),	
			'event_announcement_date'	=> $this->input->post('event_announcement_date'),	
			
	
		);
		
		
		if ($event_image)
		{
			$fields['event_image'] = $event_image;
		}		
		if ($event_image_1)
		{
			$fields['event_image_1'] = $event_image_1;
		}
		if ($event_image_2)
		{
			$fields['event_image_2'] = $event_image_2;
		}
		if ($event_image_3)
		{
			$fields['event_image_3'] = $event_image_3;
		}
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		$allow_multiple_price = 0;
		if($this->input->post('allow_multiple_price')) $allow_multiple_price = $this->input->post('allow_multiple_price');
		
		$event_online_concert = 0;
		if($this->input->post('event_online_concert')) $event_online_concert = $this->input->post('event_online_concert');
		
		$event_eticket = 0;
		if($this->input->post('event_eticket')) $event_eticket = $this->input->post('event_eticket');
		
		$hide_online = (!empty($this->input->post('hide_online')))? 1 : 0;
		// for extended event configuration
		$tablename = 'events_config';
		$fields = array(
			'events_config_eventid'				=> $event_id,
			// 'events_config_guestlist_active'	=> $this->input->post('event_guestlist'),
			'events_config_ekbarcode_active'	=> $this->input->post('event_ekbarcode'),
			'events_config_bcode_active'		=> $this->input->post('event_bcode'),
			'events_config_qrcode_active'		=> $this->input->post('event_qrcode'),
			'event_display_date_online'			=> $this->input->post('event_show_dateTime'),	
			'event_display_venue_online'		=> $this->input->post('event_display_venue_online'),
			'events_config_turnstile_active'	=> $this->input->post('event_turnstile'),	
			'events_auto_email_ASR'				=> $this->input->post('event_email_asr'),	
			// 'event_announcement_date'			=> $this->input->post('event_announcement_date'),
			'events_date_validity'				=> $this->input->post('event_date_validity'),
			'other_event_date_time'				=> $this->input->post('other_event_date_time'),
			'events_start_date_time'			=> $this->input->post('start_date_time'),
			'events_end_date_time'				=> $this->input->post('end_date_time'),
			'event_reservation_claiming'		=> $this->input->post('event_reservation_claiming'),
			'allow_multiple_price'				=> $allow_multiple_price,	
			'event_online_concert'				=> $event_online_concert,
			'event_eticket'						=> $event_eticket,
			'event_hide_online'					=> $hide_online

		);
		// 'events_config_eklisting_active'	=> $this->input->post('event_eklisting'),

		$do_update = true;
		$test = trim($this->input->post('events_config_id'));
		if (empty($test)) {
			$this->db->insert('events_config', $fields);
			if($this->db->affected_rows() > 0){
			// if($this->db->simple_query($__isql)) {
				$do_update = false;
			}
		} 
		
		if ($do_update) { 
			// $__usql = $this->db->u($tablename, $fields, $where);
			$this->db->where('events_config_eventid', $event_id);
			$this->db->update('events_config', $fields);
			// $this->db->simple_query($__usql);
			// echo $__usql;
		}
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_charges
	 *
	 */
	function edit_charges($event_id)
	{		
		$fields = array(
			'event_venue_amusement_tax'		=> $this->input->post('venue_amusement_tax'),
			'event_venue_withholding_tax'	=> $this->input->post('venue_withholding_tax'),
			'event_venue_tax'				=> $this->input->post('venue_tax'),
			'event_venue_charge_1'			=> $this->input->post('venue_charge_1'),
			'event_venue_charge_2'			=> $this->input->post('venue_charge_2'),
			'event_venue_charge_3'			=> $this->input->post('venue_charge_3'),
			'event_venue_charge_4'			=> $this->input->post('venue_charge_4'),
			'event_venue_charge_5'			=> $this->input->post('venue_charge_5'),
			'event_venue_commission'		=> $this->input->post('venue_commission'),
			'event_service_charge'			=> $this->input->post('event_service_charge'),
			'event_ticket_charge'			=> $this->input->post('event_ticket_charge'),
			'event_vat'						=> $this->input->post('event_vat'),
			'event_withholding_tax'			=> $this->input->post('event_withholding_tax'),
			'event_bank_charge_internet'	=> $this->input->post('event_bank_charge_internet'),
			'event_bank_charge_branch'		=> $this->input->post('event_bank_charge_branch'),
			'event_administrative_fee'		=> $this->input->post('event_administrative_fee'),
			'event_minimum_guarantee'		=> $this->input->post('event_minimum_guarantee'),
			'event_internet_sales_charge'	=> $this->input->post('event_internet_sales_charge'),
			'event_delivery_charge'			=> $this->input->post('event_delivery_charge'),
			'event_revenue_pullout'			=> $this->input->post('event_revenue_pullout'),
			'event_complimentary_pullout'	=> $this->input->post('event_complimentary_pullout'),
			'event_interest_fee'			=> $this->input->post('event_interest_fee'),
			'event_reservation_fee'			=> $this->input->post('event_reservation_fee'),
	
		);
		
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_ticket_types
	 *
	 */
	function edit_ticket_types($event_id)
	{
		$fields = array(
			'event_ticket_types' => serialize($this->input->post('ticket_types')),
		);
		
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		return true;
	}
	// --------------------------------------------------------------------
	
	/**
	 * edit charges
	 *
	 */
	function edit_charge($event_id)
	{
		$fields = array(
			'event_venue_amusement_tax'		=> $this->input->post('event_venue_amusement_tax'),
			'event_venue_withholding_tax'	=> $this->input->post('event_venue_withholding_tax'),
			'event_venue_tax'				=> $this->input->post('event_venue_tax'),
			'event_venue_charge_1'			=> $this->input->post('event_venue_charge_1'),
			'event_venue_charge_2'			=> $this->input->post('event_venue_charge_2'),	
			'event_venue_charge_3'			=> $this->input->post('event_venue_charge_3'),					
			'event_venue_charge_4'			=> $this->input->post('event_venue_charge_4'),
			'event_venue_charge_5'			=> $this->input->post('event_venue_charge_5'),
			'event_venue_commission'		=> $this->input->post('event_venue_commission'),
			'event_service_charge'			=> $this->input->post('event_service_charge'),
			'event_ticket_charge'			=> $this->input->post('event_ticket_charge'),
			'event_vat'						=> $this->input->post('event_vat'),
			'event_withholding_tax'			=> $this->input->post('event_withholding_tax'),
			'event_bank_charge_internet'	=> $this->input->post('event_bank_charge_internet'),
			'event_bank_charge_outlet'		=> $this->input->post('event_bank_charge_outlet'),
			'event_administrative_fee'		=> $this->input->post('event_administrative_fee'),
			'event_minimum_guarantee'		=> $this->input->post('event_minimum_guarantee'),
			'event_internet_sales_charge'	=> $this->input->post('event_internet_sales_charge'),
			'event_delivery_charge'			=> $this->input->post('event_delivery_charge'),
			'event_revenue_pullout'			=> $this->input->post('event_revenue_pullout'),
			'event_complimentary_pullout'	=> $this->input->post('event_complimentary_pullout'),
			'event_interest_fee'			=> $this->input->post('event_interest_fee'),
			'event_reservation_fee'			=> $this->input->post('event_reservation_fee'),
			'event_charge_01'				=> $this->input->post('event_charge_01'),
			'event_charge_02'				=> $this->input->post('event_charge_02'),
			'event_charge_03'				=> $this->input->post('event_charge_03'),
			'event_charge_04'				=> $this->input->post('event_charge_04'),
			'event_charge_05'				=> $this->input->post('event_charge_05'),
			'event_charge_06'				=> $this->input->post('event_charge_06'),
			'event_charge_07'				=> $this->input->post('event_charge_07'),
			'event_charge_08'				=> $this->input->post('event_charge_08'),
			'event_charge_09'				=> $this->input->post('event_charge_09'),
			'event_charge_10'				=> $this->input->post('event_charge_10'),
		);
		
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		return true;
	}	

	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($event_id)
	{
		$this->db->delete('events', array('event_id' => $event_id));
		$this->db->delete('videos', array('video_event_id' => $event_id));
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function recommend($event_id)
	{
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, array('event_recommended'=>'yes') );
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function unrecommend($event_id)
	{
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, array('event_recommended'=>'no') );
		
		return true;
	}
	
  
	function get_amusement_tax($event_id=false){
	
 
	$this->db->select('event_venue_amusement_tax as tax');
	$this->db->where('event_id', $event_id);
	return $this->db->get('events')->row()->tax;
	 
	}
	
	function get_event_details($event_id=false){
	
 

	$this->db->select('event_id,event_venue_amusement_tax as tax, event_expiration as expiry, event_season_pass as season_pass,event_online_concert');
	$this->db->join('events_config ec', 'e.event_id = ec.events_config_eventid', 'left');
	$this->db->where('event_id', $event_id);
	return $this->db->get('events e')->row();
	 
	}
	
	
	function get_event_status($evs_list){
	
		// $reports_date = strtotime($reports['reports_date']);
		// $strReportDate = date('Y-m-d',$reports_date);
		$today = date('Y-m-d');
		
		// $evs_list = array();
		$withstatus = array("done", "reserved");
	 
		$this->db->select("
							ti.ticket_id
 							, ti.ticket_event_id
							, ti.ticket_type_id
							, ti.ticket_price_id
							, ti.ticket_status
							, pr.price_price
							, tt.ticket_type_discount_type
							, tt.ticket_type_discount
							, tt.ticket_type_group
							, ti.ticket_reservation_expiry
 							, ti.ticket_branch_id
						");
		$this->db->from('tickets ti');
 		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->where_in('ti.ticket_status', $withstatus);
		$this->db->where_in('ti.ticket_event_id', $evs_list); 
		$query = $this->db->get();
		 
		
		//data arrays
		$event_array = array();
		
	  
		//build data
		foreach($query->result() as $row)
		{
			
			
			
			$ticket_amt = 0;
			if ($row->ticket_type_discount_type == 'Percentage')
			{
				$ticket_amt = ceil($row->price_price - ($row->price_price * $row->ticket_type_discount / 100));
			}
			else
			{
				$ticket_amt = $row->price_price - $row->ticket_type_discount;
			}
			
			
			if (!isset($event_array[$row->ticket_event_id]['event_id']))
			{
				$event_array[$row->ticket_event_id]['event_id'] = $row->ticket_event_id;
				if ($row->ticket_status == 'done' || $row->ticket_status == 'paid_online')
				{
					
				 
					$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] = 0;
 					 
					 
					if($row->ticket_type_group == 0){ 
						$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] = 1;
 					}
					 
					
				}
				else 
				{
				
				
			 
					$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] = 0;
 					 
					
				 
				 
				}
			}else{
			
				if ($row->ticket_status == 'done' || $row->ticket_status == 'paid_online')
				{
				
				 
					if($row->ticket_type_group == 0){ 
						$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] += 1;
 					}
				 
				
				}
			
			
			
			}
			 
			
			
			if(isset($event_array[$row->ticket_event_id]['event_tix_qty']['cap'])){
			}else{
				 
				//seat cap
				$this->db->where('price_event_id', $row->ticket_event_id);
				$query = $this->db->get('prices');
				$prices = $query->result();
				$sectionsArray = array();
 				foreach ($prices as $price)
				{
					$sections = unserialize($price->price_sections);
					$sectionsArray[] = $sections;
					 
					$this->db->select('sum(section_capacity) as cap');
					$this->db->where_in('section_id',$sections);
					$queryy = $this->db->get('sections')->row(); 
					 
					 
				}

				$sectionsArray = call_user_func_array('array_merge', $sectionsArray); 
				$this->db->select('sum(section_capacity) as cap');
				$this->db->where_in('section_id',$sectionsArray);
				$query = $this->db->get('sections')->row(); 
				$event_array[$row->ticket_event_id]['event_tix_qty']['cap'] = $query->cap;
 				 
			}
			
			
			
			
			
		}
	
		// echo '<pre>';
		// print_r($event_array);
		// echo '</pre>';
		// die();
		
		return $event_array;
	
	
	
	}
		
	function is_event_code_exist($event_code = FALSE , $id = false)
	{
		// check if username exists
		$this->db->where('event_code', $event_code);
		$query = $this->db->get('events');
		
		if($query->num_rows() > 0){
		
			if($query->row()->event_id == $id){
			
				return false;
			
			}else{
			
				return true;
			}
		
		
		}else{
		
		
		return false;
		}
	}	
	
		function is_event_url_exist($event_url = FALSE , $id = false)
	{
		// check if username exists
		$this->db->where('event_url', $event_url);
		$query = $this->db->get('events');
		
		if($query->num_rows() > 0){
		
			if($query->row()->event_id == $id){
			
				return false;
			
			}else{
			
				return true;
			}
		
		
		}else{
		
		
		return false;
		}
	}
	
		
	function get_payment_types($event_id=false)
	{
		if($event_id){
		$this->db->where('event_payment_type_eventid', $event_id);
		}
		
		 
		$query = $this->db->get('events_payment_types');
		//echo $this->db->last_query();
		
		return $query->row();
	 
	}	
	
	function edit_payment_types($event_id)
	{
		
		$fields = array(
			'event_payment_type_eventid' => $event_id,
			'event_payment_types' => serialize($this->input->post('payment_types')) 
		);
		
		$payment_types = $this->get_payment_types($event_id);
		if( empty( $payment_types ) ){
			
			$this->db->set($fields);
			$this->db->insert('events_payment_types');
		}else{
			 
			// update db
			$this->db->where('event_payment_type_eventid', $event_id);
			$this->db->update('events_payment_types', $fields);
			
		}
		 
		
		return true;
	}
 
	function save_event_cms($event_ids,$category){
		
		$fields = array(
			'event_ids' => $event_ids,
		);
		
		// update db
		$this->db->where('event_listing_id', $category);
		$this->db->update('events_listing', $fields);
	
		return "success";
	}
	
	function get_all_events_sorted($sort,$ids)
	{		
		
		$eid = explode(',',$ids);
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->where_not_in('e.event_id', $eid); 
		$this->db->where('event_active ',1);
		// $this->db->where('e.event_date_time', 'NOW()'); 
		$this->db->where('event_date_time >=', date("Y-m-d"));
		
		if($sort == 1){
		$this->db->order_by('e.event_date_time', 'desc'); 
		}else if($sort == 2){
			$this->db->order_by('e.event_title', 'asc'); 
		}else{
			$this->db->order_by('v.venue_id', 'asc'); 
		}
		$this->db->group_by('e.event_long_title'); 
		
		
		$query = $this->db->get($this->events);
		// echo $this->db->last_query();
		return $query->result();
	}
	
	function filter_by_venue($venue,$ids)
	{		
		
		$eid = explode(',',$ids);
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->where_not_in('e.event_id', $eid); 
		$this->db->where('event_date_time >=', date("Y-m-d"));
		$this->db->where('event_active ',1);
		
		if($venue)
		$this->db->where('venue_category', $venue); 
		 
		$this->db->group_by('e.event_long_title'); 
		
		
		$query = $this->db->get($this->events);
		// echo $this->db->last_query();
		return $query->result();
	}
	
	
	
	
	function get_event_in_cms($sort,$ids,$filter)
	{		
		$id = explode(',',$ids);
		// $eid = array(2761,2773);
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		if($filter==0){
		$this->db->where_in('event_id', $id); 
		}else{
			$this->db->where_not_in('event_id', $id); 
		}
		// $this->db->where('e.event_date_time ', 'NOW()'); 
		$this->db->where('event_date_time >=', date("Y-m-d"));
		$this->db->where('event_active >=', 1);
		
		if($sort == 1){
		$this->db->order_by('e.event_date_time', 'desc'); 
		}else if($sort == 2){
			$this->db->order_by('e.event_title', 'asc'); 
		}else{
			$this->db->order_by('v.venue_id', 'asc'); 
		}
		$this->db->group_by('e.event_long_title'); 
		
		
		$query = $this->db->get($this->events);
		// echo $this->db->last_query();
		return $query->result();
	}
	
	function get_all_events_filter($sort)
	{		
		$this->db->select('event_ids');
		// $this->db->where('event_date_time >=', date("Y-m-d"));
		$this->db->where('event_listing_id', $sort); 
		$query = $this->db->get('events_listing');
		// echo $this->db->last_query();
		return $query->row();
	}
	
	function get_active_filtered_events($ids)
	{		
		$id = explode(',',$ids);
		// $eid = array(2761,2773);
		$this->db->select('event_id');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');

		$this->db->where_in('event_id', $id); 

		// $this->db->where('e.event_date_time ', 'NOW()'); 
		$this->db->where('event_date_time >=', date("Y-m-d"));
		
		$this->db->group_by('e.event_long_title'); 
		
		
		$query = $this->db->get($this->events);
		// echo $this->db->last_query();
		return $query->result();
	}
	
	function get_postponed_date($event_id=false){
		$this->db->query('set transaction isolation level read uncommitted');	
		$this->db->select('event_postponed_date');
		$this->db->where('event_id', $event_id);
		return $this->db->get('events')->row()->event_postponed_date;
	 
	}
	
	/**
	 * get_SEO
	 *
	 */
	
	function get_seo($event_id=false){
	$this->db->select('e.event_seatplan_id, e.event_id, e.event_title, s.meta_description_content, s.meta_keywords_content, s.link_rel_canonical');	
	$this->db->join('events_seo s', 'e.event_id = s.event_id', 'left');

	$this->db->where('e.event_id', $event_id);
	$query = $this->db->get('events e');
		// echo $this->db->last_query();
		
	return $query->row();
		// echo $this->db->last_query();
	// return $query->row();
	 
	}
	
		// --------------------------------------------------------------------
	
	/**
	 * add_SEO
	 *
	 */
	 
	 
	 	function add_seo($event_id)
	{
		$fields = array(
		
			'event_id' => $event_id,
			'meta_description_content' => $this->input->post('meta_description_content'),
			'meta_keywords_content' => $this->input->post('meta_keywords_content'),
			'link_rel_canonical' => $this->input->post('link_rel_canonical')
			
		);
		
		$this->db->set($fields);
		$this->db->insert('events_seo');
		return $this->db->insert_id();
		
	}
	 
	/**
	 * edit_SEO
	 *
	 */
	 
	function edit_seo($event_id)
	{
		$fields = array(
		
			// 'event_id' => $this->input->post('event_id'),
			'meta_description_content' => $this->input->post('meta_description_content'),
			'meta_keywords_content' => $this->input->post('meta_keywords_content'),
			'link_rel_canonical' => $this->input->post('link_rel_canonical')
			
		);
		
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update('events_seo', $fields);
		
		return true;
	}
	
	
	function get_valid_dates($event_id=false){
	
	$this->db->join('events_config ec', 'e.event_id = ec.events_config_eventid', 'left');
	$this->db->where('e.event_id', $event_id);
	$query = $this->db->get('events e');
		// echo $this->db->last_query();
		
	return $query->row();
		// echo $this->db->last_query();
	// return $query->row();
	 
	}
	
	function get_valid_date_status($event_id=false){
	
	$this->db->select('ec.events_date_validity');
	$this->db->where('ec.events_config_eventid', $event_id);
	$query = $this->db->get('events_config ec');

	if($query->num_rows()>0)	
		return $query->row()->events_date_validity;
	else
		return 0; 
	}
	
	function edit_valid_dates($event_id)
	{
		
		$dates = explode(",",$this->input->post('events_valid_dates'));
		
		foreach ($dates as $i => $d){
			if(strtotime($d) < strtotime(date("m/d/Y"))){
				unset($dates[$i]);
			}
		}
		
		$fields = array(
			'events_valid_dates' => implode(",",$dates)
		);
		
		$this->db->where('events_config_eventid', $event_id);
		$this->db->update('events_config', $fields);
		
		return true;
		
	}
	 
	function remove_date_availabililty($event_id,$date){
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ec.events_valid_dates');
		$this->db->where('ec.events_config_eventid', $event_id);
		$query = $this->db->get('events_config ec');
		// echo $this->db->last_query();
		
		$dates = explode(",",$query->row()->events_valid_dates);
		
		foreach ($dates as $i => $d){
			if($d == $date){
				unset($dates[$i]);
			}
		}
		
		
		$fields = array(
			'events_valid_dates' => implode(",",$dates)
		);
		
		$this->db->where('events_config_eventid', $event_id);
		$this->db->update('events_config', $fields);
	}
	 
	function check_event_lock_status($event_id = false){
	
		$ex = array(9029,9465,9070,9068,9012,9013,9049,9050,9051,9052,9053,9054,9055,9056,9057,9058,9059,9060,9195,9196,9204,9213,9214,8068,7764,8053,5152 , 5080 , 5412 , 5488 , 5585 , 5631 , 5632 , 5634 , 5633 , 5636 , 5933 , 5823 , 6012 , 6230 , 6055 , 6251 , 6252 , 6146 , 6237 , 6466 , 6573 , 6556 , 6663 , 6758 , 6913 , 6908 , 6915 , 6300 , 6301 , 6899 , 7109 , 6844 , 7033 , 6922 , 7027 , 7236 , 7307 , 6090 , 5788 , 7326 , 7390, 7331,7332,7333,7334,7335,7398,7347,7508,7759,7682,7689,7745,7766,7684,7683,7795,7796,7814,7815,7816,7817,7818,7819,7820,7821,7822,7823,7824,7825,7861,7847,7894,7895,3753,4137,5803,6998,7126,7127,7132,7342,7347,7349,7357,7358,7359,7360,7361,7362,7366,7405,7508,7509,7510,7511,7512,7514,7515,7516,7517,7518,7519,7534,7540,7541,7568,7569,7570,7793,7806,7466,8080,7810,7498,7990,7436,8035,8114,8064,8064,7541,8195,7298,7228,8071,8072,8073,8074,8075,7901,8927,8892,8884,8781,8322,8948,8758, 8778,9007, 9010,8717,8883,8776,8877,8382,8708,8777,8819,8782,8768, 8769,8756,8824,8946,8886, 8947,8875,8874,8983,8829,8943,8949, 8987, 8988,8922,8945,8926,9153,9283,9282,9310,9258,8980,8981,9359,9363,9364,9362,9358,9062,9065,9068,9069,9070,9071,9227,9228,9229,8707,9516,9468,9466,9507,9508,9509,9510,9516,9517,9518,9536,9537,9467,9494,9576,9525,9574,9577,9540,9524,9527,9572,9585,9523,9532,9526,9575,9530,9570,9520,9567,9531,9571,9522,9573,9584,9521,9568,9528,9541,9529,9569,5304,9578,9579,9580,9581,9237,9422,9569,9032,9505,9031,9034,9033,9502,9524,9519,9652,9653,9654,9655,9029,9656,9624,9632,9640,9625,9633,9641,9626,9634,9642,9627,9635,9643,9628,9636,9644,9629,9637,9645,9630,9638,9646,9631,9639,9647,9473,9621,9622,9623,99651,9652,9653,9654,9655,9656,9651,9702,7124,9232,9705,9660,10183,10340,10285,10119,10387,10233,10202,10464,10430,10365,10287,10371,10260,10263,10155,10262,10170,10258,9677,10375,10279,10353,10156,9685,10360,10293,10352,10290,10344,10213,10284,10309,10014,10486,10487,10296,10855,9669,10731,10821,10817,10893,10894,10850,10854,10855,10878,10879,11173,11242,11233,10466,11035,11174,11225,11224,11234,11236,11233,11235,11239,11241,11237,11244,11242,11238,11240,11243,11246,11245,11247,11248,11272,11277,11297,10862,10899,10972,11179,11310,11400,11402,11306,11301,11455,11150,11475,11159,11250,11108,10966,11095,11285,11487,7980,11270,11498,11446,11163,11165,11166,11171,11180,11591,11427,11449,11513,11381,11381,11647,11651,11504,11287);
		if(!$event_id) return true;
		
		if (in_array($event_id, $ex)){
			
			 return false;
		}
		
		
		
		$this->db->select('event_date_time');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get('events');
		
		if($query->num_rows() > 0){
		
			$event_date_time = $query->row()->event_date_time;
			$date = date('Y-m-d H:i:s');
			
			$start = strtotime($event_date_time);
			$end = strtotime($date);

			$days_between = ceil(($end - $start) / 86400);
			
			if($days_between >= 4){
				
				
				return true;
			}else{
				
				return false;
				
			}
			
		}else{
		
		
			return true;
		}
		
		
	}


		
	function generate_price_sections_per_event($event_id = false){

		// $event_id = 4447;

		if(!$event_id){

			echo 'Failed';
			die();
		}
		$this->db->where('price_event_id', $event_id);
		// $this->db->limit(1000);
		$query = $this->db->get('prices');
		if($query->num_rows() > 0){
			$result = $query->result();
			$prices = array();
			$sections = array();
			$price_sections = array();
			$sections2 = array();
			foreach($result as $x){
				$sections[$x->price_id] =  unserialize($x->price_sections);
				$sections2= array_merge(unserialize($x->price_sections), $sections2);
				$prices[$x->price_id]['price_name'] = $x->price_name;
				$prices[$x->price_id]['price_price'] = $x->price_price;
				$prices[$x->price_id]['price_event_id'] = $x->price_event_id;
			}
			
			
			$this->db->select('section_id, section_capacity');
			$this->db->where_in('section_id', $sections2);
			$query = $this->db->get('sections');
			$result = $query->result();
			$sections_cap = array();
			foreach($result as $x){
				$sections_cap[$x->section_id]=  $x->section_capacity;
			}
			foreach($sections as $a=>$b){
				foreach($b as $y=>$z){
					$price_sections[$z]['price_event_id'] = $prices[$a]['price_event_id'];
					$price_sections[$z]['price_id'] = $a;
					$price_sections[$z]['price_name'] =$prices[$a]['price_name'];
					$price_sections[$z]['price_price'] =$prices[$a]['price_price'];

					if(isset($sections_cap[$z])){
					$price_sections[$z]['section_capacity'] =$sections_cap[$z];

					}else{

					$price_sections[$z]['section_capacity'] =0;

					}
				}
			}
			foreach($price_sections as $y=>$x){
				//remove existing
				$this->db->where('section_id',$y);
				$this->db->delete('price_sections');
				$fields = array(
					'price_event_id'		=> $x['price_event_id'],
					'price_id'				=> $x['price_id'],
					'section_id'			=> $y,
					'price_name'			=> $x['price_name'],
					'price_price'			=> $x['price_price'],
					'section_capacity'		=> $x['section_capacity'],
					);
				// insert to db
				$this->db->set($fields);
				$this->db->insert('price_sections');
			}

				// echo '<pre>';
				// print_r($price_sections);
				// echo '</pre>';
	}

}

	
	function generate_ticket_types_per_event($event_id = false){

		// $event_id = 4447;

		if(!$event_id){

			echo 'Failed';
			die();
		}
		$this->db->where('event_id', $event_id);
		// $this->db->limit(1000);
		$query = $this->db->get('events');
		if($query->num_rows() > 0){
			$result = $query->result();
			 
			
		
			// $prices = array();
			// $sections = array();
			$event_ticket_types = array();
			$ticket_types = array();
			foreach($result as $x){
				// $sections[$x->price_id] =  unserialize($x->price_sections);
				$ticket_types= array_merge(unserialize($x->event_ticket_types), $ticket_types);
				// $ticket_types[$x->event_id]['price_name'] = $x->price_name;
				// $ticket_types[$x->event_id]['price_price'] = $x->price_price;
				// $ticket_types[$x->event_id]['price_event_id'] = $x->price_event_id;
			}
			
			// echo '<pre>';
			// print_r($ticket_types);
			// echo '</pre>';
			
			// die();
			$this->db->select('ticket_type_id, ticket_type_name');
			$this->db->where_in('ticket_type_id', $ticket_types);
			$query = $this->db->get('ticket_types');
			$result = $query->result();
			
			 
			foreach($result as $x){
				
				
				//remove existing
				$this->db->where('event_id',$event_id);
				$this->db->where('ticket_type_id',$x->ticket_type_id);
				$this->db->delete('event_ticket_types');
				
				$fields = array(
					'event_id'			=> $event_id,
					'ticket_type_id'	=> $x->ticket_type_id,
					'ticket_type_name'	=> $x->ticket_type_name,
					);
				// insert to db
				$this->db->set($fields);
				 $this->db->insert('event_ticket_types');
				 
			}
			
			
			echo 'Success';
		 
		}

}

	function edit_branch_filter($event_id)
	{
		
		$branches = $this->input->post('event_branch_filter');
		$branch = $branches[0];
		if($branch!=""){
			$filters = serialize($this->input->post('event_branch_filter'));
		}else{
			$filters = "";
			
		}
		$fields = array(
			'event_branch_filter_reservation' => $filters,
		);
		
		// update db
		$this->db->where('events_config_eventid', $event_id);
		$this->db->update($this->events_config, $fields);
		
		return true;
	}
	
	 
	function upload_eticket_images($event_id =false, $p_image = false, $l_image = false){
		
 		if ($p_image)
		{
			$fields['event_eticket_p_image'] = $p_image;
		}		
		if ($l_image)
		{
			$fields['event_eticket_l_image'] = $l_image;
		}
		
		if(isset($fields)){
		// update db
		$this->db->where('events_config_eventid', $event_id);
		$this->db->update('events_config', $fields);
		}
	}

	
	function get_eticket_images($event_id = false){
		
		if($event_id == '') return false;
		$this->db->query('set transaction isolation level read uncommitted');

		$this->db->select('event_id,event_title,event_seatplan_id,event_eticket_p_image,event_eticket_l_image');
 		$this->db->where('events_config_eventid', $event_id); 
		$this->db->join($this->events_config, 'ec.events_config_eventid = e.event_id', 'left');
		$query = $this->db->get($this->events);
		return $query->row();

	}
	
	//website images
	function get_all_events_images($id = false)
	{		
 		$this->db->where('event_listing_id', $id); 
		$query = $this->db->get('events_listing');
 		return $query->row();
	}
	
	function get_by_ids($ids = false)
	{		
		//$this->db->where('event_date_time >=', date("Y-m-d"));
		//$this->db->where('event_active', 1);
		$this->db->select('event_id , event_title'); 
		$this->db->where_in('event_id', $ids); 
		$result = $this->db->get('events')->result();
		$events = array();
		foreach($result as $x){
			
			$events[$x->event_id] = $x->event_title;
		}
 		return $events;
	}
	
	function get_active_events_dropdown_new()
	{
		$this->db->where('event_date_time >=', date("Y-m-d"));
		$this->db->where('event_active',1);
		$query = $this->db->get($this->events);
		
		
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	function edit_branch_select($event_id)
	{
		
		$branches = $this->input->post('event_branch_select');
		$branch = $branches[0];
		if($branch!=""){
			$filters = serialize($this->input->post('event_branch_select'));
		}else{
			$filters = "";
			
		}
		$fields = array(
			'event_branch_selling' => $filters,
		);
		
		// update db
		$this->db->where('events_config_eventid', $event_id);
		$this->db->update($this->events_config, $fields);
		
		return true;
	}
	
	
}

// END events_model.php
/* Location: ./application/models/events_model.php */	


