<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Eft_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';

	var $paid_status = array('paid','paid_online');

	var $payment_types = array(
		'Cash' => 1, 
		'PayMaya' => 59
 	);
 

	public function __construct()
	{
		parent::__construct();
	}

	//start eft
	function check_status($order_id = false, $status = false){
	 
		 
 		$this->db->where('eft_payment_order_id', $order_id); 
 		$this->db->where('eft_payment_status', $status); 
		$query = $this->db->get('eft_payments');
	
		if($query->num_rows() > 0){ 
			return true; 
		}else{
			return false;
		}
 
		 
	}
	
	 
	
	function get_payment_details($type, $user_id = false, $session_id = false){
	  
		// $query = $this->db->select();
		$this->db->select( "'$session_id' as order_id
					 , $user_id as seller_id
					 , '$type' as type
					 , ev.event_title as event_title
					 , ev.event_code as event_code
					 , ev.event_date_time as event_date_time
					 , se.section_code as section
					 , ti.ticket_row as row
					 , ti.ticket_seat as seat
					 , tt.ticket_type_name as ticket_type
 					 , CASE WHEN tt.ticket_type_discount_type = 'PERCENTAGE' THEN ROUND(pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE ROUND(pr.price_price - tt.ticket_type_discount) END 'amount'",false);
		
		
  		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id','left');
		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id','left');
		$this->db->join('events ev', 'ev.event_id = ti.ticket_event_id','left');
		$this->db->join('sections se', 'se.section_id = ti.ticket_section_id','left');
	
 
	
		$this->db->where('ti.ticket_session_id', $session_id);
		$this->db->where('ti.ticket_type_id !=', '');
		// $this->db->group_by('ti.ticket_session_id');
		// $this->db->group_by('ti.ticket_seat');
  		$query = $this->db->get('tickets ti');
		 
		return $query;
	
	}
 
	function insert_details($data = false)
	{
		
		if(!empty($data)){
		 	
				//insert card details
				$details = array(
					'eft_payment_order_id'			=> $data['order_id'], 	
					'eft_payment_user_id'	 		=> $data['user_id'],	 	
					'eft_payment_status'			=> $data['status'], 
 
				);

				// insert to db
				$this->db->set($details);
				$this->db->insert('eft_payments');

				$payment_id = $this->db->insert_id();
				foreach($data['payment_info'] as $x){
					 
					// $type = 2; //others credit
					 // $type = 13; //others
					if(isset($this->payment_types[$x['payment_type']])){
						$type = $this->payment_types[$x['payment_type']];
					}else{
						 
						$bin = substr($x['card_num'], 0, 6); 
						$this->db->where('bin',$bin);
						$query = $this->db->get('payment_types_bin');
						
						
					 
						if($query->num_rows() > 0){
							$type = $query->row()->payment_type_id;
						}else{
							$type = 2; //others
						}
						
						
					}
					 
					$cardnum = $x['card_num'];
					//$cardnum = substr($cardnum, 0, 6) . str_repeat('X', strlen($cardnum) - 8) . substr($cardnum, -4);
					
					//insert card details
					$payment_info = array(
						'eft_payment_id'				=> $payment_id, 	
						'eft_payment_order_id'			=> $data['order_id'], 	 
						'eft_payment_type_id'	 		=> $type,	 	
						'eft_approval_code'				=> $x['approval_code'],
						'eft_invoice_num'				=> $x['invoice_num'],
						'eft_terminal_num'				=> $x['terminal_num'],
						'eft_merchant_num'				=> $x['merchant_num'],
						'eft_card_num'					=> $cardnum,
						'eft_card_name'					=> $x['payment_type'],
 						'eft_cardholder_name'			=> $x['cardholder_name'],
						'eft_payment_amount'			=> $x['amount'],
						'eft_cash_change'				=> $x['cash_change']

					);

					// insert to db
					$this->db->set($payment_info);
					$this->db->insert('eft_payments_info');


				}


				echo 1;
			 
			 
		}
		 
	}	
	
	 
    function get_payment_types(){
        
        $this->db->select('payment_type_id, payment_type_name,payment_type_type');
        $this->db->where('payment_type_active', '1');
        $this->db->where_in('payment_type_type', ['Credit Card','Debit Card','Digital Wallet']);
        return $this->db->get('payment_types')->result_array();
    }
	 
	
	//end of eft
	 
    
    
    
    
     

   
}