<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Departments_model extends CI_Model
{
	var $departments = 'departments dp';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_departments
	 *
	 * @access	public
	 */
	function get_departments($type = false)
	{
		$this->db->order_by('department_name');
		$query = $this->db->get($this->departments);
			
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_departments_dropdown
	 *
	 * @access	public
	 */
	function get_departments_dropdown()
	{
		$query = $this->db->get($this->departments);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->department_name] = $r->department_name;
			}
			ksort($array);
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_department
	 *
	 * @access	public
	 */
	function get($department_id)
	{
		$this->db->where('department_id', $department_id);
		$query = $this->db->get($this->departments);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'department_name'			=> $this->input->post('department_name'),
			'priveleges'				=> $this->input->post('priveleges'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('departments');
		
		return $this->db->insert_id();;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * is_departmentname_exist
	 *
	 * @access	public
	 */
	function is_departmentname_exist($departmentname = FALSE)
	{
		// check if departmentname exists
		$this->db->where('lower(department_name)', strtolower($departmentname));
		$query = $this->db->get($this->departments);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($department_id)
	{
		$fields = array(
			'department_name'			=> $this->input->post('department_name'),
			'priveleges'				=> $this->input->post('priveleges'),
		);
		
		// update db
		$this->db->where('department_id', $department_id);
		$this->db->update($this->departments, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($department_id)
	{
		$this->db->delete('departments', array('department_id' => $department_id));
		
		return true;
	}
}
// END departments_model.php
/* Location: ./application/models/departments_model.php */	