<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Branches_model extends CI_Model
{
	var $branches = 'branches ou';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branches
	 *
	 * @access	public
	 */
	function get_branches($type = false)
	{
		$this->db->order_by('branch_name');
		$query = $this->db->get($this->branches);
			
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branches_dropdown
	 *
	 * @access	public
	 */
	function get_branches_dropdown()
	{
		//check if DS head office 
		if($this->session->userdata('user_branch_id') == 142){ 
			$this->db->where('branch_category','SM Dept. Store');
		}
		$this->db->order_by('branch_name');
		$query = $this->db->get($this->branches);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branch
	 *
	 * @access	public
	 */
	function get($branch_id)
	{
		$this->db->where('branch_id', $branch_id);
		$query = $this->db->get($this->branches);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_last_receipt_number
	 *
	 * @access	public
	 */
	function get_last_receipt_number($branch_id)
	{
		// get branch info
		$branch = $this->get($branch_id);
		
		$next_receipt_number = $branch->branch_last_receipt_number += 1;
		
		// update last receipt number
		$this->db->where('branch_id', $branch_id);
		$this->db->update($this->branches, array('branch_last_receipt_number' => $next_receipt_number));
		
		return $next_receipt_number;
	}
	
	/**
	 * get_last_or_number
	 *
	 * @access	public
	 */
	function get_last_or_number($branch_id)
	{
		// get branch info
		$branch = $this->get($branch_id);
		
		$next_or_number = $branch->branch_last_or_number += 1;
		
		// update last receipt number
		$this->db->where('branch_id', $branch_id);
		$this->db->update($this->branches, array('branch_last_or_number' => $next_or_number));
		
		return $next_or_number;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'branch_name'			=> $this->input->post('branch_name'),
			'branch_category'		=> $this->input->post('branch_category'),
			'branch_address'		=> $this->input->post('branch_address'),
			'branch_address2'		=> $this->input->post('branch_address2'),
			'branch_city'			=> $this->input->post('branch_city'),
			'branch_zip'			=> $this->input->post('branch_zip'),
			'branch_tin'			=> $this->input->post('branch_tin'),	
			'ar_printing'			=> $this->input->post('ar_printing'),	
			'or_printing'			=> $this->input->post('or_printing'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('branches');
		
		return $this->db->insert_id();;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * is_branchname_exist
	 *
	 * @access	public
	 */
	function is_branchname_exist($branchname = FALSE)
	{
		// check if branchname exists
		$this->db->where('lower(branch_name)', strtolower($branchname));
		$query = $this->db->get($this->branches);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($branch_id)
	{
		$fields = array(
			'branch_name'			=> $this->input->post('branch_name'),
			'branch_category'		=> $this->input->post('branch_category'),
			'branch_address'		=> $this->input->post('branch_address'),
			'branch_address2'		=> $this->input->post('branch_address2'),
			'branch_city'			=> $this->input->post('branch_city'),
			'branch_zip'			=> $this->input->post('branch_zip'),
			'branch_tin'			=> $this->input->post('branch_tin'),
			'ar_printing'			=> $this->input->post('ar_printing'),	
			'or_printing'			=> $this->input->post('or_printing'),		
		);
		
		// update db
		$this->db->where('branch_id', $branch_id);
		$this->db->update($this->branches, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($branch_id)
	{
		$this->db->delete('branches', array('branch_id' => $branch_id));
		
		return true;
	}
}
// END branches_model.php
/* Location: ./application/models/branches_model.php */	