<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Banner_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $banner = 'banner pr';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_logos
	 *
	 * @access	public
	 */
	function get_banner_active()
	{
		$this->db->where('banner_status','yes');
		$query = $this->db->get($this->banner);
		
		return $query->result();
	}
	
	function get_banner_inactive()
	{
		$this->db->where('banner_status','no');
		$query = $this->db->get($this->banner);
		
		return $query->result();
	} 
	
	function get_banner()
	{
		$query = $this->db->get($this->banner);
		
		return $query->result();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_logos_dropdown
	 *
	 * @access	public
	 */
	function get_banner_dropdown()
	{
		$query = $this->db->get($this->banner);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->banner_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 */
	function upload($filename, $image_path, $filewh, $filesize)
	{
		$fields = array(
			'banner_path'		=> $image_path,
			'banner_filename'	=> $filename,
			'banner_wh'			=> $filewh,
			'banner_filesize'	=> $filesize,
			'banner_row'		=> $this->input->post('banner_row'),
			'event_title'		=> $this->input->post('event_title'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('banner');
		
		return true;
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($banner_id)
	{
		$this->db->where('banner_id', $banner_id);
      	$this->db->select('banner_path');
      	$query = $this->db->get('banner');
      	foreach($query->result() as $item)  
      	{
      		$old_image_path =$item->banner_path;
      	}
      	unlink('./uploads/'.$old_image_path);
      	$this->db->where('banner_id', $banner_id);
		$this->db->delete('banner', array('banner_id' => $banner_id));
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function active($banner_id)
	{
		$this->db->where('banner_id', $banner_id);
		$this->db->update($this->banner, array('banner_status'=>'yes') );
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function inactive($banner_id)
	{
		$this->db->where('banner_id', $banner_id);
		$this->db->update($this->banner, array('banner_status'=>'no') );
		
		return true;
	}	
}

// END logos_model.php
/* Location: ./application/models/logos_model.php */	