<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Background_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $background = 'ticket_background tbg';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_ticket background
	 *
	 * @access	public
	 */
	function get_background()
	{
		$this->db->order_by('ticket_background_id','desc');
		$this->db->limit(20);
		$query = $this->db->get($this->background);
		
		return $query->result();
	}
	
	/**
	 * get_ticket background active
	 *
	 * @access	public
	 */
	function get_background_active()
	{
		$this->db->where('ticket_background_status','yes');
		$query = $this->db->get($this->background);
		
		return $query->result();
	}
	
	/**
	 * get_ticket background inactive
	 *
	 * @access	public
	 */
	function get_background_inactive()
	{
		$this->db->where('ticket_background_status','no');
		$query = $this->db->get($this->background);
		
		return $query->result();
	} 
	
	/**
	 * upload ticket background
	 *
	 * @access	public
	 */
	function upload($filename, $image_path, $filewh, $filesize)
	{
		$fields = array(
			'ticket_background_path'		=> $image_path,
			'ticket_background_filename'	=> $filename,
			'ticket_background_wh'			=> $filewh,
			'ticket_background_filesize'	=> $filesize,
			'ticket_background_row'			=> $this->input->post('background_row'),
			'event_title'					=> $this->input->post('event_title'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('ticket_background');
		
		return true;
	}	
	
	/**
	 * delete
	 *
	 */
	function delete($background_id)
	{
		$this->db->where('ticket_background_id', $background_id);
      	$this->db->select('ticket_background_path');
      	$query = $this->db->get('ticket_background');
      	foreach($query->result() as $item)  
      	{
      		$old_image_path =$item->ticket_background_path;
      	}
      	unlink('./uploads/'.$old_image_path);
      	$this->db->where('ticket_background_id', $background_id);
		$this->db->delete('ticket_background', array('ticket_background_id' => $background_id));
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function active($background_id)
	{
		$this->db->where('ticket_background_id', $background_id);
		$this->db->update($this->background, array('ticket_background_status'=>'yes') );
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function inactive($background_id)
	{
		$this->db->where('ticket_background_id', $background_id);
		$this->db->update($this->background, array('ticket_background_status'=>'no') );
		
		return true;
	}	
	
	/**
	 * get_background_dropdown
	 *
	 * @access	public
	 */
	function get_background_dropdown()
	{
		$this->db->where('ticket_background_row', 1);
		$query = $this->db->get($this->background);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->ticket_background_id] = substr($r->event_title, 0, 50) ;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	function get_background_left()
	{
		$this->db->where('ticket_background_row', 2);
		$query = $this->db->get($this->background);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->ticket_background_id] = substr($r->event_title, 0, 43) ;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	function get_background_right()
	{
		$this->db->where('ticket_background_row', 3);
		$query = $this->db->get($this->background);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->ticket_background_id] = substr($r->event_title, 0, 43) ;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
}

// END logos_model.php
/* Location: ./application/models/logos_model.php */	