<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Admin_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';

	var $arrTListStat = array(); // status filter for TRANSACTION LISTING
	var $arrEventTListStat = array('reserved','unselected'); // status filter for EVENT TRANSACTION LISTING
	// using constructor function, get value of $arrEventTlistStat to make filter for transaction listing the same

	public function __construct()
	{
		parent::__construct();
	}

	
	function mark_paid_transaction_done($transaction_id)
	{
		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->where_in('transaction_status', array('paid','paid_online'));
		$this->db->update($this->transactions, array('transaction_status' =>'done'));
		
		// update the tickets table		
		$changes = array(
			'ticket_status'			=> 'done',
		);
		
		// update the status of the tickets
		$this->db->where_in('ticket_status', array('paid','paid_online'));
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, $changes);
		
		return true;
	}

	//for historical ATR sales
	function copy_tickets($transaction_id = false , $status = false)
	{
		
		if(!$transaction_id) return false;
		if(!$status) return false;
		
		 
		//get last sync 
		// $last_sync =$this->_get_last_sync('historical_tickets');
		// echo $last_sync;
		// die();
		// copy the event
		$sql = "insert into historical_tickets(
 				ticket_id,
 				ticket_date_entered,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				ticket_date_printed,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				ticket_status,
 				ticket_user_id,
 				ticket_branch_id,
 				ticket_terminal_id,
 				ticket_barcode 
			) 

 

			select
				ticket_id,
 				?,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				?,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				?,
				ticket_user_id,
				ticket_branch_id, 
 				ticket_terminal_id,
 				ticket_barcode 
				
				
			from tickets t
			left join voided_transaction_details v on v.voided_detail_ticket_id = t.ticket_id
			where t.ticket_transaction_id = ? and t.ticket_status in ('done','paid','paid_online')
			"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),date("Y-m-d H:i:s"),$status,$transaction_id));
		
		// $new_event_id = $this->db->insert_id();
		
		// return $new_event_id;
	}

	function copy_voided_tickets($ticket_ids = false ,$user_id = false ,$branch_id = false , $status = false)
	{
		
		if(!$ticket_ids) return false;
		if(!$user_id) return false;
		if(!$branch_id) return false;
		if(!$status) return false;
		
		 
		//get last sync 
		// $last_sync =$this->_get_last_sync('historical_tickets');
		// echo $last_sync;
		// die();
		// copy the event
		$sql = "insert into historical_tickets(
 				ticket_id,
 				ticket_date_entered,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				ticket_date_printed,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				ticket_status,
 				ticket_user_id,
 				ticket_branch_id,
 				ticket_terminal_id,
 				ticket_barcode 
			) 

 

			select
				ticket_id,
 				?,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				?,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				?,
				?,
				?,
				ticket_terminal_id,
 				ticket_barcode 
				
				
			from tickets t
			where t.ticket_id in (".implode(',', $ticket_ids).")
			"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),date("Y-m-d H:i:s"), $status , $user_id, $branch_id));
		
		// $new_event_id = $this->db->insert_id();
		
		// return $new_event_id;
	}

	
	function copy_transactions($transaction_id = false, $status = false)
	{
		
		if(!$transaction_id) return false;
		if(!$status) return false;
	 
		//get last sync 
		// $last_sync =$this->_get_last_sync('historical_transactions');
		// echo $last_sync;
		// die();
		// copy the event
		$sql = "insert  into historical_transactions(
 				transaction_id,
 				transaction_receipt_number,
 				transaction_date,
 				transaction_date_validity,
 				transaction_user_id,
 				transaction_customer_id,
 				transaction_branch_id,
 				transaction_terminal_id,
 				transaction_cash_payment,
 				transaction_card_payment,
 				transaction_gc_sm_payment,
 				transaction_gc_sodeho_payment,
 				transaction_mc_payment,
 				transaction_other_payment,
 				transaction_claim,
 				transaction_details,
 				transaction_type,
 				transaction_comment,
 				transaction_status,
 				transaction_cash_change,
 				transaction_barcode,
 				transaction_ipay_status,
 				transaction_referrer,
 				transaction_code,
 				transaction_cc_ref,
 				transaction_pin
 				  
			) 




			select
				transaction_id,
 				transaction_receipt_number,
 				?,
 				transaction_date_validity,
 				transaction_user_id,
 				transaction_customer_id,
 				transaction_branch_id,
 				transaction_terminal_id,
 				transaction_cash_payment,
 				transaction_card_payment,
 				transaction_gc_sm_payment,
 				transaction_gc_sodeho_payment,
 				transaction_mc_payment,
 				transaction_other_payment,
 				transaction_claim,
 				transaction_details,
 				transaction_type,
 				transaction_comment,
 				?,
 				transaction_cash_change,
 				transaction_barcode,
 				transaction_ipay_status,
 				transaction_referrer,
 				transaction_code,
 				transaction_cc_ref,
 				transaction_pin 
 				 

			from transactions where transaction_id = ?
			
			"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),$status,$transaction_id));
		
		// $new_event_id = $this->db->insert_id();
		
		// return $new_event_id;
	}

	function copy_payments($transaction_id = false)
	{
		
		$branch_id = $this->session->userdata('user_branch_id');
		//get last sync 
		// $last_sync =$this->_get_last_sync('historical_payments');
		// echo $last_sync;
		// die();
		// copy the event
		$sql = "insert into historical_payments(
 				payment_id,
 				payment_transaction_id,
 				payment_payment_type_id,
 				payment_amount,
				payment_datetime,
 				payment_amount_type,
 				payment_amount_voided,
				payment_branch
			) 


			select
				payment_id,
 				payment_transaction_id,
 				payment_payment_type_id,
 				payment_amount,
 				?,
 				payment_amount_type,
 				payment_amount_voided,
 				?

			from payments  
			where payment_transaction_id =?
 			"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),$branch_id, $transaction_id));
		
		// $new_event_id = $this->db->insert_id();
		
		// return $new_event_id;
	}

	function copy_charges($transaction_id = false)
	{
		 
		//get last sync 
		// $last_sync =$this->_get_last_sync('historical_charges');
		// echo $last_sync;
		// die();
		// copy the event
		$sql = "insert into historical_charges(
 				charge_datetime,
 				charge_transaction_id,
 				charge_amount,
 				charge_ticket_count,
				charge_type,
 				charge_amount_voided 
			) 


			select
				?, 
 				charge_transaction_id,
 				charge_amount,
 				charge_ticket_count,
				charge_type,
 				charge_amount_voided 

			from charges where charge_transaction_id = ? 
			"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),$transaction_id));
		
		// $new_event_id = $this->db->insert_id();
		
		// return $new_event_id;
	}

	
	function _get_last_sync($table){
		
		if(!$table) return date("1970-01-01");
		
		$this->db->select('date_modified');
		$this->db->order_by('date_modified','desc'); 
		$this->db->limit(1); 
		$query = $this->db->get($table);
		
		if($query->num_rows() > 0){
		
			return $query->row()->date_modified;
			
			 
		
		}else{
			
			return date("1970-01-01");
		}
		 
		
		
	}
	
	function copy_voided_tickets2($ticket_ids = false ,$user_id = false ,$branch_id = false , $status = false)
	{
		
		if(!$ticket_ids) return false;
		if(!$user_id) return false;
		if(!$branch_id) return false;
		if(!$status) return false;
		
		 
		//get last sync 
		// $last_sync =$this->_get_last_sync('historical_tickets');
		// echo $last_sync;
		// die();
		// copy the event
		$sql = "insert into historical_tickets(
 				ticket_id,
 				ticket_date_entered,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				ticket_date_printed,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				ticket_status,
 				ticket_user_id,
 				ticket_branch_id,
 				ticket_terminal_id,
 				ticket_barcode 
			) 

 

			select
				ticket_id,
 				?,
 				ticket_transaction_id,
 				ticket_session_id,
 				ticket_event_id,
 				ticket_section_id,
 				ticket_type_id,
 				ticket_price_id,
 				ticket_system_row,
 				ticket_system_col,
 				ticket_row,
 				ticket_seat,
 				ticket_reservation_expiry,
 				ticket_acknowledgment_receipt,
 				?,
 				ticket_date_cancelled,
 				ticket_date_reserved,
 				ticket_date_refunded,
 				?,
				?,
				?,
				ticket_terminal_id,
 				ticket_barcode 
				
				
			from tickets t
			where t.ticket_id in ($ticket_ids)
			"; 
			
		$this->db->query($sql, array(date("Y-m-d H:i:s"),date("Y-m-d H:i:s"), $status , $user_id, $branch_id));
		
		// $new_event_id = $this->db->insert_id();
		
		// return $new_event_id;
	}

	
	
}