<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class HTTPCall {
	// --------------------------------------------------------------------

	var $metadata = array();
	var $rawoutput = "";

	// original code with thrown exception:
	function do_post_request($url, $data, $optional_headers = null)
	{
		$params = array('http' => array(
				  'method' => 'POST',
				  'content' => $data
				));
		if ($optional_headers !== null) {
			$params['http']['header'] = $optional_headers;
		}
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		if (!$fp) {
			throw new Exception("Problem with $url, $php_errormsg");
		}
		$response = @stream_get_contents($fp);
		if ($response === false) {
			throw new Exception("Problem reading data from $url, $php_errormsg");
		}
		return $response;
	}

	// modded/customized
	function do_web_requests($protocol, $url, $method, $data, $optional_headers = null)
	{
		if (strtoupper($method) == "GET") {
			$url = "$url?".http_build_query($data);
			$params = array($protocol => array(
					  'method' => strtoupper($method),
					));
		}
		else {
			$params = array($protocol => array(
					  'method' => strtoupper($method),
					  'content' => http_build_query($data)
					));
		}
		if ($optional_headers !== null) {
			$params['http']['header'] = $optional_headers;
		}
		
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		
		if (!$fp) {
			$response = false;
		}
		else {
			$response = @stream_get_contents($fp);
		}
		$this->rawoutput = $response;
		$this->metadata = @stream_get_meta_data($fp);
		return $response;
		
	}	


	function do_http_post_request($url, $data, $optional_headers = null)
	{ 
		return $this->do_web_requests('http', $url, 'POST', $data, $optional_headers);
	}
	
	function do_https_post_request($url, $data, $optional_headers = null)
	{ 
		return $this->do_web_requests('https', $url, 'POST', $data, $optional_headers);
	}
	
	function do_http_get_request($url, $data, $optional_headers = null)
	{
		return $this->do_web_requests('http', $url, 'GET', $data, $optional_headers);
	}
	
	function do_https_get_request($url, $data, $optional_headers = null)
	{
		return $this->do_web_requests('https', $url, 'GET', $data, $optional_headers);
	}
	
	
}

