<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

// --------------------------------------------------------------------
	
/**
 * assemble_message
 *
 * @access	public
 */
function assemble_message($message) 
{
	return '<div id="success_message" class="success" autohide="5">'.$message.'</div>';
}

function assemble_error($message) 
{
	return '<div id="error_message" class="error">'.$message.'</div>';
}

// --------------------------------------------------------------------
	
/**
 * prep_amount
 *
 * @access	public
 */
function prep_amount($str)
{	
	return str_replace(',', '', $str);
}	
	
// --------------------------------------------------------------------
	
/**
 * print_array
 *
 * @access	public
 */
function print_array($array) 
{
	echo '<pre>';
	print_r($array);
	echo '</pre>';
}

// --------------------------------------------------------------------
	
/**
 * jsencode
 *
 * @access	public
 */
function jsencode( $obj ){
	if( is_array( $obj ) ){
		$code = array();
		if( array_keys($obj) !== range(0, count($obj) - 1) ){
			foreach( $obj as $key => $val ){
				$code []= "\"$key\":" . jsencode( $val );
			}
			$code = '{' . implode( ',', $code ) . '}';
		} else {
			foreach( $obj as $val ){
				$code []= jsencode( $val );
			}
			$code = '[' . implode( ',', $code ) . ']';
		}
		return $code;
	} else {
		return '"' . addslashes( $obj ) . '"';
	}
}


// --------------------------------------------------------------------
	
/**
 * jsdecode
 *
 * @access	public
 */
function jsdecode($v)
{
    if ($v[0] == '"') {
      $v = drupal_substr($v, 1, -1);
    }
    elseif ($v[0] == '{') {
      $var = explode(",", drupal_substr($v, 1, -1)); # changed from drupal_substr($v, 1, -2), since it was chopping off the final quote
      $v = array();
      foreach ($var as $value) {
        $va = explode(":", $value);
        # added the following condition to remove quotes from the key
        if($va[0][0] == '"') {
            $va[0] = drupal_substr($va[0], 1, -1);
        }
        $v[$va[0]] = json_decode($va[1]);
      }
    }
    elseif ($v[0] == '[') {
      $var = explode(",", drupal_substr($v, 1, -2));
      $v = array();
      foreach ($var as $value) {
        $v[] = json_decode($va[0]);
      }
    }
    return $v;
} 

// --------------------------------------------------------------------

/**
 * get_ip_address
 *
 * @access	public
 */
 
function get_ip_address() 
{
	return (empty($_SERVER['HTTP_CLIENT_IP'])?(empty($_SERVER['HTTP_X_FORWARDED_FOR'])? 
		$_SERVER['REMOTE_ADDR']:$_SERVER['HTTP_X_FORWARDED_FOR']):$_SERVER['HTTP_CLIENT_IP']);
}

// --------------------------------------------------------------------

/**
 * array_to_object
 *
 * @access	public
 */

function array_to_object($array) {
	$return = new stdClass();
	foreach ($array as $k => $v) {
		if (is_array($v)) {
			$return->$k = array_to_object($v);
		}
		else {
			$return->$k = $v;
		}
	}

	return $return;
}

// --------------------------------------------------------------------
	
/**
 * object_to_array
 *
 * @access	public
 */
function object_to_array($mixed) 
{
	if(is_object($mixed)) $mixed = (array) $mixed;
	if(is_array($mixed)) {
		$new = array();
		foreach($mixed as $key => $val) {
			$key = preg_replace("/^\\0(.*)\\0/","",$key);
			$new[$key] = object_to_array($val);
		}
	}
	else $new = $mixed;
	return $new;
}



if (! function_exists('printr')){
  function printr($val){
    echo "<pre>" . print_r($val, true). "</pre>";
    return true;
  }
}

if (! function_exists('out_datetime')) {
  function out_datetime($date, $format="F d, Y g:i:s A")
	{
    return date($format, strtotime($date));
	}	
}

if (! function_exists('out_date')) {
  function out_date($date, $format='F d, Y')
	{
	  if (strtotime($date))
        return date($format, strtotime($date));
	}	
}

if (! function_exists('input_date') ) {
  function input_date($date){
    return date('Y-m-d', strtotime($date));
  }
}

if (!function_exists('datetime_fuzzy'))
{
  function datetime_fuzzy($delta)
  {	  
	$mn = $sc = $hr = $dy = 0;	
	$sc = $delta;

	while ($sc > 59)
	{
		$mn = floor($delta/60);
		while ($mn > 59)
		{
			$hr = floor($mn/60);
			while ($hr > 23)
			{
				$dy = floor($hr/24);
				$hr = $hr %24;				
			}			
			$mn = $mn % 60;			
		}
		$sc = $delta % 60;		
	}
	$msg = array();
	if ($dy)
	{
		$msg[] = $dy . ( ($dy>1) ? 'days': 'day');
	}
	if ($hr)
	{
		$msg[] = $hr . ( ($hr>1) ? 'hrs': 'hr');		
	}
	if ($mn)
	{
		$msg[] = $mn . ( ($mn>1) ? 'mins': 'min');		
	}
	if ($sc)
	{
		$msg[] = $sc . ( ($sc>1) ? 'secs': 'sec' );		
	}
	if (empty($msg)) { $msg[] = '0 mins'; }
	//printr(array($msg, $delta, $dy, $hr, $mn, $sc));
	return implode(' ', $msg);
  }	
}

if (! function_exists('delta_to_now') )
{
  function delta_to_now($pasttime, $fuzzy=false){
    $delta = strtotime('now') - strtotime($pasttime);
	
	return $fuzzy ? datetime_fuzzy($delta) : $delta;
  }
}

if (! function_exists('delta_minutes') )
{
  function delta_minutes($pasttime, $fuzzy=false){
	return floor ( delta_to_now($pasttime) / 60 );
  }
}


if (! function_exists('input_datetime') ) {
  function input_datetime($date){
    return date('Y-m-d G:i:s', strtotime($date));
  }
}

if (! function_exists('qw')) {
  function qw($str='') {
    return preg_split("/\s+/", $str);
  }
}

if (! function_exists('issetVal')) {
  function issetVal($var, $def='') {
    return issetNE($var) ? $var : $def;
  }
}

if (! function_exists('issetNE')) {
  function issetNE($var) {
    return isset($var) && !empty($var);
  }
}


/* End of file various_helper.php */
/* Location: ./system/helpers/various_helper.php */