<?php

class Users extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('usersessions_model','usersess');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('users/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		$this->load->library('pagination');
		
		// check user session
		$this->users->check_session(array('IT','Super Admin', 'Admin','Super Admin','Admin2','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Users';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		// constants
		$limit = $this->pagination->per_page;
		$offset = $this->uri->segment(3);


		/* Search Code */
		$searchkey = array();
		$searchflds = qw('name username usertype branch terminal');
		foreach ( $searchflds as $fld)
		{
			if ($this->input->post($fld))
			{
  				$searchkey[ $fld ] = $this->input->post($fld);
			}
		}		
		if (empty($searchkey) && empty($offset) )
		{
		  	$this->session->unset_userdata('search_users');		
		}
		else
		{
			if (empty($searchkey))			
				$searchkey = $this->session->userdata('search_users');
			else
				$this->session->set_userdata('search_users', $searchkey);
		}
		foreach ($searchflds as $skey)
		{
	 		$data[$skey]= isset($searchkey[$skey]) ? $searchkey[$skey] : false;
		}
		/* Search code end */
		
		//$this->usersess->update($userid);
		
		$data['users'] = $this->users->get_users($offset, $limit, $searchkey);
		//$data['logs'] = $this->logs->get_logs($searchkey, $offset, $limit);
		
		// pagination
		$config['base_url'] = site_url('users/listing');
		$config['total_rows'] = count($this->users->get_users(null, null, $searchkey));
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->load->view('users_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function inactive_users()
	{
		$this->load->library('pagination');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
		
		// prepare data for the template
		$data['page_title'] = 'Users';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		// constants
		$limit = $this->pagination->per_page;
		$offset = $this->uri->segment(3);


		/* Search Code */
		$searchkey = array();
		$searchflds = qw('name usertype branch terminal');
		foreach ( $searchflds as $fld)
		{
			if ($this->input->post($fld))
			{
  				$searchkey[ $fld ] = $this->input->post($fld);
			}
		}		
		if (empty($searchkey) && empty($offset) )
		{
		  	$this->session->unset_userdata('search_users');		
		}
		else
		{
			if (empty($searchkey))			
				$searchkey = $this->session->userdata('search_users');
			else
				$this->session->set_userdata('search_users', $searchkey);
		}
		foreach ($searchflds as $skey)
		{
	 		$data[$skey]= isset($searchkey[$skey]) ? $searchkey[$skey] : false;
		}
		/* Search code end */
		
		//$this->usersess->update($userid);
		
		$data['users'] = $this->users->get_inactive_users($offset, $limit, $searchkey);
		//$data['logs'] = $this->logs->get_logs($searchkey, $offset, $limit);
		
		// pagination
		$config['base_url'] = site_url('users/inactive_users');
		$config['total_rows'] = count($this->users->get_inactive_users(null, null, $searchkey));
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->load->view('users_inactive_listing', $data);
	}
	// --------------------------------------------------------------------
	
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($user_id = FALSE)
	{
		if (! $user_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'View User';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance','Reservation-Admin','IT','Super Admin'));
		// $this->users->check_session(array('IT','Super Admin'));
	
		// get user's data
		$data['users'] = $this->users->get($user_id);
		
		// display the page
		$this->load->view('users_view', $data);
	}	
	// --------------------------------------------------------------------
	
	/**
	 * login
	 *
	 * @access	public
	 */
	function login()
	{
		// prepare data for the template
		$data['page_title'] = 'Login';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// $this->session->set_userdata(array('forcelogout' => 'no'));
		
    	if (! $this->session->userdata('logged_in'))
		{
  			$this->load->view('users_login', $data);			
		}
		else 
		{			
			// log this
			$this->logs->add($data['page_title']);

			redirect('users');
		}
		/*
		$user = $this->users->login();
		$usermgr = $this->users->manager_login();
		<?php if ($this->session->userdata('logged_in')): ?>
		print_r(array($usermgr, $user,'tae') );
		*/
	}
	
	
	/**
	 * manager_login
	 *
	 * @access	public
	 */
	function manager_login()
	{
		// prepare data for the template
		$data['page_title'] = 'Manager Login';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// display the page
		$this->load->view('users_manager_login', $data);
		
    	/*if (! $this->session->userdata('logged_in'))
		{
  			$this->load->view('users_login', $data);			
		}
		else 
		{			
			redirect('users');
		}
		/*
		$user = $this->users->login();
		$usermgr = $this->users->manager_login();
		<?php if ($this->session->userdata('logged_in')): ?>
		print_r(array($usermgr, $user,'tae') );
		*/
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * change password
	 *
	 * @access	public
	 */
	function change_password($redirect = false)
	{
		
		// prepare data for the template
		$data['page_title'] = 'Change Password';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		//$this->users->check_session();
			
		$config = array(
			array(
				'field'   => 'current_password',
				'label'   => 'Change Password',
				'rules'   => 'trim|strip_tags|required|min_length[2]|max_length[16]|callback__password_check'
			),
			array(
				'field'   => 'new_password',
				'label'   => 'New Password',
				'rules'   => 'trim|strip_tags|required|min_length[8]|max_length[15]|callback__password_check_alphanum'
			),			
			array(
				'field'   => 're_password',
				'label'   => 'Re - Type Password',
				'rules'   => 'trim|strip_tags|required|min_length[8]|max_length[15]|matches[new_password]|callback__password_check_alphanum'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// get user's data
			$data['user'] = $this->users->get($this->session->userdata('user_id'));
			
			// display the page
			$this->load->view('users_change_password', $data);
		}
		else
		{
			$this->users->change_password($this->session->userdata('user_id'));
			$this->session->set_flashdata('message', assemble_message('Password has been successfully modified'));
			
			if ($redirect == 'session')
			{
				redirect('users/users_session/');
			}
			else
			{
				redirect('users/go_to_landing_page');
			}
		}
	}

	function go_to_landing_page() {
		$ut =  strtolower($this->session->userdata("user_type"));
		$indexpage = $this->config->item("indexpage");
		if (isset($indexpage[$ut])) {
			redirect($indexpage[$ut]);
		} else {
			redirect('/');
		}
	}

	function forgot_password()
	{
		
		// prepare data for the template
		$data['page_title'] = 'Reset Password';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		//$this->users->check_session();
			
		$config = array(						
			array(
				'field'   => 'username',
				'label'   => 'Username',
				'rules'   => 'trim|strip_tags|required|min_length[8]|max_length[30]'
			),			
			array(
				'field'   => 'new_password',
				'label'   => 'New Password',
				'rules'   => 'trim|strip_tags|required|min_length[8]|max_length[16]|callback__password_check_alphanum'
			),			
			array(
				'field'   => 're_password',
				'label'   => 'Re - Type Password',
				'rules'   => 'trim|strip_tags|required|min_length[8]|max_length[16]|matches[new_password]'
			),
			array(
				'field'   => 'mgr_username',
				'label'   => 'Username',
				'rules'   => 'trim|required|strip_tags|max_length[30]'
			),			
			array(
				'field'   => 'mgr_password',
				'label'   => 'Password',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),			
			array(
				'field'   => 'comment',
				'label'   => 'Comment',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			
		);
		
		$this->form_validation->set_rules($config); 		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('users_forgot_password', $data);
		}
		else
		{		
			if (! $this->users->manager_login($this->input->post('mgr_username'), $this->input->post('mgr_password')) )
			{
				$data['_error_msg'] = "Manager username and password combination is incorrect";
				$this->load->view('users_forgot_password', $data);
				return false;
			}
			
			if (!  $this->users->reset_password_by_username($this->input->post('username'), $this->input->post('new_password')) )
			{
				$data['_error_msg'] = "Username cannot be found!";
				$this->load->view('users_forgot_password', $data);
				return false;
			}
			
			
			$this->session->set_flashdata('message', assemble_message('Password has been successfully modified'));
			
			redirect('users/forgot_password');
		}		
		
	}
		
	
	// --------------------------------------------------------------------
	
	/**
	 * login_check
	 *
	 * @access	public
	 */
	function login_check()
	{
		
		 
		// sleep(1);
		$user = $this->users->login();

		// log this
		$this->logs->add('User Login Check');

		if ($user)
		{

			$last_activated = $this->usersess->get_activated_session($user->user_id);
			// check if user is already actively logged in
			  //if (  $this->usersess->is_active($user->user_id) )
				  //die('userexists');
			foreach($last_activated as $la) {
				// $timeout = delta_to_now($la->last_activity, false); 
				$timeout2 = strtotime($la->last_activity);
				$timeout =   strtotime(date("Y-m-d H:i:s"));
				$timeout3 = $timeout - $timeout2; 
				if ($timeout3 < (30*60)) {
					
					$this->logs->add('Session Detected.');
					 
					die('force');
					break;
				 
 					
				} else {
					// log this
					$this->logs->add('Expired Session Detected. AutoLogout.');
					$this->usersess->stop($user->user_id);
					
					// Destroy old session
					$this->session->sess_destroy();

					die('tryagain');
					break;
				}

				
			}

				$this->usersess->start($user->user_id);

				// Create a fresh, brand new session
				// $this->session->sess_create();

				// Set session data
				$this->session->set_userdata(array(
					'logged_in' 		=> true,
					'user_branch_id' 	=> $user->user_branch_id,
					'user_terminal_id' 	=> $user->user_terminal_id,
					'user_id' 			=> $user->user_id,
					'username' 			=> $user->username,
					'firstname' 		=> $user->user_firstname,
					'lastname' 			=> $user->user_lastname,
					'user_type' 		=> $user->user_type,
					'hash'				=> $this->users->prep_password($user->user_id . $user->username . $user->user_type),
					'lasttimecheck'		=> microtime(true),
				));

				// force the user to change password
				$user_type = $this->session->userdata('user_type'); 
				if($user_type=='Treasury'){
					echo 'treasury';
				}else if($user_type=='IT'){
					echo 'IT';
					// die();
				}			
				else if ($user->user_change_password == 1)
				{
					echo 'password';
				}
				
				else
				{		
					echo 'success';
				}
		}
		else
		{
			echo 'failed';
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * manager_login_check
	 *
	 * @access	public
	 */
	function manager_login_check()
	{
		// log this
		$this->logs->add('Manager Login Check');
		
		sleep(1);
		$user = $this->users->manager_login();
		if ($user)
		{						
			echo 'success';
		}
		else
		{
			echo 'failed';
		}
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * Logout
	 *
	 * @access	public
	 */
	function logout($expired = false)
	{
		// echo $_SERVER["REQUEST_URI"];
		// die();
		// prepare data for the template
		if (!$expired) {
			$data['page_title'] = "Logout";
		} else {
			$data['page_title'] = "Logout (Expired)";
		}
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		/*
		
		// check user session
		//$this->users->check_session();
			
		$config = array(
			array(
				'field'   => 'session_ending_serial',
				'label'   => 'Ending Ticket',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[10]|greater_than[session_beginning_serial]'				
			),
		);
		
		$this->form_validation->set_rules($config); 
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');		
					
		// get user's data
		$data['user'] = $this->users->get($this->session->userdata('user_id'));	

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('users_logout', $data);
		}
		else
		{
		*/
  		// clear tickets
  		$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
	  	$this->session->unset_userdata('customer_session_id');
		
		// clear ticket series
  		/*if ($this->session->userdata('user_type') == 'Seller')
	  	{
		  	$this->users->session_logout();
		}*/
		 
  		// clear session data
	  	$array_items = array(
		  	'logged_in', 
			'user_branch_id',
			'user_terminal_id',
  			'user_id', 
	  		'username',
	  		'firstname',
	  		'lastname',
	  		'user_type',
	  		'hash',
	  		'user_session_id',
			'ott'
	  	);

		// logout from the usersssession
		// $user = $this->users->get($this->session->userdata('user_id'));

		// $this->usersess->stop($this->session->userdata('user_id'));
		$this->usersess->stop2($this->session->userdata('user_id'), get_ip_address());

				
		$this->session->unset_userdata($array_items);
	
		// echo $expired;
		// die();
		// redirect
		if (!$expired) {
			$this->session->set_flashdata('message', assemble_message('You have successfully logged out'));
			redirect('users/login');
		} else {
			$this->session->set_flashdata('message', assemble_message('Your session has expired. Please login again.'));
			redirect('');
		}
		//}					
	}
	// --------------------------------------------------------------------
	
	function forcelogout($userid)
	{
		// log this
		$this->logs->add('Force Logout');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance','IT','Super Admin'));
		// $this->users->check_session(array('IT','Super Admin'));
		
		$this->usersess->stop($userid);
		$this->session->set_flashdata('message', assemble_message('User has been successfully logged out'));
		redirect('users/activelisting/');
	}
	
	
	/**
	 * User Session 
	 *
	 * @access	public
	 */
	function users_session()
	{
		// prepare data for the template
		$data['page_title'] = 'User Session';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		//$this->users->check_session();
			
		$config = array(
			array(
				'field'   => 'session_loose_change',
				'label'   => 'Loose Change',
				'rules'   => 'trim|required|strip_tags|max_length[10]'
			),	
			array(
				'field'   => 'session_beginning_serial',
				'label'   => 'Beginning Ticket',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');		
			
		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		
		// get user's data
		$data['user'] = $this->users->get($this->session->userdata('user_id'));	

		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('users_session', $data);
		}
		else
		{
			// set session data
			$this->session->set_userdata(array(
				'tid' => $this->input->post('terminal_id'), 
				'bid' => $this->input->post('branch_id'),
			));
			
			// add session to db
			$session_id = $this->users->add_session();
			
			
			$this->session->set_userdata('user_session_id', $session_id);
			// redirect
			redirect('');
		}
	}	

	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add User';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
		$this->users->check_session(array('IT','Super Admin'));
			
		$config = array(
			array(
				'field'   => 'username',
				'label'   => 'Username',
				'rules'   => 'trim|required|strip_tags|min_length[8]|max_length[24]|callback__username_check'
			),
			array(
				'field'   => 'password',
				'label'   => 'Password',
				'rules'   => 'trim|required|strip_tags|min_length[8]|max_length[16]|callback__password_check_alphanum'
			),
			array(
				'field'   => 'email',
				'label'   => 'Email Address',
				'rules'   => 'trim|strip_tags|valid_email|max_length[80]|callback__email_check'
			),
			array(
				'field'   => 'firstname',
				'label'   => 'First Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'lastname',
				'label'   => 'Last Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'user_type',
				'label'   => 'User Type',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[20]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('users_add', $data);
		}
		else
		{
			$this->users->add();
			$this->session->set_flashdata('message', assemble_message('User has been successfully added'));
			redirect('users/listing');
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($user_id = FALSE)
	{
		if (! $user_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit User';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
		$this->users->check_session(array('IT','Super Admin','Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'password',
				'label'   => 'Password',
				'rules'   => 'trim|strip_tags|min_length[8]|max_length[16]|callback__password_check_alphanum'
			),
			array(
				'field'   => 'email',
				'label'   => 'Email Address',
				'rules'   => 'trim|strip_tags|valid_email|max_length[80]'
			),
			array(
				'field'   => 'firstname',
				'label'   => 'First Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'lastname',
				'label'   => 'Last Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'user_type',
				'label'   => 'User Type',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'user_active',
				'label'   => 'Active',
				'rules'   => 'trim|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();	
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		
		if ($this->form_validation->run() == FALSE)
		{
			// get user's data
			$data['user'] = $this->users->get($user_id);
			
			// display the page
			$this->load->view('users_edit', $data);
		}
		else
		{
			$this->users->edit($user_id);
			$this->session->set_flashdata('message', assemble_message('User has been successfully modified'));
			redirect('users/listing');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($user_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete User');
		
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
		$this->users->check_session(array('IT','Super Admin'));
		
		$this->users->delete($user_id);
		$this->session->set_flashdata('message', assemble_message('User has been successfully deleted'));
		redirect('users/listing/');
	}
	
	// --------------------------------------------------------------------

 	function activelisting()
	{
		$this->load->library('pagination');
		$this->users->check_session(array('IT','Super Admin','Admin','Super Admin','Admin2','Finance','Reservation-Admin'));
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2','Account','Reservation-Admin'));
		
		// prepare data for the template
		$data['page_title'] = 'Active Users';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		// constants
		
		$searchkey = array();
		$searchflds = array('username');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		$limit = $this->pagination->per_page;
		$offset = $this->uri->segment(3);
		
		
		
		// pagination
		$config['base_url'] = site_url('users/activelisting');
		if(!$this->input->post($fld)){
		$config['total_rows'] = count($this->usersess->get_active());
		}else{
		$config['total_rows'] = count($this->usersess->get_active($searchkey, $offset, $limit));
		}
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['users'] = $this->usersess->get_active($searchkey, $offset, $limit);
		$this->load->view('users_activelisting', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * _password_check
	 *
	 * @access	private
	 */
	function _password_check($str)
	{	
	 
		$password_exists = $this->users->is_password_exist($str);
		if (!$password_exists)
		{
			$this->form_validation->set_message('_password_check', "Password is invalid!");
			
			
			return FALSE;
			 
		}
		else
		{
		
		

			return TRUE;
		}
	}	
	
	function _password_check_alphanum($str)
	{
	

	   if (preg_match('#[0-9]#', $str) && preg_match('#[a-zA-Z]#', $str)) {
		 return TRUE;
	   }
	  

		if($str != ''){
	   $this->form_validation->set_message('_password_check_alphanum', "Password must be a combination of alphanumeric characters");
	   return FALSE;
	   }
	   
	}
	
		/**
	 * _email_check
	 *
	 * @access	private
	 */
	function _email_check($str)
	{	
		$email_exists = $this->users->is_email_exist($str);
		if ($email_exists)
		{
			$this->form_validation->set_message('_email_check', "Email $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	// --------------------------------------------------------------------
	// --------------------------------------------------------------------
	
	/**
	 * deactivate Users
	 *
	 * @access	private
	 */
	function deactivate_users()
	{	
		
		$date = date('Y-m-d',strtotime("-6 days"));
		
		$inactive_users = $this->users->inactive_users($date);
		/* 
		echo '<pre>';
		print_r($inactive_users);
		echo '</pre>'; */
		
		// $this->users->deactivate_users($date);
		
		// echo 'Inactive Users was successfully deactivated.';
	}	

	function force_logout(){
		
		
		
		$this->logs->add('Session Detected. Force Logout.');
		
		// $username = $this->input->post('terminal_id'), 
		// $this->input->post('terminal_id'), 
		$user = $this->users->login();
 
		$this->usersess->stop($user->user_id);

		// Destroy old session
		$this->session->sess_destroy();
		
		// die('tryagain');
		// break;
		// $this->session->set_userdata(array('forcelogout' => $var));
	}
	
	/**
	 * _username_check
	 *
	 * @access	private
	 */
	function _username_check($str)
	{	
		$username_exists = $this->users->is_username_exist($str);
		if ($username_exists)
		{
			$this->form_validation->set_message('_username_check', "Username $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	function get_ip(){
	
		echo get_ip_address();
	}
	
	function ref(){
		echo $_SERVER["REQUEST_URI"];
	}
}

/* End of file users.php */
/* Location: ./application/controllers/users.php */