<?php

class Ticket_Layouts extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('events_model', 'events');
		$this->load->model('ticket_layouts_model', 'ticket_layouts');		
		$this->load->model('logos_model', 'logos');	
		$this->load->model('logs_model', 'logs');
		$this->load->model('background_model', 'background');
		$this->load->database('default');
	}
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('ticket_layouts/listing');
	}
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Ticket Layouts';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all Ticket Types
		$data['ticket_layouts'] = $this->ticket_layouts->get_ticket_layouts();
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->load->view('ticket_layouts_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($ticket_layout_id = FALSE)
	{
		if (!$ticket_layout_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Ticket Layout';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
	
		// get ticket types
		$data['ticket_layout'] = $this->ticket_layouts->get($ticket_layout_id);
		print_array($data['ticket_layout']);
		// display the page
		$this->load->view('ticket_layouts_view', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// check for event id
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Add Ticket Layout';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'ticket_logo_1',
				'label'   => 'Logo 1',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_2',
				'label'   => 'Logo 2',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_3',
				'label'   => 'Logo 3',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_4',
				'label'   => 'Logo 4',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_5',
				'label'   => 'Logo 5',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_text_1',
				'label'   => 'Text 1',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_1',
				'label'   => 'Font Size 1',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_1',
				'label'   => 'Font Face 1',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_2',
				'label'   => 'Text 2',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_2',
				'label'   => 'Font Size 2',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_2',
				'label'   => 'Font Face 2',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_3',
				'label'   => 'Text 3',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_3',
				'label'   => 'Font Size 3',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_3',
				'label'   => 'Font Face 3',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_4',
				'label'   => 'Text 4',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_4',
				'label'   => 'Font Size 4',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_4',
				'label'   => 'Font Face 4',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_5',
				'label'   => 'Text 5',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_5',
				'label'   => 'Font Size 5',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_5',
				'label'   => 'Font Face 5',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_6',
				'label'   => 'Text 6',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_6',
				'label'   => 'Font Size 6',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_6',
				'label'   => 'Font Face 6',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_7',
				'label'   => 'Text 7',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_7',
				'label'   => 'Font Size 7',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_7',
				'label'   => 'Font Face 7',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get events
		//$data['events'] = $this->events->get_events_dropdown();
		
		// get logos
		$data['logos'] = $this->logos->get_logos_dropdown();
		
		if ($this->form_validation->run() == FALSE)
		{
			// get event
			$data['event'] = $this->events->get($event_id);
			
			// display the page
			$this->load->view('ticket_layouts_add', $data);
		}
		else
		{
			$this->ticket_layouts->add($event_id);
			$this->session->set_flashdata('message', assemble_message('Ticket Layout has been successfully added'));
			redirect('ticket_layouts/edit/'.$event_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit()
	{
		// check for event id
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Ticket Layout';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'ticket_logo_1',
				'label'   => 'Logo 1',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_2',
				'label'   => 'Logo 2',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_3',
				'label'   => 'Logo 3',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_4',
				'label'   => 'Logo 4',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_logo_5',
				'label'   => 'Logo 5',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'ticket_text_1',
				'label'   => 'Text 1',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_1',
				'label'   => 'Font Size 1',
				'rules'   => 'trim|numeric|required|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_1',
				'label'   => 'Font Face 1',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_2',
				'label'   => 'Text 2',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_2',
				'label'   => 'Font Size 2',
				'rules'   => 'trim|numeric|required|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_2',
				'label'   => 'Font Face 2',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_3',
				'label'   => 'Text 3',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_3',
				'label'   => 'Font Size 3',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_3',
				'label'   => 'Font Face 3',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_4',
				'label'   => 'Text 4',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_4',
				'label'   => 'Font Size 4',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_4',
				'label'   => 'Font Face 4',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_5',
				'label'   => 'Text 5',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_5',
				'label'   => 'Font Size 5',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_5',
				'label'   => 'Font Face 5',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_6',
				'label'   => 'Text 6',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_6',
				'label'   => 'Font Size 6',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_6',
				'label'   => 'Font Face 6',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ticket_text_7',
				'label'   => 'Text 7',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'ticket_font_size_7',
				'label'   => 'Font Size 7',
				'rules'   => 'trim|numeric|strip_tags|min_length[1]|max_length[2]'
			),
			array(
				'field'   => 'ticket_font_face_7',
				'label'   => 'Font Face 7',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[20]'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get events
		$data['events'] = $this->events->get_events_dropdown();	
		
		$data['customize_ticket_layout'] = $this->config->item("enable_ticket_4x3");
		
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$ticket_layout = $this->ticket_layouts->get($event_id);
			$data['ticket_layout'] = $this->ticket_layouts->get($event_id);
			
			// redirect to add ticket layout if it's not existing
			if (! $ticket_layout) redirect('ticket_layouts/add/');
			
			// get logos
			$data['logos'] = $this->logos->get_logos_dropdown();
						
			// get event
			$data['event'] = $this->events->get($event_id);
			
			$data['background'] = $this->background->get_background_dropdown();
			$data['background_l'] = $this->background->get_background_left();
			$data['background_r'] = $this->background->get_background_right();
			
			// display the page
			$this->load->view('ticket_layouts_edit', $data);
		}
		else
		{
			$this->ticket_layouts->edit($event_id);
			//$this->session->set_flashdata('message', assemble_message('Ticket Layout has been successfully modified'));
			redirect('ticket_layouts/edit/');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($ticket_layout_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Ticket Layout');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->ticket_layouts->delete($ticket_layout_id);
		$this->session->set_flashdata('message', assemble_message('Ticket Layout has been successfully deleted'));
		redirect('ticket_layouts/listing/');
	}
}
/* End of file Ticket_Layouts.php */
/* Location: ./application/controllers/Ticket_Layouts.php */