<?php

class Ticket_generator extends CI_Controller 
{
	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
	
	// template for revised ticket layout
	// var $viewfile = "generator_xml_dynamic_resized_278x206-A";
	// var $viewfile = "generator_xml_dynamic_resized_278x206-B";
	// var $viewfile = "generator_xml_dynamic_resized_278x216-B";
	// var $viewfile = "generator_xml_dynamic_resized_278x216-B-20120326";
	var $viewfile = "generator_xml_dynamic_resized_288x216-C";
	
	// background image for ticket preview
	// var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2012_resized_278x206.jpg';
	// var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2012.jpg';
	var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2013.png';

	public function __construct()
	{
		parent::__construct();
		$this->output->set_header("Cache-Control: no-store, no-cache, must-revalidate");
		$this->output->set_header("Pragma: no-cache");
		$this->output->set_header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
		$this->load->helper('generator');
		$this->load->model('generator_model', 'ticket_generator');
		$this->load->database('default');
	}
	
	// to generate ticket data format in xml format for db storage
	function newticket2db($count = 0) {

		$data["count"] = $count;
		$text = $this->load->view("generator_xml_4x3", $data, true);
		
		$valid = false;
		$insert_id = 0;
		$yearmonth = date('ym');
		if (!empty($text)) {
			$fields = array(
				'xml_yearmonth' => $yearmonth,
				'xml_content' => $text,
			);
			
			// build insert SQL
			$__isql = $this->db->insert_string("generator", $fields);
			$valid = $this->db->simple_query($__isql);
			$insert_id = $this->db->insert_id();
		}

		if (($valid) && ($insert_id > 0)) {
			// redirect("/printer/db2xml2pdf/$yearmonth/$insert_id");
			echo "Successfully created xml format <BR>";
			echo anchor("/printer/db2xml2pdf/$yearmonth/$insert_id","PDF Display - /printer/db2xml2pdf/$yearmonth/$insert_id","target=_blank");
		} else {
			// 404
			echo $__isql;
		}
	}
	
	// use this to display test xml output of new ticket layout
	function newticket($count = 0) {
		// for proper display of XML output on browser
		
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		
		$data["count"] = $count;
		$this->load->view("generator_xml_4x3",$data);
	}
	
	// use this to properly review stored XML data for printout
	function newticketFromDBReview($yearmonth = false, $id = false){
		if ($id) {} 
		else { die("Invalid access."); }
		// for proper display of XML output on browser
		$xmldata = "";
		if ($id && $yearmonth) {
			$this->db->where("xml_yearmonth", $yearmonth);
			$this->db->where("xml_id", $id);
			$query = $this->db->get("generator");
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
			}
		}

		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		echo $xmldata;
		// $this->load->view("generator_xml_4x3");
		// $this->load->view($this->viewfile);
	}

	// use this to display test xml output of new ticket layout
	function eventSample($event_id = 0, $preview = false ) {

		$event_id = str_replace(".pdf", "", $event_id);
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;

		$count = 0;
		$data["count"] = $count;
		$data["preview"] = $preview;

		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('generator_model', 'ticket_generator');
		
		$useExpandedTicket = $this->config->item("enable_ticket_4x3");
		// start build of data

		// ticket layout
		$this->load->helper('xml');
		list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($event_id);

		$this->load->helper('xml');

		$bgimage[0] = "";
		if ($preview) {
			// for barcode display
			if ($useExpandedTicket) {
				$bgimage[0] = BASEPATH.$this->ticket_bg_expanded;
			} else {
				$bgimage[0] = BASEPATH.'application/views/images/ticket_bg.jpg';
			}
		}

		$data["layout"] = $layout;
		$data["bgimage"] = $bgimage;

		// empty array of logo (not to be used for new ticket layout)
		$logo1 = array();


		// PREVIEW: Events
		$preview_prices = $this->prices->get_prices($event_id);

		$preview_priceprice = 5000;
		$preview_sectionname = 'PATRON VIP';
		$preview_row = "R";
		$preview_seat = "8";
			
		if (is_array($preview_prices)) {
			$preview_sectionname = $preview_prices[0]->price_name;
			$preview_priceprice = $preview_prices[0]->price_price;
			$preview_pricesections = $preview_prices[0]->price_sections;
		}
		
		// PREVIEW: Info
		$preview_eventcode = "EVENTCODE";
		
		$preview_events = $this->events->get($event_id);
		if(is_object($preview_events)) {
			$preview_eventcode = $preview_events->event_code;
			
			$preview_sections = $this->sections->get_sections($preview_events->event_seatplan_id);
			$preview_sectionseatconfig = "";
			foreach($preview_sections as $ps) {
				if(strpos($preview_pricesections,"\"$ps->section_id\"")>0) {
					$preview_sectionname = $ps->section_name;
					$preview_sectiontype = $ps->section_type;
					$preview_sectionseatconfig = $ps->section_seat_config;
					break;
				}
			}
			
			if ($preview_sectionseatconfig == "") {
				$preview_row = "ROW";
				$preview_seat = "SEAT";
			}
		}

		$tix_info[] = array (
			"tid" => 1,
			"evc" => strtoupper($preview_eventcode),
			"serial" => 1,
			"secname" => $preview_sectionname,
			"row" => $preview_row,
			"seat" => $preview_seat,
			"ttcode" => "RP",
			"paytype" => "CASH",
			"price" => $preview_priceprice,
			"termcode" => "SMMOA",
			"printer" => "TICKETSELLER",
			"arnum" => 0,
			"eid" => sprintf('%06s', $event_id),
			"bc_prefix" => sprintf('%04s', date("ym")),
			"bc_access" => sprintf('%06s', 1),		
		);
			; 
		$data["transaction"] = array(
			"id" => 1,
			"uid" => 1,
			"datetime" => date("Y-m-d H:i:s"),
			"tickets" => $tix_info,
		);
			// sample branch
		$data["branch"] = array(
				'address' => 'Mall of Asia Arena Annex Bldg. Coral Way Cor. JW Diokno Blvd',
				'city' => 'Pasay City',
				'tin' => '123-456-789-0000',
			);

		//for special event
		$data['price_id'] = 1;
		$data['event_id'] = $event_id;
		
		//HARRY STYLES 4137
		if($event_id == 1){
			$this->load->view("generator_xml_dynamic_resized_288x216-C_new", $data);
		}else{
			$this->load->view($this->viewfile, $data);
		}
		
		// $this->load->view($this->viewfile,$data);
		// $this->load->view("generator_xml_dynamic",$data);
		// $this->load->view("generator_xml_dynamic_rev",$data);
		// $this->load->view("generator_xml_4x3.php",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206-A",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206-B",$data);
	}

	function index(){
		$callparam = $_GET;
	
		//the path of the xml that will be converted to pdf
		$url = base_url()."generator/newticket";
		$this->load->library('HTTPCall');
		$this->httpcall->do_http_get_request($url,$callparam);

		$xmldata = $this->httpcall->rawoutput;
	
		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");
		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
			
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		

		$this->load->helper('file');
		$this->load->view('printer_xml2pdf',$data);

	}	

	// use this to display test xml output of new ticket layout
	function createXMLTickets($event_id = 0, $transaction_id = 0, $ticket_count = 0, $online_claim = false) {

		if ($ticket_count > 0) {
			// continue
		} else {
			show_404();
		}
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	

		$this->load->model('prices_model', 'prices');
		$this->load->model('payments_model', 'payments');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('branches_model', 'branches');
		$this->load->model('price_layout_model', 'price_layout');

		$this->db->where("event_id", $event_id);
		$event = $this->db->get('events')->row();
		$season_pass = $event->event_season_pass;
		
		if($season_pass == 1){
			
			$this->db->where("event_long_title", $event->event_long_title);
			$this->db->where("event_id !=", $event_id);
			$query = $this->db->get('events');
			
			
			if($query->num_rows() > 0){
				$event_ids = array();
				foreach($query->result() as $x){
					 
					$event_ids[] = $x->event_id;
					 
				}
				
				$loop = count($event_ids); 
				
			}else{
				$season_pass = 0;
				$loop = 1;
				
			}
			 
			
		}else{
			
			$loop = 1;
			
		}
		  
		
		//for special season pass
		$res = $this->tickets->get_price_and_ticket_type($transaction_id);
	 
		
		$cpi = $res->price_id;
		$cti = $res->ticket_type_id;
		
		/* 
		
		if($cpi == 46615 && $ticket_count != 1){
			
			// $free = floor($ticket_count / 2);
			// 8046
			//8649
			
			$event_ids = array(8046,8704);
			$loop = count($event_ids); 
			$season_pass = 1;
			
			
		}	
		 */
		 
		 
		//rescued holy week retreat
		if (in_array($cpi, array(51107,51110,51108,51111,51112))){ 
		
			$event_ids = array(9007,9008,9009);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		 
		//COSPLAY  CARNIVAL 2020
		if($cpi == 49991 || $cpi == 50363){ 
		
			$event_ids = array(8829, 8830);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//HYRO
		if($cpi == 49740){ 
		
			$event_ids = array(8727, 8728);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//COSPLAY 2019
		if($cpi == 47804){ 
		
			$event_ids = array(8334,8335,8336);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//MPL-PH S4 GRAND FINALS
		if($cpi == 47279){ 
		
			$event_ids = array(8189 , 8190);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 47278){ 
		
			$event_ids = array(8192 , 8193);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		//COSLANDIA
		if($cpi == 46474 || $cpi == 46473){ 
		
			$event_ids = array(8037,8041,8042);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 46555 || $cpi == 46554){ 
		
			$event_ids = array(8041,8042);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		  
		if($cpi == 46556 || $cpi == 46552){ 
		
			$event_ids = array(8037,8041);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		  
		if($cpi == 46557 || $cpi == 46553 ){ 
		
			$event_ids = array(8037,8042);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
 
		 	
		
		//COSPLAY MANIA 2019
		if($cpi == 45600 || $cpi == 45610){ 
		
			$event_ids = array(7901,7902);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		//ANIME AND COSPLAY EXPO 2019
		if($cpi == 44378){ 
		
			$event_ids = array(7700, 7701);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//unburden 44275,44318,44281,44279,44319,44320,44280
		if($cpi == 44318 || $cpi == 44281 || $cpi == 44279 || $cpi == 44319 || $cpi == 44320 || $cpi == 44280){ 
		
			$event_ids = array(7686,7687,7688);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//unburden 44275,44318,44281,44279,44319,44320,44280
		if($cpi == 44275){ 
		
			$event_ids = array(7685,7687,7688);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//LEADX
		if($cpi == 43655 || $cpi == 43652 || $cpi == 43649){ 
		
			$event_ids = array(7575 ,7576);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		
		
		//COSPLAY CARNIVAL 2019
		if($cpi == 43339){ 
		
			$event_ids = array(7522 ,7523);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		//GAMECON 2019
		if($cpi == 43334){ 
		
			$event_ids = array(7520,7521);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		 
		
		//RAKRAKAN 2019
		if($cpi == 43726){ 
		
			$event_ids = array(7498,7499,7498,7499,7498,7499,7498,7499,7498,7499,7498,7499,7498,7499);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 43151){ 
		
			$event_ids = array(7500,7501);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 43163 || $cpi == 43162){ 
		
			$event_ids = array(7498, 7499);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
	 
		
		
	 
	 
		
		//JESUS GLOBAL YOUTH DAY 40220, 40218, 40219
		
		if($cpi == 40220 || $cpi == 40218 || $cpi == 40219 || $cpi == 43736 || $cpi == 43737 || $cpi == 43738){ 
		
			$event_ids = array(7034,7035,7036);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//JESUS GLOBAL YOUTH DAY
		 
		//Manila Auto Con
		
		if($cpi == 42512 || $cpi == 42511 || $cpi == 42510){ 
		
			$event_ids = array(7393,7394,7395,7396);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
  
		//end of manila auto con
		
		
		
		//COSPLAY MATSURI 2018_Ticket Layout Config


		if($cpi == 41187){ 
		
			$event_ids = array(7206, 7207, 7208 );
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
		
		//end of COSPLAY MATSURI 2018_Ticket Layout Config
 		
		
		//DOTA ALL STAR WEEKEND
		// 34240   6045,6046,6047
		// 34242   6044,6046,6047
		// 34241   6043,6046,6046
		if($cpi == 34240){ 
		
			$event_ids = array(6045,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
		if($cpi == 34242){ 
		
			$event_ids = array(6044,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
		if($cpi == 34241){ 
		
			$event_ids = array(6043,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
  
		if($cpi == 34244){ 
		
			$event_ids = array(6043,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
  
  
  
  
		//cosplay mania 2017
		if($cpi == 33318){ 
		
			$event_ids = array(5883,5884);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
  
  
        
        // fc bundle promo 
        if($cpi == 33294){ 
		
			$event_ids = array(5876 , 5714 , 5715);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		 
 
  
		//toy con 2017
		$toycon = array(32830, 32829);
		
		// 32830 price id = 5791, 5792, 5793 event id 
		if (in_array($cpi, $toycon)){ 
		
			$event_ids = array(5793);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 32823){ 
		
			$event_ids = array(5791, 5792, 5793);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		 
		
		//bora season pass 
		$bora_season_pass = array(31503, 31504);
		
		
		if (in_array($cpi, $bora_season_pass)){ 
		
			$event_ids = array(5557, 5558,5559,5560);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
	  
		//end of bora season pass
		
		
		//shine forth 
 		
		if($cpi == 31542){ 
		
			$event_ids = array(5570,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31543){ 
		
			$event_ids = array(5570,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 31533){ 
		
			$event_ids = array(5568,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31532){ 
		
			$event_ids = array(5568,5569);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31645){ 
		
			$event_ids = array(5568, 5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//end of shine forth season pass
		
		
		//PSL
		if($cpi == 31364){ 
		
			$event_ids = array(5539, 5540,5541);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//end of psl
		 
		
		//35387 price id GameCON,  = 6239 & 6241, 2tickets will be printed
		if($cpi == 35387){ 
		
			$event_ids = array(6239, 6241);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//price id 35464 = 6251&6252 golden disk
		if($cpi == 35464){ 
		
			$event_ids = array(6251, 6252);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 35543){ 
		
			$event_ids = array(6251, 6252);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		////PRICE ID 35951 = 2 TICKETS 6336 6338 EVENT ID FINTECH EVENT
		if($cpi == 35951){ 
		
			$event_ids = array(6339, 6338);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		////cosplay carnival 2018 36406 price id = 2 tickets event id 6406 & 6408
		if($cpi == 36406){ 
		
			$event_ids = array(6406, 6408);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		////BORACAY FEST 2018   36780 or 36787 = 6474 , 6475, 6476, 6477, 6478
		if($cpi == 36780){ 
		
			$event_ids = array(6474 , 6475, 6476, 6477, 6478);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 36787){ 
		
			$event_ids = array(6474 , 6475, 6476, 6477, 6478);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		// scandal asia tour 2018
		
		
		// 36916		6500 , 6498
		
		if($cpi == 36916){ 
		
			$event_ids = array(6500 , 6498);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		// deeper 36999	6513	6514	6515 
		if($cpi == 36999){ 
		
			$event_ids = array(6513 , 6514 , 6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//37000	6513	6514	6515
		if($cpi == 37000){ 
		
			$event_ids = array(6513 , 6514 , 6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//37011		6513	6514	6515
		if($cpi == 37011){ 
		
			$event_ids = array(6513 , 6514 , 6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//37001		6518	6514	6515
		// 37002	6518	6514	6515
		// 37003	6518	6514	6515
		// 37004	6518	6514	6515
		$deeper = array(37001, 37002 , 37003, 37004);
		
		
		if (in_array($cpi, $deeper)){ 
		
			$event_ids = array(6518,6514,6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		// jungle circuit 37212 , 6557 , 6558, 6559 , 6560 , 6561  
		if($cpi == 37212){ 
		
			$event_ids = array(6557 , 6558, 6559 , 6560 , 6561);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		// ANIME AND COSPLAY EXPO 2018 38504  - 6757,6756
		if($cpi == 38504){ 
		
			$event_ids = array(6757,6756);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		  
		//Event Name: COSPLAY MANIA 2018 *SEPT 29-30 38541 6762, 6764  
		if($cpi == 38541){ 
		
			$event_ids = array(6762, 6764);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		  
		//Event Name: COSPLAY MANIA 2018 *SEPT 29-30 38552  6765, 6766
		if($cpi == 38552){ 
		
			$event_ids = array(6765, 6766);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		  
		 //Event Name: COSPLAY MANIA 2018 *SEPT 29-30 38553 6767, 6768
		if($cpi == 38553){ 
		
			$event_ids = array(6767, 6768);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		 //Event Name: COSPLAY MANIA 2019 *SEPT 28-29 
		if($cpi == 46056){ 
		
			$event_ids = array(7974, 7902);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//Event Name: CONQUERORS MANILA 2019
		$conq_prices = array(46708,46701,46700);
		if (in_array($cpi, $conq_prices)){ 
			$event_ids = array(8061, 8062);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		$conq_prices2 = array(46707,46704,46703,48534);
		if (in_array($cpi, $conq_prices2)){ 
			$event_ids = array(8062);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		
		//IMPACT Architecture
		
		//40392,40393,40396, 40398, 40400 , 40401 = 7118, 7119,7120


		$impact_prices = array(40392,40393,40396, 40398, 40400 , 40401, 42314);
					
		if (in_array($cpi, $impact_prices)){ 
		
			$event_ids = array(7118, 7119,7120);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		 
		//end if IMPACT Architecture
		
		if($cpi == 47537){ 
		
			$event_ids = array(7902);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		  
				
		////GNR P2P bus promo (ticket type) makati
		if($cti == 1270){ 
		
			$event_ids = array(6769, 6995);
			$loop = count($event_ids); 
			$season_pass = 1;
		}	
		
		if($cti == 1272){ 
		
			$event_ids = array(6769, 6995);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		// end of makati GNR promo
		
		////GNR P2P bus promo (ticket type) trinoma
		if($cti == 1271){ 
		
			$event_ids = array(6769,6996);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cti == 1273){ 
		
			$event_ids = array(6769,6996);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		
		//Event Name: toycon
		if($cpi == 57023){ 
		
			$event_ids = array(11144,11145,11146);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 57027){ 
		
			$event_ids = array(11143,11145,11146);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//buldog
		if($cpi == 57347){ 
		
			$event_ids = array(11203,11204);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//esports
		if($cpi == 59092){ 
		
			$event_ids = array(11505,11506);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//esports
		if($cpi == 59093){ 
		
			$event_ids = array(11499,11500,11501);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		 

		if (in_array($cpi, [58682,58686,59141,58683,58687,58680,58688,58684,58685])){ 
		
			$event_ids = array(11438,11439);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		 
		
		
		
		
		
		//end of trinoma gnr promo
		$gen_id = array(); 
		for ($x = 0; $x <= $loop-1; $x++) {
		   
			if($season_pass == 1){ 
				$eid = $event_ids[$x]; 
				
				
			}else{
				$eid = $event_id;
			}
			
			 
			   
				list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
				$data["layout"] = $layout;
				$data["bgimage"] = $bgimage;
	
				
				// empty array of logo (not to be used for new ticket layout)
				$logo1 = array();

				$event = $this->events->get($event_id);
				if(is_object($event)) {
					$eventcode = $event->event_code;
				}
				
				$payments = $this->payments->get_payments($transaction_id);
					
				if(count($payments) > 1){
						
						$payment_type = 'Multi';
					}elseif(count($payments) == 0){
						
						$payment_type = '';
						
					}else{
						
						$payment_type = $payments[0]->payment_type_code;
					}
					
				$type = "paid";
				$ticketlist = $this->ticket_generator->get_paid_tickets_for_printing($transaction_id);
				
					
				
				$transaction = $this->transactions->get($transaction_id);
				if ($transaction->transaction_user_id == $this->config->item('online_seller_id')) {
					$isweb = 'WEB';
				}
				if ($ticket_count == count($ticketlist)) {
					// ticket count verified, please proceed to next step
				} else {
					// count mismatch
					show_404();
				}
					
				$current_price = '';			
				$current_ticket_type = '';			
				foreach($ticketlist as $tix) {
					
				
					// serial number
					$serial = 1;
					$serial_number = $this->prices_model->get_serial_number($tix->ticket_price_id);
					
					// per ticket price (discount aapplied)
					$ticket_price = 0;
					if ($tix->ticket_type_discount_type == 'Amount')
					{
						$ticket_price = ceil($tix->price_price - $tix->ticket_type_discount);
					}
					elseif ($tix->ticket_type_discount_type == 'Percentage')
					{
						$ticket_price= ceil($tix->price_price - (($tix->price_price * $tix->ticket_type_discount)/100));
					}

					// acknowledgement number
					if ($tix->ticket_type_discount_type == 'Percentage' and $tix->ticket_type_discount == 100)
					{
						$receipt_number = 'COMPLIMENTARY';
					}
					else
					{
						if ($tix->ticket_acknowledgment_receipt > 0) { 
							$receipt_number = $tix->ticket_acknowledgment_receipt;
						}
						else {
							// get receipt number
							$receipt_number = $this->branches->get_last_receipt_number($tix->ticket_branch_id);
							
							// update transactions table
							$this->tickets->update_acknowledgment_receipt($tix->ticket_id, $receipt_number);
						}
					}

					$tix_info[$tix->ticket_id] = array (
						"tid" => $tix->ticket_id,
						"evc" => strtoupper($eventcode),
						"serial" => $serial_number,
						"secname" => $tix->section_name,
						"row" => $tix->ticket_row,
						"seat" => $tix->ticket_seat,
						"ttcode" => $tix->ticket_type_code,
						"paytype" => strtoupper($payment_type),
						"price" => $ticket_price,
						"termcode" => $tix->terminal_code,
						"printer" => strtoupper($tix->username),
						"arnum" => $receipt_number,
						"eid" => sprintf('%06s', $tix->event_id),
						// "bc_prefix" => sprintf('%04s', $tix->sm_prefix),
						"bc_prefix" => sprintf('%04s', $tix->sm_prefix_alt),
						"bc_access" => sprintf('%04s', $tix->sm_code),
					);
					
					$data["branch"] = array(
							'city' => strtoupper($tix->branch_city),
							'address' => strtoupper($tix->branch_address),
							'tin' => $tix->branch_tin,
						);

						
					$price_id = $tix->price_id;
					$ticket_type_id = $tix->ticket_type_id;
					
					 
					$price_ids = array(25500,25497,25505);
					
					if (in_array($price_id, $price_ids)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4577;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}

					
				 
					$dreamplay_vip = array(27280, 27281, 27284, 27285, 27288, 27289,27107,27115,27114,27118,27121,27124, 27135, 27136, 27139, 27140, 27143, 27144,27218,27217,27222,27221,27225,27226,27229,27230);
					if (in_array($price_id, $dreamplay_vip)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4656;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//CHECK IF IT HAS ACTIVE CUSTOM PRICE LAYOUT (JC 1-13-2023)
					$price_layout_status = $this->price_layout->check_layout_by_price($price_id);

					//IF IT HAS ACTIVE CUSTOM LAYOUT
					if(!$price_layout_status){
						if($current_price != $price_id){
							$current_price = $price_id;		
							$eid = $price_layout_status->event_id;
							 
							list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
							$data["layout"] = $layout;
							$data["bgimage"] = $bgimage;	
						}
					}
					//END
										
					//raymond was here
					if($price_id == 56281){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10983;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56282){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10984;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56283){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10985;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56284){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10986;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56285){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10987;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56286){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10988;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56287){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10989;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56288){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10990;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56289){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10991;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56292){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10992;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56293){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10993;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56294){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10994;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56295){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10995;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56296){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10996;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56297){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10997;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56298){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10998;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56299){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 10999;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56300){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11000;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56279){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11001;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56280){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11002;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56290){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11003;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56291){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11004;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56301){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11005;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56302){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11006;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					} 
					 

					if($price_id == 56119){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11007; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					  

					if($price_id == 56120){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11008; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					   
					  

					if($price_id == 56121){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11009; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					   
					 
					 

					if($price_id == 56122){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11010; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					   

					if($price_id == 56123){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11011; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					  
					 

					if($price_id == 56124){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11012; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					  
					 
					if($price_id == 56125){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11013; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					  
					 
					 

					if($price_id == 56126){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11014; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					 

					if($price_id == 56127){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11015; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 

					if($price_id == 56266){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11016; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					  

					if($price_id == 56267){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11017; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					 

					if($price_id == 56268){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11018; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					 
					 

					if($price_id == 56269){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11019; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					 
					 

					if($price_id == 56270){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11020; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					 

					if($price_id == 56271){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11021; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					  

					if($price_id == 56272){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11022; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 

					if($price_id == 56303){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11025; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 

					if($price_id == 56304){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11026; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					 

					if($price_id == 56117){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11027; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56118){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11028; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						

					if($price_id == 56264){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11029; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						

					if($price_id == 56265){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11030; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						

					if($price_id == 56275){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11031; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						
					if($price_id == 56276){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11032; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						
					if($price_id == 56277){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11033; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						

					if($price_id == 56278){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11034; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56273){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11023; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						
					if($price_id == 56274){ 
										 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11024; 
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

						
					if($price_id == 56680){ 
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11078;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56681){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11079;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56682){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11080;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56683){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11081;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56684){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11078;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56685){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11079;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 56686){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11080;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}


					if($price_id == 56687){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11081;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(56933,56934,56935))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11122;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					if(in_array($price_id, array(56988,56989,56990))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11133;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					//toycon
					if($price_id == 57020){ 
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11144;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 57021){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11145;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 57022){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11146;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					
					 
					if(in_array($price_id, array(57319,57322))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11194;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57320,57323))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11195;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57321,57324))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11196;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57328,57325))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11197;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57329,57326))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11198;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57330,57327))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11199;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					//buldog
					if($price_id == 57351){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11203;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if($price_id == 57352){ 
											 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11204;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}

					if(in_array($price_id, array(57711,57712))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11279;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57709,57710))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11280;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					
					if(in_array($price_id, array(57713,57714))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11281;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57849,57850))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11304;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(57851,57852))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11305;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(58599))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11430;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(58600))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11431;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					
					if(in_array($price_id, array(58597))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11429;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					if(in_array($price_id, array(58598))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11432;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					 if(in_array($price_id, array(58897))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11466;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					if(in_array($price_id, array(58898))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11467;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					if(in_array($price_id, array(58948))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11479;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					//59173,59169,59170 will print event id 11515
					 if(in_array($price_id, array(59173,59169,59170))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11515;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					// price id 59115,59116 = 11600 eventid
 					 if(in_array($price_id, array(59115,59116))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11600;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					 // 59821 Price id will print 11632 eventid ugly duckling event
 					if(in_array($price_id, array(59821))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11632;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					 
					
					 // 59854 priceid will print eventid  11633
 					if(in_array($price_id, array(59854))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11633;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					//59855 priceid will print eventid  11634
 					if(in_array($price_id, array(59855))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11634;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					//PRICE ID 59934 WILL PRINT EVENT ID 11656
 					if(in_array($price_id, array(59934))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11656;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					//PRICE ID 59935 WILL PRINT EVENT ID 11657
 					if(in_array($price_id, array(59935))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11657;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					//PRICE ID 59936 WILL PRINT EVENT ID 11658
 					if(in_array($price_id, array(59936))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11658;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					
					//60366 will print event id 11718 BOBAPALOOZA
 					if(in_array($price_id, array(60366))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11718;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					
					//price id 60407 will print event id 11730
 					if(in_array($price_id, array(60407))){
 						 
						if($current_price != $price_id){
						$current_price = $price_id;		
						$eid = 11730;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					}
					
					
					 
					
					
					//end of dynamic layout
					
					
					
					
					 
					
				}
				
				$data["transaction"] = array(
					"id" => $transaction->transaction_id,
					"uid" => $transaction->transaction_user_id,
					"datetime" => $transaction->transaction_date,
					"tickets" => $tix_info,
				);

				//for special event
				$data['price_id'] = $price_id;
				$data['event_id'] = $event_id;
				
				// $xmltext = $this->load->view("generator_xml_dynamic_rev", $data, true);
				 
				//HARRY STYLES 4137
				if($event_id == 1){
					$xmltext = $this->load->view("generator_xml_dynamic_resized_288x216-C_new", $data, true);
				}elseif($event_id == 8703){ //TP- PLDT TOWNHALL
					
					$xmltext = $this->load->view("generator_xml_dynamic_no_seat", $data, true);
					
				}
				// elseif($eid == 8704){ //u2
					
					// $xmltext = $this->load->view("generator_xml_dynamic_u2", $data, true);
					
				// }
				else{
					$xmltext = $this->load->view($this->viewfile, $data, true);
				}	// $xmltext = 'test';
 	
				 
				
			
			
			  // echo '<pre>';
					// print_r(array_values($tix_info));
					// echo '</pre><br>';
				
				
				// echo '<pre>';
				// print_r( $tix_info);
				// echo '</pre>';
				// echo '<br><br><br><br><br>';
				
				// echo $xmltext . '<br><br><br><br>';
				
				$valid = false;
				$insert_id = 0;
				$yearmonth = date('ym');
				$__isql = "";
			
				if (!empty($xmltext)) {
					$fields = array(
						'xml_yearmonth' => $yearmonth,
						'xml_content' => $xmltext,
						'xml_trans_id' => $transaction_id,
					);
					
					// build insert SQL
					$__isql = $this->db->insert_string("generator", $fields);
					$valid = $this->db->simple_query($__isql);
					$insert_id = $this->db->insert_id();
					
					$gen_id[] = $insert_id;					
						
					
				}

				
 			}	 
			
			$insert_id = implode("-",$gen_id);
		
			// die();
		
		if (($valid) && ($insert_id != '')) {
			if ($online_claim) {
				redirect("/transactions/print_online/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id");
			} else {
				redirect("/transactions/done_rev/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id/");
			}
			// echo anchor("/printer/db2xml2pdf/$yearmonth/$insert_id","PDF Display - /printer/db2xml2pdf/$yearmonth/$insert_id","target=_blank");
		} else {
			show_404();
			// echo $__isql;
		}
		
		

	}
	
 
}