<?php

class Terminals extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('terminals/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Account','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Terminals';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		// get all terminals
		$data['terminals'] = $this->terminals->get_terminals();
		
		$this->load->view('terminals_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Terminal';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
			
		$config = array(
			array(
				'field'   => 'terminal_code',
				'label'   => 'Code',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[10]'
			),
			array(
				'field'   => 'terminal_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'terminal_location',
				'label'   => 'Location',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
			
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('terminals_add', $data);
		}
		else
		{
			$this->terminals->add();
			$this->session->set_flashdata('message', assemble_message('Terminal has been successfully added'));
			redirect('terminals/listing');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($terminal_id = FALSE)
	{
		if (!$terminal_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Terminal';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Finance'));
	
		// get terminals
		$data['terminal'] = $this->terminals->get($terminal_id);
		
		// display the page
		$this->load->view('terminals_view', $data);
	}		
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($terminal_id = FALSE)
	{
		if (! $terminal_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Terminal';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
			
		$config = array(
			array(
				'field'   => 'branch_id',
				'label'   => 'Branch',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[10]'
			),
			array(
				'field'   => 'terminal_code',
				'label'   => 'Code',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[10]'
			),
			array(
				'field'   => 'terminal_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'terminal_location',
				'label'   => 'Location',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
			// get events
			$data['branches'] = $this->branches->get_branches_dropdown();	
		
		if ($this->form_validation->run() == FALSE)
		{
			// get terminal's data
			$data['terminal'] = $this->terminals->get($terminal_id);
			
			// display the page
			$this->load->view('terminals_edit', $data);
		}
		else
		{
			$this->terminals->edit($terminal_id);
			$this->session->set_flashdata('message', assemble_message('Terminal has been successfully modified'));
			redirect('terminals/listing');
		}
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($terminal_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Terminal');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Account'));
		
		$this->terminals->delete($terminal_id);
		$this->session->set_flashdata('message', assemble_message('Terminal has been successfully deleted'));
		redirect('terminals/listing/');
	}		
		
}

/* End of file terminals.php */
/* Location: ./application/controllers/terminals.php */	