<?php

class Sections extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('sections/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Seatplans';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all sections
		$data['sections'] = $this->sections->get_sections();
				
		//get venue name
		//$data['venues'] = $this->venues->get_name($venue_id);
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->load->view('sections_listing', $data);
	}

	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($section_id = FALSE)
	{
		if (! $section_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'View Seatplan';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller','Event','Reservation','Reservation-Admin'));
			
		// display the page
		$this->load->view('sections_view', $data);
	}		
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add($seatplan_id = false)
	{
		if (!$seatplan_id) show_404();
		if ($this->session->userdata('cei'))
		{
			$event_id = $this->session->userdata('cei');
			
			// get event
			$data['event'] = $this->events->get($event_id);
		}
		
		// prepare data for the template
		$data['page_title'] = 'Add Section';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$this->form_validation->set_rules('section_code', 'Code', 'trim|required|strip_tags|max_length[15]');
		$this->form_validation->set_rules('section_name', 'Name', 'trim|required|strip_tags|max_length[80]');
		$this->form_validation->set_rules('section_type', 'Type', 'trim|required|strip_tags|max_length[20]');
		$this->form_validation->set_rules('section_capacity', 'Capacity', 'trim|required|strip_tags|max_length[5]|integer');
		$this->form_validation->set_rules('section_stage_location', 'Stage Location', 'trim|required|strip_tags|max_length[5]');
		$this->form_validation->set_rules('section_coords', 'Section Coordinates', 'trim|strip_tags');
	
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == true)
		{
			$this->sections->add($seatplan_id);
			
			// redirect
			$this->session->set_flashdata('message', assemble_message('Section has been successfully added'));
			redirect('sections/add/'.$seatplan_id);
		}
		
		// get seatplan info
		$data['seatplan'] = $this->seatplans->get($seatplan_id);
		 
		// display the page
		$this->load->view('sections_add', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($section_id = false, $seatplan_id = false)
	{
		if (!$section_id or !$seatplan_id) show_404();
		if ($this->session->userdata('cei'))
		{
			$event_id = $this->session->userdata('cei');
			
			// get event
			$data['event'] = $this->events->get($event_id);
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Section';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$this->form_validation->set_rules('section_code', 'Code', 'trim|required|strip_tags|max_length[15]');
		$this->form_validation->set_rules('section_name', 'Name', 'trim|required|strip_tags|max_length[80]');
		$this->form_validation->set_rules('section_type', 'Type', 'trim|required|strip_tags|max_length[20]');
		$this->form_validation->set_rules('section_capacity', 'Capacity', 'trim|required|strip_tags|max_length[5]|integer');
		$this->form_validation->set_rules('section_available', 'Available', 'trim|strip_tags|max_length[5]|integer');
		$this->form_validation->set_rules('section_stage_location', 'Stage Location', 'trim|required|strip_tags|max_length[5]');
		$this->form_validation->set_rules('section_coords', 'Section Coordinates', 'trim|strip_tags');
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// get seatplan info
			$data['seatplan'] = $this->seatplans->get($seatplan_id);
			
			// get section info
			$data['section'] = $this->sections->get($section_id);
						
			// display the page
			$this->load->view('sections_edit', $data);
		}
		else
		{
			$this->sections->edit($section_id);
			
			// redirect
			$this->session->set_flashdata('message', assemble_message('Section has been successfully saved'));
			redirect('seatplans/view/'.$seatplan_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	function copy($section_id = false, $seatplan_id = false)
	{
		if (!$section_id or !$seatplan_id) show_404();

		// check user session
		$this->users->check_session(array('Admin','Super Admin'));
		
		// copy the section
		$new_section_id = $this->sections->copy_section($section_id);
		// redirect
		$this->session->set_userdata('cei', $new_section_id);
		$this->session->set_flashdata('message', assemble_message('Section has been successfully added'));
		redirect('seatplans/view/' . $seatplan_id);
		
	}
	
	
	/**
	 * edit_seats
	 *
	 * @access	public
	 */
	function edit_seats($section_id = false, $seatplan_id = false, $event_id = false)
	{
		if (!$section_id or !$seatplan_id) show_404();
		if ($this->session->userdata('cei'))
		{
			$event_id = $this->session->userdata('cei');
			
			// get event
			$data['event'] = $this->events->get($event_id);
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Seats';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		// get section info
		$section = $this->sections->get($section_id);
		
		
		if (!$section->section_seat_config)
		{
			redirect('sections/setup_seats/'.$section_id.'/'.$seatplan_id . '/' . $event_id);
		}
		
		$this->form_validation->set_rules('row_from', 'Row From', 'strtoupper|trim|required|strip_tags');
		$this->form_validation->set_rules('row_to', 'Row To', 'strtoupper|trim|required|strip_tags');
		$this->form_validation->set_rules('row_increment', 'Row Increment', 'trim|required|strip_tags|integer');
		$this->form_validation->set_rules('col_from', 'Seat From', 'trim|required|strip_tags');
		$this->form_validation->set_rules('col_to', 'Seat To', 'trim|required|strip_tags');
		$this->form_validation->set_rules('col_increment', 'Seat Increment', 'trim|required|strip_tags|integer');
		$this->form_validation->set_rules('row_aisles', 'Row Aisles', 'strtoupper|trim|strip_tags');
		$this->form_validation->set_rules('col_aisles', 'Col Aisles', 'trim|strip_tags');
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// data
		$data['seatplan_id'] = $seatplan_id;
		$data['section'] = $section;
		
		if ($this->form_validation->run() != FALSE)
		{
			if ($this->input->post('save'))
			{
				// save to db
				$this->sections->edit_seats($section_id);
			
				// redirect
				$this->session->set_flashdata('message', assemble_message('Seats has been successfully saved'));
				redirect('sections/edit_seats/'.$section_id.'/'.$seatplan_id);
			}
					
		}
			
		// display the page
		$this->load->view('sections_edit_seats', $data);
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * setup_seats
	 *
	 * @access	public
	 */
	function setup_seats($section_id = false, $seatplan_id = false, $event_id = false)
	{
		if (!$section_id or !$seatplan_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Setup Seats';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->form_validation->set_rules('row_from', 'Row From', 'trim|required|strip_tags');
		$this->form_validation->set_rules('row_to', 'Row To', 'trim|required|strip_tags');
		$this->form_validation->set_rules('row_increment', 'Row Increment', 'trim|required|strip_tags|integer');
		$this->form_validation->set_rules('col_from', 'Seat From', 'trim|required|strip_tags');
		$this->form_validation->set_rules('col_to', 'Seat To', 'trim|required|strip_tags');
		$this->form_validation->set_rules('col_increment', 'Seat Increment', 'trim|required|strip_tags|integer');
		$this->form_validation->set_rules('row_aisles', 'Row Aisles', 'trim|strip_tags');
		$this->form_validation->set_rules('col_aisles', 'Col Aisles', 'trim|strip_tags');
		//$this->form_validation->set_rules('seat_numbering', 'Seat Numbering', 'trim|strip_tags');
		
		$this->form_validation->set_error_delimiters('<p class="errors">', '</p>');
		
		if ($this->form_validation->run() != FALSE)
		{
			if ($this->input->post('save'))
			{
				// save to db
				$this->sections->edit_seats($section_id);
			
				// redirect
				$this->session->set_flashdata('message', assemble_message('Seats has been successfully saved'));
				redirect('seatplans/view/'.$seatplan_id);
			}
		}
		
		$data['seatplan_id'] = $seatplan_id;

		// get section info
		$data['section'] = $this->sections->get($section_id);
		
		
		$data['event'] = $this->events->get($event_id);
		
		// display the page
		$this->load->view('sections_setup_seats', $data);
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seat_names
	 *
	 * @access	public
	 */
	function edit_seat_names($section_id = false, $seatplan_id = false, $event_id = false)
	{
		if (!$section_id or !$seatplan_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Edit Seat Names';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		// get section info
		$section = $this->sections->get($section_id);
		
		
		if (!$section->section_seat_config)
		{
			redirect('sections/setup_seats/'.$section_id.'/'.$seatplan_id . '/' . $event_id);
		}
		
		$this->form_validation->set_rules('seat[]', 'Seat', 'trim|strip_tags');
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// data
		$data['seatplan_id'] = $seatplan_id;
		$data['section'] = $section;
		
		if ($this->form_validation->run() != FALSE)
		{
			// save to db
			$this->sections->edit_seat_names($section_id);
		
			// redirect
			$this->session->set_flashdata('message', assemble_message('Seats has been successfully saved'));
			redirect('sections/edit_seats/'.$section_id.'/'.$seatplan_id);
		}
			
		// display the page
		$this->load->view('sections_edit_seat_names', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seat_heads
	 *
	 * @access	public
	 */
	function edit_seat_heads($section_id = false, $seatplan_id = false, $event_id = false)
	{
		if (!$section_id or !$seatplan_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Edit Seat Heads';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		// get section info
		$section = $this->sections->get($section_id);
		
		
		if (!$section->section_seat_config)
		{
			redirect('sections/setup_seats/'.$section_id.'/'.$seatplan_id);
		}
		
		$this->form_validation->set_rules('seat[]', 'Seat', 'trim|strip_tags');
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// data
		$data['seatplan_id'] = $seatplan_id;
		$data['section'] = $section;
		
		if ($this->form_validation->run() != FALSE)
		{
		
		
			// save to db
			$this->sections->edit_seat_heads($section_id);
		
			// redirect
			$this->session->set_flashdata('message', assemble_message('Seat heads have been successfully saved'));
			redirect('sections/edit_seats/'.$section_id.'/'.$seatplan_id);
		}
			
		// display the page
		$this->load->view('sections_edit_seat_heads', $data);
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($section_id = false, $seatplan_id = false)
	{
		// log this
		$this->logs->add('Delete Section');
		
		if (!$section_id or !$seatplan_id)
		{
			show_404();
		}
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->sections->delete($section_id);
		$this->session->set_flashdata('message', assemble_message('Section has been successfully deleted'));
		redirect('seatplans/view/'.$seatplan_id);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_seat_heads
	 *
	 * @access	public
	 */
	function edit_seat_name_heads($section_id = false, $seatplan_id = false)
	{
		if (!$section_id or !$seatplan_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Edit Seat Heads';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		// get section info
		$section = $this->sections->get($section_id);
		
		if($this->input->post('save'))
		{
			// echo "<pre>";
			// print_r($this->input->post('seat'));
			// echo "</pre>";
			foreach ($this->input->post('seat') as $seat_row => $seat_cols)
			{
				foreach ($seat_cols as $seat_key => $seat_col)
				{	
					//echo $seat_key."<br/>";
					if ($seat_col)
					{
						$values = explode('|', $seat_col);
						$seat_config[$seat_row]['C'.$seat_key] = "$seat_row|C$seat_key|$seat_col";
					}
				}
			}
			$fields['section_seat_config'] = serialize($seat_config);
			$heads = array(
				'col_heads' => $this->input->post('col_heads'),
				'row_heads' => $this->input->post('row_heads'),
			);
			$fields['section_seat_heads'] = serialize($heads);
			// echo "<pre>";
				// print_r($fields);
			// echo "</pre>";
		}
		
		$this->form_validation->set_rules('seat[]', 'Seat', 'strtoupper|trim|strip_tags');
		$this->form_validation->set_rules('row_heads[]', 'Seat', 'strtoupper|trim|strip_tags');
		$this->form_validation->set_rules('col_heads[]', 'Seat', 'strtoupper|trim|strip_tags');
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// data
		
		$data['seatplan_id'] = $seatplan_id;
		$data['section'] = $section;
		if ($this->form_validation->run() != FALSE)
		{
			// save to db
			$this->sections->edit_seat_heads($section_id);
			$this->sections->edit_seat_names($section_id);
		
			// redirect
			$this->session->set_flashdata('message', assemble_message('Seat heads and names have been successfully saved'));
			redirect('sections/edit_seat_name_heads/'.$section_id.'/'.$seatplan_id);
		}
			
		// display the page
		$this->load->view('setions_edit_seat_name_heads', $data);
	}

	
	function getSectionsByPrice($price_id){
			
			
			$this->db->where('price_id', $price_id);
			$query = $this->db->get('prices');
			$sections = $query->row()->price_sections;
			$sections = unserialize($sections);
			// echo '<pre>';
			// print_r($sections);
			 // die();
			
			
			$this->db->where_in('section_id', $sections);
			$query = $this->db->get('sections');
			 $sections = $query->result(); 
			echo json_encode ($sections) ;
			// echo '<pre>';
			// print_r($sections);
			
			
			
			
		}
		
	 	function viewCustomerInfo($event_id,$price_id,$section_id,$row,$seat){
						
			$transaction_id = $this->sections->getCustomerInfo($event_id,$price_id,$section_id,$row,$seat);
			
			 
			 if($transaction_id==0){
				 echo 0;
			 }else{
			 
			 // echo '<pre>';
			$rows = array();
			foreach($transaction_id as $trans){
				$rows[] = $trans->ticket_transaction_id;
			}
			

			 $this->db->where_in('transaction_id', $rows);
			$query = $this->db->get('transactions');
			 $c_info = $query->result(); 
			
			 
			 $ids = join(',',$rows);  
			 // foreach($c_info as $cinfo){
			$query = $this->db->query('SELECT `tr`.`transaction_id`, `tr`.`transaction_status`, `c`.`customer_firstname` , `c`.`customer_lastname`, `c`.`customer_mobile`, `e`.`event_title`, `p`.`price_name`, `s`.`section_name`, `b`.`branch_name`,
			 `tr`.`transaction_date` FROM (`transactions` tr) JOIN `customers` c ON `c`.`customer_id` = `tr`.`transaction_customer_id` 
			, events e, sections s, branches b, prices p WHERE  `tr`.`transaction_id` IN ('.$ids.')  and `tr`.`transaction_status` IN ("paid","paid_online","done","reserved") and s.section_id = "'.$section_id.'"  and e.event_id = "'.$event_id.'" and p.price_id = "'.$price_id.'"  group by tr.transaction_id');
			
			$c_final =  $query->result(); 
				 
	
			echo json_encode ($c_final) ;

			 }
		}	 
		
		
		
}
	
	
/* End of file sections.php */
/* Location: ./application/controllers/sections.php */	
