<?php

class Secret extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->database('default');
		$this->load->model('users_model', 'users');
		$this->load->model('reports_model', 'reports');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('logs_model', 'logs');
		
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
	}
	 
		function get_username_by_mobile($mobile = false)
		{ 
		 
			$this->db->select('customer_username');
			$this->db->where('customer_mobile', $mobile);
			$query = $this->db->get('customers');
			$result = $query->row();
			if($result)
			echo $result->customer_username;
 
		}
		
		function get_username_by_email($email = false)
		{ 
		 
			$this->db->select('customer_username');
			$this->db->like('customer_email', $email);
			$query = $this->db->get('customers');
			$result = $query->row();
			
			if($result)
			echo $result->customer_username;
 
		}
		 
		function unselect_seat($section = false, $row = false, $seat = false)
		{ 
		 
			$this->db->where('ticket_section_id',$section);
			$this->db->where('ticket_row',$row);
			$this->db->where('ticket_seat',$seat);
			$this->db->where('ticket_status','selected');
			$this->db->set('ticket_status', 'unselected');
			$this->db->update('tickets');
			
			if($this->db->affected_rows() > 0) { 
				echo 'success';
			}else{
				echo 'failed';
			}
		
		}
		
		function reset_eplus($ticket_id = false)
		{ 
		 
			$this->db->where('ticket_used_ticket_id',$ticket_id);
			$this->db->delete('tickets_used'); 
			
			if($this->db->affected_rows() > 0) { 
				echo 'success';
			}else{
				echo 'failed';
			}
		
		}
 
		function barcode($eventID = false){
		
		if(!$eventID){
		
		die('no event id entered');
		}
		
		//2ND ASIAN NETWORKERS 
		$this->db->select('ticket_id');
		$this->db->where('ticket_event_id', $eventID);
		// $this->db->where('ticket_type_id', '2');
		$this->db->where('ticket_status', 'done');
		$this->db->limit(100);
 		$ress = $this->db->get('tickets ti')->result_array();
		
		// $res = array_map('current', $res[0]);
		
		$res = array();

		foreach ($ress as $key => $value){
			$res[$key] = $value['ticket_id'];
		}
		
	 
		
		$this->db->where_in('sm.sm_ticket_id', $res);
 		$this->db->join('sm_barcode sm', 'sm.sm_ticket_id = ti.ticket_id','left');
		$result = $this->db->get('tickets ti')->result();
		
		
		
		$this->load->helper('file');

		$header = 'barcodes.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		 
		$separator = ';'; 
		
		foreach ($result as $x){
			
			$eid = $x->ticket_event_id;
			$bc_prefix = $x->sm_prefix_alt;
			$sm_code = $x->sm_code;
		
		
			$barcode_hash = sprintf('%06s',$eid) . sprintf('%04s',$bc_prefix) . sprintf('%06s',$sm_code);
			echo $x->ticket_id . $separator . $barcode_hash . PHP_EOL;
		  
		}
		
		
		 
		
		// $barcode_hash = sprintf('%06s',$eid) . sprintf('%04s',$bc_prefix) . sprintf('%06s',$sm_code);
		// echo $barcode_hash;
		
		
		
		}
		
		function mark_as_done($transID = false){
		
			$status = array('paid_online');
			
			if($transID){
				
				$this->db->where('transaction_id', $transID);
				$this->db->where_in('transaction_status', $status);
				$this->db->update('transactions', array('transaction_status' => 'done')); 
				
				$trans_affected_rows = $this->db->affected_rows();
				
				
				$this->db->where('ticket_transaction_id', $transID);
				$this->db->where_in('ticket_status', $status);
				$this->db->update('tickets', array('ticket_status' => 'done')); 
				 
				$ticket_affected_rows = $this->db->affected_rows();
				 
				if($trans_affected_rows > 0  || $ticket_affected_rows > 0) { 
				
					echo 'Update successful. Kindly double check transaction and ticket status.';
				}else{
					echo 'Cant find the transaction. Kindly double check the transaction id provided.' ;
				 
				}
				
			
			}else{
			
				echo 'Kindly provide transaction ID';  
			}
			
			 
			 
		
		}
		
		//mark ticket as used --close up event
		function mark_as_used2(){
		
		
		$query = $this->db->query("
		
		select t.ticket_id from tickets t 
		where t.ticket_transaction_id in 
		( 
		593588,
		593594,
		593602,
		593607,
		593613,
		593688,
		593698,
		593703,
		593704,
		593713,
		593880,
		594016
		)
		");
		
		// echo $query->num_rows();
		// die();
		
		$result = $query->result();
		
		// echo '<pre>';
		// print_r($result);
		// echo '</pre>';
		
			ini_set('max_execution_time', 300);
			
			foreach($result as $x){
			
			 
			$fields = array(
				'used_entry_datetime'		=> "2013-12-12 10:05:49",
				'used_ticket_id'			=> $x->ticket_id,
				'used_last_date'			=> "2013-12-12 10:05:49",
					
			);

			// insert to db
			$this->db->set($fields);
			$this->db->insert('used_tickets');
						
			
			}
		
		}
		
		function mark_as_used($ticket_id = false)
		{
			// prepare data for the template
			$data['page_title'] = 'Mark As Used';
			$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
				
			 
			$config = array(
				array(
					'field'   => 'ticket_id',
					'label'   => 'Ticket ID',
					'rules'   => 'trim|required|strip_tags|min_length[7]|max_length[15]'
				),
				array(
					'field'   => 'remark',
					'label'   => 'Remark',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[200]'
				),
			);
			
			$this->form_validation->set_rules($config); 
			
			$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
  
			if ($this->form_validation->run() == FALSE)
			{
				// display the page
				$data['ticket_id'] = $ticket_id;
				$this->load->view('mark_as_used', $data);
			}
			else
			{
				echo 'ok';
				
			  
				$fields = array(
					'used_entry_datetime'		=>  date("Y-m-d H:i:s"),
					'used_ticket_id'			=> $this->input->post('ticket_id'),
					'used_last_date'			=>  date("Y-m-d H:i:s"),
					'used_remark'			=> $this->input->post('remark'),
					
				);

				// insert to db
				$this->db->set($fields);
				$this->db->insert('used_tickets');
					
				 
				$this->session->set_flashdata('message', assemble_message('Ticket has been tagged as used.'));
				redirect('/'); 
				
				
			}
		}

		function change_ticket_type_by_ticket_id(){
	
	
		$data['page_title'] = 'Change Ticket Type';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		// log this
		$this->logs->add($data['page_title']);
		$config = array(
			array(
				'field'   => 'ticket_id',
				'label'   => 'Ticket ID',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'ticket_type',
				'label'   => 'Ticket Type',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown(); 
			$this->load->view('secret_change_ticket_type_by_ticket',$data);
		}
		else
		{
			// echo 'ok';
			
		   
			$this->db->where('ticket_id',$this->input->post('ticket_id'));
			$this->db->set('ticket_type_id', $this->input->post('ticket_type'));
			$this->db->update('tickets');
				
			 
			$this->session->set_flashdata('message', assemble_message(''. $this->db->affected_rows() .' ticket has been successfully updated.'));
			redirect('/'); 
		 
		}
	
	  
	
	}
	
		function change_ticket_type_by_trans_id(){
	
	
		$data['page_title'] = 'Change Ticket Type';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$this->logs->add($data['page_title']);
		$config = array(
			array(
				'field'   => 'trans_id',
				'label'   => 'Transaction ID',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'ticket_type',
				'label'   => 'Ticket Type',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown(); 
			$this->load->view('secret_change_ticket_type_by_trans',$data);
		}
		else
		{
			// echo 'ok';
			
		   
			$this->db->where('ticket_transaction_id',$this->input->post('trans_id'));
			$this->db->set('ticket_type_id', $this->input->post('ticket_type'));
			$this->db->update('tickets');
				
			 
			$this->session->set_flashdata('message', assemble_message(''. $this->db->affected_rows() .' ticket/s has been successfully updated.'));
			redirect('/'); 
		 
		}
	
	  
	
	}
	
		function DIM_SM_TICKETS(){
		
		$cap = array();
		$pot = array();
		
		
		$this->load->helper('file');

		$header = 'DIM_SM_TICKETS_DAILY_SALES_YYYYMMDD.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		 
		$separator = ';'; 
		
		
	 
		 $query = $this->db->query("
		
		select  
		e.event_id as EVENT_ID,
		e.event_title as EVENT_DESC,
		e.event_type as EVENT_TYPE,
		e.event_date_time as DATE_TIME,
		v.venue_name as VENUE_DESC,
		p.promoter_name as PROMOTER_DESC 
		from

		events e

		inner join venues v on v.venue_id = e.event_venue_id
		inner join promoters p on p.promoter_id = e.event_promoter_id
		
		where e.event_id in (10,158,688,839,840,1332,1333,1428,1793,1933,2079)
		");
		
		// echo '<pre>';
		// print_r($query->result());
		// echo '</pre>';
		 
		$events = $query->result();
		
		foreach($events as $x){
		
			 
						$this->db->select('
					pr.price_id
					, pr.price_name
					, pr.price_price
					, pr.price_sections
					, pr.price_event_id
					');
				$this->db->where_in('pr.price_event_id', $x->EVENT_ID);
				$this->db->order_by('pr.price_price', 'desc');
				$price_types = $this->db->get('prices pr')->result();
					
				$arrsubsection = array();
			foreach($price_types as $row) {
				$subsection = unserialize($row->price_sections);
				$row->price_sections = $subsection;	
				$arrsubsection = array_merge($arrsubsection, $subsection);
			}
		// SECTION LIST
			$this->db->select('
				s.section_id
				, s.section_capacity
				, s.section_available
				, s.section_type
			');
			$this->db->where_in('s.section_id', $arrsubsection);
			$query = $this->db->get('sections s')->result();
			
			//echo "<!-- SECTION LIST \n";
			//echo $this->db->last_query();
			//echo "\n-->\n";
			
			foreach($query as $section) {
				$data_sectionlist[$section->section_id][0] = $section->section_capacity;
				
				if (strtolower($section->section_type) == "reserved") { 
					$data_sectionlist[$section->section_id][1] = $section->section_available;
				} else {
					$data_sectionlist[$section->section_id][1] = $section->section_capacity;
				}
				
				$data_sectionlist[$section->section_id][2] = 0; // taken/used seats
				// identify section type
				$data_sectionlist[$section->section_id][3] = $section->section_type;
			}
			$this->db->select('ticket_section_id, count(ticket_id) as taken');
			$this->db->where_in('ticket_section_id', $arrsubsection);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$this->db->group_by('ticket_section_id');
			$query = $this->db->get('tickets')->result();
			
			// echo $this->db->last_query();
			foreach($query as $section) {
				$tmp_section_type = $data_sectionlist[$section->ticket_section_id][3];
				if (strtolower($tmp_section_type) == "reserved") { 
					// no need to recompute availability
				} else {
					$data_sectionlist[$section->ticket_section_id][1] -= $section->taken;
				}
				$data_sectionlist[$section->ticket_section_id][2] = $section->taken;
			}
			  
				$totalcapacity = 0;
				$totalavailability = 0;
				$totalpotential = 0;

				foreach ($price_types as $ptype)
				{
					$pricename = $ptype->price_name;
					$price = $ptype->price_price;
					$pid = "$pricename ($price)";
					$pricesections = $ptype->price_sections;
					
					$pricelist[$pid] = array($pricename, $price);

					if (!isset($seat_capacity[$pid])) {
						$seat_capacity[$pid] = 0;
					}
					
					if (!isset($availability[$pid])) {
						$availability[$pid] = 0;
					}
					
					if (!isset($potential[$pid])) {
						$potential[$pid] = 0;
					}
					
					foreach ($pricesections as $sid) {	

						if (!isset($data_sectionlist[$sid][0])) {
						$capacity = 0;
						$availability[$pid] += 0;
						}else{ 
						$capacity = $data_sectionlist[$sid][0];
						$availability[$pid] += $data_sectionlist[$sid][1]; 
						}
						
						
						$seat_capacity[$pid] += $capacity;
						$potential[$pid] += ($capacity * $price);
					}
				}

				$strHeaderHTML = '';
				$price_type_count = 0;

				$tmp_grandT = 0;
				$tmp_resT = 0;
				foreach($pricelist as $k=>$v) {
				
					$pid = $k;
					$countG = 0;
					$countR = 0;
					
				
					if (isset($data_tixcountgrid[$pid])) {
						foreach($data_tixcountgrid[$pid] as $grouparr) {
							foreach($grouparr as $temparr) {
								if (is_array($temparr)) {
									$countG += count($temparr);
								}
							}
						}
					}
					
					$tmp_grand = $countG;
					$tmp_grandT += $countG;
					if (!isset($reservedcount[$pid])) {
						$countR = 0;
					}
					else {
						$countR = count($reservedcount[$pid]);
					}

					$tmp_res = $countR;
					$tmp_resT += $countR;

					$tmp_cap = $seat_capacity[$k];
					// $tmp_ava = number_format($availability[$k]);
					$tmp_pot = number_format($potential[$k]);

					$tmp_ava = $tmp_cap - $tmp_grand - $tmp_res;
					
					$strHeaderHTML .= "<th colspan=3 class=center width=180>
						$v[0] ($tmp_ava) <br>
						Capacity($tmp_cap) / Potential ($tmp_pot)
					</th>";
				
					$price_type_count++;
					
					


				
				
				}

				$scapacity['total'] = array_sum($seat_capacity);
				$availability['total'] = array_sum($availability);
				$potential['total'] = array_sum($potential);
				
				$tmp_cap =$scapacity['total'];
				// $tmp_ava = number_format($availability['total']);
				$tmp_pot = number_format($potential['total']);
				
				$tmp_ava = $tmp_cap - $tmp_grandT - $tmp_resT;
			  
			  
			  
				 $cap[$x->EVENT_ID] = $tmp_cap;
				 $pot[$x->EVENT_ID] = $tmp_pot;
			  
			  
		}
		
		// echo $pot[2141];
		
		echo "EVENT_ID $separator";
		echo "EVENT_DESC $separator";
		echo "EVENT_TYPE $separator";
		echo "DATE_TIME $separator";
		echo "VENUE_DESC $separator";
		echo "PROMOTER_DESC $separator";
		echo "SEAT_CAP $separator";
		echo PHP_EOL;
		
		foreach($events as $x){
		
		

		
		$venue = str_replace(",","",$x->VENUE_DESC);
		$promoter = str_replace(",","",$x->PROMOTER_DESC);
		$capacity = str_replace(",","",$cap[$x->EVENT_ID]); 
		
		echo "$x->EVENT_ID $separator";
		echo "$x->EVENT_DESC $separator";
		echo "$x->EVENT_TYPE $separator";
		echo "$x->DATE_TIME $separator";
		echo "$venue $separator";
		echo "$promoter $separator";
		echo "$capacity $separator";
		echo PHP_EOL;
	 
		}
		
	}

		function FCT_SM_TICKETS($eventgroup = false, $branchkey = "", $dl = false){
		
			// iconv_set_encoding("internal_encoding", "UCS-2LE");
			// iconv_set_encoding("output_encoding", "UCS-2LE");

			$data['page_title'] = 'FCT_SM_TICKETS_DAILY_SALES_YYYYMMDD';
	 
			$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
			 
			// check user session
			$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
				
	 
		 
			$this->load->helper('file');
			$datet = date('Y-m-d');
				
			$header = "FCT_SM_TICKETS_DAILY_SALES [$datet].csv";
	 
			$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				
			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		 
	 

					
			$this->load->view('fct_sm_ticket_daily_sales',$data);
				 

				 
		 
		
		}
		
		function clear_user_sessions(){
		
		$this->db->query("delete  from user_sessions");
		
		
		}
		
		
		function one_report()
		{
	
		 
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Manager', 'Finance'));
		
		 
		// prepare data for the template
		$data['page_title'] = 'One D t';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
	 
	 
		$ticket = $this->input->post('ticket');
		$tempo = $this->input->post('tempo');
		$one = $this->input->post('one');
		

		if($ticket)
		$this->db->where('eplus_card_ticket_id',$ticket);
	
		if($tempo)
		$this->db->where('eplus_card_printed_card_num',$tempo);
	
	
		if($one)
		$this->db->where('eplus_card_printed_card_num_new',$one);
	
	
			$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id','left');
			$this->db->join('sections s', 's.section_id = t.ticket_section_id','left');
		
		if($tempo){
			
			$this->db->join('users u', 'u.user_id = e.eplus_card_user_id','left');
			$this->db->join('branches b', 'b.branch_id = u.user_branch_id','left');

		}else{
		 
			$this->db->join('users u', 'u.user_id = e.eplus_card_claim_user_id','left');
			$this->db->join('branches b', 'b.branch_id = u.user_branch_id','left');
 
		} 
		
		
		
		$this->db->limit(10);
		$this->db->order_by('e.eplus_card_id','desc');
		$q = $this->db->get('eplus_cards e');
		$data['eplus'] = $q->result();
 
 		$this->load->view('oned_listing',$data);
 		
	 
	}	
	
	
		function change_password($username = false, $password = false)
		{
		
		
			if($username == '' || $password == ''){
			
				die('invalid parameters');
			}
		
			$fields = array(
				'customer_password'				=> $this->prep_password($password),
 			);
		
			// update db
			$this->db->where('customer_username', $username);
			$this->db->update('customers', $fields);
			
			if($this->db->affected_rows() > 0){
			
				echo 'success';
			}else{
				echo 'failed'; 
			}
			
		}	
		
		
		function prep_password($password)
		{
			return sha1($this->config->item('encryption_key').$password);
		}
	
		
		function eplus_report()
		{
	
		 
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Manager', 'Finance'));
		
		 
		// prepare data for the template
		$data['page_title'] = 'Eplus List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
	 
	 
		$ticket = $this->input->post('ticket');
		$card = $this->input->post('card');
		// $one = $this->input->post('one');
		

		if($ticket)
		$this->db->where('eplus_card_ticket_id',$ticket);
	
		if($card)
		$this->db->where('eplus_card_printed_card_num',$card);
	
	 
	
			$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id','left');
			$this->db->join('sections s', 's.section_id = t.ticket_section_id','left');
		
		 
			
			$this->db->join('users u', 'u.user_id = e.eplus_card_user_id','left');
			$this->db->join('branches b', 'b.branch_id = u.user_branch_id','left');

		// $this->db->where('t.ticket_event_id',5157);
		 
		
		
		
		$this->db->limit(10);
		$this->db->order_by('e.eplus_card_id','desc');
		$q = $this->db->get('eplus_cards e');
		$data['eplus'] = $q->result();
 
 		$this->load->view('iptl_listing',$data);
 		
	 
	}	
	
	
		function get_transaction($section = false, $row = false , $seat = false){
		
			$sql = "select ticket_transaction_id from tickets t where t.ticket_section_id = ? and t.ticket_row = ? and t.ticket_seat = ?
			and t.ticket_status in ('done','paid','paid_online','reserved')";  
			$q = $this->db->query($sql, array($section, $row, $seat));
			$result = $q->row();
			$transID = $result->ticket_transaction_id;
			
			// die($transID);
			redirect('transactions/view/' . $transID);
		}

		
		function clear_code($event = false ,$code = false){
			
			if(!$code){
				
				die('No Code Provided');
			}
			if(!$event){
				
				die('No Event id Provided');
			}
			
			$sql = "update qrcode q set q.qr_transaction_id = 0, q.qr_user_id = NULL , q.qr_ticket_id = NULL , q.qr_status = NULL, q.qr_datetime = NULL where q.qr_qrcode = ? and q.qr_event_id = ?"; 
			$this->db->query($sql, array($code , $event));
			echo 'Cleared successfully';
			
		}
		
		function reset_harry($transID = false){
			
			if(!$transID){
				
				die('No Transaction ID Provided');
			}
			
			$sql = "delete from claims where claim_transaction_id = ?"; 
			$this->db->query($sql, array($transID));
			echo 'Cleared successfully';
			
		}
		
		function generate_ticket_types_cron($limit = false){

			// $event_id = 4447;

			if(!$limit){

				echo 'Failed';
				die();
			}
			
			
				
			//get last sync
			$this->db->select('date_modified');
			$this->db->order_by('event_ticket_type_id'); 
			$this->db->limit(1); 
			$last_sync = $this->db->get('event_ticket_types')->row()->date_modified;
			
			 
			 
			$this->db->where('date_modified >=', $last_sync);
			$this->db->limit($limit);
			$query = $this->db->get('events_smphi_report_needed');
			if($query->num_rows() > 0){
				$result = $query->result();
				 
				
			
				// $prices = array();
				// $sections = array();
				$event_ticket_types = array();
				$ticket_types = array();
				foreach($result as $x){
					// $sections[$x->price_id] =  unserialize($x->price_sections);
					$ticket_types= array_merge(unserialize($x->event_ticket_types), $ticket_types);
					// $ticket_types[$x->event_id]['price_name'] = $x->price_name;
					// $ticket_types[$x->event_id]['price_price'] = $x->price_price;
					// $ticket_types[$x->event_id]['price_event_id'] = $x->price_event_id;
				}
				
				// echo '<pre>';
				// print_r($ticket_types);
				// echo '</pre>';
				
				// die();
				$this->db->select('ticket_type_id, ticket_type_name');
				$this->db->where_in('ticket_type_id', $ticket_types);
				$query = $this->db->get('ticket_types_smphi_report_needed');
				$result = $query->result();
				
				 
				foreach($result as $x){
					
					
					//remove existing
					$this->db->where('event_id',$event_id);
					$this->db->where('ticket_type_id',$x->ticket_type_id);
					$this->db->delete('event_ticket_types');
					
					$fields = array(
						'event_id'			=> $event_id,
						'ticket_type_id'	=> $x->ticket_type_id,
						'ticket_type_name'	=> $x->ticket_type_name,
						);
					// insert to db
					$this->db->set($fields);
					 $this->db->insert('event_ticket_types');
					 
				}
				
				
				echo 'Success';
			 
 			}

	} //END EVENT TICKET TYPE CRON
		
}

/* End of file events.php */
/* Location: ./application/controllers/events.php */

