<?php
require 'vendor/autoload.php';
use Aws\S3\S3Client;

class Seatplans extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('sections_model', 'sections');
		$this->load->model('files_model', 'files');
		$this->load->model('events_model', 'events');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('seatplans/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Seatplans';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all seatplans
		$data['seatplans'] = $this->seatplans->get_seatplans();
				
		// remove the event id
		$this->session->unset_userdata('cei');
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('seatplans_listing', $data);
	}

	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($seatplan_id = false)
	{
		if (!$seatplan_id) show_404();
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Event', 'Seller','Reservation','Reservation-Admin','Finance'));
		
		if ($this->session->userdata('cei'))
		{
			$event_id = $this->session->userdata('cei');
			
			// get event
			$data['event'] = $this->events->get($event_id);
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Seatplan';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get seatplan
		$data['seatplan'] = $this->seatplans->get($seatplan_id);
		
		// get sections
		$arr_sid = $this->sections->get_section_ids_array($seatplan_id);
		if (count($arr_sid) > 0) {
			$sections_info = $this->sections->get_ticket_availability_sections(serialize($arr_sid), $seatplan_id, true);
		} else {
			$sections_info = array();
		}
		
		$data['sections_info'] = $sections_info;
		$data['sections'] = $this->sections->get_sections($seatplan_id);
		
		// display the page
		$this->load->view('seatplans_view', $data);
	}		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Seatplan';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'seatplan_name',
				'label'   => 'Seatplan Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue ID',
				'rules'   => 'trim|required|strip_tags|min_length[1]|integer'
			),
			array(
				'field'   => 'seatplan_photo',
				'label'   => 'Seatplan Picture',
				'rules'   => 'trim|strip_tags|max_length[250]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// get venues
			$data['venues'] = $this->venues->get_venues_dropdown();

			// display the page
			$this->load->view('seatplans_add', $data);
		}
		else
		{

			if ($_FILES["seatplan_photo"]["error"] != 4)
			{
				// upload the photo; params: filename, max width, max height
				$bucketName = 'images.smtickets.com';
				$bucketPath = 'images5.smtickets.com';
				$imageTmp = $_FILES['seatplan_photo']['tmp_name'];
				$imageName = $_FILES['seatplan_photo']['name'];
				$imageType = $_FILES['seatplan_photo']['type'];

				$date = new DateTime('now');
				$timestamp = $date->format('dmYHis');
				$ext = pathinfo($imageName, PATHINFO_EXTENSION);

				$imageNameOnly = "seatplan_".$timestamp.".".$ext;
				$imageNewName = "images/"."seatplan_".$timestamp.".".$ext;
				$imagePath = "https://" . $bucketPath . "/" . $imageNewName;

				$image_path = $this->files->upload_image('seatplan_photo', 640, 1000, $imageNameOnly);

				if(strpos($image_path, "The uploaded file exceeds the maximum allowed size in your PHP configuration file.") == true || strpos($image_path, "The file you are attempting to upload is larger than the permitted size.") == true) {
					$this->session->set_flashdata('message', assemble_message('Unable to upload image. Image size exceeded 200 KB max size. Please reduce the image size.'));
					redirect('seatplans/add');
				} 
				else if (strpos($image_path, "The filetype you are attempting to upload is not allowed.") == true) {
					$error_message = strip_tags($image_path);
					$this->session->set_flashdata('message', assemble_message($error_message));
					redirect('seatplans/add');
				} 
				else {

					list($width, $height, $type, $attr) = getimagesize($imageTmp);
					$imageSize = filesize($imageTmp);
					$imageWH = $width . " x " . $height; 

					// $this->banner->upload($imageNewName, $imagePath, $imageWH, $imageSize);

					$s3 = new S3Client([
					    'version' => 'latest',
					    'region'  => 'ap-southeast-1',
					    'credentials' => [
					        'key'    => 'AKIARGTGZ65DTYI5F6FU',
					        'secret' => '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'
					    ],
					    'http' => [ 'verify' => false ]
					]);
					 
					// Upload a publicly accessible file. The file size and type are determined by the SDK.
					try {
					    $result = $s3->putObject([
					        'Bucket' => $bucketName,
					        'Key'    => $imageNewName,
					        'SourceFile' => $imageTmp,
					        'ContentType' => $imageType
					    ]);
					    // echo $result->get('ObjectURL');
					} 
					catch (Aws\S3\Exception\S3Exception $e) {
					    // echo "There was an error uploading the file.\n";
					    // echo $e->getMessage();
					}
					$this->seatplans->add($image_path);
				}
			}
			else
			{
				$this->session->set_flashdata('message', assemble_message('You did not select a file to upload.'));
				redirect('seatplans/add');
			}
				
			// redirect
			$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully added'));
			redirect('seatplans/listing');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($seatplan_id = false)
	{
		if (!$seatplan_id) show_404();
		
		if ($this->session->userdata('cei'))
		{
			$event_id = $this->session->userdata('cei');
			
			// get event
			$data['event'] = $this->events->get($event_id);
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Seatplan';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'seatplan_name',
				'label'   => 'Seatplan Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue ID',
				'rules'   => 'trim|required|strip_tags|min_length[1]|integer'
			),
			array(
				'field'   => 'seatplan_photo',
				'label'   => 'Seatplan Picture',
				'rules'   => 'trim|strip_tags|max_length[250]'
			),
			array(
				'field'   => 'seatplan_active',
				'label'   => 'Status',
				'rules'   => 'trim|strip_tags|min_length[1]|integer'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get seatplan
		$data['seatplan'] = $this->seatplans->get($seatplan_id);
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
			
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('seatplans_edit', $data);
		}
		else
		{
			if ($_FILES["seatplan_photo"]["error"] != 4)
			{
				// upload the photo; params: filename, max width, max height
				$bucketName = 'images.smtickets.com';
				$bucketPath = 'images5.smtickets.com';
				$imageTmp = $_FILES['seatplan_photo']['tmp_name'];
				$imageName = $_FILES['seatplan_photo']['name'];
				$imageType = $_FILES['seatplan_photo']['type'];

				$date = new DateTime('now');
				$timestamp = $date->format('dmYHis');
				$ext = pathinfo($imageName, PATHINFO_EXTENSION);

				$imageNameOnly = "seatplan_".$timestamp.".".$ext;
				$imageNewName = "images/"."seatplan_".$timestamp.".".$ext;
				$imagePath = "https://" . $bucketPath . "/" . $imageNewName;

				$image_path = $this->files->upload_image('seatplan_photo', 640, 1000, $imageNameOnly);


				if(strpos($image_path, "The uploaded file exceeds the maximum allowed size in your PHP configuration file.") == true || strpos($image_path, "The file you are attempting to upload is larger than the permitted size.") == true) {
					$error_message = "Unable to upload image. Image size exceeded 200 KB max size. Please reduce the image size.";
					$image_path = "";
				} 
				else if (strpos($image_path, "The filetype you are attempting to upload is not allowed.") == true) {
					$error_message = strip_tags($image_path);
					$image_path = "";
				} 
				else {
					list($width, $height, $type, $attr) = getimagesize($imageTmp);
					$imageSize = filesize($imageTmp);
					$imageWH = $width . " x " . $height; 

					// $this->banner->upload($imageNewName, $imagePath, $imageWH, $imageSize);

					$s3 = new S3Client([
					    'version' => 'latest',
					    'region'  => 'ap-southeast-1',
					    'credentials' => [
					        'key'    => 'AKIARGTGZ65DTYI5F6FU',
					        'secret' => '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'
					    ],
					    'http' => [ 'verify' => false ]
					]);
					 
					// Upload a publicly accessible file. The file size and type are determined by the SDK.
					try {
					    $result = $s3->putObject([
					        'Bucket' => $bucketName,
					        'Key'    => $imageNewName,
					        'SourceFile' => $imageTmp,
					        'ContentType' => $imageType
					    ]);
					    echo $result->get('ObjectURL');
					} 
					catch (Aws\S3\Exception\S3Exception $e) {
					    echo "There was an error uploading the file.\n";
					    echo $e->getMessage();
					}
				}
			}
			else
			{
				$image_path = '';
			}
			// save to database
			$this->seatplans->edit($seatplan_id, $image_path);
	
			// redirect

			if(isset($error_message)) {
				$this->session->set_flashdata('message', assemble_message($error_message));
				redirect('seatplans/edit/'.$seatplan_id);
			} else {
				$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully modified'));
				redirect('seatplans/edit/'.$seatplan_id);
			}
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($seatplan_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Seat Plan');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->seatplans->delete($seatplan_id);
		$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully deleted'));
		redirect('seatplans/listing/');
	}

	function copy($seatplan_id,$seatplan_name=false)
	{
	

	
/* 
	 	$data = array('column1' => $seatplan_name);
		$this->db->insert('test', $data);
		  */
		 
		// copy the seatplan
		
		$new_seatplan_id = $this->seatplans->copy_seatplan($seatplan_id,$seatplan_name);
		
		
		
		// redirect
	 	$this->session->set_userdata('cei', $new_seatplan_id);
		$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully saved'));
		redirect('seatplans/listing/'); 
	}
	
	
	
	}
/* End of file seatplans.php */
/* Location: ./application/controllers/seatplans.php */	