<?php

class Season_pass extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('season_pass_model', 'season_pass'); 
		$this->load->model('events_model', 'events'); 
		$this->load->model('users_model', 'users'); 
		$this->load->database('default');

		// place authentication check here
		// check user session
		

	}
	
	function index()
	{
		redirect('season_pass/listing');
	}
 
	function listing() {
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['page_title'] = 'Season Pass Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["listing"] = $this->season_pass->listing();
	
		$this->load->view('season_pass_listing',$data);
	}
	
	function set_layout($event_id = false) {
		$data['page_title'] = 'Season Pass Set Layout';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["listing"] = $this->season_pass->get_event_layouts($event_id);
		$data['event'] = $this->events->get($event_id);
		
		
		$this->load->view('season_pass_layouts',$data);
		
		
		
		
	}
	
	
	
	function activate($event_id = 0) {
		if ($event_id > 0) {
			$this->season_pass->set_season_listing_config($event_id,1);
		}
		redirect("season_pass/listing");
	}
	
	function deactivate($event_id = 0) {
		if ($event_id > 0) {
			$this->season_pass->set_qrsale_listing_config($event_id,0);
		}
		redirect("season_pass/listing");
	}
	
	
	
}

