<?php

class Sap extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('reports_model', 'reports');
		$this->load->model('sap_model', 'sap');
		$this->load->model('branches_model', 'branches');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('admin_model', 'admin');
		$this->load->database('default');
		// $db['archive']['database'] = "live_dbsss";
	// $this->load->database('archive');
	
	}
	
	// --------------------------------------------------------------------



	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		
		if($this->session->userdata('user_type')=='Treasury'){
		$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}else{
			$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}
		
		// prepare data for the template
		$data['page_title'] = 'Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$this->load->view('reports_index', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view sap report
	 *
	 * @access	public
	 */
	
	
	
	function export_sap_report($branch_id=false){
		$branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		$branch_code = str_replace(" ", "_", $branch_info->branch_code);
		
		$data['filename'] =  'SMTickets'.$branch_code.date('mdY');
		// die();						
		
		
		if(in_array($branch_id, array(3,6,7,8,9,37,48,72))){
		$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
		$this->load->view('sap_interface_non_smp', $data);
		}else if(in_array($branch_id, array(90))){
		$data['reports'] = $this->sap->reports_sap_online($branch_id);
		$data['filename'] =  'SMTickets'.'ONLINE'.date('mdY');
		$this->load->view('sap_interface_online', $data);
		}else if(in_array($branch_id, array(1,102,103,109,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144,156,157,170,160,178,152,189,153,166,167,190,184,171,185,172,183,179,191,181,186,161,182,192,174,168,163,173,188,193,158,177,175,154,194,187,176,164,162,195,196,159,197,180,169,165,155,198,199,200,201,203,204,205,206,207,208,209,210,211,212,213,214,215))){
		$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
		$this->load->view('sap_interface_non_sm_and_office', $data);
		}else{
		$data['reports'] = $this->sap->reports_sap_smp($branch_id);
		$ctr2 = 0;
		// $rep = $this->sap->reports_sap_smp($branch_id);
		/* foreach($rep as $key =>  $rdata){
			echo $rdata['event_id'];
			echo $prev = $rep[$ctr2]->event_id;
			$ctr2 += 1;
		}
		die(); */
		// $this->load->view('sap_interface_smp', $data);	
		$this->load->view('sap_interface_non_smp', $data);	
		}
	}
	
	function export_sap_report2($branch_id=false){	
		$data['branch_id'] = $branch_id;
		$this->load->view('sap_interface2',$data);
	}
	
	
	
	function email_incomplete_vendor(){
		$promoters = $this->sap->get_no_vendor_key();

		$ctr=1;
		foreach($promoters as $promoter){
			echo $ctr.'. '.$promoter->promoter_name.'</br>';
			$ctr=$ctr+1;
		}
				
	}
	
	function get_promoters_sap(){
		echo $this->sap->get_promoters_sap();
	}
	
	function save_sap_txt($branch_id,$branch_code){
		// unlink("resources/sapSMTicketsSMKL01022019.txt");
		
		// die();
		// $branch_info = $this->sap->get_branch_code($branch_id);
		// echo $branch_info->branch_code;
		// print_r($branch_info);
		// die();
		/* if($branch_id==90){
			$branch_code = "ONLINE";
		}else{
			$branch_code = str_replace(" ", "_", $branch_info->branch_code);
		} */
		// die();
		// $header = 'SMTickets'.$branch_code.date('mdY').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
		$date = date('mdY',strtotime("-1 days"));
		$header = 'SMTickets'.$branch_code.$date.'.txt';
		// $this->load->view('sap_test');
		file_put_contents("resources/sap/".$header, file_get_contents(base_url()."sap/export_sap_report_/".$branch_id.'/'.$header));
		// file_put_contents("resources/sap".$header, file_get_contents(base_url()."sap/export_sap_report_test/".$branch_id.'/'.$header));
	}
	
	function get_sap_branches(){
		// unlink('resources/sapSMTicketsSMEO02012019.txt');
		// die();
		 
		ini_set("memory_limit","4000M");
		//ini_set('memory_limit', '-1');
		$result = $this->sap->get_sap_branches();
		// die();
		// echo '<pre>';
		// print_r($result);
		// die();
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			$this->save_sap_txt($res->branch_account_id, $branch_code);
			
		}
		//$this->delete_sap_files(); 
		
		// $branch_id = "2";
		// $branch_code = "SMOA";
		
		// $this->save_sap_txt($branch_id, $branch_code);
		
	}
	
	function get_sap_branches_manual($date_trans){
		// unlink('resources/sapSMTicketsSMEO02012019.txt');
		// die();
		 ini_set('memory_limit', '-1');
		$result = $this->sap->get_sap_branches();
		// die();
		// echo '<pre>';
		// print_r($result);
		// die();
		$date_ = explode("-",$date_trans);
		$date = $date_[1].$date_[2].$date_[0];
		foreach($result as $res){
			
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			$this->save_sap_txt_manual($res->branch_account_id, $branch_code, $date, $date_trans);
			
		}
		$this->delete_sap_files_manual($date,$date_trans); 
		
		// $branch_id = "2";
		// $branch_code = "SMOA";
		
		// $this->save_sap_txt($branch_id, $branch_code);
		
	}
	
	function save_sap_txt_manual($branch_id,$branch_code, $date, $date_trans){
		// unlink("resources/sapSMTicketsSMKL01022019.txt");
		
		// die();
		// $branch_info = $this->sap->get_branch_code($branch_id);
		// echo $branch_info->branch_code;
		// print_r($branch_info);
		// die();
		/* if($branch_id==90){
			$branch_code = "ONLINE";
		}else{
			$branch_code = str_replace(" ", "_", $branch_info->branch_code);
		} */
		// die();
		// $header = 'SMTickets'.$branch_code.date('mdY').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
		// $date = date('mdY',strtotime("-1 days"));
		// $date = date('mdY',strtotime("-1 days"));
		$header = 'SMTickets'.$branch_code.$date.'.txt';
		// $this->load->view('sap_test');
		file_put_contents("resources/sap/".$header, file_get_contents(base_url()."sap/export_sap_report_manual/".$branch_id.'/'.$header.'/'.$date_trans));
		// file_put_contents("resources/sap".$header, file_get_contents(base_url()."sap/export_sap_report_test/".$branch_id.'/'.$header));
	}
	
	function export_sap_report_manual($branch_id=false, $header = false, $date = false){
		// $branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		// $data['filename'] =  'SMTickets'.$branch_info->branch_code.date('mdY');
		// die();
		// $header = "SMTicketsSMOA03252019.txt";
		$this->load->helper('file');

		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header.'"');
		
		/* $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			// echo count($data['reports']);
			// die();
			if(count($data['reports'])>0){
			echo count($data['reports']);
			$this->load->view('sap_interface_non_sm_and_office', $data);
			// die();
			} */
		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			// echo 'dadsa';
			// die();
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date);
			// $this->load->view('sap_interface_non_smp', $data);
			// echo "dsadsa";
			// die();
			// echo '<pre>';
			// print_r($data['reports']);
			// die();
			if(count($data['reports'])>0){
			// echo count($data['reports']);
			// die();
				
			$this->load->view('sap_interface_non_smp', $data);
			}
			// die();
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online_($branch_id,$date);
			if(count($data['reports'])>0){
				
				$this->load->view('sap_interface_online', $data);
				$data['filename'] =  'SMTickets'.'ONLINE'.date('0328Y');
				
			}
		}else if(in_array($branch_id, array(1,102,103,109,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144,156,157,170,160,178,152,189,153,166,167,190,184,171,185,172,183,179,191,181,186,161,182,192,174,168,163,173,188,193,158,177,175,154,194,187,176,164,162,195,196,159,197,180,169,165,155,198,199,200,201,203,204,205,206,207,208,209,210,211,212,213,214,215))){
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id, $date);
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_non_sm_and_office', $data);
			
			}
		}
		else if(in_array($branch_id, array(2,4,5,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,91,92,104,105,107,108,110,121,132,133,135,136,137,138,139,140,141,143,145,146,147,148,202))){
			 $data['reports'] = $this->sap->reports_sap_smp_($branch_id,$date);
			
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_smp', $data);
			
			}
		}    
	}
	
	
	
	function get_sap_branches_(){
		// unlink('resources/sapSMTicketsSMEO02012019.txt');
		// die();
		ini_set('memory_limit', '-1');
		$result = $this->sap->get_sap_branches();
		// die();
		// print_r($result);
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			$this->save_sap_txt($res->branch_account_id, $branch_code);
			
		}
		$this->delete_sap_files();
	}
	
	function delete_sap_files(){
		
		$result = $this->sap->get_sap_branches();
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
			$date = date('mdY',strtotime("-1 days"));
			$header = 'SMTickets'.$branch_code.$date.'.txt';
			$this->delete_sap_report($res->branch_account_id, $header);
			
		}
	}
	
	function delete_sap_files_manual($date,$date_trans){
		
		$result = $this->sap->get_sap_branches();
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
			// $date = date('mdY',strtotime("-1 days"));
			$header = 'SMTickets'.$branch_code.$date.'.txt';
			$this->delete_sap_report_manual($res->branch_account_id, $header, $date,$date_trans);
			
		}
	}
	
	
	function delete_sap_report($branch_id=false, $header = false){
		$this->load->helper('file');

		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			
			$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
			// $this->load->view('sap_interface_non_smp', $data);
			if(count($data['reports'])<1){

				unlink("resources/sap/".$header);
			} 
			
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online($branch_id);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}else if(in_array($branch_id, array(1,102,103,109,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144,156,157,170,160,178,152,189,153,166,167,190,184,171,185,172,183,179,191,181,186,161,182,192,174,168,163,173,188,193,158,177,175,154,194,187,176,164,162,195,196,159,197,180,169,165,155,198,199,200,201,203,204,205,206,207,208,209,210,211,212,213,214,215))){
			$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}else if(in_array($branch_id, array(2,4,5,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,91,92,104,105,107,108,110,121,132,133,135,136,137,138,139,140,141,143,145,146,147,148,202))){
			$data['reports'] = $this->sap->reports_sap_smp($branch_id);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}
		 /*  else{
			 $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			
			if(count($data['reports'])<1){
				unlink("resources/sap".$header);
			} 
		} */   
	}
	
	function delete_sap_report_manual($branch_id=false, $header = false, $date = false, $date_trans = false){
		$this->load->helper('file');

		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date_trans);
			// $this->load->view('sap_interface_non_smp', $data);
			if(count($data['reports'])<1){

				unlink("resources/sap/".$header);
			} 
			
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online_($branch_id,$date_trans);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}else if(in_array($branch_id, array(1,102,103,109,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144,156,157,170,160,178,152,189,153,166,167,190,184,171,185,172,183,179,191,181,186,161,182,192,174,168,163,173,188,193,158,177,175,154,194,187,176,164,162,195,196,159,197,180,169,165,155,198,199,200,201,203,204,205,206,207,208,209,210,211,212,213,214,215))){
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date_trans);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}else if(in_array($branch_id, array(2,4,5,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,91,92,104,105,107,108,110,121,132,133,135,136,137,138,139,140,141,143,145,146,147,148,202))){
			$data['reports'] = $this->sap->reports_sap_smp_($branch_id,$date_trans);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}
		 /*  else{
			 $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			
			if(count($data['reports'])<1){
				unlink("resources/sap".$header);
			} 
		} */   
	}
	
	// function export_sap_report_($branch_id=false){
	function export_sap_report_test($branch_id=false, $header = false){
		$this->load->view('sap_test');
	}
	function export_sap_report_($branch_id=false, $header = false){
		// $branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		// $data['filename'] =  'SMTickets'.$branch_info->branch_code.date('mdY');
		// die();
		// $header = "SMTicketsSMOA03252019.txt";
		$this->load->helper('file');

		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header.'"');
		
		/* $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			// echo count($data['reports']);
			// die();
			if(count($data['reports'])>0){
			echo count($data['reports']);
			$this->load->view('sap_interface_non_sm_and_office', $data);
			// die();
			} */
		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			// echo 'dadsa';
			// die();
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id);
			// $this->load->view('sap_interface_non_smp', $data);
			// echo "dsadsa";
			// die();
			// echo '<pre>';
			// print_r($data['reports']);
			// die();
			if(count($data['reports'])>0){
			// echo count($data['reports']);
			// die();
				
			$this->load->view('sap_interface_non_smp', $data);
			}
			// die();
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online($branch_id);
			if(count($data['reports'])>0){
				
				$this->load->view('sap_interface_online', $data);
				$data['filename'] =  'SMTickets'.'ONLINE'.date('0328Y');
				
			}
		}else if(in_array($branch_id, array(1,102,103,109,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144,156,157,170,160,178,152,189,153,166,167,190,184,171,185,172,183,179,191,181,186,161,182,192,174,168,163,173,188,193,158,177,175,154,194,187,176,164,162,195,196,159,197,180,169,165,155,198,199,200,201,203,204,205,206,207,208,209,210,211,212,213,214,215))){
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id);
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_non_sm_and_office', $data);
			
			}
		}
		else if(in_array($branch_id, array(2,4,5,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,91,92,104,105,107,108,110,121,132,133,135,136,137,138,139,140,141,143,145,146,147,148,202))){
			 $data['reports'] = $this->sap->reports_sap_smp_($branch_id);
			
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_smp', $data);
			
			}
		}  
	}
	
	function trasfer_files(){
		
		/* Remote File Name and Path */
		$remote_file = 'resources/sapSMTicketsBOMOA02012019.txt';
		  
		/* FTP Account (Remote Server) */
		$ftp_host = '10.140.7.176'; /* host */
		$ftp_user_name = 'user01'; /* username */
		$ftp_user_pass = 'user_01'; /* password */
		  
		  
		/* File and path to send to remote FTP server */
		$local_file = 'resources/sapSMTicketsBOMOA02012019.txt';
		  
		/* Connect using basic FTP */
		$connect_it = ftp_connect( $ftp_host );
		  
		/* Login to FTP */
		$login_result = ftp_login( $connect_it, $ftp_user_name, $ftp_user_pass );
		  
		/* Send $local_file to FTP */
		if ( ftp_put( $connect_it, $remote_file, $local_file, FTP_BINARY ) ) {
			echo "WOOT! Thanks Munshi and OBOYOB! Successfully transfer $local_file\n";
		}
		else {
			echo "Doh! There was a problem\n";
		}
		  
		/* Close the connection */
		ftp_close( $connect_it );

		
		
	}
	
	function branch_info_edit($branch_id)
	{
		// prepare data for the template
		$data['page_title'] = 'Promoters';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		// get all branches
		//$data['branch'] = $this->sap->get($branch_id); //old
		$data['branch'] = $this->sap->get_sap_details($branch_id);
		 

		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance','IT'));
		
		$config = array(
			array(
				'field'   => 'branch_name',
				'label'   => 'branch_name',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'branch_code',
				'label'   => 'branch_code',
				'rules'   => 'required'
			)
			 
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
			$data['branch_id'] = $branch_id;
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('branches_sap_edit', $data);
		}
		else
		{	
			// echo '<pre>';
			// print_r($_POST);
			// echo '</pre>';
			// die();
		
			unset($_POST['branch_name']);
			$this->sap->edit_sap_details($branch_id);
			$this->session->set_flashdata('message', assemble_message('Branch SAP info was successfully updated.'));
			redirect('sap/branch_info_edit/'.$branch_id);
		}
		
		
		
		
	}
	/**
	 * payment types list
	 *
	 * @access	public
	 */
	
	function payment_types_listing(){
		$this->users->check_session(array('Admin','Super Admin','Account','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Payment Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		// get all terminals
		$data['payment_types'] = $this->sap->get_payment_types();
		
		$this->load->view('sap_payment_types_listing', $data);
	}
	
	/**
	 * edit payment types
	 *
	 * @access	public
	 */
	function edit_payment_type($payment_type_id = FALSE)
	{
		if (! $payment_type_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Payment Type';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Account','Finance'));
			
		$config = array(
			
			array(
				'field'   => 'payment_mdr_rate',
				'label'   => 'Payment mdr rate',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
			// get events
			// $data['branches'] = $this->branches->get_branches_dropdown();	
		
		if ($this->form_validation->run() == FALSE)
		{
			// get terminal's data
			$data['payment_type'] = $this->sap->get_payment_type($payment_type_id);
			
			// display the page
			$this->load->view('sap_edit_payment_type', $data);
		}
		else
		{
			$this->sap->edit_payment_type($payment_type_id);
			$this->session->set_flashdata('message', assemble_message('Payment Type  MDR Rate has been successfully modified'));
			redirect('sap/payment_types_listing');
		}
	}
	
	function generate_txtfile_old($branch_id = false){
		$data['form_url'] = uri_string();
		$data['page_title'] = "Generate Txt file";
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'Date',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'branch_code',
				'label'   => 'Branch Code',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('generate_txt', $data);
		}else{
			$date = $this->input->post('date_from');
			$branch_id = $this->input->post('branch_id');
			$branch_code = $this->input->post('branch_code');
			$date_ = date_create($date);
			$format_date = date_format($date_, 'mdY');
			if($branch_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $branch_code);
			}
			
			$header_ =  "SMTickets".$branch_code.$format_date;
			$this->export_sap_txt($branch_id,$header_,$date);
			
		}
	}
	
	function export_sap_txt($branch_id=false, $header_ = false, $date = false){
		// $branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		// $data['filename'] =  'SMTickets'.$branch_info->branch_code.date('mdY');
		// die();
		
		$header = $header_.'.txt';
		// die();
		$this->load->helper('file');

		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date);
			// $this->load->view('sap_interface_non_smp', $data);
			if(count($data['reports'])>0){
				
				
				$this->load->view('sap_interface_non_smp', $data);
			}
			
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online_($branch_id,$date);
			if(count($data['reports'])>0){
				
				$this->load->view('sap_interface_online', $data);
				$data['filename'] =  'SMTickets'.'ONLINE'.date('0102Y');
				
			}
		}else if(in_array($branch_id, array(1,102,103,109,122,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,132,134,142,144,156,157,170,160,178,152,189,153,166,167,190,184,171,185,172,183,179,191,181,186,161,182,192,174,168,163,173,188,193,158,177,175,154,194,187,176,164,162,195,196,159,197,180,142,169,165,155,198,199,200,201,203))){
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date);
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_non_sm_and_office', $data);
			
			}
		}
		 else{
			 $data['reports'] = $this->sap->reports_sap_smp_($branch_id,$date);
			
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_smp', $data);
			
			}
		}  
	}
	
	function copy_void($ticket_ids,$user_id,$branch_id, $status){
		
		$this->admin->copy_voided_tickets2($ticket_ids,$user_id,$branch_id, $status);
	}
	
	function copy_tickets($transaction_id, $status){
		
		$this->admin->copy_tickets($transaction_id, $status);
	}
	
	function get_payments($branch_id,$trans_date){

		$query = $this->db->query("SELECT * FROM historical_payments hp WHERE DATE(payment_datetime) <= '".$trans_date."' AND  DATE(payment_datetime) >= '".$trans_date."' AND hp.payment_branch = '".$branch_id."' and hp.payment_payment_type_id = '1' and hp.payment_amount_voided = 0 ");
		// $query = $this->db->query("SELECT * FROM historical_payments hp WHERE DATE(payment_datetime) <= '".$trans_date."' AND  DATE(payment_datetime) >= '".$trans_date."' AND hp.payment_branch = '".$branch_id."' and hp.payment_payment_type_id = '1' and hp.payment_amount_voided != 0 ");
		$result = $query->result(); 
		
		echo "<pre>";
		print_r($result);
	}
	
	function get_tickets($branch_id,$trans_date){

		$query = $this->db->query("SELECT * FROM historical_tickets hp WHERE DATE(ticket_date_entered) <= '".$trans_date."' AND  DATE(ticket_date_entered) >= '".$trans_date."' AND hp.ticket_branch_id = '".$branch_id."'");
		$result = $query->result(); 
		
		echo "<pre>";
		print_r($result);
	}
	
	function get_trans($branch_id,$trans_date){

		// $query = $this->db->query("SELECT * FROM historical_transactions hp WHERE DATE(transaction_date) <= '".$trans_date."' AND  DATE(transaction_date) >= '".$trans_date."' AND hp.transaction_branch_id = '".$branch_id."'");
		$query = $this->db->query("select ticket_id, '2019-08-20 13:39:34', ticket_transaction_id, ticket_session_id, ticket_event_id, ticket_section_id, ticket_type_id, ticket_price_id, ticket_system_row, ticket_system_col, ticket_row, ticket_seat, ticket_reservation_expiry, ticket_acknowledgment_receipt, '2019-08-20', ticket_date_cancelled, ticket_date_reserved, ticket_date_refunded, 'paid_online', ticket_user_id, ticket_branch_id, ticket_terminal_id, ticket_barcode from historical_tickets t left join voided_transaction_details v on v.voided_detail_ticket_id = t.ticket_id where t.ticket_transaction_id = '870'");
		// $query = $this->db->query(" select ticket_id, '2019-08-20 14:31:03', ticket_transaction_id, ticket_session_id, ticket_event_id, ticket_section_id, ticket_type_id, ticket_price_id, ticket_system_row, ticket_system_col, ticket_row, ticket_seat, ticket_reservation_expiry, ticket_acknowledgment_receipt, '2019-08-20', ticket_date_cancelled, ticket_date_reserved, ticket_date_refunded, 'paid_online', ticket_user_id, ticket_branch_id, ticket_terminal_id, ticket_barcode from tickets t left join voided_transaction_details v on v.voided_detail_ticket_id = t.ticket_id where t.ticket_transaction_id = '870'");
		$result = $query->result(); 
		
		
		// foreach($result as $res){
			// echo $res->transaction_id;
		// }
		
		
		// echo $this->db->last_query();
		// echo "<pre>";
		// print_r($result);
	}
	
	function validate_transactions($date= false, $branch_id = false){
		// $query = $this->db->query("SELECT t.transaction_id FROM transactions t  LEFT OUTER JOIN historical_transactions ht ON t.transaction_id = ht.transaction_id WHERE ht.transaction_id IS NULL AND  DATE(t.transaction_date) >= '".$date."' AND DATE(t.transaction_date) <= '".$date."' AND t.transaction_branch_id = $branch_id AND t.transaction_status IN ('paid_online','done','paid','voided')");
		$query = $this->db->query("SELECT t.transaction_id FROM transactions t  LEFT OUTER JOIN historical_transactions ht ON t.transaction_id = ht.transaction_id WHERE  DATE(ht.transaction_date) >= '".$date."' AND DATE(ht.transaction_date) <= '".$date."' AND t.transaction_branch_id = $branch_id AND t.transaction_status IN ('paid_online','done','paid','voided')");
		$result = $query->result(); 
		// echo $this->db->last_query();
		
		foreach($result as $res){
			echo $res->transaction_id.'<br>';
			
			// $this->admin->copy_tickets($res->transaction_id, 'done');
			// $this->admin->copy_transactions($res->transaction_id,'done');
			// $this->admin->copy_payments($res->transaction_id);
			// $this->admin->copy_charges($res->transaction_id);
		}
		// echo count($result);
		// echo "<pre>";
		// print_r($result);
		
	}
	 
	function get_sap(){
	
	
		// $query = $this->db->query("select  a.event_id, a.transaction_id, sum(a.charge_amount) as total_charge,  sum(a.tix_qty_) as tix_qty, CASE when a.tix_qty_ > 10 THEN qty * event_internet_sales_charge ELSE sum(a.tix_qty_) * event_internet_sales_charge END 'total_charge2', CASE WHEN (payment_type_type = 'Cash') THEN ( (SUM(a.payment_amount) - SUM(a.payment_amount_voided_)) - SUM(transaction_cash_change_)) WHEN (payment_type_type != 'Cash') THEN ( (SUM(a.payment_amount) - SUM(a.payment_amount_voided_))) END total_amount, CASE WHEN (payment_type_type = 'Cash') THEN 0 WHEN (payment_type_type != 'Cash') THEN ((SUM(a.discount_fee) - SUM(a.discount_fee_voided))) END total_amount_discount, a.* from( SELECT SUM(ch.charge_amount) as charge_amt_total, transaction_id, discount_fee_profit_center, CASE when ti.ticket_status = 'paid_online' then COUNT(transaction_id)/2 ELSE COUNT(transaction_id) END tix_qty_, '0' as per_ticket, (payment_amount * (payment_mdr_rate/100)) as discount_fee, (payment_amount_voided * (payment_mdr_rate/100)) as discount_fee_voided, transaction_status, event_id,  CONCAT(payment_type_type, '/', transaction_status, '/', event_id) as pt_status, t.transaction_cash_change as transaction_cash_change_,p.payment_amount_voided as payment_amount_voided_, '2000' as 'company_code',  bac.profit_center as company_code_n,p.payment_amount, ch.charge_amount, p.payment_amount as total_amount_, total_multiple_payment, pt.payment_type_name, pt.payment_type_type, bac.cash_account, bac.eplus_account, DATE_FORMAT(ti.ticket_date_entered, '%d.%m.%Y') AS document_date, DATE_FORMAT(ti.ticket_date_entered, '%d.%m.%Y') AS posting_date, CASE WHEN (transaction_status IN ('done') AND transaction_branch_id!= '90') THEN 'OTC' WHEN (transaction_status IN ('done') AND transaction_branch_id ='90') THEN 'OL' WHEN (transaction_status = 'voided') THEN 'VD' ELSE 'UNDEFINE' END 'transaction_status2', CONCAT('_', DATE_FORMAT(ti.ticket_date_entered, '%d%m%Y')) AS reference, 'SR' AS document_type, ' ' AS period, 'PHP' AS currency, ' ' AS translation_date, CASE WHEN (payment_type_type = 'Cash') THEN '1400001294' WHEN (payment_type_type = 'Online Payment') THEN '1400003226' WHEN (payment_type_type = 'Credit Card') THEN '900000007' ELSE '-' END 'account', CASE WHEN (payment_type_type = 'Credit Card') THEN '~' ELSE ' ' END 'special_gl', CASE WHEN (payment_type_type = 'Credit Card') THEN '19' ELSE '01' END 'posting_key',  ' ' AS transaction_type, 'need' AS amount, 'need' AS payment_terms, ' ' AS baseline_date, ' ' AS calculate_tax, ' ' AS input_tax_code, CASE WHEN (payment_type_type = 'Cash') THEN bac.profit_center_cash ELSE bac.cost_center_card END cost_center, 'SMPH027211' as profit_center, ' ' AS wbs_element, ' ' AS internal_order, ' ' AS value_date, 'SMOA' AS business_place, ' ' AS payment_block, ' ' AS payment_method, ' ' AS taxable_amount,' ' AS witholding_tax_type, ' ' AS withholding_tax_code, ' ' AS blank_type, ' ' AS house_bank, ' ' contract_number, ' ' AS contract_type, ' ' AS flow_type,bac.branch_code as branch_code, CASE WHEN (payment_type_type = 'Cash') THEN bac.profit_center_cash ELSE bac.profit_center_card END assignment, e.event_code, DATE_FORMAT(e.event_date_time, '%Y%m%d') AS event_date, tm.total_amount AS 'total_amount2', e.event_internet_sales_charge, COUNT(ticket_id) AS qty,   pt.payment_type_account, transaction_branch_id, pro.promoter_vendor_key, t.transaction_comment FROM transactions t LEFT JOIN tickets ti ON ti.ticket_transaction_id = t.transaction_id LEFT JOIN events e ON ti.ticket_event_id = e.event_id LEFT JOIN total_amount tm ON tm.total_transaction_id = t.transaction_id LEFT JOIN branches b ON ti.ticket_branch_id = b.branch_id LEFT JOIN ticket_types ttp ON ti.ticket_type_id = ttp.ticket_type_id LEFT join branches_account_code bac ON bac.branch_account_id = b.branch_id LEFT JOIN historical_payments p ON t.transaction_id = p.payment_transaction_id LEFT JOIN payment_types pt ON pt.payment_type_id = p.payment_payment_type_id LEFT JOIN promoters pro ON e.event_promoter_id = pro.promoter_id LEFT JOIN prices pr ON ti.ticket_price_id = pr.price_id LEFT JOIN charges ch ON ch.charge_transaction_id = t.transaction_id WHERE transaction_status IN ('done','paid_online','voided') AND ticket_status IN ('done','paid_online','voided') AND ttp.ticket_type_group = 0 AND total_amount != 0 AND t.transaction_branch_id = '90' AND ti.ticket_date_entered between '2019-08-23 00:00:01' and   '2019-08-23 23:59:59' GROUP BY payment_id) as a group by a.payment_type_type, event_id ORDER BY event_id  ASC");
		// $query = $this->db->query("SELECT t.transaction_id FROM transactions t  LEFT OUTER JOIN historical_transactions ht ON t.transaction_id = ht.transaction_id WHERE ht.transaction_id IS NULL AND  DATE(t.transaction_date) >= '2019-10-03' AND DATE(t.transaction_date) <= '".$date."' AND t.transaction_branch_id = $branch_id AND t.transaction_status IN ('paid_online','done')");
		// $query = $this->db->query("SELECT t.transaction_date, ti.ticket_date_entered, (ti.ticket_date_entered) AS trans_date, t.`transaction_user_id` AS user_id, ti.`ticket_event_id` AS event_id, ti.`ticket_type_id`, t.`transaction_id`, ti.`ticket_date_entered` AS transaction_date, ti.`ticket_date_entered` AS original_date_voided, ep.`eplus_payment_printed_card_num`, sec.`section_code`, (CASE WHEN ti.ticket_status = 'voided' THEN pr.price_price * -1 ELSE pr.price_price END) AS price_price, c.`customer_firstname`, c.`customer_lastname`, ti.`ticket_id`, b.`branch_name`, u.`user_firstname`, u.`user_lastname`, ti.`ticket_user_id`, ti.`ticket_branch_id`, ti.`ticket_acknowledgment_receipt`, t.`transaction_branch_id`, t.`transaction_receipt_number`, t.`transaction_status`, ti.`ticket_status`, ti.`ticket_reservation_expiry`, ti.`ticket_date_printed`, tt.`ticket_type_name`, tt.`ticket_type_discount_type`, tt.`ticket_type_discount`, (CASE WHEN ti.ticket_branch_id IS NULL THEN t.transaction_branch_id ELSE ti.ticket_branch_id END) AS branch_id FROM historical_tickets ti LEFT OUTER JOIN transactions t ON t.`transaction_id` = ti.`ticket_transaction_id` LEFT OUTER JOIN sections sec ON sec.`section_id` = ti.`ticket_section_id` LEFT OUTER JOIN ticket_types tt ON tt.`ticket_type_id` = ti.`ticket_type_id` LEFT OUTER JOIN prices pr ON pr.`price_id` = ti.`ticket_price_id` LEFT OUTER JOIN eplus_payments ep ON ep.`eplus_payment_order_id` = ti.`ticket_session_id` LEFT OUTER JOIN users u ON u.`user_id` = ti.`ticket_user_id` LEFT OUTER JOIN branches b ON b.`branch_id` = ti.`ticket_branch_id` LEFT OUTER JOIN customers c ON c.`customer_id` = t.`transaction_customer_id` WHERE DATE(t.transaction_date) = '2019-10-03' AND DATE(t.transaction_date) <= '2019-10-03' AND t.`transaction_branch_id` = '90' AND ti.`ticket_status` IN('done', 'paid_online', 'paid', 'voided') ORDER BY (CASE WHEN t.transaction_branch_id IS NULL THEN ti.ticket_branch_id ELSE t.transaction_branch_id END), DATE(t.transaction_date), t.`transaction_user_id`, ti.`ticket_event_id`, t.`transaction_id`, ti.`ticket_acknowledgment_receipt`, ti.`ticket_type_id`");
		$query = $this->db->query("SELECT a.event_id, a.branch_id, a.transaction_id, SUM(a.branch_amount_voided), CASE WHEN (payment_type_type = 'Cash') THEN ((SUM(a.payment_amount_) - SUM(a.payment_amount_voided_)) - SUM(transaction_cash_change_)) WHEN (payment_type_type != 'Cash') THEN ((SUM(a.payment_amount_) - SUM(a.payment_amount_voided_))) END total_amount, CASE WHEN (payment_type_type = 'Cash') THEN 0 WHEN (payment_type_type != 'Cash') THEN ((SUM(a.discount_fee) - SUM(a.discount_fee_voided))) END total_amount_discount, a.* FROM( SELECT p.id as pid, transaction_id, p.payment_transaction_id, ti.ticket_transaction_id, ticket_id, pt.payment_type_id, ti.ticket_event_id , CASE when ti.ticket_status = 'done' then COUNT(transaction_id)/2 ELSE COUNT(transaction_id) END tix_qty, p.payment_branch AS branch_id, '0' AS per_ticket, event_id, transaction_status, CONCAT(payment_type_type, '/', transaction_status, '/', event_id) AS pt_status, CASE WHEN (payment_type_type = 'Cash') THEN '2000' WHEN (payment_type_type = 'Gift Check') THEN '2000' ELSE bac.company_code END company_code, 'SMPH027211' AS company_code_n, CASE WHEN t.transaction_branch_id != '1' THEN 0 ELSE p.payment_amount END total_amount_, CASE WHEN t.transaction_branch_id != '1' THEN 0 ELSE p.payment_amount END payment_amount, CASE WHEN p.payment_amount_voided > 0 THEN 0 ELSE t.transaction_cash_change END transaction_cash_change_, p.payment_amount as payment_amount_, p.payment_amount_voided as payment_amount_voided_, p.payment_datetime, CASE WHEN vt.voided_branch_id = '1' THEN payment_amount_voided ELSE 0 END branch_amount_voided, CASE WHEN ti.ticket_branch_id != '1' THEN 0 ELSE (p.payment_amount * (payment_mdr_rate/100)) END discount_fee, CASE WHEN p.payment_amount > 0 THEN 0 ELSE (payment_amount_voided * (payment_mdr_rate/100)) END discount_fee_voided, total_multiple_payment, bac.profit_center_cash, pt.payment_type_name, pt.payment_type_type, bac.cash_account, bac.eplus_account, DATE_FORMAT(p.payment_datetime, '%d.%m.%Y') AS document_date, DATE_FORMAT(p.payment_datetime, '%d.%m.%Y') AS posting_date, CASE WHEN (transaction_status IN ('done') AND transaction_branch_id!= '90') THEN 'OTC' WHEN (transaction_status IN ('done') AND transaction_branch_id ='90') THEN 'OL' WHEN (transaction_status = 'voided') THEN 'VD' ELSE 'UNDEFINE' END 'transaction_status2', CONCAT('_', DATE_FORMAT(p.payment_datetime, '%d%m%Y')) AS reference, 'SR' AS document_type, ' ' AS period, 'PHP' AS currency, ' ' AS translation_date, CASE WHEN (payment_type_type = 'Cash') THEN '1400001294' WHEN (payment_type_type = 'Online Payment') THEN '1400003226' WHEN (payment_type_type = 'Credit Card') THEN '900000007' ELSE '-' END 'account', CASE WHEN (payment_type_type = 'Credit Card') THEN '~' ELSE ' ' END 'special_gl', CASE WHEN (payment_type_type = 'Credit Card') THEN '19' ELSE '01' END 'posting_key', ' ' AS transaction_type, 'need' AS amount, 'need' AS payment_terms, ' ' AS baseline_date, ' ' AS calculate_tax, ' ' AS input_tax_code, bac.cost_center AS cost_center, CASE WHEN (payment_type_type = 'Cash') THEN bac.profit_center_cash WHEN (payment_type_type = 'Gift Check') THEN bac.profit_center_cash ELSE bac.profit_center_card END profit_center, ' ' AS wbs_element, ' ' AS internal_order, ' ' AS value_date, bac.business_place AS business_place, ' ' AS payment_block, ' ' AS payment_method, ' ' AS taxable_amount,' ' AS witholding_tax_type, ' ' AS withholding_tax_code, ' ' AS blank_type, ' ' AS house_bank, ' ' contract_number, ' ' AS contract_type, ' ' AS flow_type, branch_code, bac.profit_center AS assignment, e.event_code, DATE_FORMAT(e.event_date_time, '%Y%m%d') AS event_date, tm.total_amount AS 'total_amount2', e.event_internet_sales_charge, COUNT(transaction_id) AS qty, pt.payment_type_account, transaction_branch_id, pro.promoter_vendor_key, t.transaction_comment FROM historical_tickets ti LEFT JOIN ticket_types ttp ON ti.ticket_type_id = ttp.ticket_type_id LEFT JOIN transactions t ON ti.ticket_transaction_id = t.transaction_id LEFT JOIN historical_payments p ON p.payment_transaction_id = t.transaction_id LEFT JOIN branches b ON p.payment_branch = b.branch_id LEFT JOIN branches_account_code bac ON bac.branch_account_id = b.branch_id LEFT JOIN total_amount tm ON tm.total_transaction_id = p.payment_transaction_id LEFT JOIN events e ON ti.ticket_event_id = e.event_id LEFT JOIN payment_types pt ON pt.payment_type_id = p.payment_payment_type_id LEFT JOIN promoters pro ON e.event_promoter_id = pro.promoter_id LEFT JOIN voided_transactions vt ON t.transaction_id = vt.voided_transaction_id WHERE DATE(p.payment_datetime) >= '2019-10-08' AND DATE(p.payment_datetime) <= '2019-10-08' AND ticket_status IN ('done','paid_online','voided','paid') AND ttp.ticket_type_group = 0 AND total_amount != 0 AND p.payment_branch = '1' AND ti.ticket_user_id != 1 GROUP BY p.payment_id, pid) AS a GROUP BY a.payment_type_type, event_id ORDER BY payment_type_type ASC, total_amount DESC");
		$result = $query->result(); 
		echo $this->db->last_query();
		// echo count($result);
		echo "<pre>";
		print_r($result);
	}
	
	function update_trans_date($transaction_id = false){
		$query = $this->db->query(" select transaction_date from transactions where transaction_id = $transaction_id");
		$transaction_date = $query->row('transaction_date'); 
		
		$this->db->query("update historical_transactions set transaction_date = '".$transaction_date."' where transaction_id = $transaction_id");
		$this->db->query("update historical_tickets set ticket_date_entered = '".$transaction_date."' where ticket_transaction_id = $transaction_id");
		$this->db->query("update historical_payments set payment_datetime = '".$transaction_date."' where payment_transaction_id = $transaction_id");
		$this->db->query("update historical_charges set charge_datetime = '".$transaction_date."' where charge_transaction_id = $transaction_id");
		// echo $transaction_date = $result->transaction_date();
	}
	
	function update_charge($transaction_id = false){
		$query = $this->db->query(" select transaction_date from transactions where transaction_id = $transaction_id");
		$transaction_date = $query->row('transaction_date'); 
		
		$this->db->query("update charges set charge_datetime = '".$transaction_date."' where charge_transaction_id = $transaction_id");
		// echo $transaction_date = $result->transaction_date();
	}
	 
	//new
	function generate_txtfile($branch_id = false){ //manual text file form
		ini_set("memory_limit","4000M");
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Generate Txt file";
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'Date',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'branch_code',
				'label'   => 'Branch Code',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			
			array(
				'field'   => 'branch_id',
				'label'   => 'Branch',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('generate_txt', $data);
		}else{
			 
			$this->generate();
			
		}
	}
   
	function generate(){
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Generate Txt file";
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$data['date'] = $date = $this->input->post('date_from');
		$branch_id = $this->input->post('branch_id');
		$data['branch_code'] = $this->input->post('branch_code');
				
		$result = $this->sap->get_all($branch_id,$date);
 	
		
		if(empty($result)){
			
			die('No transactions today');
		}
		
		//remove duplicates
 
		foreach($result as $x){
			
			foreach($x as $key=>$value){
			
				$result2[$x->id . $x->payment_id][$key] = $value;

			}
			
		}
		 
		
	
		
		//merge same transaction and payment type
		foreach($result2 as  $y){
			
			 
			  
			
			foreach($y as $key=>$value){
			
				if($key == 'payment_amount' || $key == 'payment_amount_voided'){
					if(isset($result3[$y['transaction_id'] . $y['payment_type_id']][$key])){ 
						$result3[$y['transaction_id'] . $y['payment_type_id']][$key] += $value; 
					}else{
						$result3[$y['transaction_id'] . $y['payment_type_id']][$key] = $value; 
					}
				}else{ 
					$result3[$y['transaction_id'] . $y['payment_type_id']][$key] = $value;
				}
			}
			
			
			 
		}
		 
		// echo '<pre>';
		// print_r($result3);
		// echo '</pre>';
		// die();
		
		
		
		
		/* 
		$samed = [];
		foreach($result3 as $key=>$value){
			if($value == 0){
				$samed[]= $key;
			}
		}
		
	*/
		//convert array to object
		foreach($result3 as $x){
			
 
			$final[] = (object) $x;
			 
		} 
		
		
			 	
		 // echo '<pre>';
		// print_r($final);
		// echo '</pre>';
		// die();
		
		
		
		$data['result'] = $final;
		
		
		$this->load->view('sap',$data);
				
 	}
	
	//cron
	function save_sap_txtfile($branch_id,$branch_code){
		// unlink("resources/sapSMTicketsSMKL01022019.txt");
		 
		$date = date('mdY',strtotime("-1 days"));
		$header = 'SMTickets'.$branch_code.$date.'.txt';
		// $this->load->view('sap_test');
		file_put_contents("resources/sap/".$header, file_get_contents(base_url()."sap/generate_auto/$branch_id/$header/$branch_code"));
		// file_put_contents("resources/sap".$header, file_get_contents(base_url()."sap/export_sap_report_test/".$branch_id.'/'.$header));
	}
	
	function generate_txtfile_auto(){ //cron url
 
		ini_set("memory_limit","4000M");
		//ini_set('memory_limit', '-1');
		$result = $this->sap->get_sap_branches();
		 
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			$this->save_sap_txtfile($res->branch_account_id, $branch_code);
			
		}
		 
		
	}

	function generate_auto($branch_id = false , $header = false, $branch_code = false){
		
		if(!$branch_id || !$header || !$branch_code){
			return false;
		}
		
		$this->load->helper('file');

		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header.'"');
		
		$data['date'] = $date = date('Y-m-d',strtotime("-1 days"));
		$data['branch_code'] = $branch_code;
	
		$result = $this->sap->get_all($branch_id,$date);
		 
		
		if(empty($result)){
			
			die();
		}
		
		//remove duplicates
 
		foreach($result as $x){
			
			foreach($x as $key=>$value){
			
				$result2[$x->id . $x->payment_id][$key] = $value;

			}
			
		}
		 
		
	
		
		//merge same transaction and payment type
		foreach($result2 as  $y){
			
			 
			  
			
			foreach($y as $key=>$value){
			
				if($key == 'payment_amount' || $key == 'payment_amount_voided'){
					if(isset($result3[$y['transaction_id'] . $y['payment_type_id']][$key])){ 
						$result3[$y['transaction_id'] . $y['payment_type_id']][$key] += $value; 
					}else{
						$result3[$y['transaction_id'] . $y['payment_type_id']][$key] = $value; 
					}
				}else{ 
					$result3[$y['transaction_id'] . $y['payment_type_id']][$key] = $value;
				}
			}
			
			
			 
		}
		 
	 
		foreach($result3 as $x){
			
 
			$final[] = (object) $x;
			 
		} 
		
		
	 
		
		
		
		$data['result'] = $final;
		
		
		$this->load->view('sap',$data);
				
 	}
	
}

/* End of file reports.php */
/* Location: ./application/controllers/reports.php */