<?php

class Report_special extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->database('default');
		$this->load->model('users_model', 'users');
		$this->load->model('reports_model', 'reports');
		$this->load->model('ticket_types_model', 'ticket_types');
		
 	}
	 
	 
		function DIM_SM_TICKETS(){
		
		$cap = array();
		$pot = array();
		
		
		$this->load->helper('file');

		$header = 'DIM_SM_TICKETS_DAILY_SALES_YYYYMMDD.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		 
		$separator = ';'; 
		
		
	 
		 $query = $this->db->query("
		
		select  
		e.event_id as EVENT_ID,
		e.event_title as EVENT_DESC,
		e.event_type as EVENT_TYPE,
		e.event_date_time as DATE_TIME,
		v.venue_name as VENUE_DESC,
		p.promoter_name as PROMOTER_DESC 
		from

		events e

		inner join venues v on v.venue_id = e.event_venue_id
		inner join promoters p on p.promoter_id = e.event_promoter_id
		
		where e.event_id in (10,158,688,839,840,1332,1333,1428,1793,1933,2079)
		");
		
		// echo '<pre>';
		// print_r($query->result());
		// echo '</pre>';
		 
		$events = $query->result();
		
		foreach($events as $x){
		
			 
						$this->db->select('
					pr.price_id
					, pr.price_name
					, pr.price_price
					, pr.price_sections
					, pr.price_event_id
					');
				$this->db->where_in('pr.price_event_id', $x->EVENT_ID);
				$this->db->order_by('pr.price_price', 'desc');
				$price_types = $this->db->get('prices pr')->result();
					
				$arrsubsection = array();
			foreach($price_types as $row) {
				$subsection = unserialize($row->price_sections);
				$row->price_sections = $subsection;	
				$arrsubsection = array_merge($arrsubsection, $subsection);
			}
		// SECTION LIST
			$this->db->select('
				s.section_id
				, s.section_capacity
				, s.section_available
				, s.section_type
			');
			$this->db->where_in('s.section_id', $arrsubsection);
			$query = $this->db->get('sections s')->result();
			
			//echo "<!-- SECTION LIST \n";
			//echo $this->db->last_query();
			//echo "\n-->\n";
			
			foreach($query as $section) {
				$data_sectionlist[$section->section_id][0] = $section->section_capacity;
				
				if (strtolower($section->section_type) == "reserved") { 
					$data_sectionlist[$section->section_id][1] = $section->section_available;
				} else {
					$data_sectionlist[$section->section_id][1] = $section->section_capacity;
				}
				
				$data_sectionlist[$section->section_id][2] = 0; // taken/used seats
				// identify section type
				$data_sectionlist[$section->section_id][3] = $section->section_type;
			}
			$this->db->select('ticket_section_id, count(ticket_id) as taken');
			$this->db->where_in('ticket_section_id', $arrsubsection);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$this->db->group_by('ticket_section_id');
			$query = $this->db->get('tickets')->result();
			
			// echo $this->db->last_query();
			foreach($query as $section) {
				$tmp_section_type = $data_sectionlist[$section->ticket_section_id][3];
				if (strtolower($tmp_section_type) == "reserved") { 
					// no need to recompute availability
				} else {
					$data_sectionlist[$section->ticket_section_id][1] -= $section->taken;
				}
				$data_sectionlist[$section->ticket_section_id][2] = $section->taken;
			}
			  
				$totalcapacity = 0;
				$totalavailability = 0;
				$totalpotential = 0;

				foreach ($price_types as $ptype)
				{
					$pricename = $ptype->price_name;
					$price = $ptype->price_price;
					$pid = "$pricename ($price)";
					$pricesections = $ptype->price_sections;
					
					$pricelist[$pid] = array($pricename, $price);

					if (!isset($seat_capacity[$pid])) {
						$seat_capacity[$pid] = 0;
					}
					
					if (!isset($availability[$pid])) {
						$availability[$pid] = 0;
					}
					
					if (!isset($potential[$pid])) {
						$potential[$pid] = 0;
					}
					
					foreach ($pricesections as $sid) {	

						if (!isset($data_sectionlist[$sid][0])) {
						$capacity = 0;
						$availability[$pid] += 0;
						}else{ 
						$capacity = $data_sectionlist[$sid][0];
						$availability[$pid] += $data_sectionlist[$sid][1]; 
						}
						
						
						$seat_capacity[$pid] += $capacity;
						$potential[$pid] += ($capacity * $price);
					}
				}

				$strHeaderHTML = '';
				$price_type_count = 0;

				$tmp_grandT = 0;
				$tmp_resT = 0;
				foreach($pricelist as $k=>$v) {
				
					$pid = $k;
					$countG = 0;
					$countR = 0;
					
				
					if (isset($data_tixcountgrid[$pid])) {
						foreach($data_tixcountgrid[$pid] as $grouparr) {
							foreach($grouparr as $temparr) {
								if (is_array($temparr)) {
									$countG += count($temparr);
								}
							}
						}
					}
					
					$tmp_grand = $countG;
					$tmp_grandT += $countG;
					if (!isset($reservedcount[$pid])) {
						$countR = 0;
					}
					else {
						$countR = count($reservedcount[$pid]);
					}

					$tmp_res = $countR;
					$tmp_resT += $countR;

					$tmp_cap = $seat_capacity[$k];
					// $tmp_ava = number_format($availability[$k]);
					$tmp_pot = number_format($potential[$k]);

					$tmp_ava = $tmp_cap - $tmp_grand - $tmp_res;
					
					$strHeaderHTML .= "<th colspan=3 class=center width=180>
						$v[0] ($tmp_ava) <br>
						Capacity($tmp_cap) / Potential ($tmp_pot)
					</th>";
				
					$price_type_count++;
					
					


				
				
				}

				$scapacity['total'] = array_sum($seat_capacity);
				$availability['total'] = array_sum($availability);
				$potential['total'] = array_sum($potential);
				
				$tmp_cap =$scapacity['total'];
				// $tmp_ava = number_format($availability['total']);
				$tmp_pot = number_format($potential['total']);
				
				$tmp_ava = $tmp_cap - $tmp_grandT - $tmp_resT;
			  
			  
			  
				 $cap[$x->EVENT_ID] = $tmp_cap;
				 $pot[$x->EVENT_ID] = $tmp_pot;
			  
			  
		}
		
		// echo $pot[2141];
		
		echo "EVENT_ID $separator";
		echo "EVENT_DESC $separator";
		echo "EVENT_TYPE $separator";
		echo "DATE_TIME $separator";
		echo "VENUE_DESC $separator";
		echo "PROMOTER_DESC $separator";
		echo "SEAT_CAP $separator";
		echo PHP_EOL;
		
		foreach($events as $x){
		
		

		
		$venue = str_replace(",","",$x->VENUE_DESC);
		$promoter = str_replace(",","",$x->PROMOTER_DESC);
		$capacity = str_replace(",","",$cap[$x->EVENT_ID]); 
		
		echo "$x->EVENT_ID $separator";
		echo "$x->EVENT_DESC $separator";
		echo "$x->EVENT_TYPE $separator";
		echo "$x->DATE_TIME $separator";
		echo "$venue $separator";
		echo "$promoter $separator";
		echo "$capacity $separator";
		echo PHP_EOL;
	 
		}
		
	}

		function FCT_SM_TICKETS($eventgroup = false, $branchkey = "", $dl = false){
		
			// iconv_set_encoding("internal_encoding", "UCS-2LE");
			// iconv_set_encoding("output_encoding", "UCS-2LE");

			$data['page_title'] = 'FCT_SM_TICKETS_DAILY_SALES_YYYYMMDD';
	 
			$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
			 
			// check user session
			// $this->users->check_session(array('Admin','Super Admin', 'Finance'));
				
	 
		 
			$this->load->helper('file');
			$datet = date('Y-m-d');
				
			$header = "FCT_SM_TICKETS_DAILY_SALES [$datet].csv";
	 
			$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				
			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		 
	 

					
			$this->load->view('fct_sm_ticket_daily_sales',$data);
				 

				 
		 
		
		}
		
	
		
		
}

/* End of file events.php */
/* Location: ./application/controllers/events.php */

