<?php

class promo extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
 		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('sections_model', 'sections');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('events_model', 'events');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('customers_model', 'customers');
		$this->load->model('reservations_model', 'reservations');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('printer_model', 'printer');
		$this->load->model('eplus_model', 'eplus');
		$this->load->model('promos_model', 'promo');
		$this->load->database('default');

	 
	}
 	
	function add_discount($sc_count=false, $pwd_count=false, $p_count=false, $ath_count=false, $mov_count=false){
	 
			//7127 maroon 5 
			//11438,11439, 11440 onefc
			$events = array(8868,8044,5485, 5487, 5731,5807, 5823, 6769, 6762, 6819, 6850 , 7127,7992,11295,11438,11439, 11440);
			 
			
			if (in_array($this->session->userdata('cei'), $events) && $sc_count < 1 && $pwd_count < 1 && $ath_count < 1 && $mov_count < 1){
			
				$p_count = 1;
			
			}
	 
	 
			$data['sc_count'] = $sc_count; 
			$data['pwd_count'] = $pwd_count; 
			$data['p_count'] = $p_count; 
			$data['ath_count'] = $ath_count; 
			$data['mov_count'] = $mov_count;  			
			$this->load->view('promo_dialog',$data);
		  
	}
	
	
	function add_promo(){
	
		$this->session->set_userdata('discountData', $_POST);
		$sc_count = $this->input->post('sc_count');
		$pwd_count = $this->input->post('pwd_count');
		$p_count = $this->input->post('p_count');
		$ath_count = $this->input->post('ath_count');
		$mov_count = $this->input->post('mov_count');
		
		$config = array();
		$senior_array = array(
			array(
				'field'   => 'sc_id[]',
				'label'   => 'Senior ID',
				'rules'   => 'trim|required|alpha_dash|strip_tags|min_length[2]|max_length[20]|callback__senior_check'
			),
			array(
				'field'   => 'sc_lname[]',
				'label'   => 'Senior LastName',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[80]'
			),
			
			array(
				'field'   => 'sc_fname[]',
				'label'   => 'Senior Firstname',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[20]'
			),
			array(
				'field'   => 'sc_bdate[]',
				'label'   => 'Senior Birthdate',
				'rules'   => 'trim|required|strip_tags|min_length[10]|max_length[20]'
			),
		);
		
		$pwd_array = array(
			array(
				'field'   => 'pwd_id[]',
				'label'   => 'PWD ID',
				'rules'   => 'trim|required|alpha_dash|strip_tags|min_length[2]|max_length[20]|callback__pwd_check'
			),
			array(
				'field'   => 'pwd_lname[]',
				'label'   => 'PWD LastName',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[80]'
			),
			
			array(
				'field'   => 'pwd_fname[]',
				'label'   => 'PWD Firstname',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[20]'
			),
			 
		);
		
		$promo_array = array(
				array(
				'field'   => 'promo_code[]',
				'label'   => 'Promo Code',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]|callback__promo_check'
			), 
		);
		
		$athlete_array = array(
			array(
				'field'   => 'ath_id[]',
				'label'   => 'Athlete ID',
				'rules'   => 'trim|required|alpha_dash|strip_tags|min_length[2]|max_length[20]|callback__athlete_check'
			),
			array(
				'field'   => 'ath_lname[]',
				'label'   => 'Athlete LastName',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[80]'
			),
			
			array(
				'field'   => 'ath_fname[]',
				'label'   => 'Athlete FirstName',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[20]'
			),
			array(
				'field'   => 'ath_bdate[]',
				'label'   => 'Expiration Date',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]|callback__check_date_valid'
			),
			 
		);
		
		$mov_array = array(
			array(
				'field'   => 'mov_id[]',
				'label'   => 'Medal Of Valor ID',
				'rules'   => 'trim|required|alpha_dash|strip_tags|min_length[2]|max_length[20]|callback__mov_check'
			),
			array(
				'field'   => 'mov_lname[]',
				'label'   => 'MOV LastName',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[80]'
			),
			
			array(
				'field'   => 'mov_fname[]',
				'label'   => 'MOV FirstName',
				'rules'   => 'trim|required|alpha_numeric_spaces|strip_tags|min_length[2]|max_length[20]'
			),
			 
		);
		
		
		if($sc_count>0){$config = array_merge($config,$senior_array);}
		if($pwd_count>0){$config = array_merge($config,$pwd_array);}
		if($p_count>0){$config = array_merge($config,$promo_array);}
		if($ath_count>0){$config = array_merge($config,$athlete_array);}
		if($mov_count>0){$config = array_merge($config,$mov_array);}

		 
		$this->form_validation->set_rules($config); 

 		$this->form_validation->set_error_delimiters('', '');
		if ($this->form_validation->run() == FALSE)
		{
		 
			
			echo validation_errors();
			 
 		}
		else
		{
		
			$this->promo->add_promo();
			echo 'ok';
		}
	
	}

	
	function array_has_dupes($array) {
 	   
	 
	   if(count(array_unique($array))<count($array))
		{
			return true;
		}
		else
		{
			return false;
		}
	   
	   
	}
	
	 
	function _promo_check($str)
	{	
		// $qr_exist = $this->promo->is_promo_code_exist($str);
		
		$str2 = $this->input->post('promo_code');
		$eid = $this->session->userdata('cei');
		$dup = $this->array_has_dupes($str2); 

		$turok = array(5577,5628,5627,5630,5629,5631,5632,5634,5633,5636,5635,5638,5637,5640,5639);
		$galaxy_battles = array(6255, 6256, 6257 , 6254);

		if($eid == 5732){
			//SCOUT MUSIC FEST
			$qr_exist = $this->promo->is_promo_code_exist_static($str);
			
		}elseif($eid == 5661){
			//in the mix
			$qr_exist = $this->promo->is_promo_code_exist_static_itm($str);
			
		}elseif($eid == 5731){
			
			$qr_exist = $this->promo->is_promo_code_exist_ariana($str);
			
		}elseif(in_array($eid, $turok)){
		
			$qr_exist = $this->promo->is_promo_code_exist_turok($str);
		
		}elseif($eid == 6821){
			
			$qr_exist = $this->promo->is_promo_code_exist_one_legends($str);
			
		}elseif($eid == 6054){
			
			$qr_exist = $this->promo->is_promo_code_exist_mb($str);
			
		}elseif($eid == 5735){
			
			$qr_exist = $this->promo->is_promo_code_exist_laurus($str);
			
		}elseif(in_array($eid, $galaxy_battles)){
			
			$qr_exist = $this->promo->is_promo_code_exist_gb($str);
			
		}elseif($eid == 6335){
			//joe and tamiya
			$qr_exist = $this->promo->is_promo_code_exist_joe($str);
			
		}elseif($eid == 6411){
			 
			$qr_exist = $this->promo->is_promo_code_exist_celine($str);
			
		}elseif($eid == 6299){
			 
			$qr_exist = $this->promo->is_promo_code_exist_katy($str);
			
		}elseif($eid == 6895){
			 
			$qr_exist = $this->promo->is_promo_code_exist_neon($str);
			
		}elseif($eid == 6730){
			 
			$qr_exist = $this->promo->is_promo_code_exist_bowling($str);
			
		}elseif($eid == 6819){ //acon
			 
			$qr_exist = $this->promo->is_promo_code_exist_acon($str);
			
		}elseif($eid == 7131){ //PLUS63 HALLOWEEN & SINULOG
			 
			$qr_exist = $this->promo->is_promo_code_exist_plus($str);
			
		}elseif($eid == 7132){ //PLUS63 HALLOWEEN & SINULOG
			 
			$qr_exist = $this->promo->is_promo_code_exist_plus($str);
			
		}elseif($eid == 7027){ //Project 5Star | Ticket Promo Mechanics
			 
			$qr_exist = $this->promo->is_promo_code_exist_project($str);
			
		}elseif($eid == 4137){ //Nice to meet you promo 6890
			 
			$qr_exist = $this->promo->is_promo_code_exist_pdmn($str);
			
		}elseif($eid == 7327){ //LAUV CEBU
			 
			$qr_exist = $this->promo->is_promo_code_exist_lauv($str);
			
		}elseif($eid == 7341){ //JASON MRAZ
			 
			$qr_exist = $this->promo->is_promo_code_exist_jason($str);
			
		}elseif($eid == 6998){ //KAMIKAZEE
			 
			$qr_exist = $this->promo->is_promo_code_exist_kamikazee($str);
			
		}elseif($eid == 7806){ //BLACKPINK - PHILAM
			 
			$qr_exist = $this->promo->is_promo_code_exist_blackpink($str);
			
		}elseif(in_array($eid, array(7346,7342, 7349, 7357 , 7358, 7359,7360,7361,7362,7347,7508,7509,7510,7511,7512,7349,7514,7515,7516,7517,7518,7519,7534,7540,7541,7568,7569,7570))){ // madame butterfly
			 
			$qr_exist = $this->promo->is_promo_code_exist_madame($str);
			
		}elseif($eid == 7607){ //ONE: ROOTS OF HONOR
			 
			$qr_exist = $this->promo->is_promo_code_exist_onehero($str);
			
		}elseif($eid == 7526){ //Troye Sivan Fan Club pre sale
			 
			$qr_exist = $this->promo->is_promo_code_exist_sevenfivetwosix($str);
			
		}elseif($eid == 7504){ //DREAMCATCHER 
			 
			$qr_exist = $this->promo->is_promo_code_exist_sevenfivezerofour($str);
			
		}elseif($eid == 7503){ //BRAVE22 
			 
			$qr_exist = $this->promo->is_promo_code_exist_sevenfivezerothree($str);
			
		}elseif($eid == 7847){ //BRAVE22 
			 
			$qr_exist = $this->promo->is_promo_code_exist_chain($str);
			
		}elseif($eid == 7793){ //IV of sapdes 
			 
			$qr_exist = $this->promo->is_promo_code_exist_ivofspades($str);
			
		}elseif($eid == 7845){ //IV of spades Davao
			 
			$qr_exist = $this->promo->is_promo_code_exist_ivofspadesdavao($str);
			
		}elseif($eid == 7974){ //cosplay mania 2019
			 
			$qr_exist = $this->promo->is_promo_code_exist_cosplaymania($str);
			
		}elseif($eid == 7985){ // After the burial
			 
			$qr_exist = $this->promo->is_promo_code_exist_aftertheburial($str);
			
		}elseif($eid == 7992){ // EXO Exploration
			 
			$qr_exist = $this->promo->is_promo_code_exist_exo($str);
			
		}elseif($eid == 8044){ //COKE STUDIO MUSIC FESTIVAL 
			 
			$qr_exist = $this->promo->is_promo_code_exist_coke($str);
			
		}elseif($eid == 8051){ //EXO day2
			 
			$qr_exist = $this->promo->is_promo_code_exist_exo2($str);
			
		}elseif($eid == 8052){ //NICKELODEON SLIME FEST
			 
			$qr_exist = $this->promo->is_promo_code_exist_slime($str);
			
		}elseif($eid == 8240){ //GOT 7
			 
			$qr_exist = $this->promo->is_promo_code_exist_got($str);
			
		}elseif($eid == 8003){ // Scout creative talks
			 
			$qr_exist = $this->promo->is_promo_code_exist_scout($str);
			
		}elseif($eid == 8721){ // Super show 8
			 
			$qr_exist = $this->promo->is_promo_code_exist_suju($str);
			
		}elseif($eid == 8647){ // THE ROSE
			 
			$qr_exist = $this->promo->is_promo_code_exist_rose($str);
			
		}elseif($eid == 8868){ //SEVENTEEN
			 
			$qr_exist = $this->promo->is_promo_code_exist_seventeen($str);
			
		}elseif($eid == 8922){ //ONE: CODE OF HONOR
			 
			$qr_exist = $this->promo->is_promo_code_code_of_honor($str);
			
		}elseif($eid == 8784){ //alt philippines
			 
			$qr_exist = $this->promo->is_promo_code_alt($str);
			
		}elseif($eid == 8929){ //CARMINA BURANA MARCH 7
			 
			$qr_exist = $this->promo->is_promo_code_exist_carmina($str);
			
		}elseif($eid == 8930){ //CARMINA BURANA MARCH 8
			 
			$qr_exist = $this->promo->is_promo_code_exist_carmina($str);
			
		}elseif($eid == 8927){ //BILLIE
			 
			$qr_exist = $this->promo->is_promo_code_exist_billie($str);
			
		}elseif($eid == 8947){ //ALANIS
			 
			$qr_exist = $this->promo->is_promo_code_exist_alanis($str);
			
		}elseif(in_array($eid,[11438,11439,11440])){ //ONEFC
			 
			$qr_exist = $this->promo->is_promo_code_exist_onefc($str);
			
		}else{
			
			$qr_exist = $this->promo->is_promo_code_exist($str);
		
		}
 
		if($dup)
		{
			$this->form_validation->set_message('_promo_check', "Promo Code must be unique");
			return FALSE;
		}

		
		if ($qr_exist)
		{
			$qrcode = explode("|", $qr_exist);
			$result = $qrcode[1];
			$qrcode = $qrcode[0];
			
		 
			if($result == 'ok'){ 
 				return TRUE;
			}
			
			if($result == 'not'){ 
				$this->form_validation->set_message('_promo_check', "PromoCode $qrcode is already used for this event");
				return FALSE;
			}elseif($result == 'selected'){ 
			
				$this->form_validation->set_message('_promo_check', "PromoCode $qrcode is currently in use");
				return FALSE;
			
			}elseif($result == 'qty'){ 
			
				$this->form_validation->set_message('_promo_check', "Sorry, please select 2 tickets");
				return FALSE;
			
			} 
	  
		}
		else
		{
			// coke event promo
			if($eid==7689){
				$this->form_validation->set_message('_promo_check', "PromoCode $str could not be recognized/expired. Please try other sections or ticket type.");
			}else{
				$this->form_validation->set_message('_promo_check', "PromoCode $str could not be recognized. Please check expiry, try other sections or ticket type.");
			}
			return FALSE;
		}
	}	
	

	function gtqr_ticket_types($claim = false, $transaction_id = false)
	{
		 
		$_POST = $this->session->userdata('discountData'); 
		 
		 
		// print_r($_POST);
		// die();
		
		
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}	

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		 

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		
			// get price info
			$data['price'] =  $this->prices->get($cpi);
			
		
			// get ticket types
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
		}
		else
		{
			
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));

			// get price info
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		
	        // get ticket types
	        $ticket_types = $this->ticket_types->get_ticket_types($this->session->userdata('cei'));
		}
		
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
        $event_ticket_types = unserialize($data['price']->event_ticket_types);
 
        foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
        $data['ticket_types'] = $tt_array;
		
		 
			
		if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
		{
			// update db
			$this->tickets->edit_ticket_type();
			 
			
			// redirect
			redirect('gtqr_transactions/customer_info/');
		}
		else
		{			
			// update db
			$this->tickets->edit_ticket_type();
		
			// redirect
			redirect('gtqr_transactions/payment/'.$claim);
		}	
 
	}
	
	 function check_gc($gc_code,$gc_set){
	$gc_code_array = $this->promo->view_gc_code(	$gc_code 	);
	if($gc_code_array){
		if(	$gc_code_array->gc_status == "available" && $gc_code_array->gc_reference_info == 0 && $gc_code_array->gc_set == $gc_set	){
			echo $gc_code_array->gc_amount;
		}else if($gc_code_array->gc_status == "selected"){
			echo "invalid. currently being used";
		}else if($gc_code_array->gc_status == "used"){
			echo "invalid. already used";
		}
	}else{
		echo "invalid. non-existent";
	}

 }
 
	 function select_gc($gc_code,$gc_set){
		$affected_row = $this->promo->select_gc_code(	$gc_code, $gc_set 	);

		if($affected_row > 0){
			echo "success";
		}else{
			echo "failed";
		}
		
	 }
	 
	 function unselect_gc($gc_code,$gc_set){
		$affected_row = $this->promo->unselect_gc_code(	$gc_code, $gc_set 	);

		if($affected_row > 0){
			echo "success";
		}else{
			echo "failed";
		}
		
	 }
	
	function reset_promo($code,$transaction_id = FALSE){
		
		$affected_row = $this->promo->reset_code($code,$transaction_id);

		if($affected_row > 0){
			echo "success";
		}else{
			echo "failed";
		}
	}
	
	function _promo_per_trans(){
		$this->form_validation->set_message('_promo_per_trans', "One ticket per transaction only.");
		return FALSE;
	}
	
	function ticket_types($claim = false, $transaction_id = false)
	{
		 
		$_POST = $this->session->userdata('discountData'); 
		 
		 
		// print_r($_POST);
		// die();
		
		
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}	

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		 

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		
			// get price info
			$data['price'] =  $this->prices->get($cpi);
			
		
			// get ticket types
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
		}
		else
		{
			
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));

			// get price info
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		
	        // get ticket types
	        $ticket_types = $this->ticket_types->get_ticket_types($this->session->userdata('cei'));
		}
		
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
        $event_ticket_types = unserialize($data['price']->event_ticket_types);
 
        foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
        $data['ticket_types'] = $tt_array;
		
		 
			
		if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
		{
			// update db
			$this->tickets->edit_ticket_type();
			 
			
			// redirect
			redirect('transactions/customer_info/');
		}
		else
		{			
			// update db
			$this->tickets->edit_ticket_type();
			
			 
			redirect('transactions/payment/'.$claim);
			 
			// redirect
		}	
 
	}
	
	
	function ticket_types_upgrade($claim = false, $transaction_id = false)
	{
		 
		$_POST = $this->session->userdata('discountData'); 
		 
		 
		// print_r($_POST);
		// die();
		
		
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}	

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		 

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		
			// get price info
			$data['price'] =  $this->prices->get($cpi);
			
		
			// get ticket types
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
		}
		else
		{
			
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));

			// get price info
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		
	        // get ticket types
	        $ticket_types = $this->ticket_types->get_ticket_types($this->session->userdata('cei'));
		}
		
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
        $event_ticket_types = unserialize($data['price']->event_ticket_types);
 
        foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
        $data['ticket_types'] = $tt_array;
		
		 
			
		if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
		{
			// update db
			$this->tickets->edit_ticket_type();
			 
			
			// redirect
			redirect('transactions/customer_info/');
		}
		else
		{			
			// update db
			$this->tickets->edit_ticket_type();
			
			 
			redirect('upgrade/payment/'.$claim);
			 
			// redirect
		}	
 
	}
	
	
	//SC
	function _senior_check()
	{	
		$str = $this->input->post('sc_id');
		$senior_exists = $this->promo->is_senior_id_exist($str);
		$dup = $this->array_has_dupes($str);
		$senior_name = $this->promo->is_senior_name_exist();
		if ($senior_exists)
		{
			$this->form_validation->set_message('_senior_check', "Senior ID $senior_exists is already used for this event");
			return FALSE;
		}
		
		if($dup)
		{
			$this->form_validation->set_message('_senior_check', "Senior ID must be unique");
			return FALSE;
		}
		
		if ($senior_name)
		{
			$this->form_validation->set_message('_senior_check', "Senior $senior_name->senior_fname $senior_name->senior_lname already used discount for this event");
			return FALSE;
		}
		
		
		return TRUE;
		
	}	
	 
  
	//PWD
	function _pwd_check($str)
	{	
		$str = $this->input->post('pwd_id');
		$pwd_exists = $this->promo->is_pwd_id_exist($str);
		$dup = $this->array_has_dupes($str);
		
		if ($pwd_exists)
		{
			$this->form_validation->set_message('_pwd_check', "PWD ID $pwd_exists is already used for this event");
			return FALSE;
		}
		
		if ($dup)
		{
			$this->form_validation->set_message('_pwd_check', "PWD ID must be unique");
			return FALSE;
		}
		
		return TRUE;
		
	}	
	  
	
	//athlete's discount
	function _athlete_check($str)
	{	
		$str = $this->input->post('ath_id');
		$athlete_id = $this->promo->is_athlete_id_exist($str);
		$dup = $this->array_has_dupes($str);

		if ($athlete_id)
		{
			$this->form_validation->set_message('_athlete_check', "Athlete ID $athlete_id is already used for this event");
			return FALSE;
		}
		 
		if ($dup)
		{
			$this->form_validation->set_message('_athlete_check', "Athlete ID must be unique");
			return FALSE;
		}
		
		return TRUE;
		
	}
 
	function _check_date_valid($date) {
        
		if (date('Y-m', strtotime($date)) == $date) {
			$expiration = date("Y-m", strtotime($date));
				
			if($expiration < date("Y-m")){
				$this->form_validation->set_message('_check_date_valid', 'Athlete ID used has been expired.');
				return FALSE;
			}else{
				return TRUE;
			}
		} else {
			$this->form_validation->set_message('_check_date_valid', 'The {field} must be in format "yyyy-mm"');
			return FALSE;
		}
	}
	
	//Medal of Valor 
	 
	function _mov_check($str)
	{	
		$str = $this->input->post('mov_id');
		$mov_id = $this->promo->is_mov_id_exist($str);
		$dup = $this->array_has_dupes($str);
		
		if ($mov_id)
		{
			$this->form_validation->set_message('_mov_check', "Medal of Valor ID $mov_id is already used for this event");
			return FALSE;
		}
		
		if ($dup)
		{
			$this->form_validation->set_message('_mov_check', "Medal of Valor ID must be unique");
			return FALSE;
		}
		
		return TRUE;

	}	

}
