<?php

class Printer extends CI_Controller {

	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('generator_model', 'ticket_generator');
		$this->load->model('events_model', 'events');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('printer_model', 'printer');
		$this->load->model('transactions_model', 'transaction');
		$this->load->model('admin_model', 'admin');
		$this->load->database('default');
	}
 
	function payment_done_db2xml2pdf($yearmonth = false, $id = false, $trans_id = false){
		// called by PrinterApp - remove .pdf filename extension
		$trans_id = str_replace(".pdf","",$trans_id);
		$ids = explode("-",$id);
		$id = $ids[0];
		
		$xmldata = '';
		$validcall = false;
		if (($trans_id > 0) && ($yearmonth > 0) && ($id > 0)){
			// validate transaction 
			$validcall = $this->ticket_generator->validatePaidTransactionWithXML($yearmonth, $id, $trans_id);
		}
		
		if (!$validcall) {
			show_404();
			// echo $this->db->last_query();
			die("invalid call");
		}
		
		if ($yearmonth && $id) {
			
			$event_id = $this->tickets->get_event_id($trans_id);
			$data['event'] = $this->events->get_event_details($event_id->ticket_event_id);
			$data['date_validity'] = $this->transaction->get_date_validity($trans_id);
		
		
			$this->db->where("xml_trans_id", $trans_id);
			$this->db->where("xml_yearmonth", $yearmonth);
			$this->db->where_in("xml_id", $ids);
			$query = $this->db->get("generator");
		
			$this->load->library('simplexml');  
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
				
				$content[] = $this->simplexml->xml_parse($xmldata, "&amp");
				
			}
			
			//check if has access code 
			if($data['event']->event_online_concert == 1){
				
 				$this->db->where('online_code_transaction_id',$trans_id);
				$query = $this->db->get('online_codes');
				
				if($query->num_rows() > 0){
					$a = $query->result();
					$data['access_codes'] = [];
					foreach($a as $x){
						
						$data['access_codes'][$x->online_code_ticket_id] =  $x->online_code;
					}
				}else{
					
					die('No ACCESS CODE generated.');
					
				}

			 
			}
			
			
		} else {
			die ("Invalid access.");
		}


		
		
		$data['layout'] = $content[0]['layout']['@attributes'];
		if(isset( $content[0]['ticket'][0])){
			$data['tickets']  = $content[0]['ticket'];
		} else {
			$data['tickets'][0]  = $content[0]['ticket'];
		}
		$this->load->helper('file'); 
		
	
		
		
		// echo '<pre>';
		// print_r($data['tickets']);
		// echo '</pre>';
		
		// die();
		// 4137
		//get customer info for harry styles
		if($event_id->ticket_event_id == 8046 || $event_id->ticket_event_id == 8112 || $event_id->ticket_event_id == 8240){  //EXO
		
			$this->db->select('customer_firstname, customer_lastname');
			$this->db->join('customers','transaction_customer_id = customer_id');
			$this->db->where('transaction_id',$trans_id);
			$customer = $this->db->get('transactions');
			$data['customer'] = $customer->row();
		}
		 
		$season_price = array(51107,51110,51108,51111,51112,50363,49991,49740,47804,47279,47278,46474,46473, 46555,46556,46557,46552,46553,46554,45610, 45600, 44378,44275,44318,44281,44279,44319,44320,44280,43736,43737,43738, 43726,43655, 43652, 43649,46056,46708,46701,46700,46707,46704,46703,47537,57023 , 57027,57347,59092,59093,58682,58686,59141,58683,58687,58680,58688,58684,58685);
		
		$season_ticket_type = array(1270, 1272, 1271, 1273);
		if($data['event']->season_pass == 1 || in_array($event_id->price_id, $season_price) || in_array($event_id->ticket_type_id, $season_ticket_type)){
		
			$data['content'] = $content;
			$this->load->view('pdf_rev_season_pass',$data);
		
		}elseif($event_id->price_package > 1){
		
			$data['count'] = $event_id->price_package;
			$this->load->view('printer_xml2pdf_dynamic',$data);
			
		}else{
		 
			$this->load->view('printer_xml2pdf',$data);
			
		}
		

	}

	
	function eventSample($event_id, $enableBG = false, $testmode = false){
		// $callparam = $_GET;
		//the path of the xml that will be converted to pdf
		 $url = base_url()."ticket_generator/eventSample/$event_id/$enableBG";
		// $url = "http://10.141.23.61/portal/mgi_alpha_3/" . "ticket_generator/eventSample/$event_id/$enableBG";
		
		// DIE(	$url	);
		
		$this->load->library('Httpcall');
		
		$callparam = array();
		$this->httpcall->do_http_get_request($url,$callparam);

		$xmldata = $this->httpcall->rawoutput;
		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");
		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
			
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		
		// $data["testmode"] = $testmode;
		$data["testmode"] = 1;
		if (!$testmode) {
			$this->load->helper('file');
			$this->output->set_header('Content-type: '.get_mime_by_extension('test.pdf'));
		}
		
		
		$data['event'] = $this->events->get_event_details($event_id);
		$dv_status = $this->events->get_valid_date_status($event_id);
		if($dv_status == 1){
			$data['date_validity'] = date("Y-m-d");
		}
	
		$this->load->view('printer_xml2pdf',$data);

	}


	function generate_card_details($transID = false)
	{
		
		
		// parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		 //get paramters needed	
		// $transactionID = $this->input->get('transID');
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		 
		$result = $this->printer->get_ticket_details($transID);
		
 
		
		$this->load->dbutil();
		$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		echo $this->dbutil->xml_from_result($result, $config);
		 
	 
	}
	
	function mark_as_released($transID = false){
		
		// $this->users->check_session(array('Admin','Super Admin', 'Seller', 'Manager', 'Finance'));
	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		
		 
		 
		
		$this->printer->insert_details($xml_data);
		
 
	 
	}
	
	function check_ticket_status(){
	
	$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		
		  
	    $result =  $this->printer->check_status($xml_data);
			
		// $this->load->dbutil();
		// $config = array (
			  // 'root'    => 'root',
			  // 'element' => 'row', 
			  // 'newline' => "\n", 
			  // 'tab'    => "\t"
		// );
			
		// echo $this->dbutil->xml_from_result($result, $config);
	 
	}
	
 
    //for print app 
    
	function mark_paid_done($trans_id = ''){
		
		if($trans_id == 'ticket.pdf'){ //for test print
			echo 1;
		} 
		elseif ($trans_id > 0 ) {
			// mark the transaction and tickets as Done
			$this->admin->mark_paid_transaction_done($trans_id);
			// $this->logs->add('Marked Done ' . $trans_id);
			
			// $message = 'Marked Paid Transaction ID #' . $trans_id . ' as Done. Please review status of your transaction.';
			// $this->session->set_flashdata('message', assemble_message($message));
			echo 1;
		}else{
			
			die('No Trans ID provided');
		}
		
		  
	}

} 

/* End of file printer.php */
/* Location: ./application/controllers/printer.php */
