<?php

class Poster extends CI_Controller
 {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('poster_model', 'poster');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('poster/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Poster';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['poster'] = $this->poster->get_poster();
		
		$this->load->view('poster_listing', $data);
	}
	
	function poster_active()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Poster';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['poster'] = $this->poster->get_poster_active();
		
		$this->load->view('poster_listing', $data);
	}
	
	function poster_inactive()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Poster';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['poster'] = $this->poster->get_poster_inactive();
		
		$this->load->view('poster_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 * @access	public
	 */
	function upload()
	{
		// prepare data for the template
		$data['page_title'] = 'Upload Poster';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'poster',
				'label'   => 'Poster',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Name of Poster',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('poster_upload', $data);
		}
		else
		{
			list($filename, $image_path, $filewh, $filesize) = $this->files->upload_poster();
			$this->poster->upload($filename, $image_path, $filewh, $filesize);
			$this->session->set_flashdata('message', assemble_message('Event poster has been successfully added'));
			redirect('poster/poster_active');
		}
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($poster_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Poster');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->poster->delete($poster_id);
		$this->session->set_flashdata('message', assemble_message('Poster has been successfully deleted'));
		redirect('poster/listing/');
	}	
	
	function active($poster_id = FALSE)
	{
		// log this
		$this->logs->add('Poster Active');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->poster->active($poster_id);
		$this->session->set_flashdata('message', assemble_message('Poster has been successfully activated'));
		redirect('poster/listing/');
	}
	
	/**
	 * inactive
	 *
	 * @access	public
	 */
	function inactive($poster_id = FALSE)
	{
		// log this
		$this->logs->add('Poster Inactive');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->poster->inactive($poster_id);
		$this->session->set_flashdata('message', assemble_message('Poster has been successfully deactivated'));
		redirect('poster/listing/');
	}
	
}

/* End of file logos.php */
/* Location: ./application/controllers/logos.php */	
