<?php

class Optimize extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->db = $this->load->database('default', TRUE);
		$this->load->model('events_model', 'events');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('prices_model', 'prices');
		$this->load->model('sections_model', 'sections');
		$this->load->model('pages_model', 'pages');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index(){
		$dbAccess = $this->load->database('default',true);

		$queryString = "SELECT 
				a.ad_id
				,a.ad_path
				,a.ad_title
				,a.ad_type 
				,a.ad_filename
				,a.ad_link
				FROM (`ads` a)  
				WHERE `a`.`ad_active` = 'yes'";

		$query = $dbAccess->query($queryString);
		$data = $query->result();
		
		foreach($data as $d):
		$optimize = $this->optimize_image($d->ad_path.$d->ad_filename,$d->ad_path.$d->ad_filename,$d->ad_type);	
		endforeach;
		
		echo "<pre>";
		print_r($data);
		echo "</pre>";
		die(); 
	}
	
	function event_imagets_opt(){
		$dbAccess = $this->load->database('default',true);
		
		$dbAccess->select('	
								e.event_image
									,e.event_image_1
									');

		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("e.event_date_time >= now()");
		$query = $dbAccess->get('events e');
		$data = $query->result();
		
		
		foreach($data as $d):
		$path = "./uploads/".$d->event_image;
		$optimize = $this->optimize_image($path,$path);	
		endforeach;
		
		echo "<pre>";
		print_r($data);
		echo "</pre>";
		die();
		
	}
	
	function specific_imagets_opt($dir,$image,$m_dir=false){
		
		if($m_dir){$dir = $dir."/".$m_dir;}
		$path = "./uploads/".$dir."/".$image;
		$optimize = $this->optimize_image($path,$path);	
		
		echo $path;
		die();
		
	}
	
	function carousel_optimize(){
		$dbAccess1 = $this->load->database('default',true);

		$queryString = "SELECT `event_ids`
				FROM `events_listing`
				WHERE `event_listing_name` = 'carousel'";

		$query1 = $dbAccess1->query($queryString);
		$data1 = $query1->row();
		
		$dbAccess = $this->load->database('default',true);
		
		$dbAccess->select('	
								e.event_image
									,e.event_image_1
									');

		$dbAccess->where_in("e.event_id",explode(",",$data1->event_ids));
		$query = $dbAccess->get('events e');
		$data = $query->result();
		
		foreach($data as $d):
		$path = "./uploads/".$d->event_image_1;
		$optimize = $this->optimize_image($path,$path);	
		endforeach;
		
		echo "<pre>";
		print_r($data);
		echo "</pre>";
		die(); 
	}
	
	function optimize_image($source_url, $destination_url,$ads_type=false){
		
		require_once(BASEPATH."application/libraries/Tinify/Exception.php");
		require_once(BASEPATH."application/libraries/Tinify/ResultMeta.php");
		require_once(BASEPATH."application/libraries/Tinify/Result.php");
		require_once(BASEPATH."application/libraries/Tinify/Source.php");
		require_once(BASEPATH."application/libraries/Tinify/Client.php");
		require_once(BASEPATH."application/libraries/Tinify.php");
	
		// \Tinify\setKey("B6PqxSdMAqjSQU1L4udUz2Nk0BZskYbc"); // Switch to this key if image compression exceeded to 500
		\Tinify\setKey("ZCtuIAlNoDR5qg28NA3dwkvsNzABAWX5");
		if($ads_type){
			if($ads_type == "Lead"){
				$width = 740;
			}else{
				$width = 340;
			}
			$source = \Tinify\fromFile($source_url);
			$resized = $source->resize(array(
				"method" => "scale",
				"width" => $width
			));
			$resized->toFile($destination_url);
		}else{
			$source = \Tinify\fromFile($source_url);
			$source->toFile($destination_url);
		}
		
		
		try {
			// Use the Tinify API client.
		} catch(\Tinify\AccountException $e) {
			print("The error message is: " . $e.getMessage());
			// Verify your API key and account limit.
		} catch(\Tinify\ClientException $e) {
			print("The error message is: " . $e.getMessage());
			// Check your source image and request options.
		} catch(\Tinify\ServerException $e) {
			print("The error message is: " . $e.getMessage());
			// Temporary issue with the Tinify API.
		} catch(\Tinify\ConnectionException $e) {
			print("The error message is: " . $e.getMessage());
			// A network connection error occurred.
		} catch(Exception $e) {
			print("The error message is: " . $e.getMessage());
			// Something else went wrong, unrelated to the Tinify API.
		}
		
		$compressionsThisMonth = \Tinify\compressionCount();
		
		echo "<h1>Compression This Month: ".$compressionsThisMonth."</h1><br>";
	}
}

/* End of file optimize.php */
/* Location: ./application/controllers/optimize.php */