<?php

class Online_codes extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('online_codes_model', 'online_codes');
		$this->load->model('events_model', 'events');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('users_model', 'users');
		$this->load->database('default');

		// place authentication check here
		// check user session
		// $this->users->check_session(array('Admin','Super Admin'));

	}
	
	function index()
	{
		// $this->load->view('welcome_message');
	}

	
	function listing() {
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['page_title'] = 'Online Codes Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["listing"] = $this->online_codes->listing();
	
		$this->load->view('online_codes_listing',$data);
	}

	function generate($event_id = false) {
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['page_title'] = 'Online Codes Generate';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		// $data["listing"] = $this->online_codes->listing();
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		$config = array(
			array(
				'field'   => 'prefix',
				'label'   => 'Prefix',
				'rules'   => 'trim|strip_tags|alpha_numeric|max_length[10]'
			),
			array(
				'field'   => 'price_id[]',
				'label'   => 'Price',
				'rules'   => 'trim|required|numeric|strip_tags'
			),
			array(
				'field'   => 'chars',
				'label'   => 'No of Characters',
				'rules'   => 'trim|required|numeric|less_than_equal_to[30]|strip_tags'
			),
			
			array(
				'field'   => 'lower',
				'label'   => 'Paramters',
				'rules'   => 'trim|strip_tags|callback__check_param'
			),
			 
			array(
				'field'   => 'no_codes',
				'label'   => 'No of Codes',
				'rules'   => 'trim|required|numeric|less_than_equal_to[5000]|strip_tags'
			),
			 
		);
		
		$this->form_validation->set_rules($config); 
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE) {
 
			//$data['x'] =$this->online_codes->get_by_event_id($event_id);
			$this->load->view('online_codes_generate',$data);
		} else {
			
			$this->online_codes->generate($event_id);
			$this->session->set_flashdata('message', assemble_message('System has successfully generated codes'));
			redirect('online_codes/listing');

		}
	}

	function _check_param()
	{	
 		$numeric = $this->input->post('numeric');
		$upper = $this->input->post('upper');
		$lower = $this->input->post('lower');
		
		if ($numeric == '' && $upper == '' && $lower == '')
		{
			$this->form_validation->set_message('_check_param', "Please select at least 1 parameter.");
			return FALSE;
		}
		 
		
		return TRUE;
		
	}	
	 
	
	function activate($event_id = 0) {
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		if ($event_id > 0) {
			$this->online_codes->set_status($event_id,1);
		}
		redirect("online_codes/listing");
	}
	
	function deactivate($event_id = 0) {
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		if ($event_id > 0) {
			$this->online_codes->set_status($event_id,0);
		}
		redirect("online_codes/listing");
	}
	
	
	function add($event_id = 0) {
		
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		$data['page_title'] = 'Add Online Codes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$valid = false;
		if ($event_id > 0) {
			$config = array(
				array(
					'field'   => 'event_id',
					'label'   => 'Event ID',
					'rules'   => 'trim|required|strip_tags'
				),
				array(
					'field'   => 'price_id[]',
					'label'   => 'Price',
					'rules'   => 'trim|required|strip_tags'
				),
			);

			$this->form_validation->set_rules($config); 
			$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
			
			if ($this->form_validation->run() == FALSE) {

				$data["event_info"] = $this->events->get($event_id);

				if ($data["event_info"]->event_online_concert == 1) {
					$this->load->view('online_codes_add',$data);
					$valid = true;
				}
			} else {
				$this->upload($event_id);
				$valid = true;
			}
			
		} 
		if (! $valid) {
			redirect('online_codes/listing');
		}
	}

	//list of codes 
	function status($event_id = 0,$offset = 0) {
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		$data['page_title'] = 'List of Online Codes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["events"] = $this->events->get($event_id);
		$this->load->library('pagination');	

			
		$searchkey = array();
		$searchflds = array('online_code_transaction_id', 'online_code', 'online_code_ticket_id');
		foreach ($searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
// echo '<pre>';
// print_r($searchkey);
// die();
		$transtat_def = $this->input->post('transtat_def');
		$data["transtat_def"] = $transtat_def;
		$data["limit"] = $limit = 50;
		
		// $data["listing"] = $this->qrcode->qrcodelist($event_id, $show_all, $view_usedqrcode);
		$data["listing"] = $this->online_codes->getAll($event_id,$transtat_def,$searchkey, $offset, $limit);

		$data['offset'] = $offset;
		// pagination
		$config['base_url'] = site_url('online_codes/status/' . $event_id . '/');
		$config['total_rows'] = count($data["listing"]);
		$config['uri_segment'] = 4;
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		
		
		$this->load->view('online_codes_status',$data);
	}
	

	function upload($event_id = 0) {
		
		$data['page_title'] = 'Uploading Online Codes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$this->logs->add('CSV File Upload - Online Codes');
		
		$data['event_id'] = $event_id;
		// $data['eventlongtitle_comp'] = $this->guestlist->compressed_eventname($eventid);

		$skipfirstline = $this->input->post('skipfirstline');
 		

		// $upload_path = './uploads/csv/';
		$upload_path = $this->files->prepare_directory_by_name('csv');

		$success = false;
		if (!empty($upload_path) && ($event_id > 0)) {
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = "csv|";
			$datetime = date("YmHis");
			$config['file_name'] = "$datetime-$event_id";

			$this->load->library('upload', $config);
			$this->upload->initialize($config);

			if ($this->upload->do_upload("csvfile"))
			{
				$upload_data = $this->upload->data();
				$success = true;
				// $this->load->view('upload_success', $data);
				
				$data["csvfile"] = $upload_data["full_path"];
				$data["skipfirstline"] = $skipfirstline;
 				$data["event_info"] = $this->events->get($event_id);
				
				$this->load->view('online_codes_uploading',$data);
			}
		}
		
		if (!$success) {
			echo "Not successful. <PRE>";
			// print_r($this->upload->data());
			// print_r($_FILES);
			echo "</PRE>";
			$data['upload_error'] = $this->upload->display_errors();
		}
	}
	
	
	
	
	
	
	 
}

