<?php

class Logs_online extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->database('default');
		$this->load->model('users_model', 'users');
		$this->load->model('logs_model', 'logs');
		$this->load->model('online_logs_model', 'logs_online');
	}
	
	function index()
	{
		show_404();
	}
	
	function listing($offset = 0)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// check user session
		$this->users->check_session(array('Dashboard', 'Admin','Super Admin','Admin2'));
		
		// constants
		$this->load->library('pagination');		
		$limit = $this->pagination->per_page;
		// $offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Dashboard - Online Transactions';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('transaction_id', 'name', 'customer_mobile');
		foreach ($searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// $data["transtatus"] = $this->logs_online->get_transaction_status();
		$transtat_def = $this->input->post('transtat_def');
			$data["transtat_def"] = $transtat_def;
		$transdate_def = $this->input->post('transdate');
			$data["transdate_def"] = $transdate_def;
		if (empty($transdate_def)) { $data["limit"] = $limit = 50; } else { $data["limit"] = $limit = 0; }
		$data['transactions'] = $this->logs_online->get_all_online_transactions($transdate_def,$transtat_def,$this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'), $offset, $limit);
		
		$data['offset'] = $offset;
		// pagination
		$config['base_url'] = site_url('logs_online/listing');
		// $config['total_rows'] = $this->logs_online->get_terminal_transactions_allcount_alt(0,$this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'));

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->session->unset_userdata('senior_id');
		$this->benchmark->mark('query_end');	
		$this->load->view('logs_online_listing', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * transaction view
	 *
	 * @access	public
	 */
	function view($transaction_id = false)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		
		if (!$transaction_id) show_404();
				
		// prepare data for the template
		$data['page_title'] = 'Log Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Dashboard', 'Admin','Super Admin','Admin2'));
	
		// get details
		$data['transaction'] = $this->logs_online->get_log_details($transaction_id);
		// print_r($data['transaction']);
		$this->benchmark->mark('query_end');
		// display the page
		$this->load->view('logs_online_view', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}	
	


}	
/* End of file transactions.php */
/* Location: ./application/controllers/transactions.php */	
