<?php

class Logs extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('logs_model', 'logs');
		$this->load->model('users_model', 'users');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('logs/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		$this->load->library('pagination');
		
		// constants
		$limit = $this->pagination->per_page;
		$offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Logs';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','IT','Super Admin','Finance'));
		
		$searchkey = array();
		$searchflds = array('log_date', 'username', 'log_action', 'log_ip_address');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// pagination
		$this->load->library('pagination');		
		$limit = $this->pagination->per_page;
		$offset = $this->uri->segment(3);		
		
		$config['base_url'] = site_url('logs/listing');
		$config['total_rows'] = $this->logs->get_log_count($searchkey);
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$data['logs'] = $this->logs->get_logs($searchkey, $offset, $limit);
		
		$this->load->view('logs_listing', $data);
	}	

}

/* End of file logs.php */
/* Location: ./application/controllers/logs.php */	