<?php

class Logos extends CI_Controller
 {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('logos_model', 'logos');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('logos/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Logo';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['logos'] = $this->logos->get_logos();
		
		$this->load->view('logos_listing', $data);
	}	
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 * @access	public
	 */
	function upload()
	{
		// prepare data for the template
		$data['page_title'] = 'Upload Logo';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'logo',
				'label'   => 'Logo',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'logo_name',
				'label'   => 'Name of Logo',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('logos_upload', $data);
		}
		else
		{
			list($filename, $image_path) = $this->files->upload_logo();
			$this->logos->upload($filename, $image_path);
			$this->session->set_flashdata('message', assemble_message('Event logo has been successfully added'));
			redirect('logos/listing');
		}
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($logo_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Logo');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->logos->delete($logo_id);
		$this->session->set_flashdata('message', assemble_message('Logo has been successfully deleted'));
		redirect('logos/listing/');
	}	
	
}

/* End of file logos.php */
/* Location: ./application/controllers/logos.php */	