<?php

class Liquidation_report extends CI_controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('reports_model', 'reports');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('admin_model', 'admin');
		$this->load->model('prices_model', 'prices');
		$this->load->model('liquidation_report_model', 'liquidation');
		$this->load->database('default');
		// $db['archive']['database'] = "live_dbsss";
	// $this->load->database('archive');
	
	}

	function liquidation_report($eventgroup = false, $lr_no = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		
		$data['page_title'] = 'Liquidation Report';
		
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
	
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'Reports date',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_id',
				'label'   => 'Event',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),

		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ( ($this->form_validation->run() == FALSE))
		{
			// display the page
			$finance_type = $this->users->check_finance_type($this->session->userdata('user_id'));
			$data['finance_type'] = $finance_type;
			$this->load->view('reports_liquidation_filter', $data);
		}
		else
		{
			if($this->input->post('review_type')=="1"){
				
				$validation = $this->liquidation->for_review_validation($this->input->post('event_id'));
				
				if($validation){
					$this->session->set_flashdata('message', assemble_message('Sorry, An LR entry has been processed.'));
					redirect('liquidation_report/liquidation_report/event');
				}else{
					$this->liquidation->for_review();
					$this->session->set_flashdata('message', assemble_message('Successfully processed for review/checking.'));
					redirect('liquidation_report/liquidation_report/event');
				}
			}
			
			// echo '<pre>';
			// print_r($_POST);
			// die();
			// echo $this->input->post('branch_id');
			// die();
			if($this->input->post('branch_id')=="all"){
				$data['branchkey'] = "";
			}else{
				$data['branchkey'] = $this->input->post('branch_id');
			}
			
			if($this->input->post('ticket_senior_sales')==0){
				$data['ticket_senior_sales'] = "";
			}else{
				$data['ticket_senior_sales'] = $this->input->post('ticket_senior_sales');
			}
			if($this->input->post('unredeemed_tickets')==0){
				$data['unredeemed_tickets'] ="";
			}else{
				$data['unredeemed_tickets'] = $this->input->post('unredeemed_tickets');
			}
			if($this->input->post('refunded_sale')==0){
				$data['refunded_sale'] = "";
			}else{
				$data['refunded_sale'] = $this->input->post('refunded_sale');
			}
			
			if($this->input->post('commission')==0){
				$data['commission'] = "";
			}else{
				$data['commission'] = $this->input->post('commission');
			}
			
			if($this->input->post('ticket_sales')==0){
				$data['ticket_sales'] = "";
			}else{
				$data['ticket_sales'] = $this->input->post('ticket_sales');
			}
			
			if($this->input->post('admin_fee')==0){
				$data['admin_fee']  = "";
			}else{
				$data['admin_fee'] = $this->input->post('admin_fee');
			}
			
			if($this->input->post('ticket_printing')==0){
				$data['ticket_printing'] ="";
			}else{
				$data['ticket_printing'] = $this->input->post('ticket_printing');
			}
			
			if($this->input->post('account')==0){
				$data['account'] = "";
			}else{
				$data['account'] = $this->input->post('account');
			}
			
			if($this->input->post('deal_sheet')==0){
				$data['deal_sheet'] = "";
			}else{
				$data['deal_sheet'] = $this->input->post('deal_sheet');
			}
			
			if($this->input->post('bank_service_charge')==0){
				$data['bank_service_charge'] = "";
			}else{
				$data['bank_service_charge'] = $this->input->post('bank_service_charge');
			}
			
			if($this->input->post('ewt_rate')==0){
				$data['ewt_rate'] = "";
			}else{
				$data['ewt_rate'] = $this->input->post('ewt_rate');
			}
			
			if($this->input->post('paid_pull_outs1')==0 && $this->input->post('paid_pull_outs2')==0 && $this->input->post('paid_pull_outs3')==0 && $this->input->post('paid_pull_outs4')==0 && $this->input->post('paid_pull_outs5')==0 && $this->input->post('paid_pull_outs6')==0 && $this->input->post('paid_pull_outs7')==0 && $this->input->post('paid_pull_outs8')==0 && $this->input->post('paid_pull_outs9')==0 && $this->input->post('paid_pull_outs10')==0&& $this->input->post('paid_pull_outs11')==0 && $this->input->post('paid_pull_outs12')==0) {
			$data['paid_pull_outs'] = "" ;
			}else if($this->input->post('paid_pull_outs1')=="" && $this->input->post('paid_pull_outs2')=="" && $this->input->post('paid_pull_outs3')=="" && $this->input->post('paid_pull_outs4')=="" && $this->input->post('paid_pull_outs5')=="" && $this->input->post('paid_pull_outs6')=="" && $this->input->post('paid_pull_outs7')=="" && $this->input->post('paid_pull_outs8')=="" && $this->input->post('paid_pull_outs9')=="" && $this->input->post('paid_pull_outs10')==""&& $this->input->post('paid_pull_outs11')=="" && $this->input->post('paid_pull_outs12')=="") 
			$data['paid_pull_outs'] = "" ;
			else{
				$pull_outs = 0;
				for($ctr=1;$ctr<=12;$ctr++){
					error_reporting(0);
					$pull_outs += $this->input->post('paid_pull_outs'.$ctr);
					// if($this->input->post('paid_pull_outs'.$ctr)==0 or $this->input->post('paid_pull_outs'.$ctr) == ""){
						
					// }
					$data['paid_pull_outs'.$ctr] = $this->input->post('paid_pull_outs'.$ctr);
				}
				
				// echo $pull_outs;
				// die();
				$data['paid_pull_outs'] = $pull_outs;
			}
			
			if($this->input->post('first_down')==0){
				$data['first_down'] = "";
			}else{
				$data['first_down'] = $this->input->post('first_down');
			}
			
			if($this->input->post('second_down_')==0){
				$data['second_down_'] =  "";
				// die();
			}else{
				$data['second_down_'] = $this->input->post('second_down_');
				// die();
			}
			
			if($this->input->post('third_down')==0){
				$data['third_down'] = "";
			}else{
				$data['third_down'] = $this->input->post('third_down');
			}
			
			if( $this->input->post('ninety_down')==0){
				$data['ninety_down'] = "";
			}else{
				$data['ninety_down'] = $this->input->post('ninety_down');
			}
			
			if($this->input->post('smacc_charges') == 0){
				$data['smacc_charges'] = "";
			}else{
				$data['smacc_charges'] = $this->input->post('smacc_charges');
			}
			$data["referrer"] = "";
			$data["date_validity"] = "";
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			// if(!$lr_no){
				// $this->liquidation->for_review();
			// }
			$this->load->view('reports_liquidation_report',$data);
			
	}
	
	}
	
	function liquidation_report_checking($eventgroup = false, $lr_no = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		$data['lr_no'] = $lr_no;
		$data['page_title'] = 'Liquidation Report';
		
		
		$data['reviewed'] = $this->liquidation->check_reviewed($lr_no);
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
	
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'Reports date',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_id',
				'label'   => 'Event',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),

		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ( ($this->form_validation->run() == FALSE))
		{
			$finance_type = $this->users->check_finance_type($this->session->userdata('user_id'));
			$data['finance_type'] = $finance_type;
			// display the page
			$this->load->view('reports_liquidation_filter_for_review', $data);
		}
		else
		{
			if($this->input->post('review_type')=="1"){
				$this->liquidation->check($lr_no);
				$this->session->set_flashdata('message', assemble_message('Successfully reviewed/checked.'));
				redirect('liquidation_report/liquidation_report/event/'.$lr_no);
			}
			
			// echo '<pre>';
			// print_r($_POST);
			// die();
			// echo $this->input->post('branch_id');
			// die();
			if($this->input->post('branch_id')=="all"){
				$data['branchkey'] = "";
			}else{
				$data['branchkey'] = $this->input->post('branch_id');
			}
			
			if($this->input->post('ticket_senior_sales')==0){
				$data['ticket_senior_sales'] = "";
			}else{
				$data['ticket_senior_sales'] = $this->input->post('ticket_senior_sales');
			}
			if($this->input->post('unredeemed_tickets')==0){
				$data['unredeemed_tickets'] ="";
			}else{
				$data['unredeemed_tickets'] = $this->input->post('unredeemed_tickets');
			}
			if($this->input->post('refunded_sale')==0){
				$data['refunded_sale'] = "";
			}else{
				$data['refunded_sale'] = $this->input->post('refunded_sale');
			}
			
			if($this->input->post('commission')==0){
				$data['commission'] = "";
			}else{
				$data['commission'] = $this->input->post('commission');
			}
			
			if($this->input->post('ticket_sales')==0){
				$data['ticket_sales'] = "";
			}else{
				$data['ticket_sales'] = $this->input->post('ticket_sales');
			}
			
			if($this->input->post('admin_fee')==0){
				$data['admin_fee']  = "";
			}else{
				$data['admin_fee'] = $this->input->post('admin_fee');
			}
			
			if($this->input->post('ticket_printing')==0){
				$data['ticket_printing'] ="";
			}else{
				$data['ticket_printing'] = $this->input->post('ticket_printing');
			}
			
			if($this->input->post('account')==0){
				$data['account'] = "";
			}else{
				$data['account'] = $this->input->post('account');
			}
			
			if($this->input->post('deal_sheet')==0){
				$data['deal_sheet'] = "";
			}else{
				$data['deal_sheet'] = $this->input->post('deal_sheet');
			}
			
			if($this->input->post('bank_service_charge')==0){
				$data['bank_service_charge'] = "";
			}else{
				$data['bank_service_charge'] = $this->input->post('bank_service_charge');
			}
			
			if($this->input->post('ewt_rate')==0){
				$data['ewt_rate'] = "";
			}else{
				$data['ewt_rate'] = $this->input->post('ewt_rate');
			}
			
			if($this->input->post('paid_pull_outs1')==0 && $this->input->post('paid_pull_outs2')==0 && $this->input->post('paid_pull_outs3')==0 && $this->input->post('paid_pull_outs4')==0 && $this->input->post('paid_pull_outs5')==0 && $this->input->post('paid_pull_outs6')==0 && $this->input->post('paid_pull_outs7')==0 && $this->input->post('paid_pull_outs8')==0 && $this->input->post('paid_pull_outs9')==0 && $this->input->post('paid_pull_outs10')==0&& $this->input->post('paid_pull_outs11')==0 && $this->input->post('paid_pull_outs12')==0) {
			$data['paid_pull_outs'] = "" ;
			}else if($this->input->post('paid_pull_outs1')=="" && $this->input->post('paid_pull_outs2')=="" && $this->input->post('paid_pull_outs3')=="" && $this->input->post('paid_pull_outs4')=="" && $this->input->post('paid_pull_outs5')=="" && $this->input->post('paid_pull_outs6')=="" && $this->input->post('paid_pull_outs7')=="" && $this->input->post('paid_pull_outs8')=="" && $this->input->post('paid_pull_outs9')=="" && $this->input->post('paid_pull_outs10')==""&& $this->input->post('paid_pull_outs11')=="" && $this->input->post('paid_pull_outs12')=="") 
			$data['paid_pull_outs'] = "" ;
			else{
				$pull_outs = 0;
				for($ctr=1;$ctr<=12;$ctr++){
					error_reporting(0);
					$pull_outs += $this->input->post('paid_pull_outs'.$ctr);
					// if($this->input->post('paid_pull_outs'.$ctr)==0 or $this->input->post('paid_pull_outs'.$ctr) == ""){
						
					// }
					$data['paid_pull_outs'.$ctr] = $this->input->post('paid_pull_outs'.$ctr);
				}
				
				// echo $pull_outs;
				// die();
				$data['paid_pull_outs'] = $pull_outs;
			}
			
			if($this->input->post('first_down')==0){
				$data['first_down'] = "";
			}else{
				$data['first_down'] = $this->input->post('first_down');
			}
			
			if($this->input->post('second_down_')==0){
				$data['second_down_'] =  "";
				// die();
			}else{
				$data['second_down_'] = $this->input->post('second_down_');
				// die();
			}
			
			if($this->input->post('third_down')==0){
				$data['third_down'] = "";
			}else{
				$data['third_down'] = $this->input->post('third_down');
			}
			
			if( $this->input->post('ninety_down')==0){
				$data['ninety_down'] = "";
			}else{
				$data['ninety_down'] = $this->input->post('ninety_down');
			}
			
			if($this->input->post('smacc_charges') == 0){
				$data['smacc_charges'] = "";
			}else{
				$data['smacc_charges'] = $this->input->post('smacc_charges');
			}
			$data["referrer"] = "";
			$data["date_validity"] = "";
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			// if(!$lr_no){
				// $this->liquidation->for_review();
			// }
			$this->load->view('reports_liquidation_report',$data);
			
		}
	
	}
	
	function liquidation_report_edit($eventgroup = false, $lr_no = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		$data['lr_no'] = $lr_no;
		$data['page_title'] = 'Liquidation Report';
		
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
	
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'Reports date',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_id',
				'label'   => 'Event',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),

		);
		$data['reviewed'] = $this->liquidation->check_reviewed($lr_no);

		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ( ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_liquidation_filter_edit', $data);
		}
		else
		{
			if($this->input->post('review_type')=="1"){
				$this->liquidation->update($lr_no);
				$this->session->set_flashdata('message', assemble_message('Successfully updated'));
				redirect('liquidation_report/liquidation_report_edit/event/'.$lr_no);
			}else if($this->input->post('review_type')=="3"){
				$this->liquidation->check($lr_no);
				$this->session->set_flashdata('message', assemble_message('Successfully reviewed/checked.'));
				redirect('liquidation_report/liquidation_report_edit/event/'.$lr_no);
			}
			
			// echo '<pre>';
			// print_r($_POST);
			// die();
			// echo $this->input->post('branch_id');
			// die();
			if($this->input->post('branch_id')=="all"){
				$data['branchkey'] = "";
			}else{
				$data['branchkey'] = $this->input->post('branch_id');
			}
			
			if($this->input->post('ticket_senior_sales')==0){
				$data['ticket_senior_sales'] = "";
			}else{
				$data['ticket_senior_sales'] = $this->input->post('ticket_senior_sales');
			}
			if($this->input->post('unredeemed_tickets')==0){
				$data['unredeemed_tickets'] ="";
			}else{
				$data['unredeemed_tickets'] = $this->input->post('unredeemed_tickets');
			}
			if($this->input->post('refunded_sale')==0){
				$data['refunded_sale'] = "";
			}else{
				$data['refunded_sale'] = $this->input->post('refunded_sale');
			}
			
			if($this->input->post('commission')==0){
				$data['commission'] = "";
			}else{
				$data['commission'] = $this->input->post('commission');
			}
			
			if($this->input->post('ticket_sales')==0){
				$data['ticket_sales'] = "";
			}else{
				$data['ticket_sales'] = $this->input->post('ticket_sales');
			}
			
			if($this->input->post('admin_fee')==0){
				$data['admin_fee']  = "";
			}else{
				$data['admin_fee'] = $this->input->post('admin_fee');
			}
			
			if($this->input->post('ticket_printing')==0){
				$data['ticket_printing'] ="";
			}else{
				$data['ticket_printing'] = $this->input->post('ticket_printing');
			}
			
			if($this->input->post('account')==0){
				$data['account'] = "";
			}else{
				$data['account'] = $this->input->post('account');
			}
			
			if($this->input->post('deal_sheet')==0){
				$data['deal_sheet'] = "";
			}else{
				$data['deal_sheet'] = $this->input->post('deal_sheet');
			}
			
			if($this->input->post('bank_service_charge')==0){
				$data['bank_service_charge'] = "";
			}else{
				$data['bank_service_charge'] = $this->input->post('bank_service_charge');
			}
			
			if($this->input->post('ewt_rate')==0){
				$data['ewt_rate'] = "";
			}else{
				$data['ewt_rate'] = $this->input->post('ewt_rate');
			}
			
			if($this->input->post('paid_pull_outs1')==0 && $this->input->post('paid_pull_outs2')==0 && $this->input->post('paid_pull_outs3')==0 && $this->input->post('paid_pull_outs4')==0 && $this->input->post('paid_pull_outs5')==0 && $this->input->post('paid_pull_outs6')==0 && $this->input->post('paid_pull_outs7')==0 && $this->input->post('paid_pull_outs8')==0 && $this->input->post('paid_pull_outs9')==0 && $this->input->post('paid_pull_outs10')==0&& $this->input->post('paid_pull_outs11')==0 && $this->input->post('paid_pull_outs12')==0) {
			$data['paid_pull_outs'] = "" ;
			}else if($this->input->post('paid_pull_outs1')=="" && $this->input->post('paid_pull_outs2')=="" && $this->input->post('paid_pull_outs3')=="" && $this->input->post('paid_pull_outs4')=="" && $this->input->post('paid_pull_outs5')=="" && $this->input->post('paid_pull_outs6')=="" && $this->input->post('paid_pull_outs7')=="" && $this->input->post('paid_pull_outs8')=="" && $this->input->post('paid_pull_outs9')=="" && $this->input->post('paid_pull_outs10')==""&& $this->input->post('paid_pull_outs11')=="" && $this->input->post('paid_pull_outs12')=="") 
			$data['paid_pull_outs'] = "" ;
			else{
				$pull_outs = 0;
				for($ctr=1;$ctr<=12;$ctr++){
					error_reporting(0);
					$pull_outs += $this->input->post('paid_pull_outs'.$ctr);
					// if($this->input->post('paid_pull_outs'.$ctr)==0 or $this->input->post('paid_pull_outs'.$ctr) == ""){
						
					// }
					$data['paid_pull_outs'.$ctr] = $this->input->post('paid_pull_outs'.$ctr);
				}
				
				// echo $pull_outs;
				// die();
				$data['paid_pull_outs'] = $pull_outs;
			}
			
			if($this->input->post('first_down')==0){
				$data['first_down'] = "";
			}else{
				$data['first_down'] = $this->input->post('first_down');
			}
			
			if($this->input->post('second_down_')==0){
				$data['second_down_'] =  "";
				// die();
			}else{
				$data['second_down_'] = $this->input->post('second_down_');
				// die();
			}
			
			if($this->input->post('third_down')==0){
				$data['third_down'] = "";
			}else{
				$data['third_down'] = $this->input->post('third_down');
			}
			
			if( $this->input->post('ninety_down')==0){
				$data['ninety_down'] = "";
			}else{
				$data['ninety_down'] = $this->input->post('ninety_down');
			}
			
			if($this->input->post('smacc_charges') == 0){
				$data['smacc_charges'] = "";
			}else{
				$data['smacc_charges'] = $this->input->post('smacc_charges');
			}
			$data["referrer"] = "";
			$data["date_validity"] = "";
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			// if(!$lr_no){
				// $this->liquidation->for_review();
			// }
			$this->load->view('reports_liquidation_report',$data);
			
		}
	
	}
	
	
	
	function lr_listing()
	{
		
		// prepare data for the template
		$data['page_title'] = 'Liquidation Report';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();		
		$searchflds = qw('lr_no event_title promoter_name venue_name status');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all data
		$data['liquidation'] = $this->liquidation->get_lr_list($searchkey);
				
		// remove the event id
		$this->session->unset_userdata('cei');
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$finance_type = $this->users->check_finance_type($this->session->userdata('user_id'));
		// die();
		$data['finance_type'] = $finance_type;
		if(in_array($finance_type,array(0,''))){
			$this->session->set_flashdata('message', assemble_message("You can't access this page."));
			redirect('');
		}
		
		$this->load->view('lr_listing', $data);
	}
	
	function get_lr_info($lr_id){
		$info = $this->liquidation->get_lr($lr_id);
		echo json_encode (unserialize($info)) ;
	}
		
	function get_prices($event_id){
		$result = $this->prices->get_prices($event_id);
		echo json_encode ($result) ;
		
	}
	
	function getTicketTypeByEvent($event_id )
	{
		// $this->db->distinct();
		// $this->db->select('tt.ticket_type_name, tt.ticket_type_id');
		$this->db->select('event_ticket_types');
		$this->db->where('event_id', $event_id);
		// $this->db->where('tt.ticket_type_group', 0);
		// $this->db->join('tickets t', 't.ticket_type_id = tt.ticket_type_id');
		$query = $this->db->get('events');
		$row = $query->row();
		
		// echo $ticket_type = unserialize($result->event_ticket_types);
		 $ticket_type = $row->event_ticket_types;
		 $ticket_type2 = unserialize($ticket_type);
		 
		 // print_r($ticket_type2);
		
		$this->db->select('ticket_type_name, ticket_type_id');
		$this->db->where_in('ticket_type_id', $ticket_type2);
		$this->db->where('ticket_type_group', 0);
		// $this->db->join('tickets t', 't.ticket_type_id = tt.ticket_type_id');
		$query = $this->db->get('ticket_types');
		$result = $query->result();
		
		
		// echo $this->db->last_query();
		
		echo json_encode ($result) ;
	}
	
	function empty_tbl(){
		$this->db->empty_table('liquidation_report');
	}
	
	function drop_tbl(){
		$this->db->query('DROP TABLE liquidation_report');
	}
	
	function add_tbl(){
		$query = $this->db->query("CREATE TABLE IF NOT EXISTS `liquidation_report` ( `lr_no` int(11) NOT NULL AUTO_INCREMENT,`event_id` int(11) DEFAULT NULL,`commission_type` int(11) DEFAULT NULL,`status` varchar(50) DEFAULT NULL,`processor_id` varchar(50) DEFAULT NULL,`process_date` datetime DEFAULT NULL,`check_date` datetime DEFAULT NULL,`reviewer_id` varchar(50) DEFAULT NULL,`commission_details` text,`remarks` varchar(50) DEFAULT NULL,PRIMARY KEY (`lr_no`))");
		
	}
	
	function checkedd($lr_num,$user_id){
		$this->liquidation->checkedd($lr_num,$user_id);
	}
	
	
	
}