<?php

class Image extends CI_Controller
 {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('poster_model', 'poster');
		$this->load->model('image_model', 'Image');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->model('events_model', 'events');
		
		
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('Image/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Image';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['Image'] = $this->Image->get_image();
		
		// echo '<pre>';
		// print_r($data['Image']);
		// echo '</pre>';
		// Die();
		
		
		$this->load->view('image_listing', $data);
	}
	
	function image_active()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Image';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['Image'] = $this->Image->get_image_active();
		
		$this->load->view('image_listing', $data);
	}
	
	function image_inactive()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Image';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['Image'] = $this->Image->get_image_inactive();
		
		$this->load->view('image_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 * @access	public
	 */
	function upload()
	{
		// prepare data for the template
		$data['page_title'] = 'Upload Image';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'Image',
				'label'   => 'Image',
				'rules'   => 'trim|strip_tags'
			),

			array(
				'field'   => 'image_title',
				'label'   => 'Name of Image',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
				
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		$data['event_names'] = $this->events->get_active_events_dropdown();	
		$data['event'] = $this->events->get();
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('image_upload', $data);
		}
		else
		{
			list($filename, $image_path, $filewh, $filesize) = $this->files->upload_gallery_images();

			// echo '<pre>';
			// print_r($this->files->upload_gallery_images());
			// echo '</pre>';
			// Die();
			
			
			$this->Image->upload($filename, $image_path, $filewh, $filesize);
			$this->session->set_flashdata('message', assemble_message('Image has been successfully added'));
			redirect('image/image_active');
		}
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($image_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Image');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->Image->delete($image_id);
		$this->session->set_flashdata('message', assemble_message('Image has been successfully deleted'));
		redirect('image/listing/');
	}	
	
	function active($image_id = FALSE)
	{
		// log this
		$this->logs->add('Image Active');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->Image->active($image_id);
		$this->session->set_flashdata('message', assemble_message('Image has been successfully activated'));
		redirect('image/listing/');
	}
	
	/**
	 * inactive
	 *
	 * @access	public
	 */
	function inactive($image_id = FALSE)
	{
		// log this
		$this->logs->add('Image Inactive');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->Image->inactive($image_id);
		$this->session->set_flashdata('message', assemble_message('Image has been successfully deactivated'));
		redirect('image/listing/');
	}
	
}

/* End of file logos.php */
/* Location: ./application/controllers/logos.php */	

