<?php

class gtqr_code extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('gtqr_model', 'gtqr');
		$this->load->model('events_model', 'events');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('users_model', 'users');
		$this->load->model('gtqr_setup_model', 'gtqr_setup');
		$this->load->database('default');

		// place authentication check here
		// check user session
		// $this->users->check_session(array('Admin','Super Admin'));

	}
	
	function index()
	{
		// $this->load->view('welcome_message');
	}

	
	function listing() {
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['page_title'] = 'QR Code Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["listing"] = $this->gtqr->listing();
	
		$this->load->view('gtqr_code_listing',$data);
	}

	function add_qrcode($event_id = 0) {
		
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		$data['page_title'] = 'Add QRcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$valid = false;
		if ($event_id > 0) {
			$config = array(
				array(
					'field'   => 'upload',
					'label'   => 'CSV',
					'rules'   => 'required'
				),
			);

			$this->form_validation->set_rules($config); 
			$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
			
			if ($this->form_validation->run() == FALSE) {

				$data["event_info"] = $this->events->get($event_id);

				if ($data["event_info"]->events_config_qrcode_active == 1) {
					$this->load->view('gtqr_code_add',$data);
					$valid = true;
				}
			} else {
				$this->upload($event_id);
				$valid = true;
			}
			
		} 
		if (! $valid) {
			redirect('gtqr_code/listing');
		}
	}


	function upload($event_id = 0) {
		
		$data['page_title'] = 'Uploading QRcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$this->logs->add('CSV File Upload - QRcode');
		
		$data['event_id'] = $event_id;
		// $data['eventlongtitle_comp'] = $this->guestlist->compressed_eventname($eventid);

		$skipfirstline = $this->input->post('skipfirstline');
		//$price_id = $this->input->post('price_id');
		

		// $upload_path = './uploads/csv/';
		$upload_path = $this->files->prepare_directory_by_name('csv');

		$success = false;
		if (!empty($upload_path) && ($event_id > 0)) {
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = "csv|";
			$datetime = date("YmHis");
			$config['file_name'] = "ek_$datetime-$event_id";

			$this->load->library('upload', $config);
			$this->upload->initialize($config);

			if ($this->upload->do_upload("qrfile"))
			{
				$upload_data = $this->upload->data();
				$success = true;
				// $this->load->view('upload_success', $data);
				
				$data["csvfile"] = $upload_data["full_path"];
				$data["skipfirstline"] = $skipfirstline;
				//$data["price_id"] = $price_id;
				$data["event_info"] = $this->events->get($event_id);
				
				$this->load->view('gtqr_code_uploading',$data);
			}
		}
		
		if (!$success) {
			echo "Not successful. <PRE>";
			// print_r($this->upload->data());
			// print_r($_FILES);
			echo "</PRE>";
			$data['upload_error'] = $this->upload->display_errors();
		}
	}
	
	function qrcodelist($event_id = 0,$offset = 0) {
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		$data['page_title'] = 'List of QRcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["events"] = $this->events->get($event_id);
		$this->load->library('pagination');	

			
		$searchkey = array();
		$searchflds = array('transaction_id', 'qr_code');
		foreach ($searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}

		$transtat_def = $this->input->post('transtat_def');
		$data["transtat_def"] = $transtat_def;
		$data["limit"] = $limit = 5000;
		
		// $data["listing"] = $this->qrcode->qrcodelist($event_id, $show_all, $view_usedqrcode);
		$data["listing"] = $this->gtqr->getAll($event_id,$transtat_def,$this->input->post('transaction_id'), $this->input->post('qr_code'), $offset, $limit);

		$data['offset'] = $offset;
		// pagination
		$config['base_url'] = site_url('gtqr_code/qrcodelist/' . $event_id . '/');
		$config['total_rows'] = $this->gtqr->countAll($event_id,$this->input->post('transaction_id'), $this->input->post('qr_code'));
		$config['uri_segment'] = 4;
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		
		
		$this->load->view('gtqr_codelist',$data);
	}
	

	
	function activate($event_id = 0) {
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		if ($event_id > 0) {
			$this->gtqr->set_qrsale_listing_config($event_id,1);
		}
		redirect("ekbarcode/listing");
	}
	
	function deactivate($event_id = 0) {
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		if ($event_id > 0) {
			$this->gtqr->set_qrsale_listing_config($event_id,0);
		}
		redirect("gtqr_code/listing");
	}
	
	function check_qrcode(){
	
		$config = array(
			array(
				'field'   => 'qrCode',
				'label'   => 'QR Code',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			
			$this->load->view('gtqr_check_qrcode');
		}
		else
		{
			$result = $this->gtqr->check_qrcode();
			if($result){
				if($result=='ok')
				echo 'ok';
				elseif($result=='not')
				echo 'not';
				else
				echo 'selected';
			}else{
			echo 'no';
			}
		}

	
	}

	function qrcode_setup($event=0){
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		$data['page_title'] = 'QRcode SETUP';
		$this->logs->add($data['page_title']);
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["event_info"] = $this->events->get($event);		

		//GET THE PRICES OF THE EVENT
		$result = $this->prices->get_prices($event);
		// transform result into an associative array
		if($result){
			foreach($result as $r)
			{
				$array[$r->price_id] = $r->price_name;
			}
			$data['prices']= $array;
		}

		//TO CHECK IF EVENT HAS EXISTING QRCODE SETUP
		$qr_setup = $this->gtqr_setup->verify_qr_setup($event);
		
		if(count($qr_setup) > 0){
			$data['qrsetup'] = $qr_setup;
			if($data['qrsetup'][0]['qr_price_id']==0){
				$all_price_selected = array();
				foreach($result as $x){
					array_push($all_price_selected, $x->price_id);
				}
				$data['qrsetup'][0]['qr_price_id'] = $all_price_selected;
			}else{
				$data['qrsetup'][0]['qr_price_id'] = explode(",",$data['qrsetup'][0]['qr_price_id']);
			}
		}
		
		$config = array(
			array(
				'field'   => 'start_date',
				'label'   => 'Start Date',
				'rules'   => 'required'
			),
			array(
				'field'   => 'end_date',
				'label'   => 'End Date',
				'rules'   => 'required'
			),
			array(
				'field'   => 'price_type[]',
				'label'   => 'Price',
				'rules'   => 'required'
			)
		);

		$this->form_validation->set_rules($config); 
		$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
		
		if ($this->form_validation->run() == FALSE) {
			//PROCEED IN VIEWING
			if ($data["event_info"]->events_config_qrcode_active == 1) {


				$this->load->view('gtqr_code_setup',$data);
			}
		} else {
			//PROCEED IN SAVING

			$price_type = $this->input->post('price_type');

			//IF ALL PRICE TYPES WERE SELECTED
			if(count($price_type) == count($data['prices'])){
				$price_type=0;
			}
			else{
				//CONVERT INTO STRING WITH COMMA SEPARATED VALUE
				$price_type = implode(",",$price_type);
			}
			
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$qr_required = $this->input->post('qr_required');
			if(!isset($qr_required)){
				$qr_required=0;
			}

			$param = array(
				'qr_price_id' => $price_type,
				'qr_start_date' => $start_date,
				'qr_end_date' => $end_date,
				'qr_required' => $qr_required
			);
			
			//PROCEED ON UPDATE
			if(count($qr_setup) > 0){
				$result = $this->gtqr_setup->update_qrsetup($event,$param);
				if($result){
					$this->session->set_flashdata('message', assemble_message('QR code setup has been updated'));
					redirect("gtqr_code/listing");
				}
			}
			//PROCEED ON CREATING
			else{
				$param['qr_event_id'] = $event;
				$result = $this->gtqr_setup->add_qrsetup($param);
				if($result){
					$this->session->set_flashdata('message', assemble_message('QR code setup has been added'));
					redirect("gtqr_code/listing");
				}
			}

		}
	}

}

