<?php

class Fraud extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('sections_model', 'sections');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('events_model', 'events');
		$this->load->model('fraud_model', 'fraud');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('customers_model', 'customers');
		$this->load->model('reservations_model', 'reservations');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('online_transactions_model', 'otransactions');
		
		$this->load->database('default');
		// $this->load->model('tourgroup_model', 'tourgroup');
	}
	
	function index()
	{
		show_404();
	}
	function reset(){
	
	$this->session->unset_userdata('searchterm');
	redirect('fraud/listing/');
	}
	
	function listing($offset = 0)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// check user session
		// $this->users->check_session(array('Dashboard', 'Admin','Super Admin','Admin2','Reservation-Admin','Finance'));
		$this->users->check_session(array('Dashboard', 'IT','Super Admin'));
		
		// constants
		$this->load->library('pagination');		
		$limit = $this->pagination->per_page;
		// $offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Fraud - Online Transactions';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('transaction_id', 'name','event_title','customer_mobile', 'customer_email');
		foreach ($searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		
		   
		$searchterm =$this->fraud->searchterm_handler($this->input->post('event_title', TRUE));
		$data['event_title']= $searchterm;
		
		
		
		// $data["transtatus"] = $this->fraud->get_transaction_status();
		// $transtat_def = $this->input->post('transtat_def');
			// $data["transtat_def"] = $transtat_def;
		$transdate_def = $this->input->post('transdate');
			$data["transdate_def"] = $transdate_def;
		if (empty($transdate_def)) { $data["limit"] = $limit = 20; } else { $data["limit"] = $limit = 0; }
		$data['transactions'] = $this->fraud->get_all_online_transactions($transdate_def,$this->input->post('transaction_id'), $this->input->post('name'), $searchterm,$this->input->post('customer_mobile'),  $this->input->post('customer_email'),$offset, $limit);
		
		// $data['transdate'] = $this->otransactions->get_online_transaction_dates();
		$data['offset'] = $offset;
		// pagination
		$config['base_url'] = site_url('fraud/listing');
		// $config['total_rows'] = $this->fraud->get_terminal_transactions_allcount($this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'));
		// $config['total_rows'] = $this->fraud->get_terminal_transactions_allcount_alt(0,$this->input->post('transaction_id'), $this->input->post('name'), $searchterm, $this->input->post('customer_mobile'));
		// $config['total_rows'] = $this->fraud->get_terminal_transaction_count($searchkey);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->session->unset_userdata('senior_id');
		$this->benchmark->mark('query_end');	
		$this->load->view('fraud_listing', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}	
	
	
	function block_list(){
	
		// ini_set("memory_limit","512M");
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2','Reservation-Admin','Finance'));
		$this->users->check_session(array('IT','Super Admin'));

		// prepare data for the template
		$data['page_title'] = 'Fraud';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('name','customer_notes');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}

		// pagination
		$this->load->library('pagination');		
		$limit = $this->pagination->per_page;
		$limit= 20;
		$offset = $this->uri->segment(3);		
		
		$config['base_url'] = site_url('fraud/block_list');
		$config['total_rows'] = count( $this->fraud->get_blocked_customers($searchkey) );
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$data['fraud'] = $this->fraud->get_blocked_customers($searchkey, $offset, $limit);
				
				// echo $this->db->last_query();
			
		$this->load->view('block_listing', $data);
	
	
	}
	
	function block($customer_id = false){
	
	
	$result = $this->fraud->block($customer_id);
	
	echo $result;
	
	}	
	
	function unblock($customer_id = false){
	
	
	$result = $this->fraud->unblock($customer_id);
	
	echo $result;
	
	}
	
	function process_payment()
	{
		$this->users->check_session(array('Admin','Super Admin'));
		$url = 'https://aws-api.smtickets.com/prodAPI/v1/transaction/payment_done';
		
		if(isset($_POST['referencenumber']) && isset($_POST['amount']) && isset($_POST['paycode'])){
			 
			$this->logs->add('Process Payment -' . $_POST['referencenumber']);

		
			$data = array(
				'referencenumber' => $_POST['referencenumber'],
				'paycode' => $_POST['paycode'],
				'amount' => $_POST['amount']
			);

			 
			$options = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST',
					'content' => http_build_query($data)
				),
			);

			$context  = stream_context_create($options);
			$result = @file_get_contents($url, false, $context);
			
			
			echo $result ;
			
		}else{
			$this->load->view('process_payment_it');
		}
			
	}
			
	function overide_payment()
	{
		$this->users->check_session(array('Admin','Super Admin'));
		$url = 'https://aws-api.smtickets.com/tmAPI/transaction/payment_done_2';
		
		if(isset($_POST['referencenumber'])){
			 $ref =  explode("-", $_POST['referencenumber']);
  
			if($ref[1] == ''){
				die('Reference number is required');
			}
			 
			if($_POST['reservationnumber'] == ''){
				die('Reservation number is required');
			}
			 
			if($_POST['amount'] == ''){
				die('Amount is required');
			}
			
			
			//update ticket details w/ res 
			$this->db->where_in('ticket_transaction_id', [$ref[1] , $_POST['reservationnumber']]);
			$q = $this->db->get('tickets');
			if($q->num_rows() > 0){
				$result = $q->result(); 
				$e = [];
				$reservations = [];
				$unselected = [];
				foreach($result as $x){
					if($x->ticket_status == 'reserved'){  $reservations[] = $x; }
					if($x->ticket_status == 'unselected'){ $unselected[] = $x; }
					
					$e[] = $x->ticket_event_id;
				}
				if(count($reservations) !=  count($unselected)) { die('Please check reservation qty.');}
				
				if(count(array_unique($e)) > 1){ die('Please check reservation event.');}
			 
				for ($x = 0; $x < count($unselected); $x++) {
					
					
					$fields = array(
						'ticket_section_id'		=>$reservations[$x]->ticket_section_id,
						'ticket_price_id'		=>$reservations[$x]->ticket_price_id,
						'ticket_system_row'		=>$reservations[$x]->ticket_system_row,
						'ticket_system_col'		=>$reservations[$x]->ticket_system_col,
						'ticket_row'			=>$reservations[$x]->ticket_row,
						'ticket_seat'			=>$reservations[$x]->ticket_seat,
					);
				
					// update db
					$this->db->where('ticket_id', $unselected[$x]->ticket_id);
					$this->db->where('ticket_status', 'unselected');
					$this->db->limit(1); 
					$this->db->update('tickets', $fields);
					
					$this->logs->add('Override -' .$ref[1] . '-' . $_POST['reservationnumber']);
					 
				} 
				// echo '<pre>';
				// print_r($reservations);
				
			}
			
			
			 
			$data = array(
				'cardnumber' => $_POST['cardnumber'],
				'referencenumber' => $_POST['referencenumber'],
				'paycode' => $_POST['paycode'],
				'amount' => $_POST['amount'],
				'others' => ''
			);

			 
			$options = array(
				'http' => array(
					'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
					'method'  => 'POST',
					'content' => http_build_query($data)
				),
			);

			$context  = stream_context_create($options);
			$result = @file_get_contents($url, false, $context);
			
			
			
			echo $result ;
			
		}else{
			$this->load->view('override_payment_it');
		}
	}
	

}	
/* End of file transactions.php */
/* Location: ./application/controllers/transactions.php */	

