<?php
require 'vendor/autoload.php';
use Aws\S3\S3Client;

class Events extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('events_model', 'events');
		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('files_model', 'files');
		$this->load->model('sections_model', 'sections');
		$this->load->model('logs_model', 'logs');
		$this->load->model('pages_model', 'pages');
		$this->load->model('extension_model', 'extension');
		$this->load->model('video_model', 'video');
		$this->load->model('branches_model', 'branches');
		$this->load->model('event_code_model', 'event_pre_selling');
		$this->load->database('default');
		
		ini_set('user_agent',$this->agent->agent_string());

	}
	
	// --------------------------------------------------------------------

	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		
		if($this->session->userdata('user_type')=='Treasury'){
		$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->benchmark->mark('query_end');		
		$this->load->view('events_listing', $data);
		$this->benchmark->mark('page_end');

		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);

	}
	
	function all()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_all_events($searchkey);
		//print_r($this->db->last_query());
		
		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function active()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_active_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function inactive()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_inactive_events($searchkey);
	
		
		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function current()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		redirect('');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($event_id = FALSE)
	{
		
		// if($this->session->userdata('user_type') != 'Admin') {
			
			// $this->session->set_flashdata('message', assemble_message('Selling is not available at the moment'));
			// redirect('');
		// }
		
		//unset valid date
		$this->session->unset_userdata('valid_date');
		
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$this->load->helper('simplejson');
		
		if (!$event_id) 
		{
			if ($this->session->userdata('cei')) 
			{
				$event_id = $this->session->userdata('cei');

				
			}
			else
			{
				show_404();
			}
		}
		else
		{
			if ($this->session->flashdata('message'))
				$this->session->set_flashdata('message', $this->session->flashdata('message'));
				
			$this->session->set_userdata('cei', $event_id);
			$this->session->unset_userdata('cqr');
			redirect('events/view');
		}
		
		 
		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Finance'))){
		
			$this->db->query('set transaction isolation level read uncommitted');
			$sql = "select event_active from events e where e.event_id = ?";

			$query= $this->db->query($sql, array($this->session->userdata('cei'))); 
			$row = $query->row();
			$status = $row->event_active;
			if($status == 0)
			redirect('');
			// $this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
		 
			//lite version
			// redirect('events/view_lite');
		}
		
		 
		
		//hide event
		// if($this->session->userdata('user_type') != 'Admin','Super Admin' && ($event_id == 10 || $event_id == 5157)){

		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')) && $event_id == 10){
			
			redirect('');
		}
		
		
		//check login session 
		$this->users->check_user_session();
		
		
		 
		
		
		
		//skyranch
		if($this->session->userdata('user_branch_id') == 217){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		
		//EXO restricton
		if($event_id == 7804){
			$exo_branches = array(1,123,231,231);
			 
			if(in_array($this->session->userdata('user_branch_id'), $exo_branches)){
				
				
			 $this->session->set_flashdata('message', assemble_message('Event selling is not available on this branch'));
			 redirect('');
			}
			
			 
		}
		
		//cosplay restricton   11631,11633,11634
		if(in_array( $event_id, [11631,11633,11634])){
			$nct_branches = array(103,1);
			 
			if(!in_array($this->session->userdata('user_branch_id'), $nct_branches)){
				 
			 $this->session->set_flashdata('message', assemble_message('Event selling is not available on this branch'));
			 redirect('');
			}
			
			 
		}
		
		//SUJU 9
		if($event_id == 11647){
			$suju_branches = array(103,1);
			 
			if(!in_array($this->session->userdata('user_branch_id'), $suju_branches)){
				 
			 $this->session->set_flashdata('message', assemble_message('Event selling is not available on this branch'));
			 redirect('');
			}
			
			 
		}
		
		
		
	
		// prepare data for the template
		$data['page_title'] = 'View Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		//$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller'));
	
	
	
	
		// clear previously selected tickets that are due for clearing
		$this->tickets->clear_selected_seats();
		
		// remove current customer session and tickets
		$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
		$this->session->set_userdata(array('customer_session_id' => '', 'claim' => ''));
	
		// add event id to session
		$this->session->set_userdata('cei', $event_id);
	
		// get event
		$event = $this->events->get($event_id);

		//CHECK IF SELLING TO SELECTED BRANCHES IS ACTIVE
		if($event->event_branch_selling!="" || $event->event_branch_selling!=null){
			$selected_branches = unserialize($event->event_branch_selling);
			array_push($selected_branches,1);
			if(!in_array($this->session->userdata('user_branch_id'), $selected_branches)){
			 $this->session->set_flashdata('message', assemble_message('Event selling is not available on this branch'));
			 redirect('');
			}

		}
		
			
				
		//update section availability 
		if($event->events_date_validity == 0 || $event->events_date_validity == ''){
			$this->update_availability($event_id);
		
		}
		 
		
		// get prices
		$prices = $this->prices->get_prices_compact($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$price_section_info = $this->sections->get_ticket_availability_lite($price->price_sections, $event->event_seatplan_id, true); 
			$section_type = $price_section_info['type'];
			// if (strtolower($section_type) == "reserved") { 
				// $available = $price_section_info['total_available_db'];
			// } else {
				$available = $price_section_info['total_available'];
			// }
		 
			
			$sec_type_price[] = array(
				$price->price_name,
				($available > 0)? "" : "*SOLD OUT",
				($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
				number_format($price->price_price),
				$price_section_info['total_capacity'],
				$price_section_info['total_reserved'],
				$available,
				$price->price_hidden_online,
				$price->price_hidden_otc,
 			);
			 
			// $total_availability += $available;
		endforeach;

		$data["event"] = $event;
		$data["sec_type_price"] = $sec_type_price;
		
		$this->benchmark->mark('query_end');

	
		$this->db->select('events_config_qrcode_active');
		$this->db->where('events_config_eventid', $event_id);
		$q = $this->db->get('events_config');
		$qr = $q->row();
		$count = $q->num_rows();
		
		
		if(($count > 0) && ($qr->events_config_qrcode_active) &&  $event->event_promo ==0){

			$this->load->view('gtqr_events_view', $data);
		}else{
			
			

			
			
			//toruk special access
			$turok = array(5577,5628,5627,5630,5629,5631,5632,5634,5633,5636,5635,5638,5637,5640,5639);
			$turok_seller = array(4243,4242,4185 ,4226,4227,4228,4229,4230,4231,4232,4234,4235);

			if (in_array($this->session->userdata('user_id'), $turok_seller)){
				 
				 
				$this->load->view('events_view_toruk', $data);
				 
			}elseif($event_id == 5803){
				 
				 
				$this->load->view('events_view_harry', $data);
				 
			}else{
				
				
				$lock = $this->events->check_event_lock_status($event_id);
				if($lock){
					 
				$this->load->view('events_view_locked', $data);
					
				}else{
					
					
				$this->load->view('events_view', $data);
				}
				
				
			}
			
			
			
		}
		
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
	
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */



	 function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin'));
			
		$config = array(
			array(
				'field'   => 'event_code',
				'label'   => 'Event Code',
				'rules'   => 'trim|required|strip_tags|max_length[20]|callback__event_code_check'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			// array(
				// 'field'   => 'event_type',


				// 'label'   => 'Event Type',
				// 'rules'   => 'trim|required|strip_tags|max_length[80]'
			// ),

			array(
				'field'   => 'event_performers',
				'label'   => 'Performers',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_performers_website',
				'label'   => 'Performers Website Address',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_description',
				'label'   => 'Description/Synopsis',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'date_time',
				'label'   => 'Date and Time',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),			
			
			array(
				'field'   => 'event_expiration',
				'label'   => 'Event Expiration',
				'rules'   => 'trim|strip_tags|max_length[3]'
			),
			array(
				'field'   => 'event_photo',
				'label'   => 'Event Photo',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'event_photo_1',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_2',
				'label'   => 'Event Picture 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_3',
				'label'   => 'Event Picture 3',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'promoter_id',
				'label'   => 'Promoter Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'seatplan_id',
				'label'   => 'Seat Plan',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'event_reservation_expire',
				'label'   => 'Reservation Expiry',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'
			),	
			array(
				'field'   => 'event_internet_sales_charge',
				'label'   => 'Internet Sales Charge',
				'rules'   => 'trim|required|strip_tags|integer'
			),
			
			array(

				'field'   => 'event_tags',
				'label'   => 'Event Tags',
				'rules'   => 'trim|required|strip_tags'
			),


			
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
		
		// get promoters
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		
		// get seatplans
		$data['seatplans'] = $this->seatplans->get_seatplans_dropdown();
		
		if ($this->form_validation->run() == FALSE)
		{	
			// display the page
			$this->load->view('events_add', $data);
		}
		else
		{
				
				
		
			// upload the photo; params: filename, max width, max height
			$image_path = $this->files->upload_image('event_photo', 640, 1000);
			
			
			$image_path_1 = $this->files->upload_image_1('event_photo_1', 640, 1000);
			$image_path_2 = $this->files->upload_image_1('event_photo_2', 640, 1000);
			$image_path_3 = $this->files->upload_image_1('event_photo_3', 640, 1000);


			// add to db
			$id = $this->events->add($image_path);

			for($i=1;$i<=20;$i++){

			if($this->input->post('video_name_'. $i) && $this->input->post('video_url_'. $i))
			{
				$this->video->embed($this->input->post('video_name_'. $i),$id,$this->input->post('video_url_'. $i));
			}
		}

			
			
			// redirect
			$this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
			redirect('');

		}
	}
	

 
	/**
	 * add video
	 *
	 * @access	public
	 */
	function video($event_id = false)
	{
		if(!$event_id)
		{
			$event_id = $this->session->userdata('cei');
			//echo '1';
		}
		else
		{
		$this->session->set_userdata('cei', $event_id);

			//echo '2';
		}
		// prepare data for the template
		$data['page_title'] = 'Add Video';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
			
		$config = array(
			array(
				'field'   => 'event_title',
				'label'   => 'Event Title',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'page_content',
				'label'   => 'Page Content',
				'rules'   => 'trim'
			),	
		);
		//$this->db->select('event_long_title');
		//$this->db->where('event_id', $event_id);
		//$query = $this->db->get('events');
		
		//$event_long = $query->row();
		//$page_id = preg_replace("/[^0-9a-z]/","", strtolower($event_long));
		// get event data
		//$data['pages'] = $this->pages->get($page_id);
		$data['event'] = $this->events->get($event_id);
		//$data['pages'] = $this->pages->get($page_id->page_id);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
				
		if ($this->form_validation->run() == FALSE)
		{	
			// display the page
			$this->load->view('events_video', $data);
		}
		else
		{
			$this->pages->add_video();
			//print_r($this->db->last_query());
			// redirect
			$this->session->set_flashdata('message', assemble_message('Video has been successfully added/updated.'));
			redirect('events/video/');
		}
	}
	
	function remove_video(){
	
		$result = $this->pages->remove_video();
		echo $result;
		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */



 
	 function edit($event_id = false)
	{
		
 
		 
		if(!$event_id)
		{
			$event_id = $this->session->userdata('cei');

		}
		else
		{
		$this->session->set_userdata('cei', $event_id);


		}
		
		
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			
			$this->db->where('e.event_id', $event_id);
			$this->db->where('e.event_cod', 1);
			$q = $this->db->get('events e');
			
			if ($q->num_rows() < 1){
			
			 $this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
			}
			
		}
		
		
		
		

	
		// prepare data for the template
		$data['page_title'] = 'Edit Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			

	 
		$config = array(
			array(
				'field'   => 'event_code',
				'label'   => 'Event Code',
				'rules'   => 'trim|required|strip_tags|max_length[20]|callback__event_code_check['. $event_id .']'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			// array(
				// 'field'   => 'event_url',

				// 'label'   => 'Event url',
				// 'rules'   => 'trim|required|strip_tags|max_length[255]|callback__event_url_check['. $event_id .']'
			// ),


			array(
				'field'   => 'event_category',
				'label'   => 'Category',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_performers',
				'label'   => 'Performers',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_performers_website',
				'label'   => 'Performers Website Address',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_description',
				'label'   => 'Description/Synopsis',
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'date_time',
				'label'   => 'Date and Time',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),
			array(
				'field'   => 'event_expiration',
				'label'   => 'Event Expiration',
				'rules'   => 'trim|strip_tags|max_length[3]'
			),
			array(
				'field'   => 'event_photo',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'event_photo_1',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_2',
				'label'   => 'Event Picture 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_3',
				'label'   => 'Event Picture 3',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'promoter_id',
				'label'   => 'Promoter Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'seatplan_id',
				'label'   => 'Seat Plan',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),	
			array(
				'field'   => 'event_reservation_expire',
				'label'   => 'Reservation Expiry',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'


			),	
			
			
			array(
				'field'   => 'event_max_ticket',
				'label'   => 'Max Ticket',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'


			),		
			
			array(
				'field'   => 'event_promo',
				'label'   => 'Promo',
				'rules'   => 'trim|strip_tags'


			),

			
			array(
				'field'   => 'event_tags',
				'label'   => 'Tags',
				'rules'   => 'trim|required|strip_tags'
			),

			array(
				'field'   => 'event_season',
				'label'   => 'Season Pass',
				'rules'   => 'trim|strip_tags'
			),
 
			array(
				'field'   => 'end_date_time',
				'label'   => 'End Date Time',
				'rules'   => 'trim|strip_tags'
			),







		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
		
		// get promoters
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		
		// get event data
		$data['event'] = $this->events->get($event_id);		
		
		// get video
		$data['video'] = $this->video->get_video($event_id);


		// get seatplans
		$current_seatplan['seatplan_id'] = $data['event']->seatplan_id;
		$current_seatplan['seatplan_name'] = $data['event']->seatplan_name;
		$data['seatplans'] = $this->seatplans->get_seatplans_dropdown($current_seatplan);
		

		if ($this->form_validation->run() == FALSE){		

			// display the page
			$this->load->view('events_edit', $data);

		}else{



		for($i=1;$i<=20;$i++){
			if($this->input->post('video_id_'.$i)){
			if ($_FILES['video_thumb_'. $i]['name'])
			{
				// upload the photo; params: filename, max width, max height
				$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
			}else{
			$videoThumbnailLink = false;
			}
				$this->video->update($this->input->post('video_id_'. $i),$this->input->post('video_name_'. $i),$event_id,$this->input->post('video_url_'. $i), $videoThumbnailLink, $this->input->post('video_active_' . $i));
			}
			else if(!$this->input->post('video_id_'.$i) && $this->input->post('video_name_'. $i))
			{
				if ($_FILES['video_thumb_'. $i]['name'])
				{
					// upload the photo; params: filename, max width, max height
					$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
				}else{
				$videoThumbnailLink = false;
				}
				$this->video->embed($this->input->post('video_name_'. $i),$event_id, $this->input->post('video_url_'. $i), $videoThumbnailLink );
			}
		}
		
			// echo '<pre>';
			// print_r($_FILES);
			// echo '</pre>';
			// die();
		
			//Upload images
			if ($_FILES["event_photo"]["error"] != 4)
			{
				// upload the photo; params: filename, max width, max height
				$bucketName = 'images.smtickets.com';
				$bucketPath = 'images5.smtickets.com';
				$imageTmp = $_FILES['event_photo']['tmp_name'];
				$imageName = $_FILES['event_photo']['name'];
				$imageType = $_FILES['event_photo']['type'];

				$date = new DateTime('now');
				$timestamp = $date->format('dmYHis');
				$ext = pathinfo($imageName, PATHINFO_EXTENSION);

				$imageNameOnly = "portrait_".$timestamp.".".$ext;
				$imageNewName = "images/"."portrait_".$timestamp.".".$ext;
				$imagePath = "https://" . $bucketPath . "/" . $imageNewName;

				$image_path = $this->files->upload_image('event_photo', 640, 1000, $imageNameOnly);

				if(strpos($image_path, "The uploaded file exceeds the maximum allowed size in your PHP configuration file.") == true || strpos($image_path, "The file you are attempting to upload is larger than the permitted size.") == true) {
					$error_message = "Unable to upload image. Image size exceeded 200 KB max size. Please reduce the image size.";
					$image_path = "";
				} else if (strpos($image_path, "The filetype you are attempting to upload is not allowed.") == true) {
					$error_message = strip_tags($image_path);
					$image_path = "";
				}
				else {
					list($width, $height, $type, $attr) = getimagesize($imageTmp);
					$imageSize = filesize($imageTmp);
					$imageWH = $width . " x " . $height; 

					// $this->banner->upload($imageNewName, $imagePath, $imageWH, $imageSize);

					$s3 = new S3Client([
					    'version' => 'latest',
					    'region'  => 'ap-southeast-1',
					    'credentials' => [
					        'key'    => 'AKIARGTGZ65DTYI5F6FU',
					        'secret' => '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'
					    ],
					    'http' => [ 'verify' => false ]
					]);
					 
					// Upload a publicly accessible file. The file size and type are determined by the SDK.
					try {
					    $result = $s3->putObject([
					        'Bucket' => $bucketName,
					        'Key'    => $imageNewName,
					        'SourceFile' => $imageTmp,
					        'ContentType' => $imageType
					    ]);
					    // echo $result->get('ObjectURL');
					} 
					catch (Aws\S3\Exception\S3Exception $e) {
					    // echo "There was an error uploading the file.\n";
					    // echo $e->getMessage();
					}
				}
			}
			else 
			{
				$image_path = '';
			}
			if ($_FILES["event_photo_1"]["error"] != 4)
			{
				// upload the photo; params: filename, max width, max height
				$bucketName = 'images.smtickets.com';
				$bucketPath = 'images5.smtickets.com';
				$imageTmp = $_FILES['event_photo_1']['tmp_name'];
				$imageName = $_FILES['event_photo_1']['name'];
				$imageType = $_FILES['event_photo_1']['type'];

				$date = new DateTime('now');
				$timestamp = $date->format('dmYHis');
				$ext = pathinfo($imageName, PATHINFO_EXTENSION);

				$imageNameOnly = "carousel_".$timestamp.".".$ext;
				$imageNewName = "images/"."carousel_".$timestamp.".".$ext;
				$imagePath = "https://" . $bucketPath . "/" . $imageNewName;

				$image_path_1 = $this->files->upload_image_1('event_photo_1', 640, 1000, $imageNameOnly);
				
				if(strpos($image_path_1, "The uploaded file exceeds the maximum allowed size in your PHP configuration file.") == true || strpos($image_path_1, "The file you are attempting to upload is larger than the permitted size.") == true) {
					$error_message_1 = "Unable to upload image. Image size exceeded 200 KB max size. Please reduce the image size.";
					$image_path_1 = "";
				} else if (strpos($image_path_1, "The filetype you are attempting to upload is not allowed.") == true) {
					$error_message_1 = strip_tags($image_path_1);
					$image_path_1 = "";
				}
				else {
					list($width, $height, $type, $attr) = getimagesize($imageTmp);
					$imageSize = filesize($imageTmp);
					$imageWH = $width . " x " . $height; 

					// $this->banner->upload($imageNewName, $imagePath, $imageWH, $imageSize);

					$s3 = new S3Client([
					    'version' => 'latest',
					    'region'  => 'ap-southeast-1',
					    'credentials' => [
					        'key'    => 'AKIARGTGZ65DTYI5F6FU',
					        'secret' => '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'
					    ],
					    'http' => [ 'verify' => false ]
					]);
					 
					// Upload a publicly accessible file. The file size and type are determined by the SDK.
					try {
					    $result = $s3->putObject([
					        'Bucket' => $bucketName,
					        'Key'    => $imageNewName,
					        'SourceFile' => $imageTmp,
					        'ContentType' => $imageType
					    ]);
					    // echo $result->get('ObjectURL');
					} 
					catch (Aws\S3\Exception\S3Exception $e) {
					    // echo "There was an error uploading the file.\n";
					    // echo $e->getMessage();
					}
				}
			}
			else 
			{
				$image_path_1 = '';
			}
			
			
			if (isset($_FILES['event_photo_2']['name']))
			{
				// upload the photo; params: filename, max width, max height
				$image_path_2 = $this->files->upload_image_1('event_photo_2', 640, 1000,'medium');
			}
			else 
			{
				$image_path_2 = '';
			}
			
			if (isset($_FILES['event_photo_3']['name']))
			{
				// upload the photo; params: filename, max width, max height
				$image_path_3 = $this->files->upload_image_1('event_photo_3', 640, 1000,'thumb');
			}
			else 
			{
				$image_path_3 = '';
			} 

			
				
				// add to db
				$this->events->edit($event_id, $image_path, $image_path_1,$image_path_2,$image_path_3);


			if(isset($error_message)) {
				$this->session->set_flashdata('message', assemble_message($error_message));
				redirect('events/edit/');
			}
			else if(isset($error_message_1)) {
				$this->session->set_flashdata('message', assemble_message($error_message_1));
				redirect('events/edit/');
			}
			else {
				$this->session->set_flashdata('message', assemble_message('Event has been successfully modified'));
				redirect('events/edit/');
			}
		}

	}
 

	
	// --------------------------------------------------------------------
	
	/**
	 * copy
	 *
	 * @access	public
	 */
	
	
	
	
	
	
	function copy($event_id)
	{
		// copy the event
		$new_event_id = $this->events->copy($event_id);
		
		// redirect
		$this->session->set_userdata('cei', $new_event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully copied except the price sections.  You may manually specify them now.'));
		redirect('prices/listing/');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_ticket_types
	 *
	 * @access	public
	 */
	function edit_ticket_types($event_id = false)
	{
		if ((!$this->session->userdata('cei'))  && (!$event_id)) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
			
		$config = array(
			array(
				'field'   => 'ticket_types[]',
				'label'   => 'Ticket Types',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
	
		if ($this->form_validation->run() == FALSE)
		{
			// get ticket types
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_sort();
		
			// display the page
			$this->load->view('events_edit_ticket_types', $data);
		}
		else
		{
			$this->events->edit_ticket_types($event_id);
			$this->events->generate_ticket_types_per_event($event_id); //for smphi reports
			$this->session->set_flashdata('message', assemble_message('Ticket types has been successfully modified'));
			redirect('events/edit_ticket_types/');
		}
	}	
	// --------------------------------------------------------------------
	
	/**
	 * edit charges
	 *
	 * @access	public
	 */
	function edit_charges($event_id=false)
	{
		if ((!$this->session->userdata('cei')) && (!$event_id) ) show_404();
		if($this->session->userdata('user_type')=='Finance' && ($event_id)){
			$event_id = $event_id;
		}else{
			$event_id = $this->session->userdata('cei');
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Charges';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
			
		$config = array(
			array(
				'field'   => 'event_venue_amusement_tax',
				'label'   => 'Venue Amusement Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_withholding_tax',
				'label'   => 'Venue Withholding Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_tax',
				'label'   => 'Venue Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_1',
				'label'   => 'Event Charge 1',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_2',
				'label'   => 'Event Charge 2',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_3',
				'label'   => 'Event Charge 3',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_4',
				'label'   => 'Event Charge 4',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_5',
				'label'   => 'Event Charge 5',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),									
			array(
				'field'   => 'event_venue_commission',
				'label'   => 'Venue Commission',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_service_charge',
				'label'   => 'Service Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_ticket_charge',
				'label'   => 'Ticket Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_vat',
				'label'   => 'VAT',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_withholding_tax',
				'label'   => 'WithholdinG Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),	
			array(
				'field'   => 'event_bank_charge_internet',
				'label'   => 'Service Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_bank_charge_outlet',
				'label'   => 'Bank Charge Outlet',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_administrative_fee',
				'label'   => 'Administrative Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_minimum_guarantee',
				'label'   => 'Minimum Guarantee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_internet_sales_charge',
				'label'   => 'Internet Sales Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_delivery_charge',
				'label'   => 'Delivery Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),		
			array(
				'field'   => 'event_revenue_pullout',
				'label'   => 'Revenue Pull - Out',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_complimentary_pullout',
				'label'   => 'Complimentary Pull - Out',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_interest_fee',
				'label'   => 'Interest Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'

			),
			array(
				'field'   => 'event_reservation_fee',
				'label'   => 'Reservartion Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(

				'field'   => 'event_charge_01',
				'label'   => 'Charge 01',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_02',
				'label'   => 'Charge 02',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_03',
				'label'   => 'Charge 03',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_04',
				'label'   => 'Charge 04',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_05',
				'label'   => 'Charge 05',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_06',
				'label'   => 'Charge 06',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_07',
				'label'   => 'Charge 07',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_08',
				'label'   => 'Charge 08',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_09',
				'label'   => 'Charge 09',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_10',
				'label'   => 'Charge 10',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),										
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get($event_id);
			
			// display the page
			$this->load->view('events_charge', $data);
		}
		else
		{
			$this->events->edit_charge($event_id);
			$this->session->set_flashdata('message', assemble_message('Charges has been successfully modified'));
			redirect('events/edit_charges');
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($event_id = FALSE)
	{
		// log this
		$this->logs->add('Delete Event');
		
		
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->events->delete($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully deleted'));
		redirect('');
	}
	
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function recommend($event_id = FALSE)
	{
		// log this
		$this->logs->add('Add To Recommended Event');
			
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->events->recommend($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully added to Recommended Events'));


		redirect('events/edit/');
		// redirect('');
	}
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function unrecommend($event_id = FALSE)
	{
		// log this
		$this->logs->add('Remove From Recommended Event');
			
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->events->unrecommend($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully removed from Recommended'));


		redirect('events/edit/');
		// redirect('');
	}		
	
	function images() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));

		$this->load->view('events_image_upload_links', $data);
	}	
	
	function images_sync_list() {
		// prepare data for the template
		$data['page_title'] = 'Image Synchronized';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		$this->load->view('events_images_sync_list');
	}
	
	
	function images_sync() {
		// prepare data for the template
		$data['page_title'] = 'Synchronize Website Images';
		// $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$url = $this->config->item("images_sync_url");
		@$this->extension->do_http_post_request($url,array());
		shell_exec("wget -nH -r -l 2 -p $url");
		
		
		// $url1 = $this->config->item("images_sync_url1"); 
		// @$this->extension->do_http_post_request($url1,array());  
		// shell_exec("wget -nH -r -l 2 -p $url1");


		
		
		
		 

		$this->session->set_flashdata('message', assemble_message("Image sync done. Please double-check images on $url"));
		redirect('/events/images/');
	}
	
	function data_sync() {
		// prepare data for the template
		$data['page_title'] = 'Synchronize Website Data';
		// $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$url = $this->config->item("data_sync_url");
		@$this->extension->do_http_post_request($url,array());
		shell_exec("wget -nH -r -l 2 -p $url");
		

  
		
		// $url1 = $this->config->item("data_sync_url1");
		// @$this->extension->do_http_post_request($url1,array());
		// shell_exec("wget -nH -r -l 2 -p $url1");

		$this->db->cache_delete_all();
		
		
		
		$this->session->set_flashdata('message', assemble_message("Data sync done. Please double-check datas on $url"));
		redirect('events/images');
	}
	
  
	function _event_code_check($str = false, $id = false)
	{	
		$event_code_exists = $this->events->is_event_code_exist($str, $id);
		if ($event_code_exists)
		{
			$this->form_validation->set_message('_event_code_check', "Event Code $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	 	function _event_url_check($str, $id)
	{	
		$event_code_exists = $this->events->is_event_url_exist($str, $id);
		if ($event_code_exists)
		{
			$this->form_validation->set_message('_event_url_check', "Event Url $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	
	 
	function edit_payment_types()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Payment Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
			
		$config = array(
			array(
				'field'   => 'payment_types[]',
				'label'   => 'Payment Types',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info 
		$data['event'] = $this->events->get($event_id);
		$data['payment_types'] = $this->events->get_payment_types($event_id);
	
		if ($this->form_validation->run() == FALSE)
		{
			 
		
			// display the page
			$this->load->view('events_edit_payment_types', $data);
		}
		else
		{
			$this->events->edit_payment_types($event_id);
			$this->session->set_flashdata('message', assemble_message('Payment types has been successfully modified'));
			redirect('events/edit_payment_types/');
		}
	}	
	// --------------------------------------------------------------------
	
	function all_events(){

		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			
			redirect('');
		}


		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_all_events_sorted(1,'');

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing_all', $data);
	}
	

	
	
	function get_query(){
		echo $this->events->get_all_events_sorted(2);
	}
	
	 
	function save_event_cms(){
		
		$event_ids = $this->input->get_post("event_ids");
		$category =	$this->input->get_post("category");
		// $event_ids = explode(",", $event_ids);
		$IDs = "";
		
		 
		foreach($event_ids	as $event_id){
			$IDs = $IDs . "$event_id,";
		}	



		echo $this->events->save_event_cms($IDs,$category);
		
	}

	function get_event_in_cms(){
		
		parse_str(substr(strrchr($_SERVER['REQUEST_URI'], "?"), 1), $_GET);

		$sort = $_GET['event_type']; 	
		$filter = $_GET['filter']; 	
		
		$id = $this->events->get_all_events_filter($sort);
	
		// $ids = $id->event_id;
		if(isset($id->event_ids)){
			$ids = $id->event_ids;
		}else{
			$ids = '';
		}
		
		// echo $this->events->get_event_in_cms($sort,$ids);
		echo json_encode($this->events->get_event_in_cms($sort,$ids,$filter));
		
	}
	
	function get_event_in_cms2(){
		
		parse_str(substr(strrchr($_SERVER['REQUEST_URI'], "?"), 1), $_GET);

		$sort = $_GET['event_type']; 	
		$filter = $_GET['filter']; 	
		
		$id = $this->events->get_all_events_filter($sort);
		if(isset($id->event_ids)){
			$ids = $id->event_ids;
		}else{
			$ids = '';
		}
		// echo $this->events->get_event_in_cms($sort,$ids);
		echo json_encode($this->events->get_event_in_cms($sort,$ids,$filter));
		
	}
	// function get_all_events_filter(){
		
		 // $ids = $this->events->get_all_events_filter(2);
		 // echo $ids->event_id;
	// }
	
	function get_all_events_sorted(){
		
		parse_str(substr(strrchr($_SERVER['REQUEST_URI'], "?"), 1), $_GET);

		$sort = $_GET['event_type']; 
		$ids = $_GET['ids']; 
		
		$sorted = $this->events->get_all_events_sorted($sort,$ids);
		
		echo json_encode($sorted);
	}
	
	
	function filter_by_venue(){
		
		parse_str(substr(strrchr($_SERVER['REQUEST_URI'], "?"), 1), $_GET);

		$venue = $_GET['venue']; 
		$ids = $_GET['ids']; 
		
		$sorted = $this->events->filter_by_venue($venue,$ids);
		
		echo json_encode($sorted);
	}
	
	
	function get_postponed_date($event_id){
		$postponed_date = $this->events->get_postponed_date($event_id);
	}
	
	function remove_expired_events(){
		
		
		
		$hot_events = $this->events->get_all_events_filter(1);
		$hot_events = $hot_events->event_id;

		$hot_event_result =  $this->events->get_active_filtered_events($hot_events);

		$active_hot_events = "";
		foreach($hot_event_result as $res){
			$active_hot_events .= $res->event_id.',';
		}
		echo $active_hot_events = substr($active_hot_events, 0,-1);
		echo '<br>';
		$just_announce = $this->events->get_all_events_filter(2);
		$just_announce = $just_announce->event_id;
		
		$just_announce_result =  $this->events->get_active_filtered_events($just_announce);

		$active_just_announce = "";
		foreach($just_announce_result as $res){
			$active_just_announce .= $res->event_id.',';
		}
		echo $active_just_announce = substr($active_just_announce, 0,-1);
		echo '<br>';
		$featured = $this->events->get_all_events_filter(3);
		$featured = $featured->event_id;
		
		$active_featured_result =  $this->events->get_active_filtered_events($featured);

		$active_featured = "";
		foreach($active_featured_result as $res){
			$active_featured .= $res->event_id.',';
		}
		echo $active_featured = substr($active_featured, 0,-1);
		echo '<br>';
		$caroussel = $this->events->get_all_events_filter(1);
		$caroussel = $caroussel->event_id;
		
		$active_caroussel_result =  $this->events->get_active_filtered_events($caroussel);

		$active_caroussel = "";
		foreach($active_caroussel_result as $res){
			$active_caroussel .= $res->event_id.',';
		}
		
		echo $active_caroussel = substr($active_caroussel, 0,-1);
		// die();
		echo '<br>'.$active_featured;
		
		$save_active_hot_events = $this->events->save_event_cms($active_hot_events,1);
		$save_active_just_announce = $this->events->save_event_cms($active_just_announce,2);
		$save_active_featured_events = $this->events->save_event_cms($active_featured, 3);
		$save_active_caroussel = $this->events->save_event_cms($active_caroussel,4);
		
	}
	
	function edit_seo($event_id)
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Charges';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'meta_description_content',
				'label'   => 'Meta Description Content',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'meta_keywords_content',
				'label'   => 'Meta Keywords Content',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'link_rel_canonical',
				'label'   => 'Link rel Canonical',
				'rules'   => 'trim|required|strip_tags'
			),
												
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get_seo($event_id);
			// print_r($this->events->get_seo($event_id));
			// die();
			// display the page
			$this->load->view('event_seo', $data);
		}
		else
			
		
		{
			
			$meta = $this->events->get_seo($event_id)->meta_description_content;
			if($meta==''){
			$this->events->add_seo($event_id);
			$this->session->set_flashdata('message', assemble_message('Event SEO has been successfully added'));
			redirect('events/edit_seo/'.$event_id);
			}else{
			
			$this->events->edit_seo($event_id);
			$this->session->set_flashdata('message', assemble_message('Event SEO has been successfully modified'));
			redirect('events/edit_seo/'.$event_id);
			}
		}
	}
	
	function mail_test(){
		// echo 'dsf';
		// die();
		$to = "johnny.bayod@mobilegroupinc.com";
		$subject = "test";
		// $date_today = date("Y-m-d");
		// Get HTML contents from file
		// $asr_url = base_url()."auto_email/email_asr/".$a_email->event_id;
		
		// die();
		$htmlContent = "asaffsd";

		// Set content-type for sending HTML email
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

		// Additional headers
		$headers .= 'From: smtickets' . "\r\n";
		// $headers .= 'Cc: test@gmail.com' . "\r\n";

		// Send email
		mail($to,$subject,$htmlContent,$headers);
	}

	function date_validity($event_id)
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Date Validity';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'events_valid_dates',
				'label'   => 'Select valid dates',
				'rules'   => 'trim|strip_tags'
			),
												
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get_valid_dates($event_id);
			
			// get used price dates
			$data['used_dates'] = $this->prices->get_used_dates($event_id);

			// display the page
			$this->load->view('event_date_validity', $data);
		}
		else
			
		
		{
			
			$valid_dates = $this->events->get_valid_dates($event_id)->meta_description_content;
			$result = $this->events->edit_valid_dates($event_id);
			if($result){
				if($valid_dates==''){	
					$this->session->set_flashdata('message', assemble_message('Event Valid Dates have been successfully added'));	
				}else{
					$this->session->set_flashdata('message', assemble_message('Event Valid Dates have been successfully modified'));
				}
				redirect('events/date_validity/'.$event_id);
			}else{
				$this->session->set_flashdata('message', assemble_message('An error occured. Please try again.'));
				redirect('events/date_validity/'.$event_id);
			}
			
		}
	}
	
	function set_session_data($session_variable=false,$session_data=false){
		
		if(!$session_variable){$session_variable = $this->input->get_post('variable');}
		if(!$session_data){$session_data = $this->input->get_post('data');}
		
		
		$this->session->set_userdata($session_variable, $session_data);
			
		// echo $session_variable." : ".$this->session->userdata('valid_date');
	}
	
	function get_prices_per_date($event_id){
		
		$session_variable = $this->input->get_post('variable');
		$session_data = $this->input->get_post('data');
		
		$this->set_session_data($session_variable,$session_data);
		
		$date=date_format(date_create($session_data),"m/d/Y");
		$date2=date_format(date_create($session_data),"Y-m-d");
		
		$price_dates = $this->prices->get_price_dates($event_id,$date);
		
		if($price_dates){		
			$prices_id = unserialize($price_dates[0]->price_event_date_price_id);	
			
			// print_r($prices_name);
			// die();
			
			// get event
			$event = $this->events->get($event_id);
			
			// get prices
			$prices = $this->prices->get_prices_compact($event_id);
			$sec_type_price = array();
			
			
			
			foreach($prices as $price):
				// print_r($price); die();
				if(in_array($price->price_id, $prices_id)):
				$price_section_info = $this->sections->get_ticket_availability_kid($date2 , $price->price_sections, $event->event_seatplan_id, true); 
				$section_type = $price_section_info['type'];
				// if (strtolower($section_type) == "reserved") { 
					// $available = $price_section_info['total_available_db'];
				// } else {
					$available = $price_section_info['total_available'];
				// }
				$sec_type_price[] = array(
					$price->price_name,
					($available > 0)? "" : "*SOLD OUT",
					($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
					number_format($price->price_price),
					$price_section_info['total_capacity'],
					$price_section_info['total_reserved'],
					$available,
				);
				// $total_availability += $available;
				endif;
			endforeach;
			
		}else{
			$sec_type_price[] = array(
				'Not Available',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
			);
			$this->events->remove_date_availabililty($event_id,$date);
		}
		
		
		
		echo json_encode($sec_type_price);
	}

	function view_lite($event_id = FALSE)
	{
		
		//unset valid date
		$this->session->unset_userdata('valid_date');
		$this->db->cache_on();
		// $this->benchmark->mark('page_start');
		// $this->benchmark->mark('query_start');

		$this->load->helper('simplejson');
		
		if (!$event_id) 
		{
			if ($this->session->userdata('cei')) 
			{
				$event_id = $this->session->userdata('cei');

				
			}
			else
			{
				show_404();
			}
		}
		else
		{
			if ($this->session->flashdata('message'))
				$this->session->set_flashdata('message', $this->session->flashdata('message'));
				
			$this->session->set_userdata('cei', $event_id);
			$this->session->unset_userdata('cqr');
			redirect('events/view');
		}
		
 	
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
		
			$this->db->query('set transaction isolation level read uncommitted');
			$sql = "select event_active from events e where e.event_id = ?";

			$query= $this->db->query($sql, array($this->session->userdata('cei'))); 
			$row = $query->row();
			$status = $row->event_active;
			if($status == 0)
			redirect('');
			// $this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
		 
		
		}
		
		 
		
		//hide event
		// if($this->session->userdata('user_type') != 'Admin','Super Admin' && ($event_id == 10 || $event_id == 5157)){

		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')) && $event_id == 10){
			
			redirect('');
		}
	
		// prepare data for the template
		$data['page_title'] = 'View Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		//$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller'));
	
		// clear previously selected tickets that are due for clearing
		$this->tickets->clear_selected_seats();
		
		// remove current customer session and tickets
		$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
		$this->session->set_userdata(array('customer_session_id' => '', 'claim' => ''));
		
		// add event id to session
		$this->session->set_userdata('cei', $event_id);
	
		// get event
		$event = $this->events->get($event_id);
		
		// get prices
		$prices = $this->prices->get_prices_compact($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$price_section_info = $this->sections->get_ticket_availability_lite($price->price_sections, $event->event_seatplan_id, true); 
			$section_type = $price_section_info['type'];
			if (strtolower($section_type) == "reserved") { 
				$available = $price_section_info['total_available_db'];
			} else {
				$available = 0;
			}
		 
			
			$sec_type_price[] = array(
				$price->price_name,
				($available > 0)? "" : "*SOLD OUT",
				($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
				number_format($price->price_price), 
 			);
			 
			// $total_availability += $available;
		endforeach;

		$data["event"] = $event;
		$data["sec_type_price"] = $sec_type_price;
		
		$this->benchmark->mark('query_end');

	
		$this->db->select('events_config_qrcode_active');
		$this->db->where('events_config_eventid', $event_id);
		$q = $this->db->get('events_config');
		$qr = $q->row();
		$count = $q->num_rows();
		
		
		if(($count > 0) && ($qr->events_config_qrcode_active) &&  $event->event_promo ==0){

			$this->load->view('gtqr_events_view', $data);
		}else{
			
			
		$this->db->cache_off();
			
			
			//toruk special access
			$turok = array(5577,5628,5627,5630,5629,5631,5632,5634,5633,5636,5635,5638,5637,5640,5639);
			$turok_seller = array(4243,4242,4185 ,4226,4227,4228,4229,4230,4231,4232,4234,4235);

			if (in_array($this->session->userdata('user_id'), $turok_seller)){
				 
				 
				$this->load->view('events_view_toruk', $data);
				 
			}else{
				
				
				$this->load->view('events_view_lite', $data);
				
			}
			
			
			
		}
		
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
	
	}
	
 
	function update_availability($event_id = false)
	{
		
		if($event_id == 7788) return false;
		
		
		// get event
		$event = $this->events->get($event_id);
		
		
		// get prices
		$prices = $this->prices->get_prices_compact2($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$this->sections->update_ticket_availability_sections($price->price_sections, $event->event_seatplan_id, true); 
			 
		endforeach;

		 
	}
	
	function update_availability_per_event($event_id = false)
	{
		
		// if($event_id == 7788) return false;
	 
		// get event
		$event = $this->events->get($event_id);
		
		
		// get prices
		$prices = $this->prices->get_prices_compact2($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$this->sections->update_ticket_availability_sections_per_event($price->price_sections, $event->event_seatplan_id, true); 
			 
		endforeach;

		 
	}
	
	
	function test(){
		
		preg_match('{[\}\{]}', '');
		$my_url = "+++?++";
		if (preg_match('%[a-zA-Z0-9_-|.:~[]|\\\/\\?]%', $my_url))
		{
			echo "the url $my_url contains guru";
		}
		else
		{
			echo "the url $my_url does not contain guru";
		}
	}

	function test2(){
		echo phpinfo();
	}

	function filename(){
		
		
		echo mktime(now());
	}
	
	function filter_by_branch($event_id = false)
	{
		if ((!$this->session->userdata('cei'))  && (!$event_id)) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
			
		$config = array(
			array(
				'field'   => 'event_branch_filter[]',
				'label'   => 'Event Branch Filter',
				'rules'   => 'trim|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
	
		if ($this->form_validation->run() == FALSE)
		{
			// get ticket types
			$data['branches'] = $this->branches->get_branches_dropdown();
		
			// display the page
			$this->load->view('event_branch_filter', $data);
		}
		else
		{
			$this->events->edit_branch_filter($event_id);
			$this->session->set_flashdata('message', assemble_message('branch filter has been successfully modified'));
			redirect('events/filter_by_branch/'.$event_id);
		}
	}
	
	
	/* for  dreamplay    */
	
	function createEvents(){
	
	$startdate = $this->input->get_post("from");
	$enddate = $this->input->get_post("to");
	$event_id = $this->input->get_post("event_id");

	
	
	if(!$startdate) die('No StartDate');
	if(!$enddate) die('No EndDate');
	if(!$event_id) die('No Event');
	
	
	 // get event info
	$event = $this->events->get($event_id);

	$EVENT_CODE = $event->event_code;
	$EVENT_TITLE = $event->event_title;
	$EVENT_PARENT = $event->event_parent;
	
	if($event->event_parent != "0"){
			$melco_event = $this->events->get($event->event_parent);	
			$EVENT_CODE = $melco_event->event_code;
			$EVENT_TITLE = $melco_event->event_title;
			$EVENT_PARENT = $melco_event->event_id;
	}

		$suffix = false;
		
		$timestamp =  strtotime($startdate);
		
		$startdate = (int)$startdate -1; //trick para sa pagrereproduce ng isang event date lang..basta
		
			while ($startdate < $enddate)
			{ 
			$startdate = date('Y-m-d', $timestamp);
			$suffix = date('mdy', $timestamp);

			$new_seatplan_id = $this->events->_copy_seatplan($event->event_seatplan_id);

				$data = array(
				
				'event_code' => $EVENT_CODE . "_" . $suffix,
				'event_title' => $EVENT_TITLE,
				
				'event_long_title' => $event->event_long_title, 
				'event_type' => $event->event_type, 
				'event_performers' => $event->event_performers, 
				'event_performers_website' => $event->event_performers_website, 
				'event_description' => $event->event_description, 
				'event_venue_id' => $event->event_venue_id, 
				'event_date_time' => $startdate, 
				'event_image' => $event->event_image, 
				'event_image_1' => $event->event_image_1, 
				'event_ticket_logo_1' => $event->event_ticket_logo_1, 
				'event_ticket_logo_2' => $event->event_ticket_logo_2, 
				'event_promoter_id' => $event->event_promoter_id, 
				'event_ticket_types' => $event->event_ticket_types, 
				'event_venue_amusement_tax' => $event->event_venue_amusement_tax, 
				'event_venue_withholding_tax' => $event->event_venue_withholding_tax, 
				'event_venue_tax' => $event->event_venue_tax, 
				'event_venue_charge_1' => $event->event_venue_charge_1, 
				'event_venue_charge_2' => $event->event_venue_charge_2, 
				'event_venue_charge_3' => $event->event_venue_charge_3, 
				'event_venue_charge_4' => $event->event_venue_charge_4, 
				'event_venue_charge_5' => $event->event_venue_charge_5, 
				'event_venue_commission' => $event->event_venue_commission, 
				'event_service_charge' => $event->event_service_charge, 
				'event_ticket_charge' => $event->event_ticket_charge, 
				'event_vat' => $event->event_vat, 
				'event_withholding_tax' => $event->event_withholding_tax, 
				'event_bank_charge_internet' => $event->event_bank_charge_internet, 
				'event_bank_charge_outlet' => $event->event_bank_charge_outlet, 
				'event_administrative_fee' => $event->event_administrative_fee, 
				'event_minimum_guarantee' => $event->event_minimum_guarantee, 
				'event_internet_sales_charge' => $event->event_internet_sales_charge, 
				'event_delivery_charge' => $event->event_delivery_charge, 
				'event_revenue_pullout' => $event->event_revenue_pullout, 
				'event_interest_fee' => $event->event_interest_fee, 
				'event_reservation_fee' => $event->event_reservation_fee, 
				'event_charge_01' => $event->event_charge_01, 
				'event_charge_02' => $event->event_charge_02, 
				'event_charge_03' => $event->event_charge_03, 
				'event_charge_04' => $event->event_charge_04, 
				'event_charge_05' => $event->event_charge_05, 
				'event_charge_06' => $event->event_charge_06, 
				'event_charge_07' => $event->event_charge_07, 
				'event_charge_08' => $event->event_charge_08, 
				'event_charge_09' => $event->event_charge_09, 
				'event_charge_10' => $event->event_charge_10,
				'event_seatplan_id' => $new_seatplan_id, 
				'event_last_receipt_number' => $event->event_last_receipt_number, 
				'event_reservation_expire' => $event->event_reservation_expire, 
				'event_active' => $event->event_active, 
				'event_disable_reservation' => $event->event_disable_reservation, 
				'event_recommended' => $event->event_recommended, 
				'event_disable_reservation' => $event->event_disable_reservation, 
				'event_always_show' => $event->event_always_show, 
				'event_hotel' => $event->event_hotel, 
				'event_online_registration' => $event->event_online_registration, 
				'event_expiration' => $event->event_expiration, 
				'event_promo' => $event->event_promo, 
				'event_max_ticket' => $event->event_max_ticket, 
				'event_cod' => $event->event_cod, 
				
				'event_parent' => $EVENT_PARENT,
				);
				
				$this->db->insert('events', $data);			
				$last_inserted_event = $this->db->insert_id();
						
				$new_ticket_layout = $this->_duplicate_ticket_layout($last_inserted_event,$event_id);	
				
				
			
						$prices = $this->prices->get_prices($event_id);
								//Iterate through each prices
							
							$melco_section = null;
							
							foreach($prices as $price){
								
								
								
								
								// if(empty($melco_section)){

								

								
									//get sections of each price
									$sections = unserialize($price->price_sections);
									
									
									
									$new_sections = array();
									
									//Iterate through each section
									foreach($sections as $section){
									$new_sections[] = $this->melco_copy_sections($section,$new_seatplan_id);
									}
									

									
									$price_parent = $price->price_id;
									// }
									
									$melco_section = $new_sections;
									
									
									$prices_data = array(
									'price_event_id' => $last_inserted_event,
									'price_name' => $price->price_name,
									'price_price' => $price->price_price, 
									'price_sections' => serialize($melco_section), 
									'price_parent' => $price_parent, 
									);

									
									
									// die())
									
									
									
									$this->db->insert('prices', $prices_data);
							}
	
			$timestamp = strtotime('+1 days', strtotime($startdate));

			}

		echo "success";
		die();
	}
	
	
	
	function delete_melco(){
	$event_id = $this->input->get_post("event");
	$event = $this->events->get($event_id);

						$prices = $this->prices->get_prices($event_id);
							foreach($prices as $price){
								//get sections of each price
								$sections = unserialize($price->price_sections);

								//Delete Sections
								foreach($sections as $section){
										$this->db->where('section_id',$section);
										$this->db->delete('sections'); 
								}
									
								$this->db->where('price_id',$price->price_id);
								$this->db->delete('prices'); 
							} 
			
			//Delete ticket Layout
			$this->db->where('ticket_layout_event_id',$event_id);
			$this->db->delete('ticket_layouts'); 
			
			
			//Delete Seatplan
			$this->db->where('seatplan_id',$event->event_seatplan_id);
			$this->db->delete('seatplans'); 
			
			//Delete Videos
			$this->db->where('video_event_id',$event_id);
			$this->db->delete('videos'); 
			
			//Delete Event
			$this->db->where('event_id',$event_id);
			$this->db->delete('events'); 
			
			echo "Event Successfully Deleted";
			Die();
							
	}
	
	 

	function melco_copy_sections($section_id,$seatplan_id){
	
	$this->db->where('section_id', $section_id);
	 $section = $this->db->get("sections")->result();
	 $section = $section[0];

		$data = array(	
		'section_seatplan_id' => $seatplan_id,
		'section_code' => $section->section_code 
		,'section_name' => $section->section_name
		// ,'section_name' => $section->section_name
		,'section_type' => $section->section_type
		,'section_stage_location' => $section->section_stage_location
		,'section_seat_config' => $section->section_seat_config
		,'section_seat_heads' => $section->section_seat_heads
		,'section_row_from' => $section->section_row_from
		,'section_row_to' => $section->section_row_to
		,'section_row_increment' => $section->section_row_increment
		,'section_col_from' => $section->section_col_from
		,'section_col_to' => $section->section_col_to
		,'section_col_increment' => $section->section_col_increment
		,'section_row_aisles' => $section->section_row_aisles
		,'section_col_aisles' => $section->section_col_aisles
		,'section_capacity' => $section->section_capacity
		,'section_available' => $section->section_available
		,'section_coords' => $section->section_coords
		,'section_parent' => $section->section_id
		);

		$this->db->insert('sections', $data);

	return $this->db->insert_id();
	}

	 

	function reproduce(){
	$data['browser_title'] = "Create Events";
	$this->load->view("melco",$data);
	}
	
	
	function get_event_by_date($value = false){

	
	$event_id = $this->events->melco($value);
	
		if($event_id){
		$this->view($event_id);
		}else{
			redirect("");
		}
	}
  

	function edit_melco($event_id = false){

		if(!$event_id){
			$event_id = $this->session->userdata('cei');
		}
		else{
		$this->session->set_userdata('cei', $event_id);
		}


		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
			$this->db->where('e.event_id', $event_id);
			$this->db->where('e.event_cod', 1);
			$q = $this->db->get('events e');		
			if ($q->num_rows() < 1){	
			 $this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			}
		}

		// prepare data for the template
		$data['page_title'] = 'Edit Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		$this->users->check_session('Admin');


		$config = array(
			array(
				'field'   => 'event_code',
				'label'   => 'Event Code',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[20]'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Title of Event',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[80]'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title of Event',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[255]'
			),
			array(
				'field'   => 'event_type',
				'label'   => 'Type of Event',
				'rules'   => 'trim|required|strip_tags|xss_clean||max_length[80]'
			),
			array(
				'field'   => 'event_performers',
				'label'   => 'Performers',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[255]'
			),
			array(
				'field'   => 'event_performers_website',
				'label'   => 'Performers Website Address',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[255]'
			),
			array(
				'field'   => 'event_description',
				'label'   => 'Description/Synopsis',
				'rules'   => 'trim|required|xss_clean'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue Name',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[5]|integer'
			),
			array(
				'field'   => 'date_time',
				'label'   => 'Date and Time',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[20]'
			),
			array(
				'field'   => 'event_expiration',
				'label'   => 'Event Expiration',
				'rules'   => 'trim|strip_tags|xss_clean|max_length[3]'
			),
			array(
				'field'   => 'event_photo',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|xss_clean|max_length[255]'
			),	
			array(
				'field'   => 'event_photo_1',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|xss_clean|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_2',
				'label'   => 'Event Picture 2',
				'rules'   => 'trim|strip_tags|xss_clean|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_3',
				'label'   => 'Event Picture 3',
				'rules'   => 'trim|strip_tags|xss_clean|max_length[255]'
			),
			array(
				'field'   => 'promoter_id',
				'label'   => 'Promoter Name',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[5]|integer'
			),
			array(
				'field'   => 'seatplan_id',
				'label'   => 'Seat Plan',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[5]|integer'
			),	
			array(
				'field'   => 'event_reservation_expire',
				'label'   => 'Reservation Expiry',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[2]|integer'
			),	
			array(
				'field'   => 'event_max_ticket',
				'label'   => 'Max Ticket',
				'rules'   => 'trim|required|strip_tags|xss_clean|max_length[2]|integer'
			),		
			array(
				'field'   => 'event_promo',
				'label'   => 'Promo',
				'rules'   => 'trim|strip_tags|xss_clean'
			),	

		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
		
		// get promoters
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		
		// get event data
		$data['event'] = $this->events->get($event_id);		
		
		// get video
		$data['video'] = $this->video->get_video($event_id);


		// get seatplans
		$current_seatplan['seatplan_id'] = $data['event']->seatplan_id;
		$current_seatplan['seatplan_name'] = $data['event']->seatplan_name;
		$data['seatplans'] = $this->seatplans->get_seatplans_dropdown($current_seatplan);
		

		if ($this->form_validation->run() == FALSE){		
			// display the page
			$this->load->view('events_edit', $data);
		}
		else{
		
		for($i=1;$i<=20;$i++){
			if($this->input->post('video_id_'.$i)){
				if ($_FILES['video_thumb_'. $i]['name']){
					// upload the photo; params: filename, max width, max height
					$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
				}else{
				$videoThumbnailLink = false;
				}
			
				$this->video->update($this->input->post('video_id_'. $i),$this->input->post('video_name_'. $i),$event_id,$this->input->post('video_url_'. $i), $videoThumbnailLink, $this->input->post('video_active_' . $i));
			}
			else if(!$this->input->post('video_id_'.$i) && $this->input->post('video_name_'. $i)){
				if ($_FILES['video_thumb_'. $i]['name']){
					$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
				}else{
				$videoThumbnailLink = false;
				}
				
				$this->video->embed($this->input->post('video_name_'. $i),$event_id, $this->input->post('video_url_'. $i), $videoThumbnailLink );
			}
		}
		
		
			//Upload images
			if ($_FILES['event_photo']['name']){
				// upload the photo; params: filename, max width, max height
				$image_path = $this->files->upload_image('event_photo', 640, 1000,'large');
			}
			else{
				$image_path = '';
			}
			if ($_FILES['event_photo_1']['name']){
				// upload the photo; params: filename, max width, max height
				$image_path_1 = $this->files->upload_image_1('event_photo_1', 640, 1000,'large');
			}
			else{
				$image_path_1 = '';
			}
			
			if ($_FILES['event_photo_2']['name']){
				// upload the photo; params: filename, max width, max height
				$image_path_2 = $this->files->upload_image_1('event_photo_2', 640, 1000,'medium');
			}
			else{
				$image_path_2 = '';
			}
			
			if ($_FILES['event_photo_3']['name']){
				// upload the photo; params: filename, max width, max height
				$image_path_3 = $this->files->upload_image_1('event_photo_3', 640, 1000,'thumb');
			}
			else{
				$image_path_3 = '';
			} 

			// add to db
			$this->events->edit($event_id, $image_path, $image_path_1,$image_path_2,$image_path_3);

			// redirect
			$this->session->set_flashdata('message', assemble_message('Event has been successfully modified'));
			redirect('events/edit/');
		}
	}
 
 
	function isMelcoEvent($event_id){
	
	$this->db->select('event_cod');
	$this->db->where('event_id',$event_id);
	$result = $this->db->get('events')->row()->event_cod;
	
	$isMelco = false;
		
		if($result == '1'){
			$isMelco = true;
		}else{
			$isMelco = false;
		}
		
	return $isMelco;	
	}
	
	
	function _duplicate_ticket_layout($event_id,$parent_id){
		
		
	// copy the seat plan from the template
	
	// $sql = "insert into ticket_layouts(seatplan_name, seatplan_venue_id, seatplan_image, seatplan_template, seatplan_active) select seatplan_name, seatplan_venue_id, seatplan_image, '0', '1' from seatplans where seatplan_id = ?"; 
	$sql = "insert into ticket_layouts(ticket_layout_event_id,ticket_logo_id_1,ticket_logo_id_2,ticket_logo_id_3,ticket_logo_id_4,ticket_logo_id_5,ticket_text_1,ticket_font_size_1,ticket_font_face_1,ticket_text_2,ticket_font_size_2,ticket_font_face_2,ticket_text_3,ticket_font_size_3,ticket_font_face_3,ticket_text_4,ticket_font_size_4,ticket_font_face_4,ticket_text_5,ticket_font_size_5,ticket_font_face_5,ticket_text_6,ticket_font_size_6,ticket_font_face_6,ticket_text_7,ticket_font_size_7,ticket_font_face_7,ticket_text_1_left,ticket_font_face_1_left,ticket_font_size_1_left,ticket_text_2_left,ticket_font_face_2_left,ticket_font_size_2_left,ticket_text_3_left,ticket_font_face_3_left,ticket_font_size_3_left,ticket_text_4_left,ticket_font_face_4_left,ticket_font_size_4_left,ticket_text_5_left,ticket_font_face_5_left,ticket_font_size_5_left,ticket_text_1_right,ticket_font_face_1_right,ticket_font_size_1_right,ticket_text_2_right,ticket_font_face_2_right,ticket_font_size_2_right,ticket_text_3_right,ticket_font_face_3_right,ticket_font_size_3_right,ticket_text_4_right,ticket_font_face_4_right,ticket_font_size_4_right,ticket_text_5_right,ticket_font_face_5_right,ticket_font_size_5_right,ticket_background_id,ticket_background_left,ticket_background_right) 	
	select $event_id,ticket_logo_id_1,ticket_logo_id_2,ticket_logo_id_3,ticket_logo_id_4,ticket_logo_id_5,ticket_text_1,ticket_font_size_1,ticket_font_face_1,ticket_text_2,ticket_font_size_2,ticket_font_face_2,ticket_text_3,ticket_font_size_3,ticket_font_face_3,ticket_text_4,ticket_font_size_4,ticket_font_face_4,ticket_text_5,ticket_font_size_5,ticket_font_face_5,ticket_text_6,ticket_font_size_6,ticket_font_face_6,ticket_text_7,ticket_font_size_7,ticket_font_face_7,ticket_text_1_left,ticket_font_face_1_left,ticket_font_size_1_left,ticket_text_2_left,ticket_font_face_2_left,ticket_font_size_2_left,ticket_text_3_left,ticket_font_face_3_left,ticket_font_size_3_left,ticket_text_4_left,ticket_font_face_4_left,ticket_font_size_4_left,ticket_text_5_left,ticket_font_face_5_left,ticket_font_size_5_left,ticket_text_1_right,ticket_font_face_1_right,ticket_font_size_1_right,ticket_text_2_right,ticket_font_face_2_right,ticket_font_size_2_right,ticket_text_3_right,ticket_font_face_3_right,ticket_font_size_3_right,ticket_text_4_right,ticket_font_face_4_right,ticket_font_size_4_right,ticket_text_5_right,ticket_font_face_5_right,ticket_font_size_5_right,ticket_background_id,ticket_background_left,ticket_background_right from ticket_layouts where ticket_layout_event_id = $parent_id"; 
	$this->db->query($sql, $parent_id);
	$new_ticket_layout_id = $this->db->insert_id();
	 
	// die($this->db->last_query());
	 
	return $new_ticket_layout_id;
	}
	
	function eticket(){
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Eticket Images';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'p_image',
				'label'   => 'Portrait',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'l_image',
				'label'   => 'Landscape',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),		
												
		); 
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get_eticket_images($event_id);
			// print_r($this->events->get_seo($event_id));
			// die();
			// display the page
			$this->load->view('event_eticket', $data);
		}
		else 
		{
		 

			//Upload images
			if ($_FILES["p_image"]["error"] != 4)
			{
				// upload the photo; params: filename, max width, max height
				$bucketName = 'images.smtickets.com';
				$bucketPath = 'images5.smtickets.com';
				$imageTmp = $_FILES['p_image']['tmp_name'];
				$imageName = $_FILES['p_image']['name'];
				$imageType = $_FILES['p_image']['type'];

				$date = new DateTime('now');
				$timestamp = $date->format('dmYHis');
				$ext = pathinfo($imageName, PATHINFO_EXTENSION);

				$imageNameOnly = "portrait_".$timestamp.".".$ext;
				$imageNewName = "images/"."portrait_".$timestamp.".".$ext;
				$imagePath = "https://" . $bucketPath . "/" . $imageNewName;

				$image_path = $this->files->upload_image('p_image', 640, 1000, $imageNameOnly);

				if(strpos($image_path, "The uploaded file exceeds the maximum allowed size in your PHP configuration file.") == true || strpos($image_path, "The file you are attempting to upload is larger than the permitted size.") == true) {
					$error_message = "Unable to upload image. Image size exceeded 200 KB max size. Please reduce the image size.";
					$image_path = "";
				} else if (strpos($image_path, "The filetype you are attempting to upload is not allowed.") == true) {
					$error_message = strip_tags($image_path);
					$image_path = "";
				}
				else {
					list($width, $height, $type, $attr) = getimagesize($imageTmp);
					$imageSize = filesize($imageTmp);
					$imageWH = $width . " x " . $height; 

					// $this->banner->upload($imageNewName, $imagePath, $imageWH, $imageSize);

					$s3 = new S3Client([
					    'version' => 'latest',
					    'region'  => 'ap-southeast-1',
					    'credentials' => [
					        'key'    => 'AKIARGTGZ65DTYI5F6FU',
					        'secret' => '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'
					    ],
					    'http' => [ 'verify' => false ]
					]);
					 
					// Upload a publicly accessible file. The file size and type are determined by the SDK.
					try {
					    $result = $s3->putObject([
					        'Bucket' => $bucketName,
					        'Key'    => $imageNewName,
					        'SourceFile' => $imageTmp,
					        'ContentType' => $imageType
					    ]);
					    // echo $result->get('ObjectURL');
					} 
					catch (Aws\S3\Exception\S3Exception $e) {
					    // echo "There was an error uploading the file.\n";
					    // echo $e->getMessage();
					}
				}
			}
			else 
			{
				$image_path = '';
			}
			if ($_FILES["l_image"]["error"] != 4)
			{
				// upload the photo; params: filename, max width, max height
				$bucketName = 'images.smtickets.com';
				$bucketPath = 'images5.smtickets.com';
				$imageTmp = $_FILES['l_image']['tmp_name'];
				$imageName = $_FILES['l_image']['name'];
				$imageType = $_FILES['l_image']['type'];

				$date = new DateTime('now');
				$timestamp = $date->format('dmYHis');
				$ext = pathinfo($imageName, PATHINFO_EXTENSION);

				$imageNameOnly = "carousel_".$timestamp.".".$ext;
				$imageNewName = "images/"."carousel_".$timestamp.".".$ext;
				$imagePath = "https://" . $bucketPath . "/" . $imageNewName;

				$image_path_1 = $this->files->upload_image_1('l_image', 640, 1000, $imageNameOnly);
				
				if(strpos($image_path_1, "The uploaded file exceeds the maximum allowed size in your PHP configuration file.") == true || strpos($image_path_1, "The file you are attempting to upload is larger than the permitted size.") == true) {
					$error_message_1 = "Unable to upload image. Image size exceeded 200 KB max size. Please reduce the image size.";
					$image_path_1 = "";
				} else if (strpos($image_path_1, "The filetype you are attempting to upload is not allowed.") == true) {
					$error_message_1 = strip_tags($image_path_1);
					$image_path_1 = "";
				}
				else {
					list($width, $height, $type, $attr) = getimagesize($imageTmp);
					$imageSize = filesize($imageTmp);
					$imageWH = $width . " x " . $height; 

					// $this->banner->upload($imageNewName, $imagePath, $imageWH, $imageSize);

					$s3 = new S3Client([
					    'version' => 'latest',
					    'region'  => 'ap-southeast-1',
					    'credentials' => [
					        'key'    => 'AKIARGTGZ65DTYI5F6FU',
					        'secret' => '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'
					    ],
					    'http' => [ 'verify' => false ]
					]);
					 
					// Upload a publicly accessible file. The file size and type are determined by the SDK.
					try {
					    $result = $s3->putObject([
					        'Bucket' => $bucketName,
					        'Key'    => $imageNewName,
					        'SourceFile' => $imageTmp,
					        'ContentType' => $imageType
					    ]);
					    // echo $result->get('ObjectURL');
					} 
					catch (Aws\S3\Exception\S3Exception $e) {
					    // echo "There was an error uploading the file.\n";
					    // echo $e->getMessage();
					}
				}
			}
			else 
			{
				$image_path_1 = '';
			}
			
		 
			$this->events->upload_eticket_images($event_id, $image_path, $image_path_1);

			$this->session->set_flashdata('message', assemble_message('Eticket images has been successfully updated'));
			redirect('events/view/');
		}
		
	}
	
		
	function web_images()
	{
		 
		// prepare data for the template
		$data['page_title'] = 'Website Images List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
			
			
		// display the page
		$this->load->view('web_images', $data);
 
	 
	}	
	
	function web_image_setup($type = false)
	{
		
		$result = $this->events->get_all_events_images($type);
 		$data['type'] = $result;
 		
		$data['sorted_eventids'] =  explode(",",$result->event_ids);
		$data['events_list'] = $this->events->get_by_ids(explode(",",$result->event_ids));
		
		// echo '<pre>';
		// print_r($data['sorted_eventids']);
		// print_r($data['events_list']);
		// echo '</pre>';
		
 		// prepare data for the template
		$data['page_title'] = 'Website Image Setup';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
			
		$config = array(
			array(
				'field'   => 'id',
				'label'   => 'id',
				'rules'   => 'trim|required|strip_tags'
			),array(
				'field'   => 'data',
				'label'   => 'events',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		$data['events'] = $this->events->get_active_events_dropdown_new();
		if ($this->form_validation->run() == FALSE)
		{
			 	 
			// display the page
			$this->load->view('web_image_setup', $data);
		}
		else
		{
 			 
 			$this->events->save_event_cms($_POST['data'],$type);
			 $this->session->set_flashdata('message', assemble_message('Website images has been successfully modified'));
			 redirect('events/web_images/');
		}
	}
	function select_branch($event_id=false){
		if ((!$this->session->userdata('cei'))  && (!$event_id)) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Selected Branch';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'event_branch_select[]',
				'label'   => 'Event Branch Select',
				'rules'   => 'trim|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
	
		if ($this->form_validation->run() == FALSE)
		{
			// get ticket types
			$data['branches'] = $this->branches->get_branches_dropdown();
		
			// display the page
			$this->load->view('event_branch_select', $data);
		}
		else
		{
			$this->events->edit_branch_select($event_id);
			$this->session->set_flashdata('message', assemble_message('Selected branches have been selected for selling'));
			redirect('events/select_branch/'.$event_id);
		}
	}	
	function pre_selling($event_id=false){
		if ((!$this->session->userdata('cei'))  && (!$event_id)) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Add Pre-selling';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'promo_code',
				'label'   => 'promo_code',
				'rules'   => 'required'
			),
			array(
				'field'   => 'start_date',
				'label'   => 'start_date',
				'rules'   => 'required'
			),
			array(
				'field'   => 'end_date',
				'label'   => 'end_date',
				'rules'   => 'required'
			)
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
		$event_sell = $this->event_pre_selling->verify_event_selling($event_id);
		if(count($event_sell) > 0){
			$data['event_selling'] = $event_sell;
		}
		if ($this->form_validation->run() == FALSE)
		{
			$this->load->view('event_pre_selling', $data);
		}
		else
		{
			$pre_code = $this->input->post('promo_code');
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$active = $this->input->post('is_active');
			$case_sens = $this->input->post('case_sensitive');
			$title = $this->input->post('title_text');
			if(!isset($active)){
				$active=0;
			}
			if(!isset($case_sens)){
				$case_sens=0;
			}
			if(count($event_sell) > 0){
				$param = array(
					"start_date" => $start_date,
					"end_date" => $end_date,
					"is_active" => $active,
					"is_case_sensitive" => $case_sens,
					"pre_selling_code" => $pre_code,
					"title_text" => $title
				);
				$this->event_pre_selling->update_event_code_selling($event_id,$param);
				$this->session->set_flashdata('message', assemble_message('Pre selling setup has been updated'));
			}else{
				$param = array(
					"event_id" => $event_id,
					"start_date" => $start_date,
					"end_date" => $end_date,
					"is_active" => $active,
					"is_case_sensitive" => $case_sens,
					"pre_selling_code" => $pre_code,
					"title_text" => $title
				);
				$this->event_pre_selling->add_event_code_selling($param);
				$this->session->set_flashdata('message', assemble_message('Pre selling setup has been added'));
			}
			
			
			
			redirect('events/pre_selling/'.$event_id);
		}
	}
}

/* End of file events.php */
/* Location: ./application/controllers/events.php */



