<?php

class Eft extends CI_Controller {

	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('generator_model', 'ticket_generator');
		$this->load->model('events_model', 'events');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('logs_model', 'logs');
		$this->load->model('eft_model', 'eft');
		$this->load->model('eplus_model', 'eplus');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('customers_model', 'customers');
		$this->load->model('printer_model', 'printer');
		$this->load->model('logs_model', 'logs');
		$this->load->model('users_model', 'users');
		$this->load->database('default');
	}
  
	//start eft
	function pay($customer_session_id = false, $amount = false){ 
		
		$this->output->set_header("Expires: Tue, 01 Jan 2000 00:00:00 GMT"); 
		$this->output->set_header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 
		$this->output->set_header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); 
		$this->output->set_header("Cache-Control: post-check=0, pre-check=0", false); 
		$this->output->set_header("Pragma: no-cache");
		
		$_POST = $this->session->userdata('postData');
	 
		
		$cash = 0;
		$paymaya = 0;
		$ref = 0;

		if($_POST['transaction_payment_cash']) {
			$cash = $_POST['transaction_payment_cash'];
		}
		
		if($_POST['total_change']) {
			$change = $_POST['total_change'];
		}
		
		
		if($_POST['transaction_payment_paymaya']) {
			$paymaya = $_POST['transaction_payment_paymaya'];
			$ref = implode("", $_POST['cc_refno']);
		}
  
		$eplus = false;
		// prepare data for the template
		$data['page_title'] = 'EFT Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
				
		$user_id = $this->session->userdata('user_id');
		
		$baseurl = $this->config->item('base_url');  		
	 
		$data['customer_session_id'] = $customer_session_id;
		$data['baseurl'] = $baseurl;
		$data['user_id'] = $user_id;
		$amount_due = round($_POST['amount_due'], 0);
	   
	 
		// body onload 
		// $data['onload'] =  "onLoad='window.location=\"ecs://$baseurl/printer/generate_card_details/366089\"'";
		
       // echo '<pre>';
       // print_r($_POST);
       // echo '</pre>';
			// die();
		$data['onload'] =  $test =  "onLoad='window.location=\"eft://$baseurl". "eft/generate_payment_info/?type=buy&user_id=$user_id&order_id=$customer_session_id&cash=$cash&change=$change&eft=$amount&paymaya=$paymaya&paymaya_ref=$ref&amount_due=$amount_due\"'";
		  
        
       // echo "$baseurl" . "eft/generate_payment_info?type=buy&user_id=$user_id&order_id=$customer_session_id&cash=$cash&eft=$amount&paymaya=$paymaya&paymaya_ref=$ref&amount_due=$amount_due";

		 
		$data['order_id'] = $customer_session_id;
		$this->load->view('transactions_eft_payment',$data);
		
	}	
	
	
	function check_payment_status($order_id = false, $status){
	 
	    $result =  $this->eft->check_status($order_id, $status);
		echo $result;
	}

	function generate_payment_info()
	{
		  
		 
        
        $type = $_GET['type'];
        $eft = $_GET['eft'];
        $user_id = $_GET['user_id'];
        $order_id = $_GET['order_id'];
		  
		 
        if(!$type || !$eft || !$user_id || !$order_id){
			die();
		}  
        
        
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		 
		$result = $this->eft->get_payment_details($type, $user_id, $order_id);
		
  
		$this->load->dbutil();
		$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		echo $this->dbutil->xml_from_result($result, $config);
	
	}
	
	
	function payment()
	{
	 
	  
		// check for customer session
		if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
		{	
			 

			$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
			//redirect('');
		}
				
		$customer_session_id = $this->session->userdata('customer_session_id');
		$cei = $this->session->userdata('cei');
		$cpi = $this->session->userdata('cpi');

		
		//check for eft sessions
		if($this->session->userdata('postData')){
		
			$_POST = $this->session->userdata('postData');

        
			if($_POST['transaction_payment_eft'] > 0){
                
                //remove other payment tenders for eft transactions
				$_POST['transaction_payment_cash'] = '';
				$_POST['transaction_payment_paymaya'] = '';
				$_POST['transaction_payment_credit_card_1'] = '';
				$_POST['transaction_payment_credit_card_2'] = '';
				$_POST['transaction_payment_debit_card'] = '';
				$_POST['cc_refno'] = array();
                
                 
			}
                 
            
			 
		}else{
		
			// echo '<pre>';
			// print_r($this->session->userdata); 
			// echo '</pre>';
			// die();
			$this->session->set_flashdata('message', assemble_error('Transaction corrupted. Please restart transaction from beginning.<br />'));
			// redirect("/events/view/$this->session->userdata('cei')");
		}
		
		 
		// prepare data for the template
		$data['page_title'] = 'Eft Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// check ticket status
		//$this->transactions->_check_tix_stat($customer_session_id, $cei, array('selected', 'reserved'), $this->session->userdata('tix_qty'));
		 
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
		// add customer to db
		$customer_id = $this->customers->quick_add();
		
		if ($this->session->userdata('claim') == 'claim')
		{
			// update the transaction
			$transaction_id = $this->session->userdata('tid');

			$this->transactions->update($transaction_id, $data['event']->event_reservation_fee, $customer_id);
		}
		else
		{
			// add transaction
			$transaction_id = $this->transactions->add($customer_id);
		}
		
		if ($transaction_id)
		{
			//insert into historical table 
			$this->admin->copy_tickets($transaction_id, 'done');
			$this->admin->copy_transactions($transaction_id,'done');
			$this->admin->copy_payments($transaction_id);  
			redirect('transactions/done/'.$transaction_id);
		}
		else
		{
			$this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
			redirect('transactions/payment/');
		}
	 
	}
 
	
	function mark_as_paid(){
		
 	
		$json = file_get_contents('php://input');

		// Converts it into a PHP object
		$data = json_decode($json, true);
  
		//  die();
		$this->eft->insert_details($data);
	  
	}
	
	
   function get_payments(){
        
       $result = $this->eft->get_payment_types();
         
       echo json_encode($result);
    }
	//end of eft
	
	
	
	//end of eft
	
	
	
	
     
	function test_eft(){
		
		 
	$curl = curl_init();

		curl_setopt_array($curl, array(
	  CURLOPT_URL => 'http://10.143.131.206/eft/mark_as_paid',
	  CURLOPT_RETURNTRANSFER => true,
	  CURLOPT_ENCODING => '',
	  CURLOPT_MAXREDIRS => 10,
	  CURLOPT_TIMEOUT => 0,
	  CURLOPT_FOLLOWLOCATION => true,
	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	  CURLOPT_CUSTOMREQUEST => 'POST',
	  CURLOPT_POSTFIELDS =>'{
		"order_id":"d2348f4000869e3ea962ac1cea3767706c7763fb",
		"user_id":"3687",
		"status":"Approved",
		"payment_info": [
			{
				"payment_type":"VISA",
				"amount":9,
				"approval_code": "1111",
				"invoice_num": "2222",
				"terminal_num": "3333",
				"merchant_num": "4444",
 				"card_num": "4183580000008107",
				"cardholder_name": "jap sy"
				"cash_change": "0"
			}
			
				 
			
		]
	}',
	  CURLOPT_HTTPHEADER => array(
		'Content-Type: application/json',
		'Cookie: aws-ticketing=r1tsop49u794c9svlvkn4lmnrtnm3vnr'
	  ),
	));

	$response = curl_exec($curl);

	curl_close($curl);
	echo $response;

			// ,
			 // {
				// "payment_type":"Cash",
				// "amount":400,
				// "approval_code": "",
				// "invoice_num": "",
				// "terminal_num": "",
				// "merchant_num": "",
 				// "card_num": "",
				// "cardholder_name": ""
			// },
			 // {
				// "payment_type":"PayMaya",
				// "amount":100,
 				// "approval_code": "6664",
				// "invoice_num": "",
				// "terminal_num": "",
				// "merchant_num": "",
 				// "card_num": "",
				// "cardholder_name": ""
			// }
	}
 
} 

/* End of file printer.php */
/* Location: ./application/controllers/printer.php */