<?php

class Ds extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('reports_model', 'reports');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('ds_model', 'ds');
		$this->load->database('default');

	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		// prepare data for the template
		$data['page_title'] = 'Ds';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$this->load->view('reports_index', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * dsf
	 *
	 * @access	public
	 */
	
	function dsf()
	{
		$data['reports'] = $this->ds->reports_filter($eventgroup);
						
		$this->load->helper('file');

		$header = 'SMT' . date("mdY", strtotime($this->input->post('date_file'))) . '.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		//echo $this->input->post('date_file');
		$this->load->view('reports_dsf', $data);
	}

	// --------------------------------------------------------------------
	
	/**
	 * dsu
	 *
	 * @access	public
	 */
	
	function dsu()
	{
		$this->load->helper('file');

		$header = 'SMU' . date("mdY") . '.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		$this->load->view('reports_dsu');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * dse
	 *
	 * @access	public
	 */
	
	function dse()
	{
		$this->load->helper('file');

		$header = 'EVENTS.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		$this->load->view('reports_dse');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * dsp
	 *
	 * @access	public
	 */
	
	function dsp()
	{
		$this->load->helper('file');

		$header = 'PRICECODES.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		$this->load->view('reports_dsp');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * dspt
	 *
	 * @access	public
	 */
	
	function dspt()
	{
		$this->load->helper('file');

		$header = 'TENDERTYPES.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		$this->load->view('reports_dspt');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * dstt
	 *
	 * @access	public
	 */
	
	function dstt()
	{
		$this->load->helper('file');

		$header = 'TICKETTYPES.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		$this->load->view('reports_dstt');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * dsb
	 *
	 * @access	public
	 */
	
	function dsb()
	{
		$this->load->helper('file');

		$header = 'BRANCHES.csv';
		
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		
		$this->load->view('reports_dsb');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * ds_reports
	 *
	 * @access	public
	 */
	
	function ds_reports_opt($eventgroup = "")
	{
		redirect("/ds/ds_reports/$eventgroup");
	}
	
	function ds_reports($eventgroup = "")
	{
		
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		switch ($eventgroup)
		{
			case 'bssr' : 
				{
					$this->users->check_session(array('Admin','Super Admin', 'Finance'));
					$data['page_title'] = 'Branch Sales Summary Report';
					break;
				}
			case 'dsf' : 
				{
					$data['page_title'] = 'Daily Sales File';
					break;
				}
			default :
				{
					redirect($data['form_url'].'/event/');
					break;
				}
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		if ($eventgroup != 'dsf')
		{
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		}
		else 
		{
		$config = array(
			array(
				'field'   => 'date_file',
				'label'   => 'Date',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		}
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_ds_reports_filter', $data);
		}
		else
		{
			switch ($eventgroup)
			{
				case 'bssr' :
					{
						$data['reports'] = $this->ds->reports_filter($eventgroup);
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_ds_bssr', $data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						break;
					}
				case 'dsf' :
					{
						$data['reports'] = $this->ds->reports_filter($eventgroup);
						
						$this->load->helper('file');
				
						$header = 'SMT' . date("mdY", strtotime($this->input->post('date_file'))) . '.csv';
						
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//echo $this->input->post('date_file');
						$this->benchmark->mark('query_end');
						$this->load->view('reports_dsf', $data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						break;
					}
			}
		}
	}
	
}

/* End of file reports.php */
/* Location: ./application/controllers/reports.php */