<?php

class Departments extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('contacts_model', 'contacts');
		$this->load->model('departments_model', 'departments');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('departments/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Departmentes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all venues
		$data['departments'] = $this->departments->get_departments();
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Finance'));
		
		$this->load->view('departments_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($department_id = FALSE)
	{
		if (! $department_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'View Department';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller','Reservation','Reservation-Admin'));
	
		// get user's data
		$data['departments'] = $this->departments->get($department_id);
		
		// get contacts
		$data['contacts'] = $this->contacts->get_contacts('departments', $department_id);
		
		// display the page
		$this->load->view('departments_view', $data);
	}		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Department';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'department_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]|callback__departmentname_check'
			),
			array(
				'field'   => 'priveleges',
				'label'   => 'Privileges',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			)
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{					
			// display the page
			$this->load->view('departments_add', $data);
		}
		else
		{
			$departments_id = $this->departments->add();
			$this->session->set_flashdata('message', assemble_message('Department has been successfully added.  Please add the contact person.'));
			redirect('departments/listing');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _departmentname_check
	 *
	 * @access	private
	 */
	function _departmentname_check($str)
	{	
		$departmentname_exists = $this->departments->is_departmentname_exist($str);
		if ($departmentname_exists)
		{
			$this->form_validation->set_message('_departmentname_check', "The department $str already exists.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($department_id = FALSE)
	{
		if (! $department_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit department';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'department_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'priveleges',
				'label'   => 'Privileges',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			)
		);

		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
		
			// get data
			$data['department'] = $this->departments->get($department_id);
			
			// display the page
			$this->load->view('departments_edit', $data);
		}
		else
		{
			$this->departments->edit($department_id);
			$this->session->set_flashdata('message', assemble_message('Department has been successfully modified'));
			//redirect('venues/listing');
			redirect('departments/listing/'.$department_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($department_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Department');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->departments->delete($department_id);
		$this->session->set_flashdata('message', assemble_message('Department has been successfully deleted'));
		redirect('departments/listing/');
	}
}
/* End of file departments.php */
/* Location: ./application/controllers/departments.php */	
