<?php

class Customers extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('customers_model', 'customers');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('customers/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// ini_set("memory_limit","512M");
		// check user session
		$this->users->check_session(array('Reservation-Admin'));

		// prepare data for the template
		$data['page_title'] = 'Customers';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		// $searchflds = array('name','customer_notes','customer_email','customer_mobile');
		$searchflds = array('name','email_address');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}

		// pagination
		$this->load->library('pagination');		
		// $limit = $this->pagination->per_page;
		$limit = 20;
		$offset = $this->uri->segment(3);		
		
		$config['base_url'] = site_url('customers/listing');
		$config['total_rows'] = count( $this->customers->get_customers($searchkey) );
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$data['customers'] = $this->customers->get_customers($searchkey, $offset, $limit);
				
				// echo $this->db->last_query();
			
		$this->load->view('customers_listing', $data);
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($customer_id = FALSE)
	{
		if (! $customer_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Customer';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Finance','IT'));
	
		// get customer's data
		$data['customer'] = $this->customers->get($customer_id);
		
		// display the page
		$this->load->view('customers_view', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get()
	{
		if (!$this->input->post('customer_mobile')) show_404();
		
		// log this
		$this->logs->add('Get Customer');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Promoter','Reservation','Reservation-Admin'));
	
		// get customer's data
		$customer = $this->customers->get_by_mobile($this->input->post('customer_mobile'));
		
		//$this->load->helper('json');
		
		echo jsencode(object_to_array($customer));
	
	}		

	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Customer';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'customer_firstname',
				'label'   => 'First Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_middlename',
				'label'   => 'Middle Name',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_lastname',
				'label'   => 'Last Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_age_bracket',
				'label'   => 'Age',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[10]'
			),
			array(
				'field'   => 'customer_gender',
				'label'   => 'Gender',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[6]'
			),
			array(
				'field'   => 'customer_nationality',
				'label'   => 'Nationality',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_marital_status',
				'label'   => 'Marital Status',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[10]'
			),
			array(
				'field'   => 'customer_address1',
				'label'   => 'Address 1',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'customer_address2',
				'label'   => 'Address 2',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'customer_city',
				'label'   => 'City',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_zip',
				'label'   => 'Zip Code',
				'rules'   => 'trim|strip_tags|min_length[4]|max_length[10]'
			),
			array(
				'field'   => 'customer_phone',
				'label'   => 'Phone Number',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_fax',
				'label'   => 'Fax Number',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_mobile',
				'label'   => 'Mobile Number',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_email',
				'label'   => 'Email Address',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_website',
				'label'   => 'Website Address',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_work_address1',
				'label'   => 'Work Address 1',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'customer_work_address2',
				'label'   => 'Work Address 2',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'customer_work_city',
				'label'   => 'Work City',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_work_zip',
				'label'   => 'Work Zip Code',
				'rules'   => 'trim|strip_tags|min_length[4]|max_length[10]'
			),
			array(
				'field'   => 'customer_work_phone',
				'label'   => 'Work Phone Number',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_work_fax',
				'label'   => 'Work Fax Number',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_work_mobile',
				'label'   => 'Work Mobile Number',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_work_email',
				'label'   => 'Work Email Address',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_work_website',
				'label'   => 'Work Website Address',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_notes',
				'label'   => 'Notes',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('customers_add', $data);
		}
		else
		{
			$this->customers->add();
			$this->session->set_flashdata('message', assemble_message('Customer has been successfully added'));
			redirect('customers/listing');
		}
	}	

	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($customer_id = FALSE)
	{
		if (! $customer_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Customer';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'customer_firstname',
				'label'   => 'First Name',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_middlename',
				'label'   => 'Middle Name',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_lastname',
				'label'   => 'Last Name',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_age_bracket',
				'label'   => 'Age',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'customer_gender',
				'label'   => 'Gender',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'customer_nationality',
				'label'   => 'Nationality',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_marital_status',
				'label'   => 'Marital Status',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'customer_address1',
				'label'   => 'Address 1',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'customer_address2',
				'label'   => 'Address 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'customer_city',
				'label'   => 'City',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_zip',
				'label'   => 'Zip Code',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'customer_phone',
				'label'   => 'Phone Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_fax',
				'label'   => 'Fax Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_mobile',
				'label'   => 'Mobile Number',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_email',
				'label'   => 'Email Address',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_website',
				'label'   => 'Website Address',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_work_address1',
				'label'   => 'Work Address 1',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'customer_work_address2',
				'label'   => 'Work Address 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'customer_work_city',
				'label'   => 'Work City',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_work_zip',
				'label'   => 'Work Zip Code',
				'rules'   => 'trim|strip_tags|max_length[6]'
			),
			array(
				'field'   => 'customer_work_phone',
				'label'   => 'Work Phone Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_work_fax',
				'label'   => 'Work Fax Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_work_mobile',
				'label'   => 'Work Mobile Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_work_email',
				'label'   => 'Work Email Address',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_work_website',
				'label'   => 'Work Website Address',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'customer_notes',
				'label'   => 'Notes',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'customer_birthdate',
				'label'   => 'Birthdate',
				'rules'   => 'trim|strip_tags|required|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// get user's data
			$data['customer'] = $this->customers->get($customer_id);
			
			// display the page
			$this->load->view('customers_edit', $data);
		}
		else
		{
			$this->customers->edit($customer_id);
			$this->session->set_flashdata('message', assemble_message('Customer has been successfully modified'));
			redirect('customers/listing');
		}
	}		
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($customer_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Customer');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->customers->delete($customer_id);
		$this->session->set_flashdata('message', assemble_message('Customer has been successfully deleted'));
		redirect('customers/listing/');
	}
	
}

/* End of file customers.php */
/* Location: ./application/controllers/customers.php */	