<?php

class custom_routes extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('events_model', 'events');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->model('users_model', 'users');
        $this->load->model('routes_model', 'custom_routes');
		$this->load->database('default');

		// place authentication check here
		// check user session
		// $this->users->check_session(array('Admin','Super Admin'));

	}
	function index(){
        $data['page_title'] = 'Custom URL';
		$this->logs->add($data['page_title']);
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
        $data['routes_list'] = $this->custom_routes->list();
        $this->load->view('custom_url_list',$data);
    }
    function listing(){
        $data['page_title'] = 'Custom URL';
		$this->logs->add($data['page_title']);
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
        $data['routes_list'] = $this->custom_routes->list();
        $this->load->view('custom_url_list',$data);
    }
    function add(){
        $data['page_title'] = 'Custom URL Add';
		$this->logs->add($data['page_title']);
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        $config = array(
			array(
				'field'   => 'route_slug',
				'label'   => 'Route Slug',
				'rules'   => 'required'
			),
			array(
				'field'   => 'route_url',
				'label'   => 'Route URL',
				'rules'   => 'required'
			),
			array(
				'field'   => 'start_date',
				'label'   => 'Start Date',
				'rules'   => 'required'
			),
			array(
				'field'   => 'end_date',
				'label'   => 'End Date',
				'rules'   => 'required'
			)
		);

        $this->form_validation->set_rules($config); 
		$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
		
		if ($this->form_validation->run() == FALSE) {
			//PROCEED IN ADDING
            $this->load->view('custom_url_add',$data);
        }
        else{
            //PROCEED IN SAVING
            $route_slug = $this->input->post('route_slug');
            $route_url = $this->input->post('route_url');
            $start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$active = $this->input->post('active_status');
			if(!isset($active)){
				$active=0;
			}
            $param = array(
                'route_slug' => $route_slug,
                'route_url' => $route_url,
                'route_start' => $start_date,
                'route_end' => $end_date,
                'route_active' => $active
            );

            $result = $this->custom_routes->add_routes($param);
            if($result){
                $this->session->set_flashdata('message', assemble_message('Custom URL has been added'));
				redirect("custom_routes/listing");
            }

			//$this->load->view('custom_url_add',$data);
		}
        
    }
    function edit($route_id=false){
        $data['page_title'] = 'Custom URL Edit';
		$this->logs->add($data['page_title']);
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        
        

        $config = array(
			array(
				'field'   => 'route_slug',
				'label'   => 'Route Slug',
				'rules'   => 'required'
			),
			array(
				'field'   => 'route_url',
				'label'   => 'Route URL',
				'rules'   => 'required'
			),
			array(
				'field'   => 'start_date',
				'label'   => 'Start Date',
				'rules'   => 'required'
			),
			array(
				'field'   => 'end_date',
				'label'   => 'End Date',
				'rules'   => 'required'
			)
		);

        $this->form_validation->set_rules($config); 
		$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
		
		if ($this->form_validation->run() == FALSE) {
			//PROCEED IN VIEWING

            //GET THE ROUTE DETAILS
            $data['route_details'] = $this->custom_routes->get_route_details($route_id);
            $this->load->view('custom_url_add',$data);
        }
        else{
            //PROCEED IN UPDATING
            $route_slug = $this->input->post('route_slug');
            $route_url = $this->input->post('route_url');
            $start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$active = $this->input->post('active_status');
			if(!isset($active)){
				$active=0;
			}
            $param = array(
                'route_slug' => $route_slug,
                'route_url' => $route_url,
                'route_start' => $start_date,
                'route_end' => $end_date,
                'route_active' => $active
            );
            $result = $this->custom_routes->update_route_details($route_id,$param);
            if($result){
                $this->session->set_flashdata('message', assemble_message('Custom URL has been updated'));
				redirect("custom_routes/listing");
            }
            //$this->load->view('custom_url_add',$data);
        }
    }
	function disable(){
		$data['page_title'] = 'Disable Event URL';
		$this->logs->add($data['page_title']);
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        $config = array(
			array(
				'field'   => 'event_id',
				'label'   => 'Event ID',
				'rules'   => 'required'
			),
			array(
				'field'   => 'start_date',
				'label'   => 'Start Date',
				'rules'   => 'required'
			),
			array(
				'field'   => 'end_date',
				'label'   => 'End Date',
				'rules'   => 'required'
			)
		);

        $this->form_validation->set_rules($config); 
		$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
		
		if ($this->form_validation->run() == FALSE) {
			//PROCEED IN ADDING
            $this->load->view('custom_url_disable',$data);
        }
        else{
            //PROCEED IN SAVING
            //$route_slug = $this->input->post('route_slug');
            $event_id = $this->input->post('event_id');
            $start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$active = $this->input->post('active_status');
			if(!isset($active)){
				$active=0;
			}
            $param = array(
                'route_slug' => 'events/view/'.$event_id,
                'route_url' => '/invalid',
                'route_start' => $start_date,
                'route_end' => $end_date,
                'route_active' => $active
            );
			// $param[1] = array(
            //     'route_slug' => 'events/view/'.$event_id.'/(:any)',
            //     'route_url' => '/invalid',
            //     'route_start' => $start_date,
            //     'route_end' => $end_date,
            //     'route_active' => $active
            // );
			// $param[2] = array(
            //     'route_slug' => 'events/view/'.$event_id.'(:any)',
            //     'route_url' => '/invalid',
            //     'route_start' => $start_date,
            //     'route_end' => $end_date,
            //     'route_active' => $active
        	// );

			// foreach($param as $p){
			// 	$result = $this->custom_routes->add_routes($p);	
			// }
			$result = $this->custom_routes->add_routes($param);	
            if($result){
                $this->session->set_flashdata('message', assemble_message('Custom URL has been added'));
				redirect("custom_routes/listing");
            }

			//$this->load->view('custom_url_add',$data);
		}
	}

	function get_event($event_id=0){
		$data = $this->events->get($event_id);
		echo json_encode($data);
	}
}